﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appmesh/AppMesh_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppMesh {
namespace Model {

/**
 * <p>An object that represents the virtual service that traffic is routed
 * to.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/GatewayRouteVirtualService">AWS
 * API Reference</a></p>
 */
class GatewayRouteVirtualService {
 public:
  AWS_APPMESH_API GatewayRouteVirtualService() = default;
  AWS_APPMESH_API GatewayRouteVirtualService(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPMESH_API GatewayRouteVirtualService& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPMESH_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the virtual service that traffic is routed to.</p>
   */
  inline const Aws::String& GetVirtualServiceName() const { return m_virtualServiceName; }
  inline bool VirtualServiceNameHasBeenSet() const { return m_virtualServiceNameHasBeenSet; }
  template <typename VirtualServiceNameT = Aws::String>
  void SetVirtualServiceName(VirtualServiceNameT&& value) {
    m_virtualServiceNameHasBeenSet = true;
    m_virtualServiceName = std::forward<VirtualServiceNameT>(value);
  }
  template <typename VirtualServiceNameT = Aws::String>
  GatewayRouteVirtualService& WithVirtualServiceName(VirtualServiceNameT&& value) {
    SetVirtualServiceName(std::forward<VirtualServiceNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_virtualServiceName;
  bool m_virtualServiceNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppMesh
}  // namespace Aws
