/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.GitLogUtil;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "", "<init>", "()V", "Complete", "Incomplete", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Incomplete;", "intellij.vcs.git"})
public abstract sealed class GitCommitEditingOperationResult {
    private GitCommitEditingOperationResult() {
    }

    public /* synthetic */ GitCommitEditingOperationResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "repository", "Lgit4idea/repo/GitRepository;", "base", "Lgit4idea/branch/GitRebaseParams$RebaseUpstream;", "oldHead", "", "newHead", "commitToFocus", "Lcom/intellij/vcs/log/Hash;", "commitToFocusOnUndo", "<init>", "(Lgit4idea/repo/GitRepository;Lgit4idea/branch/GitRebaseParams$RebaseUpstream;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/vcs/log/Hash;Lcom/intellij/vcs/log/Hash;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getCommitToFocus", "()Lcom/intellij/vcs/log/Hash;", "getCommitToFocusOnUndo", "firstChangedHash", "getFirstChangedHash", "findFirstChangedHash", "checkUndoPossibility", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility;", "undo", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult;", "withFocusCommits", "newCommitToFocus", "newCommitToFocusOnUndo", "UndoResult", "UndoPossibility", "intellij.vcs.git"})
    public static final class Complete
    extends GitCommitEditingOperationResult {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRebaseParams.RebaseUpstream base;
        @NotNull
        private final String oldHead;
        @NotNull
        private final String newHead;
        @Nullable
        private final Hash commitToFocus;
        @Nullable
        private final Hash commitToFocusOnUndo;
        @Nullable
        private final Hash firstChangedHash;

        public Complete(@NotNull GitRepository repository2, @NotNull GitRebaseParams.RebaseUpstream base, @NotNull String oldHead, @NotNull String newHead, @Nullable Hash commitToFocus, @Nullable Hash commitToFocusOnUndo) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)oldHead, (String)"oldHead");
            Intrinsics.checkNotNullParameter((Object)newHead, (String)"newHead");
            super(null);
            this.repository = repository2;
            this.base = base;
            this.oldHead = oldHead;
            this.newHead = newHead;
            this.commitToFocus = commitToFocus;
            this.commitToFocusOnUndo = commitToFocusOnUndo;
            this.firstChangedHash = this.findFirstChangedHash();
        }

        public /* synthetic */ Complete(GitRepository gitRepository, GitRebaseParams.RebaseUpstream rebaseUpstream, String string, String string2, Hash hash, Hash hash2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                hash = null;
            }
            if ((n & 0x20) != 0) {
                hash2 = null;
            }
            this(gitRepository, rebaseUpstream, string, string2, hash, hash2);
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @Nullable
        public final Hash getCommitToFocus() {
            return this.commitToFocus;
        }

        @Nullable
        public final Hash getCommitToFocusOnUndo() {
            return this.commitToFocusOnUndo;
        }

        @Nullable
        public final Hash getFirstChangedHash() {
            return this.firstChangedHash;
        }

        private final Hash findFirstChangedHash() {
            String string = GitRebaseUtils.getCommitsRangeToRebase(this.base, this.newHead);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommitsRangeToRebase(...)");
            String changedCommitsRange = string;
            String[] stringArray = new String[]{changedCommitsRange};
            List list = GitLogUtil.collectMetadata(this.repository.getProject(), this.repository.getRoot(), stringArray).getCommits();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCommits(...)");
            List changedCommits = list;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)CollectionsKt.lastOrNull((List)changedCommits);
            return vcsCommitMetadata != null ? (Hash)vcsCommitMetadata.getId() : null;
        }

        @NotNull
        public final UndoPossibility checkUndoPossibility() {
            this.repository.update();
            if (!Intrinsics.areEqual((Object)this.repository.getCurrentRevision(), (Object)this.newHead)) {
                return UndoPossibility.Impossible.HeadMoved.INSTANCE;
            }
            if (this.firstChangedHash == null) {
                return UndoPossibility.Possible.INSTANCE;
            }
            String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranchContainingCommit(this.repository, this.firstChangedHash);
            if (protectedBranch != null) {
                return new UndoPossibility.Impossible.PushedToProtectedBranch(protectedBranch);
            }
            return UndoPossibility.Possible.INSTANCE;
        }

        @NotNull
        public final UndoResult undo() {
            UndoResult undoResult;
            GitCommandResult gitCommandResult = Git.getInstance().reset(this.repository, GitResetMode.KEEP, this.oldHead, new GitLineHandlerListener[0]);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"reset(...)");
            GitCommandResult res = gitCommandResult;
            this.repository.update();
            if (res.success()) {
                GitUtil.updateAndRefreshChangedVfs(this.repository, HashImpl.build((String)this.newHead));
                undoResult = UndoResult.Success.INSTANCE;
            } else {
                String string = res.getErrorOutputAsHtmlString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorOutputAsHtmlString(...)");
                undoResult = new UndoResult.Error(string);
            }
            return undoResult;
        }

        @NotNull
        public final Complete withFocusCommits(@Nullable Hash newCommitToFocus, @Nullable Hash newCommitToFocusOnUndo) {
            return new Complete(this.repository, this.base, this.oldHead, this.newHead, newCommitToFocus, newCommitToFocusOnUndo);
        }

        public static /* synthetic */ Complete withFocusCommits$default(Complete complete, Hash hash, Hash hash2, int n, Object object) {
            if ((n & 1) != 0) {
                hash = complete.commitToFocus;
            }
            if ((n & 2) != 0) {
                hash2 = complete.commitToFocusOnUndo;
            }
            return complete.withFocusCommits(hash, hash2);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility;", "", "<init>", "()V", "Impossible", "Possible", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Possible;", "intellij.vcs.git"})
        public static abstract sealed class UndoPossibility {
            private UndoPossibility() {
            }

            public /* synthetic */ UndoPossibility(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility;", "<init>", "()V", "HeadMoved", "PushedToProtectedBranch", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible$HeadMoved;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible$PushedToProtectedBranch;", "intellij.vcs.git"})
            public static abstract sealed class Impossible
            extends UndoPossibility {
                private Impossible() {
                    super(null);
                }

                public /* synthetic */ Impossible(DefaultConstructorMarker $constructor_marker) {
                    this();
                }

                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible$HeadMoved;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible;", "<init>", "()V", "intellij.vcs.git"})
                public static final class HeadMoved
                extends Impossible {
                    @NotNull
                    public static final HeadMoved INSTANCE = new HeadMoved();

                    private HeadMoved() {
                        super(null);
                    }
                }

                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible$PushedToProtectedBranch;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible;", "branch", "", "<init>", "(Ljava/lang/String;)V", "getBranch", "()Ljava/lang/String;", "intellij.vcs.git"})
                public static final class PushedToProtectedBranch
                extends Impossible {
                    @NotNull
                    private final String branch;

                    public PushedToProtectedBranch(@NotNull String branch) {
                        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                        super(null);
                        this.branch = branch;
                    }

                    @NotNull
                    public final String getBranch() {
                        return this.branch;
                    }
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Possible;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility;", "<init>", "()V", "intellij.vcs.git"})
            public static final class Possible
            extends UndoPossibility {
                @NotNull
                public static final Possible INSTANCE = new Possible();

                private Possible() {
                    super(null);
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult;", "", "<init>", "()V", "Success", "Error", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult$Error;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult$Success;", "intellij.vcs.git"})
        public static abstract sealed class UndoResult {
            private UndoResult() {
            }

            public /* synthetic */ UndoResult(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult$Error;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult;", "errorHtml", "", "<init>", "(Ljava/lang/String;)V", "getErrorHtml", "()Ljava/lang/String;", "intellij.vcs.git"})
            public static final class Error
            extends UndoResult {
                @NotNull
                private final String errorHtml;

                public Error(@NlsContexts.NotificationContent @NotNull String errorHtml) {
                    Intrinsics.checkNotNullParameter((Object)errorHtml, (String)"errorHtml");
                    super(null);
                    this.errorHtml = errorHtml;
                }

                @NotNull
                public final String getErrorHtml() {
                    return this.errorHtml;
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult$Success;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult;", "<init>", "()V", "intellij.vcs.git"})
            public static final class Success
            extends UndoResult {
                @NotNull
                public static final Success INSTANCE = new Success();

                private Success() {
                    super(null);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Incomplete;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "<init>", "()V", "intellij.vcs.git"})
    public static final class Incomplete
    extends GitCommitEditingOperationResult {
        @NotNull
        public static final Incomplete INSTANCE = new Incomplete();

        private Incomplete() {
            super(null);
        }
    }
}

