/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

class NegationCountVisitor
extends GroovyRecursiveElementVisitor {
    private int negationCount = 0;

    NegationCountVisitor() {
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        if (element == null) {
            NegationCountVisitor.$$$reportNull$$$0(0);
        }
        int oldCount = 0;
        if (element instanceof GrMethod) {
            oldCount = this.negationCount;
        }
        super.visitElement(element);
        if (element instanceof GrMethod) {
            this.negationCount = oldCount;
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            NegationCountVisitor.$$$reportNull$$$0(1);
        }
        super.visitBinaryExpression(expression);
        IElementType tokenType = expression.getOperationTokenType();
        GrExpression rhs = expression.getRightOperand();
        if (rhs == null) {
            return;
        }
        if (GroovyTokenTypes.mNOT_EQUAL.equals(tokenType)) {
            ++this.negationCount;
        }
    }

    @Override
    public void visitUnaryExpression(@NotNull GrUnaryExpression grUnaryExpression) {
        if (grUnaryExpression == null) {
            NegationCountVisitor.$$$reportNull$$$0(2);
        }
        super.visitUnaryExpression(grUnaryExpression);
        IElementType sign = grUnaryExpression.getOperationTokenType();
        if (GroovyTokenTypes.mLNOT.equals(sign)) {
            ++this.negationCount;
        }
    }

    public int getNegationCount() {
        return this.negationCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grUnaryExpression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/metrics/NegationCountVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitUnaryExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

