/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.JUnitBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.ChangeSignatureRefactoring;
import com.intellij.refactoring.JavaRefactoringFactory;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ParameterizedParametersStaticCollectionInspection
extends BaseInspection {
    private static final String PARAMETERS_FQN = "org.junit.runners.Parameterized.Parameters";

    protected LocalQuickFix buildFix(final Object ... infos) {
        if (infos.length == 0) {
            return null;
        }
        Object object = infos[0];
        if (object instanceof PsiClass) {
            PsiClass aClass = (PsiClass)object;
            String signature = "@org.junit.runners.Parameterized.Parameters public static java.lang.Iterable<java.lang.Object[]> parameters()";
            final CreateMethodQuickFix fix = CreateMethodQuickFix.createFix((PsiClass)aClass, (String)"@org.junit.runners.Parameterized.Parameters public static java.lang.Iterable<java.lang.Object[]> parameters()", (String)"");
            if (fix == null) {
                return null;
            }
            return new LocalQuickFix(){

                @NotNull
                public String getName() {
                    String string = this.getFamilyName();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = JUnitBundle.message("fix.data.provider.create.method.fix.name", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    fix.applyFix(project, descriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 2, 3 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/execution/junit/codeInspection/ParameterizedParametersStaticCollectionInspection$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/execution/junit/codeInspection/ParameterizedParametersStaticCollectionInspection$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 2, 3 -> new IllegalArgumentException(string);
                    };
                }
            };
        }
        return new LocalQuickFix(){

            public boolean startInWriteAction() {
                return false;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement problemElement;
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((problemElement = descriptor.getPsiElement()) == null || !problemElement.isValid()) {
                    return;
                }
                PsiElement element = problemElement.getParent();
                if (!(element instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)element;
                WriteAction.run(() -> {
                    VirtualFile vFile = method.getContainingFile().getVirtualFile();
                    if (ReadonlyStatusHandler.getInstance((Project)method.getProject()).ensureFilesWritable(List.of(vFile)).hasReadonlyFiles()) {
                        return;
                    }
                    method.getModifierList().setModifierProperty("static", true);
                });
                PsiType type = (PsiType)infos[1];
                ParameterInfoImpl @NotNull [] parameterInfo = new ParameterInfoImpl[]{};
                ChangeSignatureRefactoring csp = JavaRefactoringFactory.getInstance((Project)project).createChangeSignatureProcessor(method, false, "public", method.getName(), type, (ParameterInfo[])parameterInfo, null, null, null, null);
                csp.run();
            }

            @NotNull
            public String getName() {
                String string = JUnitBundle.message("fix.data.provider.signature.fix.name", infos[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = JUnitBundle.message("fix.data.provider.signature.family.name", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/junit/codeInspection/ParameterizedParametersStaticCollectionInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/junit/codeInspection/ParameterizedParametersStaticCollectionInspection$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos.length == 0) {
            String string = JUnitBundle.message("fix.data.provider.multiple.methods.problem", new Object[0]);
            if (string == null) {
                ParameterizedParametersStaticCollectionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = infos.length > 1 ? JUnitBundle.message("fix.data.provider.signature.incorrect.problem", new Object[0]) : JUnitBundle.message("fix.data.provider.signature.missing.method.problem", new Object[0]);
        if (string == null) {
            ParameterizedParametersStaticCollectionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(this){

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!TestUtils.isParameterizedTest((PsiClass)aClass)) {
                    return;
                }
                Project project = aClass.getProject();
                PsiClass iterableClass = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Iterable", GlobalSearchScope.allScope((Project)project));
                if (iterableClass == null) {
                    return;
                }
                int methodFound = 0;
                for (PsiMethod method : aClass.getMethods()) {
                    String signatureText;
                    boolean iterable;
                    if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)ParameterizedParametersStaticCollectionInspection.PARAMETERS_FQN, (int)0)) continue;
                    ++methodFound;
                    boolean notPublic = !method.hasModifierProperty("public");
                    boolean notStatic = !method.hasModifierProperty("static");
                    PsiType returnType = method.getReturnType();
                    PsiClass returnTypeClass = PsiUtil.resolveClassInType((PsiType)returnType);
                    boolean objectArray = returnType instanceof PsiArrayType && returnType.getDeepComponentType().equalsToText("java.lang.Object");
                    boolean bl = iterable = returnTypeClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)returnTypeClass, (PsiClass)iterableClass, (boolean)true);
                    if (!objectArray && !iterable) {
                        signatureText = "public static Iterable<Object[]> " + method.getName() + "()";
                        returnType = JavaPsiFacade.getElementFactory((Project)project).createTypeFromText("java.lang.Iterable<java.lang.Object[]>", (PsiElement)method);
                    } else {
                        signatureText = "public static " + returnType.getPresentableText() + " " + method.getName() + "()";
                    }
                    if (!notPublic && !notStatic && (objectArray || iterable)) continue;
                    this.registerMethodError(method, new Object[]{signatureText, returnType});
                }
                if (methodFound == 0) {
                    this.registerClassError(aClass, new Object[]{aClass});
                } else if (methodFound > 1) {
                    this.registerClassError(aClass, new Object[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/execution/junit/codeInspection/ParameterizedParametersStaticCollectionInspection$3", "visitClass"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInspection/ParameterizedParametersStaticCollectionInspection", "buildErrorString"));
    }
}

