/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor.lineMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonLineMover
extends LineMover {
    private Direction myDirection = Direction.Same;

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            JsonLineMover.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JsonLineMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            JsonLineMover.$$$reportNull$$$0(2);
        }
        this.myDirection = Direction.Same;
        if (!(file instanceof JsonFile) || !super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        Pair<PsiElement, PsiElement> movedElementRange = JsonLineMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)info.toMove);
        if (!JsonLineMover.isValidElementRange(movedElementRange)) {
            return false;
        }
        movedElementRange = JsonLineMover.expandCommentsInRange(movedElementRange);
        PsiElement movedSecond = (PsiElement)movedElementRange.getSecond();
        PsiElement movedFirst = (PsiElement)movedElementRange.getFirst();
        info.toMove = new LineRange(movedFirst, movedSecond);
        int lineCount = editor.getDocument().getLineCount();
        info.toMove2 = down ? new LineRange(info.toMove.endLine, Math.min(info.toMove.endLine + 1, lineCount)) : new LineRange(Math.max(info.toMove.startLine - 1, 0), info.toMove.startLine);
        if (movedFirst instanceof PsiComment && movedSecond instanceof PsiComment) {
            return true;
        }
        Pair destElementRange = JsonLineMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)info.toMove2);
        if (destElementRange != null) {
            JsonValue secondParentParent;
            PsiElement parent;
            PsiElement destSecond;
            PsiElement destFirst = (PsiElement)destElementRange.getFirst();
            if (destFirst == (destSecond = (PsiElement)destElementRange.getSecond()) && !(destFirst instanceof JsonProperty) && !(destFirst instanceof JsonValue) && ((JsonFile)(parent = destFirst.getParent()).getContainingFile()).getTopLevelValue() == parent) {
                info.prohibitMove();
                return true;
            }
            PsiElement firstParent = destFirst.getParent();
            PsiElement secondParent = destSecond.getParent();
            JsonValue firstParentParent = (JsonValue)PsiTreeUtil.getParentOfType((PsiElement)firstParent, (Class[])new Class[]{JsonObject.class, JsonArray.class});
            if (firstParentParent == secondParent) {
                Direction direction = this.myDirection = down ? Direction.Outside : Direction.Inside;
            }
            if (firstParent == (secondParentParent = (JsonValue)PsiTreeUtil.getParentOfType((PsiElement)secondParent, (Class[])new Class[]{JsonObject.class, JsonArray.class}))) {
                this.myDirection = down ? Direction.Inside : Direction.Outside;
            }
        }
        return true;
    }

    @NotNull
    private static Pair<PsiElement, PsiElement> expandCommentsInRange(@NotNull Pair<PsiElement, PsiElement> range) {
        if (range == null) {
            JsonLineMover.$$$reportNull$$$0(3);
        }
        PsiElement upper = JsonPsiUtil.findFurthestSiblingOfSameType((PsiElement)range.getFirst(), false);
        PsiElement lower = JsonPsiUtil.findFurthestSiblingOfSameType((PsiElement)range.getSecond(), true);
        Pair pair = Pair.create((Object)upper, (Object)lower);
        if (pair == null) {
            JsonLineMover.$$$reportNull$$$0(4);
        }
        return pair;
    }

    public void afterMove(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            JsonLineMover.$$$reportNull$$$0(5);
        }
        if (file == null) {
            JsonLineMover.$$$reportNull$$$0(6);
        }
        if (info == null) {
            JsonLineMover.$$$reportNull$$$0(7);
        }
        int diff = info.toMove.endLine - info.toMove.startLine - (info.toMove2.endLine - info.toMove2.startLine);
        switch (this.myDirection.ordinal()) {
            case 0: {
                JsonLineMover.addCommaIfNeeded(editor.getDocument(), down ? info.toMove.endLine - 1 - diff : info.toMove2.endLine - 1 + diff);
                JsonLineMover.trimCommaIfNeeded(editor.getDocument(), file, down ? info.toMove.endLine : info.toMove2.endLine + diff);
                break;
            }
            case 1: {
                if (!down) {
                    JsonLineMover.addCommaIfNeeded(editor.getDocument(), info.toMove2.startLine - 1);
                }
                JsonLineMover.trimCommaIfNeeded(editor.getDocument(), file, down ? info.toMove.startLine : info.toMove2.startLine);
                JsonLineMover.trimCommaIfNeeded(editor.getDocument(), file, down ? info.toMove.endLine : info.toMove2.endLine + diff);
                break;
            }
            case 2: {
                JsonLineMover.addCommaIfNeeded(editor.getDocument(), down ? info.toMove.startLine : info.toMove2.startLine);
                JsonLineMover.trimCommaIfNeeded(editor.getDocument(), file, down ? info.toMove.endLine : info.toMove2.endLine + diff);
                if (!down) break;
                JsonLineMover.trimCommaIfNeeded(editor.getDocument(), file, info.toMove.startLine - 1);
                JsonLineMover.addCommaIfNeeded(editor.getDocument(), info.toMove.endLine);
                JsonLineMover.trimCommaIfNeeded(editor.getDocument(), file, info.toMove.endLine);
            }
        }
    }

    private static int getForwardLineNumber(Document document, PsiElement element) {
        while (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            element = element.getNextSibling();
        }
        if (element == null) {
            return -1;
        }
        TextRange range = element.getTextRange();
        return document.getLineNumber(range.getEndOffset());
    }

    private static int getBackwardLineNumber(Document document, PsiElement element) {
        while (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            element = element.getPrevSibling();
        }
        if (element == null) {
            return -1;
        }
        TextRange range = element.getTextRange();
        return document.getLineNumber(range.getEndOffset());
    }

    private static void trimCommaIfNeeded(Document document, PsiFile file, int line) {
        int offset = document.getLineEndOffset(line);
        if (JsonLineMover.doTrimComma(document, offset + 1, offset)) {
            return;
        }
        PsiElement element = file.findElementAt(offset - 1);
        int forward = JsonLineMover.getForwardLineNumber(document, element);
        int backward = JsonLineMover.getBackwardLineNumber(document, element);
        if (forward < 0 || backward < 0) {
            return;
        }
        JsonLineMover.doTrimComma(document, document.getLineEndOffset(forward) - 1, document.getLineEndOffset(backward));
    }

    private static boolean doTrimComma(Document document, int forwardOffset, int backwardOffset) {
        CharSequence charSequence = document.getCharsSequence();
        if (backwardOffset <= 0) {
            return true;
        }
        if (charSequence.charAt(backwardOffset - 1) == ',') {
            int offsetAfter = JsonLineMover.skipWhitespaces(charSequence, forwardOffset);
            if (offsetAfter >= charSequence.length()) {
                return true;
            }
            char ch = charSequence.charAt(offsetAfter);
            if (ch == ']' || ch == '}') {
                document.deleteString(backwardOffset - 1, backwardOffset);
            }
            if (ch != '/') {
                return true;
            }
        }
        return false;
    }

    private static int skipWhitespaces(CharSequence charSequence, int offset2) {
        while (offset2 < charSequence.length() && Character.isWhitespace(charSequence.charAt(offset2))) {
            ++offset2;
        }
        return offset2;
    }

    private static void addCommaIfNeeded(Document document, int line) {
        int offset = document.getLineEndOffset(line);
        if (offset > 0 && document.getCharsSequence().charAt(offset - 1) != ',') {
            document.insertString(offset, (CharSequence)",");
        }
    }

    private static boolean isValidElementRange(@Nullable Pair<PsiElement, PsiElement> elementRange) {
        if (elementRange == null) {
            return false;
        }
        return ((PsiElement)elementRange.getFirst()).getParent() == ((PsiElement)elementRange.getSecond()).getParent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/editor/lineMover/JsonLineMover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/editor/lineMover/JsonLineMover";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "expandCommentsInRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "expandCommentsInRange";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "afterMove";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static enum Direction {
        Same,
        Inside,
        Outside;

    }
}

