/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.ijent.IjentChildPtyProcessAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.terminal.pty.PtyProcessTtyConnector;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jediterm.core.util.TermSize;
import com.pty4j.PtyProcess;
import com.pty4j.unix.UnixPtyProcess;
import com.pty4j.windows.conpty.WinConPtyProcess;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.ShellProcessHolder;
import org.jetbrains.plugins.terminal.util.ShellEelProcess;

@ApiStatus.Internal
public class LocalTerminalTtyConnector
extends PtyProcessTtyConnector {
    private static final Logger LOG = Logger.getInstance(LocalTerminalTtyConnector.class);
    @NotNull
    private final PtyProcess myProcess;
    @NotNull
    private final ShellProcessHolder myShellProcessHolder;

    public LocalTerminalTtyConnector(@NotNull ShellProcessHolder shellProcessHolder, @NotNull Charset charset) {
        if (shellProcessHolder == null) {
            LocalTerminalTtyConnector.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            LocalTerminalTtyConnector.$$$reportNull$$$0(1);
        }
        super(shellProcessHolder.getPtyProcess(), charset);
        this.myProcess = shellProcessHolder.getPtyProcess();
        this.myShellProcessHolder = shellProcessHolder;
    }

    @ApiStatus.Internal
    @NotNull
    public EelDescriptor getEelDescriptor() {
        EelDescriptor eelDescriptor = this.myShellProcessHolder.getDescriptor();
        if (eelDescriptor == null) {
            LocalTerminalTtyConnector.$$$reportNull$$$0(2);
        }
        return eelDescriptor;
    }

    @ApiStatus.Internal
    @NotNull
    public ShellEelProcess getShellEelProcess() {
        return new ShellEelProcess(this.myShellProcessHolder.getEelProcess(), this.myShellProcessHolder.getEelApi(), this.myProcess);
    }

    public void close() {
        if (this.myProcess instanceof UnixPtyProcess) {
            ((UnixPtyProcess)this.myProcess).hangup();
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                if (this.myProcess.isAlive()) {
                    LOG.info("Terminal hasn't been terminated by SIGHUP, performing default termination");
                    this.myProcess.destroy();
                }
            }, 1000L, TimeUnit.MILLISECONDS);
        } else if (this.myProcess instanceof IjentChildPtyProcessAdapter && this.myShellProcessHolder.isPosix()) {
            this.myShellProcessHolder.terminatePosixShell();
        } else {
            WinConPtyProcess winConPtyProcess;
            PtyProcess ptyProcess = this.myProcess;
            if (ptyProcess instanceof WinConPtyProcess && !(winConPtyProcess = (WinConPtyProcess)ptyProcess).isBundledConPtyLibrary()) {
                this.sendInterruptToWinConPtyProcess();
            }
            this.myProcess.destroy();
        }
    }

    private void sendInterruptToWinConPtyProcess() {
        OutputStream outputStream = this.myProcess.getOutputStream();
        if (outputStream != null && this.myProcess.isAlive()) {
            try {
                outputStream.write(3);
                outputStream.flush();
            }
            catch (IOException e) {
                LOG.info("Failed to send Ctrl+C to " + this.myProcess.getClass().getSimpleName() + ", alive:" + this.myProcess.isAlive(), (Throwable)e);
            }
        }
    }

    public void resize(@NotNull TermSize termSize) {
        if (termSize == null) {
            LocalTerminalTtyConnector.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("resize to " + String.valueOf(termSize));
        }
        super.resize(termSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellProcessHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/LocalTerminalTtyConnector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "termSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/LocalTerminalTtyConnector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEelDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

