/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.engine.TemplateData;

final class EngineContextManager {
    static IEngineContext prepareEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IContext context) {
        IEngineContext engineContext = EngineContextManager.createEngineContextIfNeeded(configuration, templateData, templateResolutionAttributes, context);
        engineContext.increaseLevel();
        if (context instanceof IEngineContext) {
            engineContext.setTemplateData(templateData);
        }
        return engineContext;
    }

    static void disposeEngineContext(IEngineContext engineContext) {
        engineContext.decreaseLevel();
    }

    private static IEngineContext createEngineContextIfNeeded(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IContext context) {
        if (context instanceof IEngineContext) {
            return (IEngineContext)context;
        }
        IEngineContextFactory engineContextFactory = configuration.getEngineContextFactory();
        return engineContextFactory.createEngineContext(configuration, templateData, templateResolutionAttributes, context);
    }

    private EngineContextManager() {
    }
}

