/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.find;

import com.intellij.concurrency.ThreadContext;
import com.intellij.find.impl.FindKey;
import com.intellij.ide.SelectInEditorManager;
import com.intellij.ide.ui.SerializableTextChunk;
import com.intellij.ide.ui.SerializableTextChunkKt;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.DocumentFullUpdateListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.find.FindInFilesResult;
import com.intellij.platform.find.UsageInfoModel;
import com.intellij.platform.find.UsageInfoModelKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ItemWithLazyContent;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfoAdapter;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.UsageDocumentProcessor;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c3\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005*\u00011\b\u0000\u0018\u0000 X2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002XYB/\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010*\u001a\u00020%H\u0002J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000204H\u0002J\b\u00106\u001a\u00020%H\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020.0\u001fH\u0002J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u00020%H\u0016J\u0013\u0010;\u001a\b\u0012\u0004\u0012\u00020!0<H\u0016\u00a2\u0006\u0002\u0010=J\u0014\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0<0?H\u0016J\b\u0010@\u001a\u00020%H\u0016J\b\u0010A\u001a\u00020%H\u0016J\b\u0010B\u001a\u00020%H\u0016J\u0010\u0010C\u001a\u0002042\u0006\u0010D\u001a\u00020%H\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010D\u001a\u00020%H\u0002J\b\u0010G\u001a\u00020HH\u0016J\b\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020JH\u0016J\n\u0010L\u001a\u0004\u0018\u00010MH\u0016J\b\u0010N\u001a\u000204H\u0016J\b\u0010O\u001a\u000204H\u0016J\u0010\u0010P\u001a\u00020%2\u0006\u0010Q\u001a\u00020RH\u0016J\b\u0010S\u001a\u000204H\u0016J\b\u0010T\u001a\u00020UH\u0016J\n\u0010V\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010W\u001a\u0004\u0018\u00010\u001bH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001f8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001e\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020%@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020.0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00102\u00a8\u0006Z"}, d2={"Lcom/intellij/platform/find/UsageInfoModel;", "Lcom/intellij/usages/UsageInfoAdapter;", "Lcom/intellij/usages/rules/UsageInFile;", "Lcom/intellij/usages/rules/UsageDocumentProcessor;", "Lcom/intellij/usages/ItemWithLazyContent;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/platform/find/FindInFilesResult;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "initializationListener", "Ljava/util/function/Consumer;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/find/FindInFilesResult;Lkotlinx/coroutines/CoroutineScope;Ljava/util/function/Consumer;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getModel", "()Lcom/intellij/platform/find/FindInFilesResult;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cachedPsiFile", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "cachedSmartRange", "Lcom/intellij/psi/SmartPsiFileRange;", "cachedMergedSmartRanges", "", "cachedUsageInfos", "Lcom/intellij/usageView/UsageInfo;", "getCachedUsageInfos", "()Ljava/util/List;", "value", "", "isLoaded", "setLoaded", "(Z)V", "isPreviewAccessed", "isRemDev", "initializationJob", "Lkotlinx/coroutines/Job;", "defaultRange", "Lcom/intellij/openapi/util/TextRange;", "defaultMergedRanges", "fullUpdateListener", "com/intellij/platform/find/UsageInfoModel$fullUpdateListener$1", "Lcom/intellij/platform/find/UsageInfoModel$fullUpdateListener$1;", "dispose", "", "initialize", "isContentComputed", "getMergedRanges", "calculateRange", "Lcom/intellij/openapi/util/Segment;", "isValid", "getMergedInfos", "", "()[Lcom/intellij/usageView/UsageInfo;", "getMergedInfosAsync", "Ljava/util/concurrent/CompletableFuture;", "isReadOnly", "canNavigate", "canNavigateToSource", "navigate", "requestFocus", "openTextEditor", "Lcom/intellij/openapi/editor/Editor;", "getPath", "", "getLine", "", "getNavigationOffset", "getLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "highlightInEditor", "selectInEditor", "merge", "mergeableUsage", "Lcom/intellij/usages/rules/MergeableUsage;", "reset", "getPresentation", "Lcom/intellij/usages/UsagePresentation;", "getFile", "getDocument", "Companion", "UsageInfoModelPresentation", "intellij.platform.find"})
@SourceDebugExtension(value={"SMAP\nUsageInfoModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsageInfoModel.kt\ncom/intellij/platform/find/UsageInfoModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,331:1\n1563#2:332\n1634#2,3:333\n1617#2,9:336\n1869#2:345\n1870#2:347\n1626#2:348\n1056#2:349\n1617#2,9:350\n1869#2:359\n1870#2:362\n1626#2:363\n1740#2,3:364\n1#3:346\n1#3:360\n1#3:361\n1#3:369\n37#4,2:367\n82#5,3:370\n*S KotlinDebug\n*F\n+ 1 UsageInfoModel.kt\ncom/intellij/platform/find/UsageInfoModel\n*L\n81#1:332\n81#1:333,3\n106#1:336,9\n106#1:345\n106#1:347\n106#1:348\n106#1:349\n191#1:350,9\n191#1:359\n191#1:362\n191#1:363\n218#1:364,3\n106#1:346\n191#1:361\n228#1:367,2\n304#1:370,3\n*E\n"})
public final class UsageInfoModel
implements UsageInfoAdapter,
UsageInFile,
UsageDocumentProcessor,
ItemWithLazyContent,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final FindInFilesResult model;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Consumer<UsageInfoAdapter> initializationListener;
    @Nullable
    private final VirtualFile virtualFile;
    @Nullable
    private PsiFile cachedPsiFile;
    @Nullable
    private Document document;
    @Nullable
    private SmartPsiFileRange cachedSmartRange;
    @NotNull
    private List<? extends SmartPsiFileRange> cachedMergedSmartRanges;
    @NotNull
    private List<? extends UsageInfo> cachedUsageInfos;
    private boolean isLoaded;
    private boolean isPreviewAccessed;
    @Nullable
    private Job initializationJob;
    @NotNull
    private final TextRange defaultRange;
    @NotNull
    private final List<TextRange> defaultMergedRanges;
    @NotNull
    private final fullUpdateListener.1 fullUpdateListener;

    /*
     * WARNING - void declaration
     */
    private UsageInfoModel(Project project, FindInFilesResult model, CoroutineScope coroutineScope, Consumer<UsageInfoAdapter> initializationListener) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        UsageInfo virtualFile;
        void $this$virtualFile_u24lambda_u240;
        this.project = project;
        this.model = model;
        this.coroutineScope = coroutineScope;
        this.initializationListener = initializationListener;
        UsageInfoModel usageInfoModel = this;
        UsageInfoModel usageInfoModel2 = this;
        boolean $i$a$-run-UsageInfoModel$virtualFile$22 = false;
        UsageInfo usageInfo = (UsageInfo)CollectionsKt.firstOrNull($this$virtualFile_u24lambda_u240.model.getUsageInfos());
        if (usageInfo == null || (usageInfo = usageInfo.getFile()) == null || (usageInfo = usageInfo.getVirtualFile()) == null) {
            usageInfo = VirtualFileIdKt.virtualFile((VirtualFileId)$this$virtualFile_u24lambda_u240.model.getFileId());
        }
        if ((virtualFile = usageInfo) == null) {
            UsageInfoModelKt.access$getLOG$p().error("Cannot find virtualFile for " + $this$virtualFile_u24lambda_u240.model.getPresentablePath());
        }
        usageInfoModel2.virtualFile = virtualFile;
        this.cachedMergedSmartRanges = CollectionsKt.emptyList();
        this.cachedUsageInfos = CollectionsKt.emptyList();
        this.defaultRange = new TextRange(this.model.getNavigationOffset(), this.model.getNavigationOffset() + this.model.getLength());
        Iterable iterable = this.model.getMergedOffsets();
        usageInfoModel2 = this;
        boolean $i$f$map = false;
        void $i$a$-run-UsageInfoModel$virtualFile$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TextRange((int)it, (int)(it + this.model.getLength())));
        }
        usageInfoModel2.defaultMergedRanges = (List)destination$iv$iv;
        this.fullUpdateListener = new DocumentFullUpdateListener(this){
            final /* synthetic */ UsageInfoModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFullUpdateDocument(Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                PsiDocumentManager.getInstance((Project)this.this$0.getProject()).performForCommittedDocument(document, () -> fullUpdateListener.1.onFullUpdateDocument$lambda$0(this.this$0));
            }

            private static final void onFullUpdateDocument$lambda$0(UsageInfoModel this$0) {
                UsageInfoModel.access$initialize(this$0);
            }
        };
        this.initialize();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final FindInFilesResult getModel() {
        return this.model;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    private final List<UsageInfo> getCachedUsageInfos() {
        if (this.cachedUsageInfos.isEmpty()) {
            UsageInfoModelKt.access$getLOG$p().debug("UsageInfos are not yet initialized for " + this.model.getPresentablePath());
        }
        return this.cachedUsageInfos;
    }

    private final void setLoaded(boolean value) {
        this.isLoaded = value;
        if (value && this.isRemDev()) {
            this.initializationListener.accept(this);
        }
    }

    private final boolean isRemDev() {
        return this.model.getUsageInfos().isEmpty();
    }

    public void dispose() {
        block0: {
            Document document = this.document;
            DocumentEx documentEx = document instanceof DocumentEx ? (DocumentEx)document : null;
            if (documentEx == null) break block0;
            documentEx.removeFullUpdateListener((DocumentFullUpdateListener)this.fullUpdateListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initialize() {
        if (!this.isRemDev()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            this.cachedUsageInfos = this.model.getUsageInfos();
            UsageInfo usageInfo = (UsageInfo)CollectionsKt.firstOrNull(this.getCachedUsageInfos());
            this.cachedPsiFile = usageInfo != null ? usageInfo.getFile() : null;
            Iterable iterable = this.getCachedUsageInfos();
            UsageInfoModel usageInfoModel = this;
            boolean $i$f$mapNotNull = false;
            void var3_4 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SmartPsiFileRange it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UsageInfo it = (UsageInfo)element$iv$iv;
                boolean bl2 = false;
                if (it.getPsiFileRange() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            usageInfoModel.cachedMergedSmartRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SmartPsiFileRange it = (SmartPsiFileRange)a;
                    boolean bl = false;
                    Segment segment = it.getRange();
                    it = (SmartPsiFileRange)b;
                    Comparable comparable = Integer.valueOf(segment != null ? segment.getStartOffset() : 0);
                    bl = false;
                    Segment segment2 = it.getRange();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(segment2 != null ? segment2.getStartOffset() : 0));
                }
            });
            this.cachedSmartRange = (SmartPsiFileRange)CollectionsKt.firstOrNull(this.cachedMergedSmartRanges);
            this.setLoaded(true);
        } else {
            if (FindKey.isLazyPreviewEnabled() && !this.isPreviewAccessed) {
                return;
            }
            Job job = this.initializationJob;
            boolean bl = job != null ? job.isActive() : false;
            if (bl) {
                UsageInfoModelKt.access$getLOG$p().debug("Initialization job is already in progress " + this.model.getPresentablePath());
                return;
            }
            this.initializationJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int label;
                final /* synthetic */ UsageInfoModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                public final Object invokeSuspend(Object $result) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.dump(StructuredIf.java:65)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                /*
                 * WARNING - void declaration
                 */
                private static final Unit invokeSuspend$lambda$1(UsageInfoModel this$0) {
                    TextRange range;
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    boolean $i$f$mapTo;
                    Collection destination$iv$iv;
                    Iterable $this$map$iv;
                    boolean $i$f$map;
                    List list;
                    Iterable it;
                    UsageInfoModel usageInfoModel;
                    PsiFile psiFile;
                    VirtualFile vFile;
                    VirtualFile virtualFile = UsageInfoModel.access$getVirtualFile$p(this$0);
                    if (virtualFile != null) {
                        vFile = virtualFile;
                        boolean bl = false;
                        psiFile = PsiManager.getInstance((Project)this$0.getProject()).findFile(vFile);
                    } else {
                        psiFile = null;
                    }
                    PsiFile psiFile2 = psiFile;
                    UsageInfoModel.access$setCachedPsiFile$p(this$0, psiFile2);
                    if (UsageInfoModel.access$getDocument$p(this$0) == null) {
                        PsiFile psiFile3;
                        UsageInfoModel usageInfoModel2 = this$0;
                        PsiFile psiFile4 = psiFile2;
                        if (psiFile4 != null && (psiFile4 = psiFile4.getFileDocument()) != null) {
                            PsiFile psiFile5 = psiFile4;
                            vFile = psiFile5;
                            usageInfoModel = usageInfoModel2;
                            boolean bl = false;
                            DocumentEx documentEx = it instanceof DocumentEx ? (DocumentEx)it : null;
                            if (documentEx != null) {
                                documentEx.addFullUpdateListener((DocumentFullUpdateListener)UsageInfoModel.access$getFullUpdateListener$p(this$0));
                            }
                            usageInfoModel2 = usageInfoModel;
                            psiFile3 = psiFile5;
                        } else {
                            psiFile3 = null;
                        }
                        UsageInfoModel.access$setDocument$p(usageInfoModel2, psiFile3);
                    }
                    if (psiFile2 == null) {
                        UsageInfoModelKt.access$getLOG$p().error("Cannot find psiFile for file " + this$0.getModel().getPresentablePath());
                        return Unit.INSTANCE;
                    }
                    SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this$0.getProject());
                    SmartPsiFileRange smartPsiFileRange = smartPointerManager.createSmartPsiFileRangePointer(psiFile2, UsageInfoModel.access$getDefaultRange$p(this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
                    SmartPsiFileRange smartRange = smartPsiFileRange;
                    UsageInfoModel.access$setCachedSmartRange$p(this$0, smartRange);
                    UsageInfoModel usageInfoModel3 = this$0;
                    if (UsageInfoModel.access$getDefaultMergedRanges$p(this$0).size() == 1) {
                        list = CollectionsKt.listOf((Object)smartRange);
                    } else {
                        it = UsageInfoModel.access$getDefaultMergedRanges$p(this$0);
                        usageInfoModel = usageInfoModel3;
                        $i$f$map = false;
                        void var6_7 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            TextRange textRange = (TextRange)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(smartPointerManager.createSmartPsiFileRangePointer(psiFile2, range));
                        }
                        list = (List)destination$iv$iv;
                        usageInfoModel3 = usageInfoModel;
                    }
                    UsageInfoModel.access$setCachedMergedSmartRanges$p(usageInfoModel3, list);
                    $this$map$iv = UsageInfoModel.access$getDefaultMergedRanges$p(this$0);
                    usageInfoModel = this$0;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        range = (TextRange)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new UsageInfo((PsiElement)psiFile2, (TextRange)it2, false));
                    }
                    UsageInfoModel.access$setCachedUsageInfos$p(usageInfoModel, (List)destination$iv$iv);
                    return Unit.INSTANCE;
                }
            }), (int)2, null);
        }
    }

    public boolean isContentComputed() {
        if (this.isLoaded) {
            return true;
        }
        this.isPreviewAccessed = true;
        this.initialize();
        return this.isLoaded;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> getMergedRanges() {
        List list;
        if (this.cachedMergedSmartRanges.size() < this.defaultMergedRanges.size()) {
            list = this.defaultMergedRanges;
        } else {
            List<TextRange> list2;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.cachedMergedSmartRanges;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                TextRange textRange;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SmartPsiFileRange smartRange = (SmartPsiFileRange)element$iv$iv;
                boolean bl2 = false;
                if (smartRange.getRange() != null) {
                    Segment it;
                    boolean bl3 = false;
                    textRange = new TextRange(it.getStartOffset(), it.getEndOffset());
                } else {
                    textRange = null;
                }
                if (textRange == null) continue;
                TextRange it$iv$iv = textRange;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List<TextRange> list3 = (List)destination$iv$iv;
            if (list3.isEmpty()) {
                boolean bl = false;
                list2 = this.defaultMergedRanges;
            } else {
                list2 = list3;
            }
            list = list2;
        }
        return list;
    }

    private final Segment calculateRange() {
        Segment range;
        SmartPsiFileRange smartPsiFileRange = this.cachedSmartRange;
        Object object = range = smartPsiFileRange != null ? smartPsiFileRange.getRange() : null;
        if (range == null) {
            String logMessage = "Smart range is null for " + this.model.getPresentablePath() + ". The default range will be used.";
            Job job = this.initializationJob;
            if (!(job != null ? job.isActive() : false)) {
                UsageInfoModelKt.access$getLOG$p().warn(logMessage);
            } else {
                UsageInfoModelKt.access$getLOG$p().debug(logMessage);
            }
            return (Segment)this.defaultRange;
        }
        return range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid() {
        boolean bl;
        int n;
        VirtualFile virtualFile = this.virtualFile;
        if (virtualFile == null) return false;
        if (!virtualFile.isValid()) return false;
        boolean bl2 = true;
        if (!bl2) {
            return false;
        }
        if (FileTypeManager.getInstance().getFileTypeByFile(this.virtualFile).isBinary()) {
            return false;
        }
        Document document = this.document;
        if (document != null) {
            n = document.getTextLength();
        } else {
            PsiFile psiFile = this.cachedPsiFile;
            n = psiFile != null ? psiFile.getTextLength() : this.model.getFileLength();
        }
        int fileLength = n;
        List<TextRange> ranges = this.getMergedRanges();
        if (((Collection)ranges).isEmpty()) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        Iterable $this$all$iv = ranges;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            TextRange range = (TextRange)element$iv;
            boolean bl4 = false;
            if (!TextRange.isProperRange((int)range.getStartOffset(), (int)range.getEndOffset())) return false;
            if (range.getEndOffset() > fileLength) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    public UsageInfo[] getMergedInfos() {
        if (!this.isLoaded && !((Collection)this.defaultMergedRanges).isEmpty() && this.getCachedUsageInfos().isEmpty()) {
            this.initialize();
        }
        Collection $this$toTypedArray$iv = this.getCachedUsageInfos();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    @NotNull
    public CompletableFuture<UsageInfo[]> getMergedInfosAsync() {
        CompletableFuture<UsageInfo[]> completableFuture = CompletableFuture.supplyAsync(() -> UsageInfoModel.getMergedInfosAsync$lambda$1(ThreadContext.captureThreadContext(() -> UsageInfoModel.getMergedInfosAsync$lambda$0(this))));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    public boolean isReadOnly() {
        return this.virtualFile == null || !this.virtualFile.isWritable();
    }

    public boolean canNavigate() {
        return this.virtualFile != null && this.virtualFile.isValid();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            this.openTextEditor(requestFocus);
        }
    }

    private final Editor openTextEditor(boolean requestFocus) {
        VirtualFile virtualFile = this.virtualFile;
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Segment range = this.calculateRange();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.project, virtualFile2, range.getStartOffset());
        return FileEditorManager.getInstance((Project)this.project).openTextEditor(descriptor, requestFocus);
    }

    @NotNull
    public String getPath() {
        return this.model.getPresentablePath();
    }

    public int getLine() {
        return this.model.getLine();
    }

    public int getNavigationOffset() {
        return this.calculateRange().getStartOffset();
    }

    @Nullable
    public FileEditorLocation getLocation() {
        if (this.virtualFile == null) {
            return null;
        }
        FileEditor editor = FileEditorManager.getInstance((Project)this.project).getSelectedEditor(this.virtualFile);
        if (!(editor instanceof TextEditor)) {
            return null;
        }
        Segment segment = this.calculateRange();
        return (FileEditorLocation)new TextEditorLocation(segment.getStartOffset(), (TextEditor)editor);
    }

    public void highlightInEditor() {
        if (!this.isValid()) {
            return;
        }
        Segment marker = this.calculateRange();
        SelectInEditorManager.getInstance((Project)this.project).selectInEditor(this.virtualFile, marker.getStartOffset(), marker.getEndOffset(), false, false);
    }

    public void selectInEditor() {
        if (!this.isValid()) {
            return;
        }
        Editor editor = this.openTextEditor(true);
        if (editor == null) {
            UsageInfoModelKt.access$getLOG$p().error("Cannot open editor for " + this.getPath());
            return;
        }
        Segment marker = this.calculateRange();
        editor.getSelectionModel().setSelection(marker.getStartOffset(), marker.getEndOffset());
    }

    public boolean merge(@NotNull MergeableUsage mergeableUsage) {
        Intrinsics.checkNotNullParameter((Object)mergeableUsage, (String)"mergeableUsage");
        return false;
    }

    public void reset() {
    }

    @NotNull
    public UsagePresentation getPresentation() {
        return new UsageInfoModelPresentation(this.model);
    }

    @Nullable
    public VirtualFile getFile() {
        return this.virtualFile;
    }

    @Nullable
    public Document getDocument() {
        Object object;
        Document document = this.document;
        if (document != null) {
            Document it = document;
            boolean bl = false;
            return it;
        }
        Logger $this$runAndLogException$iv = UsageInfoModelKt.access$getLOG$p();
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)((Document)ActionsKt.runReadAction(() -> UsageInfoModel.getDocument$lambda$1$0(this))));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (Document)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    private static final UsageInfo[] getMergedInfosAsync$lambda$0(UsageInfoModel this$0) {
        return this$0.getMergedInfos();
    }

    private static final UsageInfo[] getMergedInfosAsync$lambda$1(Function0 $tmp0) {
        return (UsageInfo[])$tmp0.invoke();
    }

    private static final Document getDocument$lambda$1$0(UsageInfoModel this$0) {
        Document doc;
        block6: {
            Object object;
            Document psiDoc;
            PsiFile psiFile = this$0.cachedPsiFile;
            if (psiFile != null) {
                PsiFile psiFile2 = psiFile;
                boolean bl = false;
                v1 = PsiDocumentManager.getInstance((Project)this$0.project).getDocument(psiFile2);
            } else {
                v1 = psiDoc = null;
            }
            if (psiDoc == null) {
                UsageInfoModelKt.access$getLOG$p().warn("PsiFile is not yet loaded for path " + this$0.model.getPresentablePath() + ". Trying to get document from virtualFile");
            }
            if ((object = psiDoc) == null) {
                VirtualFile virtualFile = this$0.virtualFile;
                object = virtualFile != null ? VirtualFileUtil.findDocument((VirtualFile)virtualFile) : null;
            }
            if ((doc = object) == null || this$0.document != null) break block6;
            this$0.document = doc;
            if (this$0.isRemDev()) {
                Document document = doc;
                DocumentEx documentEx = document instanceof DocumentEx ? (DocumentEx)document : null;
                if (documentEx != null) {
                    documentEx.addFullUpdateListener((DocumentFullUpdateListener)this$0.fullUpdateListener);
                }
            }
        }
        return doc;
    }

    @JvmStatic
    @RequiresBackgroundThread
    @NotNull
    public static final UsageInfoModel createUsageInfoModel(@NotNull Project project, @NotNull FindInFilesResult model, @NotNull CoroutineScope coroutineScope, @NotNull Consumer<UsageInfoAdapter> initializationListener) {
        return Companion.createUsageInfoModel(project, model, coroutineScope, initializationListener);
    }

    public static final /* synthetic */ VirtualFile access$getVirtualFile$p(UsageInfoModel $this) {
        return $this.virtualFile;
    }

    public static final /* synthetic */ void access$setLoaded(UsageInfoModel $this, boolean value) {
        $this.setLoaded(value);
    }

    public static final /* synthetic */ List access$getDefaultMergedRanges$p(UsageInfoModel $this) {
        return $this.defaultMergedRanges;
    }

    public static final /* synthetic */ List access$getCachedUsageInfos(UsageInfoModel $this) {
        return $this.getCachedUsageInfos();
    }

    public static final /* synthetic */ void access$setCachedPsiFile$p(UsageInfoModel $this, PsiFile psiFile) {
        $this.cachedPsiFile = psiFile;
    }

    public static final /* synthetic */ Document access$getDocument$p(UsageInfoModel $this) {
        return $this.document;
    }

    public static final /* synthetic */ void access$setDocument$p(UsageInfoModel $this, Document document) {
        $this.document = document;
    }

    public static final /* synthetic */ TextRange access$getDefaultRange$p(UsageInfoModel $this) {
        return $this.defaultRange;
    }

    public static final /* synthetic */ void access$setCachedSmartRange$p(UsageInfoModel $this, SmartPsiFileRange smartPsiFileRange) {
        $this.cachedSmartRange = smartPsiFileRange;
    }

    public static final /* synthetic */ void access$setCachedMergedSmartRanges$p(UsageInfoModel $this, List list) {
        $this.cachedMergedSmartRanges = list;
    }

    public static final /* synthetic */ void access$setCachedUsageInfos$p(UsageInfoModel $this, List list) {
        $this.cachedUsageInfos = list;
    }

    public static final /* synthetic */ fullUpdateListener.1 access$getFullUpdateListener$p(UsageInfoModel $this) {
        return $this.fullUpdateListener;
    }

    public /* synthetic */ UsageInfoModel(Project project, FindInFilesResult model, CoroutineScope coroutineScope, Consumer initializationListener, DefaultConstructorMarker $constructor_marker) {
        this(project, model, coroutineScope, initializationListener);
    }

    public static final /* synthetic */ void access$initialize(UsageInfoModel $this) {
        $this.initialize();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/find/UsageInfoModel$Companion;", "", "<init>", "()V", "createUsageInfoModel", "Lcom/intellij/platform/find/UsageInfoModel;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/platform/find/FindInFilesResult;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "initializationListener", "Ljava/util/function/Consumer;", "Lcom/intellij/usages/UsageInfoAdapter;", "intellij.platform.find"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @RequiresBackgroundThread
        @NotNull
        public final UsageInfoModel createUsageInfoModel(@NotNull Project project, @NotNull FindInFilesResult model, @NotNull CoroutineScope coroutineScope, @NotNull Consumer<UsageInfoAdapter> initializationListener) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter(initializationListener, (String)"initializationListener");
            return new UsageInfoModel(project, model, coroutineScope, initializationListener, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0015\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000f\u0010\u0010\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/find/UsageInfoModel$UsageInfoModelPresentation;", "Lcom/intellij/usages/UsagePresentation;", "model", "Lcom/intellij/platform/find/FindInFilesResult;", "<init>", "(Lcom/intellij/platform/find/FindInFilesResult;)V", "getModel", "()Lcom/intellij/platform/find/FindInFilesResult;", "getIcon", "Ljavax/swing/Icon;", "getText", "", "Lcom/intellij/usages/TextChunk;", "()[Lcom/intellij/usages/TextChunk;", "getPlainText", "", "getTooltipText", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "intellij.platform.find"})
    @SourceDebugExtension(value={"SMAP\nUsageInfoModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsageInfoModel.kt\ncom/intellij/platform/find/UsageInfoModel$UsageInfoModelPresentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,331:1\n1563#2:332\n1634#2,3:333\n37#3,2:336\n*S KotlinDebug\n*F\n+ 1 UsageInfoModel.kt\ncom/intellij/platform/find/UsageInfoModel$UsageInfoModelPresentation\n*L\n325#1:332\n325#1:333,3\n325#1:336,2\n*E\n"})
    private static final class UsageInfoModelPresentation
    implements UsagePresentation {
        @NotNull
        private final FindInFilesResult model;

        public UsageInfoModelPresentation(@NotNull FindInFilesResult model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.model = model;
        }

        @NotNull
        public final FindInFilesResult getModel() {
            return this.model;
        }

        @Nullable
        public Icon getIcon() {
            IconId iconId = this.model.getIconId();
            return iconId != null ? IconIdKt.icon((IconId)iconId) : null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public TextChunk[] getText() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.model.getPresentation();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SerializableTextChunk serializableTextChunk = (SerializableTextChunk)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SerializableTextChunkKt.textChunk((SerializableTextChunk)it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new TextChunk[0]);
        }

        @NotNull
        public String getPlainText() {
            return CollectionsKt.joinToString$default((Iterable)this.model.getPresentation(), (CharSequence)"", null, null, (int)0, null, UsageInfoModelPresentation::getPlainText$lambda$0, (int)30, null);
        }

        @Nullable
        public String getTooltipText() {
            return this.model.getTooltipText();
        }

        private static final CharSequence getPlainText$lambda$0(SerializableTextChunk it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getText();
        }
    }
}

