/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtQuick.h"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtQuick/qsgnode.sip"
#include <qsgnode.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtQuick/sipQtQuickQSGNode.cpp"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtQuick/qsgnode.sip"
#include <qsgnode.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtQuick/sipQtQuickQSGNode.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtQuick/qsgnode.sip"
#include <qsgnode.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtQuick/sipQtQuickQSGNode.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtQuick/qsgnode.sip"
static sipErrorState qsgnode_handle_flags(QSGNode *node, PyObject *self, QSGNode::Flags old_flags)
{
    QSGNode::Flags new_flags = node->flags();
    
    if (node->parent())
    {
        if ((old_flags & QSGNode::OwnedByParent) != (new_flags & QSGNode::OwnedByParent))
        {
            if (old_flags & QSGNode::OwnedByParent)
            {
                sipTransferBack(self);
            }
            else
            {
                PyObject *parent = sipConvertFromType(node->parent(), sipType_QSGNode, 0);

                if (!parent)
                    return sipErrorFail;

                sipTransferTo(self, parent);
                Py_DECREF(parent);
            }
        }
    }
    
    QSGNode::NodeType ntype = node->type();
        
    if (ntype == QSGNode::BasicNodeType || ntype == QSGNode::GeometryNodeType || ntype == QSGNode::ClipNodeType)
    {
        QSGBasicGeometryNode *bg_node = (QSGBasicGeometryNode *)node;
            
        if (bg_node->geometry())
        {
            if ((old_flags & QSGNode::OwnsGeometry) != (new_flags & QSGNode::OwnsGeometry))
            {
                PyObject *geom = sipConvertFromType(bg_node->geometry(), sipType_QSGGeometry, 0);

                if (!geom)
                    return sipErrorFail;

                if (old_flags & QSGNode::OwnsGeometry)
                    sipTransferBack(geom);
                else
                    sipTransferTo(geom, self);

                Py_DECREF(geom);
            }
        }
    }
    
    if (ntype == QSGNode::GeometryNodeType)
    {
        QSGGeometryNode *g_node = (QSGGeometryNode *)node;
            
        if (g_node->material())
        {
            if ((old_flags & QSGNode::OwnsMaterial) != (new_flags & QSGNode::OwnsMaterial))
            {
                PyObject *mat = sipConvertFromType(g_node->material(), sipType_QSGMaterial, 0);

                if (!mat)
                    return sipErrorFail;

                if (old_flags & QSGNode::OwnsMaterial)
                    sipTransferBack(mat);
                else
                    sipTransferTo(mat, self);

                Py_DECREF(mat);
            }
        }

        if (g_node->opaqueMaterial())
        {
            if ((old_flags & QSGNode::OwnsOpaqueMaterial) != (new_flags & QSGNode::OwnsOpaqueMaterial))
            {
                PyObject *omat = sipConvertFromType(g_node->opaqueMaterial(), sipType_QSGMaterial, 0);

                if (!omat)
                    return sipErrorFail;

                if (old_flags & QSGNode::OwnsOpaqueMaterial)
                    sipTransferBack(omat);
                else
                    sipTransferTo(omat, self);

                Py_DECREF(omat);
            }
        }
    }

    return sipErrorNone;
}
#line 131 "/build/pyqt5/src/PyQt5-5.15.11/build/QtQuick/sipQtQuickQSGNode.cpp"


class sipQSGNode : public ::QSGNode
{
public:
    sipQSGNode();
    virtual ~sipQSGNode();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void preprocess() SIP_OVERRIDE;
    bool isSubtreeBlocked() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQSGNode(const sipQSGNode &);
    sipQSGNode &operator = (const sipQSGNode &);

    char sipPyMethods[2];
};

sipQSGNode::sipQSGNode(): ::QSGNode(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQSGNode::~sipQSGNode()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

void sipQSGNode::preprocess()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_preprocess);

    if (!sipMeth)
    {
        ::QSGNode::preprocess();
        return;
    }

    extern void sipVH_QtQuick_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH_QtQuick_6(sipGILState, sipImportedVirtErrorHandlers_QtQuick_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQSGNode::isSubtreeBlocked() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_isSubtreeBlocked);

    if (!sipMeth)
        return ::QSGNode::isSubtreeBlocked();

    extern bool sipVH_QtQuick_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH_QtQuick_9(sipGILState, sipImportedVirtErrorHandlers_QtQuick_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_QSGNode_parent, "parent(self) -> QSGNode|None");

extern "C" {static PyObject *meth_QSGNode_parent(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_parent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            ::QSGNode*sipRes;

            sipRes = sipCpp->parent();

            return sipConvertFromType(sipRes, sipType_QSGNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_parent, doc_QSGNode_parent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_removeChildNode, "removeChildNode(self, node: QSGNode|None)");

extern "C" {static PyObject *meth_QSGNode_removeChildNode(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_removeChildNode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSGNode* a0;
        ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QSGNode, &sipCpp, sipType_QSGNode, &a0))
        {
            sipCpp->removeChildNode(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_removeChildNode, doc_QSGNode_removeChildNode);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_removeAllChildNodes, "removeAllChildNodes(self)");

extern "C" {static PyObject *meth_QSGNode_removeAllChildNodes(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_removeAllChildNodes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            sipCpp->removeAllChildNodes();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_removeAllChildNodes, doc_QSGNode_removeAllChildNodes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_prependChildNode, "prependChildNode(self, node: QSGNode|None)");

extern "C" {static PyObject *meth_QSGNode_prependChildNode(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_prependChildNode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSGNode* a0;
        PyObject *a0Wrapper;
        ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B@J8", &sipSelf, sipType_QSGNode, &sipCpp, &a0Wrapper, sipType_QSGNode, &a0))
        {
#line 192 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtQuick/qsgnode.sip"
        sipCpp->prependChildNode(a0);
        
        if (a0->flags() & QSGNode::OwnedByParent)
            sipTransferTo(a0Wrapper, sipSelf);
#line 298 "/build/pyqt5/src/PyQt5-5.15.11/build/QtQuick/sipQtQuickQSGNode.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_prependChildNode, doc_QSGNode_prependChildNode);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_appendChildNode, "appendChildNode(self, node: QSGNode|None)");

extern "C" {static PyObject *meth_QSGNode_appendChildNode(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_appendChildNode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSGNode* a0;
        PyObject *a0Wrapper;
        ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B@J8", &sipSelf, sipType_QSGNode, &sipCpp, &a0Wrapper, sipType_QSGNode, &a0))
        {
#line 200 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtQuick/qsgnode.sip"
        sipCpp->appendChildNode(a0);
        
        if (a0->flags() & QSGNode::OwnedByParent)
            sipTransferTo(a0Wrapper, sipSelf);
#line 330 "/build/pyqt5/src/PyQt5-5.15.11/build/QtQuick/sipQtQuickQSGNode.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_appendChildNode, doc_QSGNode_appendChildNode);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_insertChildNodeBefore, "insertChildNodeBefore(self, node: QSGNode|None, before: QSGNode|None)");

extern "C" {static PyObject *meth_QSGNode_insertChildNodeBefore(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_insertChildNodeBefore(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSGNode* a0;
        PyObject *a0Wrapper;
        ::QSGNode* a1;
        ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B@J8J8", &sipSelf, sipType_QSGNode, &sipCpp, &a0Wrapper, sipType_QSGNode, &a0, sipType_QSGNode, &a1))
        {
#line 208 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtQuick/qsgnode.sip"
        sipCpp->insertChildNodeBefore(a0, a1);
        
        if (a0->flags() & QSGNode::OwnedByParent)
            sipTransferTo(a0Wrapper, sipSelf);
#line 363 "/build/pyqt5/src/PyQt5-5.15.11/build/QtQuick/sipQtQuickQSGNode.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_insertChildNodeBefore, doc_QSGNode_insertChildNodeBefore);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_insertChildNodeAfter, "insertChildNodeAfter(self, node: QSGNode|None, after: QSGNode|None)");

extern "C" {static PyObject *meth_QSGNode_insertChildNodeAfter(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_insertChildNodeAfter(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSGNode* a0;
        PyObject *a0Wrapper;
        ::QSGNode* a1;
        ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B@J8J8", &sipSelf, sipType_QSGNode, &sipCpp, &a0Wrapper, sipType_QSGNode, &a0, sipType_QSGNode, &a1))
        {
#line 216 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtQuick/qsgnode.sip"
        sipCpp->insertChildNodeAfter(a0, a1);
        
        if (a0->flags() & QSGNode::OwnedByParent)
            sipTransferTo(a0Wrapper, sipSelf);
#line 396 "/build/pyqt5/src/PyQt5-5.15.11/build/QtQuick/sipQtQuickQSGNode.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_insertChildNodeAfter, doc_QSGNode_insertChildNodeAfter);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_childCount, "childCount(self) -> int");

extern "C" {static PyObject *meth_QSGNode_childCount(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_childCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->childCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_childCount, doc_QSGNode_childCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_childAtIndex, "childAtIndex(self, i: int) -> QSGNode|None");

extern "C" {static PyObject *meth_QSGNode_childAtIndex(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_childAtIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QSGNode, &sipCpp, &a0))
        {
            ::QSGNode*sipRes;

            sipRes = sipCpp->childAtIndex(a0);

            return sipConvertFromType(sipRes, sipType_QSGNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_childAtIndex, doc_QSGNode_childAtIndex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_firstChild, "firstChild(self) -> QSGNode|None");

extern "C" {static PyObject *meth_QSGNode_firstChild(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_firstChild(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            ::QSGNode*sipRes;

            sipRes = sipCpp->firstChild();

            return sipConvertFromType(sipRes, sipType_QSGNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_firstChild, doc_QSGNode_firstChild);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_lastChild, "lastChild(self) -> QSGNode|None");

extern "C" {static PyObject *meth_QSGNode_lastChild(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_lastChild(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            ::QSGNode*sipRes;

            sipRes = sipCpp->lastChild();

            return sipConvertFromType(sipRes, sipType_QSGNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_lastChild, doc_QSGNode_lastChild);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_nextSibling, "nextSibling(self) -> QSGNode|None");

extern "C" {static PyObject *meth_QSGNode_nextSibling(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_nextSibling(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            ::QSGNode*sipRes;

            sipRes = sipCpp->nextSibling();

            return sipConvertFromType(sipRes, sipType_QSGNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_nextSibling, doc_QSGNode_nextSibling);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_previousSibling, "previousSibling(self) -> QSGNode|None");

extern "C" {static PyObject *meth_QSGNode_previousSibling(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_previousSibling(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            ::QSGNode*sipRes;

            sipRes = sipCpp->previousSibling();

            return sipConvertFromType(sipRes, sipType_QSGNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_previousSibling, doc_QSGNode_previousSibling);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_type, "type(self) -> QSGNode.NodeType");

extern "C" {static PyObject *meth_QSGNode_type(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            ::QSGNode::NodeType sipRes;

            sipRes = sipCpp->type();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QSGNode_NodeType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_type, doc_QSGNode_type);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_markDirty, "markDirty(self, bits: QSGNode.DirtyState|QSGNode.DirtyStateBit)");

extern "C" {static PyObject *meth_QSGNode_markDirty(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_markDirty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSGNode::DirtyState* a0;
        int a0State = 0;
        ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QSGNode, &sipCpp, sipType_QSGNode_DirtyState, &a0, &a0State))
        {
            sipCpp->markDirty(*a0);
            sipReleaseType(a0, sipType_QSGNode_DirtyState, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_markDirty, doc_QSGNode_markDirty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_isSubtreeBlocked, "isSubtreeBlocked(self) -> bool");

extern "C" {static PyObject *meth_QSGNode_isSubtreeBlocked(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_isSubtreeBlocked(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            bool sipRes;

            sipRes = (sipSelfWasArg ? sipCpp->::QSGNode::isSubtreeBlocked() : sipCpp->isSubtreeBlocked());

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_isSubtreeBlocked, doc_QSGNode_isSubtreeBlocked);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_flags, "flags(self) -> QSGNode.Flags");

extern "C" {static PyObject *meth_QSGNode_flags(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_flags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            ::QSGNode::Flags*sipRes;

            sipRes = new ::QSGNode::Flags(sipCpp->flags());

            return sipConvertFromNewType(sipRes, sipType_QSGNode_Flags, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_flags, doc_QSGNode_flags);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_setFlag, "setFlag(self, a0: QSGNode.Flag, enabled: bool = True)");

extern "C" {static PyObject *meth_QSGNode_setFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QSGNode_setFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSGNode::Flag a0;
        bool a1 = 1;
        ::QSGNode *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_enabled,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE|b", &sipSelf, sipType_QSGNode, &sipCpp, sipType_QSGNode_Flag, &a0, &a1))
        {
            sipErrorState sipError = sipErrorNone;

#line 234 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtQuick/qsgnode.sip"
        QSGNode::Flags old_flags = sipCpp->flags();
        
        sipCpp->setFlag(a0, a1);
        
        sipError = qsgnode_handle_flags(sipCpp, sipSelf, old_flags);
#line 700 "/build/pyqt5/src/PyQt5-5.15.11/build/QtQuick/sipQtQuickQSGNode.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            Py_INCREF(Py_None);
            return Py_None;
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_setFlag, doc_QSGNode_setFlag);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_setFlags, "setFlags(self, a0: QSGNode.Flags|QSGNode.Flag, enabled: bool = True)");

extern "C" {static PyObject *meth_QSGNode_setFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QSGNode_setFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSGNode::Flags* a0;
        int a0State = 0;
        bool a1 = 1;
        ::QSGNode *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_enabled,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|b", &sipSelf, sipType_QSGNode, &sipCpp, sipType_QSGNode_Flags, &a0, &a0State, &a1))
        {
            sipCpp->setFlags(*a0, a1);
            sipReleaseType(a0, sipType_QSGNode_Flags, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_setFlags, doc_QSGNode_setFlags);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSGNode_preprocess, "preprocess(self)");

extern "C" {static PyObject *meth_QSGNode_preprocess(PyObject *, PyObject *);}
static PyObject *meth_QSGNode_preprocess(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QSGNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSGNode, &sipCpp))
        {
            (sipSelfWasArg ? sipCpp->::QSGNode::preprocess() : sipCpp->preprocess());

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSGNode, sipName_preprocess, doc_QSGNode_preprocess);

    return SIP_NULLPTR;
}


extern "C" {static Py_ssize_t slot_QSGNode___len__(PyObject *);}
static Py_ssize_t slot_QSGNode___len__(PyObject *sipSelf)
{
    ::QSGNode *sipCpp = reinterpret_cast< ::QSGNode *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSGNode));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;

#line 1 "Auto-generated"
            sipRes = (Py_ssize_t)sipCpp->childCount();
#line 796 "/build/pyqt5/src/PyQt5-5.15.11/build/QtQuick/sipQtQuickQSGNode.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QSGNode(void *, int);}
static void release_QSGNode(void *sipCppV, int sipState)
{
    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQSGNode *>(sipCppV);
    else
        delete reinterpret_cast< ::QSGNode *>(sipCppV);
}


extern "C" {static void *array_QSGNode(Py_ssize_t);}
static void *array_QSGNode(Py_ssize_t sipNrElem)
{
    return new ::QSGNode[sipNrElem];
}


extern "C" {static void array_delete_QSGNode(void *);}
static void array_delete_QSGNode(void *sipCpp)
{
    delete[] reinterpret_cast< ::QSGNode *>(sipCpp);
}


extern "C" {static void dealloc_QSGNode(sipSimpleWrapper *);}
static void dealloc_QSGNode(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQSGNode *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QSGNode(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QSGNode(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QSGNode(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQSGNode *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new sipQSGNode();

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QSGNode[] = {
    {(void *)slot_QSGNode___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QSGNode[] = {
    {sipName_appendChildNode, meth_QSGNode_appendChildNode, METH_VARARGS, doc_QSGNode_appendChildNode},
    {sipName_childAtIndex, meth_QSGNode_childAtIndex, METH_VARARGS, doc_QSGNode_childAtIndex},
    {sipName_childCount, meth_QSGNode_childCount, METH_VARARGS, doc_QSGNode_childCount},
    {sipName_firstChild, meth_QSGNode_firstChild, METH_VARARGS, doc_QSGNode_firstChild},
    {sipName_flags, meth_QSGNode_flags, METH_VARARGS, doc_QSGNode_flags},
    {sipName_insertChildNodeAfter, meth_QSGNode_insertChildNodeAfter, METH_VARARGS, doc_QSGNode_insertChildNodeAfter},
    {sipName_insertChildNodeBefore, meth_QSGNode_insertChildNodeBefore, METH_VARARGS, doc_QSGNode_insertChildNodeBefore},
    {sipName_isSubtreeBlocked, meth_QSGNode_isSubtreeBlocked, METH_VARARGS, doc_QSGNode_isSubtreeBlocked},
    {sipName_lastChild, meth_QSGNode_lastChild, METH_VARARGS, doc_QSGNode_lastChild},
    {sipName_markDirty, meth_QSGNode_markDirty, METH_VARARGS, doc_QSGNode_markDirty},
    {sipName_nextSibling, meth_QSGNode_nextSibling, METH_VARARGS, doc_QSGNode_nextSibling},
    {sipName_parent, meth_QSGNode_parent, METH_VARARGS, doc_QSGNode_parent},
    {sipName_prependChildNode, meth_QSGNode_prependChildNode, METH_VARARGS, doc_QSGNode_prependChildNode},
    {sipName_preprocess, meth_QSGNode_preprocess, METH_VARARGS, doc_QSGNode_preprocess},
    {sipName_previousSibling, meth_QSGNode_previousSibling, METH_VARARGS, doc_QSGNode_previousSibling},
    {sipName_removeAllChildNodes, meth_QSGNode_removeAllChildNodes, METH_VARARGS, doc_QSGNode_removeAllChildNodes},
    {sipName_removeChildNode, meth_QSGNode_removeChildNode, METH_VARARGS, doc_QSGNode_removeChildNode},
    {sipName_setFlag, SIP_MLMETH_CAST(meth_QSGNode_setFlag), METH_VARARGS|METH_KEYWORDS, doc_QSGNode_setFlag},
    {sipName_setFlags, SIP_MLMETH_CAST(meth_QSGNode_setFlags), METH_VARARGS|METH_KEYWORDS, doc_QSGNode_setFlags},
    {sipName_type, meth_QSGNode_type, METH_VARARGS, doc_QSGNode_type}
};

static sipEnumMemberDef enummembers_QSGNode[] = {
    {sipName_BasicNodeType, static_cast<int>(::QSGNode::BasicNodeType), 80},
    {sipName_ClipNodeType, static_cast<int>(::QSGNode::ClipNodeType), 80},
    {sipName_DirtyGeometry, static_cast<int>(::QSGNode::DirtyGeometry), 77},
    {sipName_DirtyMaterial, static_cast<int>(::QSGNode::DirtyMaterial), 77},
    {sipName_DirtyMatrix, static_cast<int>(::QSGNode::DirtyMatrix), 77},
    {sipName_DirtyNodeAdded, static_cast<int>(::QSGNode::DirtyNodeAdded), 77},
    {sipName_DirtyNodeRemoved, static_cast<int>(::QSGNode::DirtyNodeRemoved), 77},
    {sipName_DirtyOpacity, static_cast<int>(::QSGNode::DirtyOpacity), 77},
    {sipName_GeometryNodeType, static_cast<int>(::QSGNode::GeometryNodeType), 80},
    {sipName_OpacityNodeType, static_cast<int>(::QSGNode::OpacityNodeType), 80},
    {sipName_OwnedByParent, static_cast<int>(::QSGNode::OwnedByParent), 78},
    {sipName_OwnsGeometry, static_cast<int>(::QSGNode::OwnsGeometry), 78},
    {sipName_OwnsMaterial, static_cast<int>(::QSGNode::OwnsMaterial), 78},
    {sipName_OwnsOpaqueMaterial, static_cast<int>(::QSGNode::OwnsOpaqueMaterial), 78},
    {sipName_TransformNodeType, static_cast<int>(::QSGNode::TransformNodeType), 80},
    {sipName_UsePreprocess, static_cast<int>(::QSGNode::UsePreprocess), 78},
};

PyDoc_STRVAR(doc_QSGNode, "\1QSGNode()");


static pyqt5ClassPluginDef plugin_QSGNode = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtQuick_QSGNode = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QSGNode,
        SIP_NULLPTR,
        &plugin_QSGNode,
    },
    {
        sipNameNr_QSGNode,
        {0, 0, 1},
        20, methods_QSGNode,
        16, enummembers_QSGNode,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QSGNode,
    -1,
    -1,
    SIP_NULLPTR,
    slots_QSGNode,
    init_type_QSGNode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QSGNode,
    SIP_NULLPTR,
    array_QSGNode,
    SIP_NULLPTR,
    release_QSGNode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QSGNode,
    sizeof (::QSGNode),
};
