// python wrapper for vtkSpreadSheetView
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSpreadSheetView.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSpreadSheetView(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSpreadSheetView_ClassNew(); }

#ifndef DECLARED_PyvtkPVView_ClassNew
extern "C" { PyObject *PyvtkPVView_ClassNew(); }
#define DECLARED_PyvtkPVView_ClassNew
#endif

static PyObject *
PyvtkSpreadSheetView_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSpreadSheetView::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSpreadSheetView::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSpreadSheetView *tempr = vtkSpreadSheetView::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSpreadSheetView *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSpreadSheetView::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSpreadSheetView::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSpreadSheetView::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_SetIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIdentifier(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::SetIdentifier(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetIdentifier() :
      op->vtkSpreadSheetView::GetIdentifier());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_StillRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StillRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StillRender();
    }
    else
    {
      op->vtkSpreadSheetView::StillRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_InteractiveRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InteractiveRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InteractiveRender();
    }
    else
    {
      op->vtkSpreadSheetView::InteractiveRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Update();
    }
    else
    {
      op->vtkSpreadSheetView::Update();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_SetShowExtractedSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShowExtractedSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShowExtractedSelection(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::SetShowExtractedSelection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_ShowExtractedSelectionOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowExtractedSelectionOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShowExtractedSelectionOn();
    }
    else
    {
      op->vtkSpreadSheetView::ShowExtractedSelectionOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_ShowExtractedSelectionOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowExtractedSelectionOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShowExtractedSelectionOff();
    }
    else
    {
      op->vtkSpreadSheetView::ShowExtractedSelectionOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetShowExtractedSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowExtractedSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowExtractedSelection() :
      op->vtkSpreadSheetView::GetShowExtractedSelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_SetGenerateCellConnectivity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateCellConnectivity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateCellConnectivity(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::SetGenerateCellConnectivity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetGenerateCellConnectivity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateCellConnectivity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateCellConnectivity() :
      op->vtkSpreadSheetView::GetGenerateCellConnectivity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GenerateCellConnectivityOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateCellConnectivityOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateCellConnectivityOn();
    }
    else
    {
      op->vtkSpreadSheetView::GenerateCellConnectivityOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GenerateCellConnectivityOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateCellConnectivityOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateCellConnectivityOff();
    }
    else
    {
      op->vtkSpreadSheetView::GenerateCellConnectivityOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_SetShowFieldData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShowFieldData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShowFieldData(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::SetShowFieldData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetShowFieldData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowFieldData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowFieldData() :
      op->vtkSpreadSheetView::GetShowFieldData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_ShowFieldDataOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowFieldDataOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShowFieldDataOn();
    }
    else
    {
      op->vtkSpreadSheetView::ShowFieldDataOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_ShowFieldDataOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowFieldDataOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShowFieldDataOff();
    }
    else
    {
      op->vtkSpreadSheetView::ShowFieldDataOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_SetFieldAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFieldAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFieldAssociation(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::SetFieldAssociation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetFieldAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldAssociation() :
      op->vtkSpreadSheetView::GetFieldAssociation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_OrderColumnsByList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OrderColumnsByList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->OrderColumnsByList(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::OrderColumnsByList(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_InitializeOrderedColumnList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InitializeOrderedColumnList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InitializeOrderedColumnList();
    }
    else
    {
      op->vtkSpreadSheetView::InitializeOrderedColumnList();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetOrderedColumnList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOrderedColumnList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::vector<std::string> tempr = (ap.IsBound() ?
      op->GetOrderedColumnList() :
      op->vtkSpreadSheetView::GetOrderedColumnList());

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_SetOrderedColumnList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrderedColumnList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    if (ap.IsBound())
    {
      op->SetOrderedColumnList(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::SetOrderedColumnList(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_ClearOrderedColumnList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearOrderedColumnList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearOrderedColumnList();
    }
    else
    {
      op->vtkSpreadSheetView::ClearOrderedColumnList();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_HideColumnByName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HideColumnByName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->HideColumnByName(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::HideColumnByName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_IsColumnHiddenByName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsColumnHiddenByName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsColumnHiddenByName(temp0) :
      op->vtkSpreadSheetView::IsColumnHiddenByName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_ClearHiddenColumnsByName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearHiddenColumnsByName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearHiddenColumnsByName();
    }
    else
    {
      op->vtkSpreadSheetView::ClearHiddenColumnsByName();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_HideColumnByLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HideColumnByLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->HideColumnByLabel(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::HideColumnByLabel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_IsColumnHiddenByLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsColumnHiddenByLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsColumnHiddenByLabel(temp0) :
      op->vtkSpreadSheetView::IsColumnHiddenByLabel(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_ClearHiddenColumnsByLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearHiddenColumnsByLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearHiddenColumnsByLabel();
    }
    else
    {
      op->vtkSpreadSheetView::ClearHiddenColumnsByLabel();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetNumberOfColumns(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfColumns");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfColumns() :
      op->vtkSpreadSheetView::GetNumberOfColumns());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetNumberOfRows(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfRows");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfRows() :
      op->vtkSpreadSheetView::GetNumberOfRows());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetColumnName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColumnName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetColumnName(temp0) :
      op->vtkSpreadSheetView::GetColumnName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_IsColumnInternal_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsColumnInternal");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsColumnInternal(temp0) :
      op->vtkSpreadSheetView::IsColumnInternal(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSpreadSheetView_IsColumnInternal_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsColumnInternal");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsColumnInternal(temp0) :
      op->vtkSpreadSheetView::IsColumnInternal(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSpreadSheetView_IsColumnInternal_Methods[] = {
  {"IsColumnInternal", PyvtkSpreadSheetView_IsColumnInternal_s1, METH_VARARGS,
   "@k"},
  {"IsColumnInternal", PyvtkSpreadSheetView_IsColumnInternal_s2, METH_VARARGS,
   "@z"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSpreadSheetView_IsColumnInternal(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSpreadSheetView_IsColumnInternal_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "IsColumnInternal");
  return nullptr;
}


static PyObject *
PyvtkSpreadSheetView_GetColumnLabel_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColumnLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetColumnLabel(temp0) :
      op->vtkSpreadSheetView::GetColumnLabel(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSpreadSheetView_GetColumnLabel_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColumnLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetColumnLabel(temp0) :
      op->vtkSpreadSheetView::GetColumnLabel(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSpreadSheetView_GetColumnLabel_Methods[] = {
  {"GetColumnLabel", PyvtkSpreadSheetView_GetColumnLabel_s1, METH_VARARGS,
   "@k"},
  {"GetColumnLabel", PyvtkSpreadSheetView_GetColumnLabel_s2, METH_VARARGS,
   "@z"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSpreadSheetView_GetColumnLabel(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSpreadSheetView_GetColumnLabel_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetColumnLabel");
  return nullptr;
}


static PyObject *
PyvtkSpreadSheetView_GetColumnByName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColumnByName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetColumnByName(temp0) :
      op->vtkSpreadSheetView::GetColumnByName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetColumnVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColumnVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetColumnVisibility(temp0) :
      op->vtkSpreadSheetView::GetColumnVisibility(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetValue(temp0, temp1) :
      op->vtkSpreadSheetView::GetValue(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_GetValueByName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueByName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetValueByName(temp0, temp1) :
      op->vtkSpreadSheetView::GetValueByName(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_IsRowSelected(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsRowSelected");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsRowSelected(temp0) :
      op->vtkSpreadSheetView::IsRowSelected(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_IsAvailable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsAvailable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsAvailable(temp0) :
      op->vtkSpreadSheetView::IsAvailable(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_IsDataValid(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsDataValid");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->IsDataValid(temp0, temp1) :
      op->vtkSpreadSheetView::IsDataValid(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_SetColumnNameToSort_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColumnNameToSort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetColumnNameToSort(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::SetColumnNameToSort(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSpreadSheetView_SetColumnNameToSort_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColumnNameToSort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetColumnNameToSort();
    }
    else
    {
      op->vtkSpreadSheetView::SetColumnNameToSort();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSpreadSheetView_SetColumnNameToSort(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSpreadSheetView_SetColumnNameToSort_s1(self, args);
    case 0:
      return PyvtkSpreadSheetView_SetColumnNameToSort_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetColumnNameToSort");
  return nullptr;
}


static PyObject *
PyvtkSpreadSheetView_SetInvertSortOrder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInvertSortOrder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInvertSortOrder(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::SetInvertSortOrder(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_SetBlockSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBlockSize(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::SetBlockSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_Export(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Export");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  vtkCSVExporter *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCSVExporter"))
  {
    bool tempr = (ap.IsBound() ?
      op->Export(temp0) :
      op->vtkSpreadSheetView::Export(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpreadSheetView_ClearCache_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearCache();
    }
    else
    {
      op->vtkSpreadSheetView::ClearCache();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSpreadSheetView_ClearCache_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation"))
  {
    if (ap.IsBound())
    {
      op->ClearCache(temp0);
    }
    else
    {
      op->vtkSpreadSheetView::ClearCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSpreadSheetView_ClearCache(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkSpreadSheetView_ClearCache_s1(self, args);
    case 1:
      return PyvtkSpreadSheetView_ClearCache_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ClearCache");
  return nullptr;
}


static PyObject *
PyvtkSpreadSheetView_FetchBlockCallback(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FetchBlockCallback");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpreadSheetView *op = static_cast<vtkSpreadSheetView *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTable *tempr = (ap.IsBound() ?
      op->FetchBlockCallback(temp0) :
      op->vtkSpreadSheetView::FetchBlockCallback(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSpreadSheetView_Methods[] = {
  {"IsTypeOf", PyvtkSpreadSheetView_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSpreadSheetView_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSpreadSheetView_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSpreadSheetView\nC++: static vtkSpreadSheetView *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSpreadSheetView_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSpreadSheetView\nC++: vtkSpreadSheetView *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSpreadSheetView_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSpreadSheetView_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetIdentifier", PyvtkSpreadSheetView_SetIdentifier, METH_VARARGS,
   "SetIdentifier(self, _arg:int) -> None\nC++: virtual void SetIdentifier(vtkTypeUInt32 _arg)\n\nA unique identifier for this vtkSpreadSheetView across all\nprocesses.\n"},
  {"GetIdentifier", PyvtkSpreadSheetView_GetIdentifier, METH_VARARGS,
   "GetIdentifier(self) -> int\nC++: virtual vtkTypeUInt32 GetIdentifier()\n\n"},
  {"StillRender", PyvtkSpreadSheetView_StillRender, METH_VARARGS,
   "StillRender(self) -> None\nC++: void StillRender() override;\n\nTriggers a high-resolution render.\n\note CallOnAllProcesses\n"},
  {"InteractiveRender", PyvtkSpreadSheetView_InteractiveRender, METH_VARARGS,
   "InteractiveRender(self) -> None\nC++: void InteractiveRender() override;\n\nTriggers a interactive render. Based on the settings on the view,\nthis may result in a low-resolution rendering or a simplified\ngeometry rendering.\n\note CallOnAllProcesses\n"},
  {"Update", PyvtkSpreadSheetView_Update, METH_VARARGS,
   "Update(self) -> None\nC++: void Update() override;\n\nOverridden to identify and locate the active-representation.\n"},
  {"SetShowExtractedSelection", PyvtkSpreadSheetView_SetShowExtractedSelection, METH_VARARGS,
   "SetShowExtractedSelection(self, __a:bool) -> None\nC++: void SetShowExtractedSelection(bool)\n\nGet/Set if the view shows extracted selection only or the actual\ndata. false by default.\n\note CallOnAllProcesses\n"},
  {"ShowExtractedSelectionOn", PyvtkSpreadSheetView_ShowExtractedSelectionOn, METH_VARARGS,
   "ShowExtractedSelectionOn(self) -> None\nC++: virtual void ShowExtractedSelectionOn()\n\n"},
  {"ShowExtractedSelectionOff", PyvtkSpreadSheetView_ShowExtractedSelectionOff, METH_VARARGS,
   "ShowExtractedSelectionOff(self) -> None\nC++: virtual void ShowExtractedSelectionOff()\n\n"},
  {"GetShowExtractedSelection", PyvtkSpreadSheetView_GetShowExtractedSelection, METH_VARARGS,
   "GetShowExtractedSelection(self) -> bool\nC++: virtual bool GetShowExtractedSelection()\n\n"},
  {"SetGenerateCellConnectivity", PyvtkSpreadSheetView_SetGenerateCellConnectivity, METH_VARARGS,
   "SetGenerateCellConnectivity(self, _arg:bool) -> None\nC++: virtual void SetGenerateCellConnectivity(bool _arg)\n\nAllow user to enable/disable cell connectivity generation.\n"},
  {"GetGenerateCellConnectivity", PyvtkSpreadSheetView_GetGenerateCellConnectivity, METH_VARARGS,
   "GetGenerateCellConnectivity(self) -> bool\nC++: virtual bool GetGenerateCellConnectivity()\n\n"},
  {"GenerateCellConnectivityOn", PyvtkSpreadSheetView_GenerateCellConnectivityOn, METH_VARARGS,
   "GenerateCellConnectivityOn(self) -> None\nC++: virtual void GenerateCellConnectivityOn()\n\n"},
  {"GenerateCellConnectivityOff", PyvtkSpreadSheetView_GenerateCellConnectivityOff, METH_VARARGS,
   "GenerateCellConnectivityOff(self) -> None\nC++: virtual void GenerateCellConnectivityOff()\n\n"},
  {"SetShowFieldData", PyvtkSpreadSheetView_SetShowFieldData, METH_VARARGS,
   "SetShowFieldData(self, _arg:bool) -> None\nC++: virtual void SetShowFieldData(bool _arg)\n\nAllow user to enable/disable field data visibility. Default to\nfalse.\n"},
  {"GetShowFieldData", PyvtkSpreadSheetView_GetShowFieldData, METH_VARARGS,
   "GetShowFieldData(self) -> bool\nC++: virtual bool GetShowFieldData()\n\n"},
  {"ShowFieldDataOn", PyvtkSpreadSheetView_ShowFieldDataOn, METH_VARARGS,
   "ShowFieldDataOn(self) -> None\nC++: virtual void ShowFieldDataOn()\n\n"},
  {"ShowFieldDataOff", PyvtkSpreadSheetView_ShowFieldDataOff, METH_VARARGS,
   "ShowFieldDataOff(self) -> None\nC++: virtual void ShowFieldDataOff()\n\n"},
  {"SetFieldAssociation", PyvtkSpreadSheetView_SetFieldAssociation, METH_VARARGS,
   "SetFieldAssociation(self, _arg:int) -> None\nC++: virtual void SetFieldAssociation(int _arg)\n\nSpecify the field association for the data to be shown in the\nview. This is passed on to the vtkSpreadSheetRepresentation in\n`Update` pass.\n"},
  {"GetFieldAssociation", PyvtkSpreadSheetView_GetFieldAssociation, METH_VARARGS,
   "GetFieldAssociation(self) -> int\nC++: virtual int GetFieldAssociation()\n\n"},
  {"OrderColumnsByList", PyvtkSpreadSheetView_OrderColumnsByList, METH_VARARGS,
   "OrderColumnsByList(self, enable:bool) -> None\nC++: void OrderColumnsByList(bool enable)\n\nSpecify sorting method that we want to use, when it's enabled,\ncolumns will be sorted internally by a given array, this array\nwill be cached in `OrderedColumnList`.\n\nDefault of `OrderedColumnList` will be the list of each visible\ncolumns visible in the current SpreadSheetView.\n\nDefault is false.\n"},
  {"InitializeOrderedColumnList", PyvtkSpreadSheetView_InitializeOrderedColumnList, METH_VARARGS,
   "InitializeOrderedColumnList(self) -> None\nC++: void InitializeOrderedColumnList()\n\n"},
  {"GetOrderedColumnList", PyvtkSpreadSheetView_GetOrderedColumnList, METH_VARARGS,
   "GetOrderedColumnList(self) -> (str, ...)\nC++: std::vector<std::string> GetOrderedColumnList()\n\n"},
  {"SetOrderedColumnList", PyvtkSpreadSheetView_SetOrderedColumnList, METH_VARARGS,
   "SetOrderedColumnList(self, list:[str, ...]) -> None\nC++: void SetOrderedColumnList(std::vector<std::string> list)\n\n"},
  {"ClearOrderedColumnList", PyvtkSpreadSheetView_ClearOrderedColumnList, METH_VARARGS,
   "ClearOrderedColumnList(self) -> None\nC++: void ClearOrderedColumnList()\n\n"},
  {"HideColumnByName", PyvtkSpreadSheetView_HideColumnByName, METH_VARARGS,
   "HideColumnByName(self, columnName:str) -> None\nC++: void HideColumnByName(const char *columnName)\n\nThis API enables the users to hide columns that should be shown.\nColumns can be hidden using their names or labels.\n"},
  {"IsColumnHiddenByName", PyvtkSpreadSheetView_IsColumnHiddenByName, METH_VARARGS,
   "IsColumnHiddenByName(self, columnName:str) -> bool\nC++: bool IsColumnHiddenByName(const char *columnName)\n\n"},
  {"ClearHiddenColumnsByName", PyvtkSpreadSheetView_ClearHiddenColumnsByName, METH_VARARGS,
   "ClearHiddenColumnsByName(self) -> None\nC++: void ClearHiddenColumnsByName()\n\n"},
  {"HideColumnByLabel", PyvtkSpreadSheetView_HideColumnByLabel, METH_VARARGS,
   "HideColumnByLabel(self, columnLabel:str) -> None\nC++: void HideColumnByLabel(const char *columnLabel)\n\n"},
  {"IsColumnHiddenByLabel", PyvtkSpreadSheetView_IsColumnHiddenByLabel, METH_VARARGS,
   "IsColumnHiddenByLabel(self, columnLabel:str) -> bool\nC++: bool IsColumnHiddenByLabel(const std::string &columnLabel)\n\n"},
  {"ClearHiddenColumnsByLabel", PyvtkSpreadSheetView_ClearHiddenColumnsByLabel, METH_VARARGS,
   "ClearHiddenColumnsByLabel(self) -> None\nC++: void ClearHiddenColumnsByLabel()\n\n"},
  {"GetNumberOfColumns", PyvtkSpreadSheetView_GetNumberOfColumns, METH_VARARGS,
   "GetNumberOfColumns(self) -> int\nC++: virtual vtkIdType GetNumberOfColumns()\n\nGet the number of columns.\n\note CallOnClient\n"},
  {"GetNumberOfRows", PyvtkSpreadSheetView_GetNumberOfRows, METH_VARARGS,
   "GetNumberOfRows(self) -> int\nC++: virtual vtkIdType GetNumberOfRows()\n\nGet the number of rows.\n\note CallOnClient\n"},
  {"GetColumnName", PyvtkSpreadSheetView_GetColumnName, METH_VARARGS,
   "GetColumnName(self, index:int) -> str\nC++: virtual const char *GetColumnName(vtkIdType index)\n\nReturns the name for the column.\n\note CallOnClient\n"},
  {"IsColumnInternal", PyvtkSpreadSheetView_IsColumnInternal, METH_VARARGS,
   "IsColumnInternal(self, index:int) -> bool\nC++: virtual bool IsColumnInternal(vtkIdType index)\nIsColumnInternal(self, columnName:str) -> bool\nC++: virtual bool IsColumnInternal(const char *columnName)\n\nReturns true if the column is internal.\n"},
  {"GetColumnLabel", PyvtkSpreadSheetView_GetColumnLabel, METH_VARARGS,
   "GetColumnLabel(self, index:int) -> str\nC++: virtual std::string GetColumnLabel(vtkIdType index)\nGetColumnLabel(self, columnName:str) -> str\nC++: virtual std::string GetColumnLabel(const char *columnName)\n\nReturns the user-friendly label to use for the column in the\nspreadsheet view.\n\nIf `this->IsColumnInternal(..)` is true for the chosen column.\nThen this method will return `nullptr`.\n\note CallOnClient\n"},
  {"GetColumnByName", PyvtkSpreadSheetView_GetColumnByName, METH_VARARGS,
   "GetColumnByName(self, columnName:str) -> int\nC++: vtkIdType GetColumnByName(const char *columnName)\n\nReturns the column index for a column given its name. May return\n-1 is name is not valid or present.\n"},
  {"GetColumnVisibility", PyvtkSpreadSheetView_GetColumnVisibility, METH_VARARGS,
   "GetColumnVisibility(self, index:int) -> bool\nC++: virtual bool GetColumnVisibility(vtkIdType index)\n\nReturns the visibility for the column at the given index.\n"},
  {"GetValue", PyvtkSpreadSheetView_GetValue, METH_VARARGS,
   "GetValue(self, row:int, col:int) -> vtkVariant\nC++: virtual vtkVariant GetValue(vtkIdType row, vtkIdType col)\n\nReturns the value at given location. This may result in\ncollective operations is data is not available locally. This\nmethod can only be called on the CLIENT process for now.\n\note CallOnClient\n"},
  {"GetValueByName", PyvtkSpreadSheetView_GetValueByName, METH_VARARGS,
   "GetValueByName(self, row:int, columnName:str) -> vtkVariant\nC++: virtual vtkVariant GetValueByName(vtkIdType row,\n    const char *columnName)\n\n"},
  {"IsRowSelected", PyvtkSpreadSheetView_IsRowSelected, METH_VARARGS,
   "IsRowSelected(self, row:int) -> bool\nC++: virtual bool IsRowSelected(vtkIdType row)\n\nReturns true if the row is selected.\n"},
  {"IsAvailable", PyvtkSpreadSheetView_IsAvailable, METH_VARARGS,
   "IsAvailable(self, row:int) -> bool\nC++: virtual bool IsAvailable(vtkIdType row)\n\nReturns true is the data for the particular row is locally\navailable.\n"},
  {"IsDataValid", PyvtkSpreadSheetView_IsDataValid, METH_VARARGS,
   "IsDataValid(self, row:int, col:int) -> bool\nC++: virtual bool IsDataValid(vtkIdType row, vtkIdType col)\n\nReturns true of the data at the given row and column is valid.\n"},
  {"SetColumnNameToSort", PyvtkSpreadSheetView_SetColumnNameToSort, METH_VARARGS,
   "SetColumnNameToSort(self, __a:str) -> None\nC++: void SetColumnNameToSort(const char *)\nSetColumnNameToSort(self) -> None\nC++: void SetColumnNameToSort()\n\nGet/Set the column name to sort by.\n\note CallOnAllProcesses\n"},
  {"SetInvertSortOrder", PyvtkSpreadSheetView_SetInvertSortOrder, METH_VARARGS,
   "SetInvertSortOrder(self, __a:bool) -> None\nC++: void SetInvertSortOrder(bool)\n\nGet/Set whether the sort order must be Max to Min rather than Min\nto Max.\n\note CallOnAllProcesses\n"},
  {"SetBlockSize", PyvtkSpreadSheetView_SetBlockSize, METH_VARARGS,
   "SetBlockSize(self, val:int) -> None\nC++: void SetBlockSize(vtkIdType val)\n\nSet the block size\n\note CallOnAllProcesses\n"},
  {"Export", PyvtkSpreadSheetView_Export, METH_VARARGS,
   "Export(self, exporter:vtkCSVExporter) -> bool\nC++: virtual bool Export(vtkCSVExporter *exporter)\n\nExport the contents of this view using the exporter.\n"},
  {"ClearCache", PyvtkSpreadSheetView_ClearCache, METH_VARARGS,
   "ClearCache(self) -> None\nC++: void ClearCache()\nClearCache(self, __a:vtkPVDataRepresentation) -> None\nC++: virtual void ClearCache(vtkPVDataRepresentation *)\n\nAllow user to clear the cache if he needs to.\n"},
  {"FetchBlockCallback", PyvtkSpreadSheetView_FetchBlockCallback, METH_VARARGS,
   "FetchBlockCallback(self, blockindex:int) -> vtkTable\nC++: vtkTable *FetchBlockCallback(vtkIdType blockindex)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSpreadSheetView_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("identifier"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpreadSheetView_GetIdentifier(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpreadSheetView_SetIdentifier(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpreadSheetView_SetIdentifier(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIdentifier/SetIdentifier\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_extracted_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpreadSheetView_GetShowExtractedSelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpreadSheetView_SetShowExtractedSelection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpreadSheetView_SetShowExtractedSelection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetShowExtractedSelection/SetShowExtractedSelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_cell_connectivity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpreadSheetView_GetGenerateCellConnectivity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpreadSheetView_SetGenerateCellConnectivity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpreadSheetView_SetGenerateCellConnectivity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateCellConnectivity/SetGenerateCellConnectivity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_field_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpreadSheetView_GetShowFieldData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpreadSheetView_SetShowFieldData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpreadSheetView_SetShowFieldData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetShowFieldData/SetShowFieldData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_association"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpreadSheetView_GetFieldAssociation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpreadSheetView_SetFieldAssociation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpreadSheetView_SetFieldAssociation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFieldAssociation/SetFieldAssociation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ordered_column_list"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpreadSheetView_GetOrderedColumnList(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpreadSheetView_SetOrderedColumnList(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpreadSheetView_SetOrderedColumnList(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOrderedColumnList/SetOrderedColumnList\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("column_name_to_sort"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpreadSheetView_SetColumnNameToSort(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpreadSheetView_SetColumnNameToSort(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetColumnNameToSort\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("invert_sort_order"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpreadSheetView_SetInvertSortOrder(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpreadSheetView_SetInvertSortOrder(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInvertSortOrder\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("block_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpreadSheetView_SetBlockSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpreadSheetView_SetBlockSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBlockSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_columns"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpreadSheetView_GetNumberOfColumns(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfColumns\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_rows"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpreadSheetView_GetNumberOfRows(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfRows\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSpreadSheetView_Doc =
  "vtkSpreadSheetView - vtkSpreadSheetView is a vtkPVView subclass for a\nview used to show any data as a spreadsheet.\n\n"
  "Superclass: vtkPVView\n\n"
  "This view can only show one representation at a time. If more than\n"
  "one representation is added to this view, only the first visible\n"
  "representation will be shown.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSpreadSheetView_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSpreadSheetView", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSpreadSheetView_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSpreadSheetView_StaticNew()
{
  return vtkSpreadSheetView::New();
}

PyObject *PyvtkSpreadSheetView_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSpreadSheetView_Type, PyvtkSpreadSheetView_Methods,
    "vtkSpreadSheetView",
 &PyvtkSpreadSheetView_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVView_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSpreadSheetView_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSpreadSheetView(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSpreadSheetView_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSpreadSheetView", o) != 0)
  {
    Py_DECREF(o);
  }

}

