// python wrapper for vtkInSituPParticlePathFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkInSituPParticlePathFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkInSituPParticlePathFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkInSituPParticlePathFilter_ClassNew(); }

#ifndef DECLARED_PyvtkLegacyPParticlePathFilter_ClassNew
extern "C" { PyObject *PyvtkLegacyPParticlePathFilter_ClassNew(); }
#define DECLARED_PyvtkLegacyPParticlePathFilter_ClassNew
#endif

static PyObject *
PyvtkInSituPParticlePathFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkInSituPParticlePathFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituPParticlePathFilter *op = static_cast<vtkInSituPParticlePathFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkInSituPParticlePathFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkInSituPParticlePathFilter *tempr = vtkInSituPParticlePathFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituPParticlePathFilter *op = static_cast<vtkInSituPParticlePathFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkInSituPParticlePathFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkInSituPParticlePathFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkInSituPParticlePathFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituPParticlePathFilter *op = static_cast<vtkInSituPParticlePathFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkInSituPParticlePathFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_SetClearCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetClearCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituPParticlePathFilter *op = static_cast<vtkInSituPParticlePathFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetClearCache(temp0);
    }
    else
    {
      op->vtkInSituPParticlePathFilter::SetClearCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_AddRestartConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddRestartConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituPParticlePathFilter *op = static_cast<vtkInSituPParticlePathFilter *>(vp);

  vtkAlgorithmOutput *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->AddRestartConnection(temp0);
    }
    else
    {
      op->vtkInSituPParticlePathFilter::AddRestartConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_RemoveAllRestarts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllRestarts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituPParticlePathFilter *op = static_cast<vtkInSituPParticlePathFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllRestarts();
    }
    else
    {
      op->vtkInSituPParticlePathFilter::RemoveAllRestarts();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_SetRestartedSimulation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRestartedSimulation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituPParticlePathFilter *op = static_cast<vtkInSituPParticlePathFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRestartedSimulation(temp0);
    }
    else
    {
      op->vtkInSituPParticlePathFilter::SetRestartedSimulation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_GetRestartedSimulation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRestartedSimulation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituPParticlePathFilter *op = static_cast<vtkInSituPParticlePathFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRestartedSimulation() :
      op->vtkInSituPParticlePathFilter::GetRestartedSimulation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_SetFirstTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFirstTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituPParticlePathFilter *op = static_cast<vtkInSituPParticlePathFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFirstTimeStep(temp0);
    }
    else
    {
      op->vtkInSituPParticlePathFilter::SetFirstTimeStep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInSituPParticlePathFilter_GetFirstTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFirstTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituPParticlePathFilter *op = static_cast<vtkInSituPParticlePathFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFirstTimeStep() :
      op->vtkInSituPParticlePathFilter::GetFirstTimeStep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkInSituPParticlePathFilter_Methods[] = {
  {"IsTypeOf", PyvtkInSituPParticlePathFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkInSituPParticlePathFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkInSituPParticlePathFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkInSituPParticlePathFilter\nC++: static vtkInSituPParticlePathFilter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkInSituPParticlePathFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkInSituPParticlePathFilter\nC++: vtkInSituPParticlePathFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkInSituPParticlePathFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkInSituPParticlePathFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetClearCache", PyvtkInSituPParticlePathFilter_SetClearCache, METH_VARARGS,
   "SetClearCache(self, __a:bool) -> None\nC++: void SetClearCache(bool)\n\nSet whether or not to clear out cache of previous time steps.\nDefault value is false. Clearing the cache is aimed towards in\nsitu use.\n"},
  {"AddRestartConnection", PyvtkInSituPParticlePathFilter_AddRestartConnection, METH_VARARGS,
   "AddRestartConnection(self, input:vtkAlgorithmOutput) -> None\nC++: void AddRestartConnection(vtkAlgorithmOutput *input)\n\nProvide support pre-pending previously computed particle paths.\n"},
  {"RemoveAllRestarts", PyvtkInSituPParticlePathFilter_RemoveAllRestarts, METH_VARARGS,
   "RemoveAllRestarts(self) -> None\nC++: void RemoveAllRestarts()\n\n"},
  {"SetRestartedSimulation", PyvtkInSituPParticlePathFilter_SetRestartedSimulation, METH_VARARGS,
   "SetRestartedSimulation(self, _arg:bool) -> None\nC++: virtual void SetRestartedSimulation(bool _arg)\n\nSet/Get if the simulation has been restarted. If it is a\nrestarted simulation we may not necessarily want to\ninject/reinject particles on the first time step. The default is\nFalse.\n"},
  {"GetRestartedSimulation", PyvtkInSituPParticlePathFilter_GetRestartedSimulation, METH_VARARGS,
   "GetRestartedSimulation(self) -> bool\nC++: virtual bool GetRestartedSimulation()\n\n"},
  {"SetFirstTimeStep", PyvtkInSituPParticlePathFilter_SetFirstTimeStep, METH_VARARGS,
   "SetFirstTimeStep(self, _arg:int) -> None\nC++: virtual void SetFirstTimeStep(int _arg)\n\nSpecify the first time step that particle paths are computed.\nThis is useful for restarted simulations or when the simulation's\nfirst time step isn't 0. The default is 0.\n"},
  {"GetFirstTimeStep", PyvtkInSituPParticlePathFilter_GetFirstTimeStep, METH_VARARGS,
   "GetFirstTimeStep(self) -> int\nC++: virtual int GetFirstTimeStep()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkInSituPParticlePathFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("clear_cache"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkInSituPParticlePathFilter_SetClearCache(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkInSituPParticlePathFilter_SetClearCache(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetClearCache\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("restarted_simulation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkInSituPParticlePathFilter_GetRestartedSimulation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkInSituPParticlePathFilter_SetRestartedSimulation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkInSituPParticlePathFilter_SetRestartedSimulation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRestartedSimulation/SetRestartedSimulation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("first_time_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkInSituPParticlePathFilter_GetFirstTimeStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkInSituPParticlePathFilter_SetFirstTimeStep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkInSituPParticlePathFilter_SetFirstTimeStep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFirstTimeStep/SetFirstTimeStep\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkInSituPParticlePathFilter_Doc =
  "vtkInSituPParticlePathFilter - An In Situ Particle tracer for\nunsteady vector fields\n\n"
  "Superclass: vtkLegacyPParticlePathFilter\n\n"
  "vtkInSituPParticlePathFilter is a filter that integrates a vector\n"
  "field to generate particle paths. It is intended for in situ use. The\n"
  "additions to the parallel particle path filter is that the particle\n"
  "locations at previous time steps can be cleared out (ClearCache data\n"
  "member) and restarted connection can be used to continue advecting\n"
  "particles from a restarted simulation.\n"
  "@sa\n"
  "vtkPParticlePathFilterBase has the details of the algorithms\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkInSituPParticlePathFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneralMPI.vtkInSituPParticlePathFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkInSituPParticlePathFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkInSituPParticlePathFilter_StaticNew()
{
  return vtkInSituPParticlePathFilter::New();
}

PyObject *PyvtkInSituPParticlePathFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkInSituPParticlePathFilter_Type, PyvtkInSituPParticlePathFilter_Methods,
    "vtkInSituPParticlePathFilter",
 &PyvtkInSituPParticlePathFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkLegacyPParticlePathFilter_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkInSituPParticlePathFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkInSituPParticlePathFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkInSituPParticlePathFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkInSituPParticlePathFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

