#ifndef SBK_KDUALACTIONWRAPPER_H
#define SBK_KDUALACTIONWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kdualaction.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KDualActionWrapper : public KDualAction
{
public:
    KDualActionWrapper(::QObject * parent);
    KDualActionWrapper(const ::QString & inactiveText, const ::QString & activeText, ::QObject * parent);
    KDualActionWrapper(const KDualActionWrapper &) = delete;
    KDualActionWrapper& operator=(const KDualActionWrapper &) = delete;
    KDualActionWrapper(KDualActionWrapper &&) = delete;
    KDualActionWrapper& operator=(KDualActionWrapper &&) = delete;
    ~KDualActionWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KDUALACTIONWRAPPER_H
