// java wrapper for vtkVRRenderer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVRRenderer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkOpenGLRenderer_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVRRenderer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVRRenderer",dType)) { return me; }
  if ((res= vtkOpenGLRenderer_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRenderer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRenderer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRenderer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRenderer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_ResetCamera_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCamera(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_ResetCameraClippingRange_15(JNIEnv* env, jobject obj)
{

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCameraClippingRange();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_ResetCameraClippingRange_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCameraClippingRange(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRenderer_MakeCamera_17(JNIEnv* env, jobject obj)
{
  vtkCamera * temp20;

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeCamera();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_GetFloorTransform_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform * temp0;
  temp0 = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetFloorTransform(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_DeviceRender_19(JNIEnv* env, jobject obj)
{

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeviceRender();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_SetShowFloor_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowFloor(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRRenderer_GetShowFloor_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowFloor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_SetShowLeftMarker_112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowLeftMarker(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRRenderer_GetShowLeftMarker_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowLeftMarker();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_SetShowRightMarker_114(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowRightMarker(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRRenderer_GetShowRightMarker_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowRightMarker();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_ResetCameraClippingRange_116(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCameraClippingRange(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_ResetCamera_117(JNIEnv* env, jobject obj)
{

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCamera();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderer_ResetCamera_118(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkVRRenderer* op = static_cast<vtkVRRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCamera(temp0,temp1,temp2,temp3,temp4,temp5);

}
