// java wrapper for vtkVRCamera object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVRCamera.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkOpenGLCamera_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVRCamera_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVRCamera",dType)) { return me; }
  if ((res= vtkOpenGLCamera_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRCamera_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRCamera* op = static_cast<vtkVRCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRCamera_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRCamera* op = static_cast<vtkVRCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRCamera_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRCamera* op = static_cast<vtkVRCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRCamera_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRCamera* op = static_cast<vtkVRCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRCamera_SetCameraFromWorldToDeviceMatrix_14(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkMatrix4x4 * temp0;
  double   temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkVRCamera* op = static_cast<vtkVRCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCameraFromWorldToDeviceMatrix(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRCamera_SetCameraFromDeviceToWorldMatrix_15(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkMatrix4x4 * temp0;
  double   temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkVRCamera* op = static_cast<vtkVRCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCameraFromDeviceToWorldMatrix(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRCamera_SetTrackHMD_16(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkVRCamera* op = static_cast<vtkVRCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTrackHMD(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRCamera_GetTrackHMD_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVRCamera* op = static_cast<vtkVRCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTrackHMD();
  return temp20;

}
