// java wrapper for vtkGridAxesActor3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGridAxesActor3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkProp3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGridAxesActor3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGridAxesActor3D",dType)) { return me; }
  if ((res= vtkProp3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_ShallowCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetGridBounds_15(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetGridBounds_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkGridAxesActor3D_GetGridBounds_17(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetFaceMask_18(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFaceMask(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor3D_GetFaceMask_19(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceMask();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetLabelMask_110(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelMask(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor3D_GetLabelMask_111(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelMask();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_GetActors_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_UpdateGeometry_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateGeometry(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetLabelUniqueEdgesOnly_114(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelUniqueEdgesOnly(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGridAxesActor3D_GetLabelUniqueEdgesOnly_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelUniqueEdgesOnly();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetGenerateGrid_116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateGrid(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGridAxesActor3D_GetGenerateGrid_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateGrid();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_GenerateGridOn_118(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGridOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_GenerateGridOff_119(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGridOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetGenerateEdges_120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateEdges(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGridAxesActor3D_GetGenerateEdges_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateEdges();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_GenerateEdgesOn_122(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateEdgesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_GenerateEdgesOff_123(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateEdgesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetGenerateTicks_124(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateTicks(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGridAxesActor3D_GetGenerateTicks_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateTicks();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_GenerateTicksOn_126(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateTicksOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_GenerateTicksOff_127(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateTicksOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetProperty_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor3D_GetProperty_129(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetTitleTextProperty_130(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkTextProperty * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleTextProperty(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetXTitleTextProperty_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXTitleTextProperty(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetYTitleTextProperty_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYTitleTextProperty(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetZTitleTextProperty_133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZTitleTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor3D_GetTitleTextProperty_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkTextProperty * temp20;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleTextProperty(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetTitle_135(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  std::string temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitle(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetXTitle_136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXTitle(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetYTitle_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYTitle(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetZTitle_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZTitle(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGridAxesActor3D_GetTitle_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const std::string * temp20;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = &(op)->GetTitle(temp0);
  return vtkJavaStringToUTF8(env, *temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetUseCustomLabels_140(JNIEnv* env, jobject obj,jint id0,jboolean id1)
{
  int   temp0;
  bool   temp1;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseCustomLabels(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetXUseCustomLabels_141(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXUseCustomLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetYUseCustomLabels_142(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYUseCustomLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetZUseCustomLabels_143(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZUseCustomLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetNumberOfLabels_144(JNIEnv* env, jobject obj,jint id0,jlong id1)
{
  int   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfLabels(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetNumberOfXLabels_145(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfXLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetNumberOfYLabels_146(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfYLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetNumberOfZLabels_147(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfZLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetLabel_148(JNIEnv* env, jobject obj,jint id0,jlong id1,jdouble id2)
{
  int   temp0;
  long long   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabel(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetXLabel_149(JNIEnv* env, jobject obj,jlong id0,jdouble id1)
{
  long long   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXLabel(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetYLabel_150(JNIEnv* env, jobject obj,jlong id0,jdouble id1)
{
  long long   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYLabel(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetZLabel_151(JNIEnv* env, jobject obj,jlong id0,jdouble id1)
{
  long long   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZLabel(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetLabelTextProperty_152(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkTextProperty * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelTextProperty(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetXLabelTextProperty_153(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXLabelTextProperty(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetYLabelTextProperty_154(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYLabelTextProperty(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetZLabelTextProperty_155(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZLabelTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor3D_GetLabelTextProperty_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkTextProperty * temp20;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelTextProperty(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetNotation_157(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNotation(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetXNotation_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXNotation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetYNotation_159(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYNotation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetZNotation_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZNotation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor3D_GetNotation_161(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNotation(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetPrecision_162(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPrecision(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetXPrecision_163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXPrecision(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetYPrecision_164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYPrecision(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetZPrecision_165(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor3D_GetPrecision_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPrecision(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_GetRenderedBounds_167(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRenderedBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetForceOpaque_168(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceOpaque(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGridAxesActor3D_GetForceOpaque_169(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForceOpaque();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_ForceOpaqueOn_170(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceOpaqueOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_ForceOpaqueOff_171(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceOpaqueOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor3D_RenderOpaqueGeometry_172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor3D_RenderTranslucentPolygonalGeometry_173(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor3D_RenderOverlay_174(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor3D_HasTranslucentPolygonalGeometry_175(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_ReleaseGraphicsResources_176(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetLabelDisplayOffset_177(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelDisplayOffset(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_SetLabelDisplayOffset_178(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelDisplayOffset(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkGridAxesActor3D_GetLabelDisplayOffset_179(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelDisplayOffset();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor3D_GetBounds_180(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkGridAxesActor3D* op = static_cast<vtkGridAxesActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGridAxesActor3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGridAxesActor3D::New());
}
