// java wrapper for vtkVolume object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVolume.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkProp3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVolume_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVolume",dType)) { return me; }
  if ((res= vtkProp3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolume_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolume_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolume_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolume_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolume_SetMapper_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractVolumeMapper * temp0;
  temp0 = static_cast<vtkAbstractVolumeMapper*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMapper(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolume_GetMapper_15(JNIEnv* env, jobject obj)
{
  vtkAbstractVolumeMapper * temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMapper();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolume_SetProperty_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkVolumeProperty * temp0;
  temp0 = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolume_GetProperty_17(JNIEnv* env, jobject obj)
{
  vtkVolumeProperty * temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolume_GetVolumes_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetVolumes(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolume_Update_19(JNIEnv* env, jobject obj)
{

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkVolume_GetBounds_110(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolume_GetBounds_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolume_GetMinXBound_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinXBound();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolume_GetMaxXBound_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxXBound();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolume_GetMinYBound_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinYBound();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolume_GetMaxYBound_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxYBound();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolume_GetMinZBound_116(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinZBound();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolume_GetMaxZBound_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxZBound();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolume_GetMTime_118(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolume_GetRedrawMTime_119(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRedrawMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolume_ShallowCopy_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolume_RenderVolumetricGeometry_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderVolumetricGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolume_ReleaseGraphicsResources_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkVolume_GetGradientOpacityConstant_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  float   temp20;
  temp0 = id0;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGradientOpacityConstant(temp0);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkVolume_GetGradientOpacityConstant_124(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGradientOpacityConstant();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkVolume_GetArraySize_125(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArraySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolume_UpdateTransferFunctions_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateTransferFunctions(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolume_UpdateScalarOpacityforSampleSize_127(JNIEnv* env, jobject obj,jobject id0,jfloat id1)
{
  vtkRenderer * temp0;
  float   temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateScalarOpacityforSampleSize(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVolume_GetSupportsSelection_128(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVolume* op = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSupportsSelection();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkVolume_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkVolume::New());
}
