// java wrapper for vtkPointWidget object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPointWidget.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtk3DWidget_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPointWidget_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPointWidget",dType)) { return me; }
  if ((res= vtk3DWidget_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointWidget_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointWidget_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointWidget_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointWidget_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_SetEnabled_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnabled(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_PlaceWidget_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceWidget(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_PlaceWidget_16(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceWidget();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_PlaceWidget_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceWidget(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_GetPolyData_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPolyData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_SetPosition_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_SetPosition_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPointWidget_GetPosition_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_GetPosition_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_SetOutline_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutline(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointWidget_GetOutline_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutline();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_OutlineOn_115(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutlineOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_OutlineOff_116(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutlineOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_SetXShadows_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXShadows(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointWidget_GetXShadows_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXShadows();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_XShadowsOn_119(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->XShadowsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_XShadowsOff_120(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->XShadowsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_SetYShadows_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYShadows(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointWidget_GetYShadows_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYShadows();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_YShadowsOn_123(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->YShadowsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_YShadowsOff_124(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->YShadowsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_SetZShadows_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZShadows(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointWidget_GetZShadows_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZShadows();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_ZShadowsOn_127(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZShadowsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_ZShadowsOff_128(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZShadowsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_SetTranslationMode_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTranslationMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointWidget_GetTranslationMode_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslationMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_TranslationModeOn_131(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->TranslationModeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_TranslationModeOff_132(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->TranslationModeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_AllOn_133(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_AllOff_134(JNIEnv* env, jobject obj)
{

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointWidget_GetProperty_135(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointWidget_GetSelectedProperty_136(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointWidget_SetHotSpotSize_137(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHotSpotSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointWidget_GetHotSpotSizeMinValue_138(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHotSpotSizeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointWidget_GetHotSpotSizeMaxValue_139(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHotSpotSizeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointWidget_GetHotSpotSize_140(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointWidget* op = static_cast<vtkPointWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHotSpotSize();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPointWidget_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPointWidget::New());
}
