// java wrapper for vtkXMLReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkXMLReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkXMLReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkXMLReader",dType)) { return me; }
  if ((res= vtkAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetReadFromInputString_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadFromInputString(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_GetReadFromInputString_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadFromInputString();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_ReadFromInputStringOn_18(JNIEnv* env, jobject obj)
{

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadFromInputStringOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_ReadFromInputStringOff_19(JNIEnv* env, jobject obj)
{

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadFromInputStringOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetInputString_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputString(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetInputString_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputString(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetBinaryInputString_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBinaryInputString(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetInputArray_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCharArray * temp0;
  temp0 = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_CanReadFile_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetOutputAsDataSet_115(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputAsDataSet();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetOutputAsDataSet_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataSet * temp20;
  temp0 = id0;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputAsDataSet(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetPointDataArraySelection_117(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetCellDataArraySelection_118(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetColumnArraySelection_119(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_GetNumberOfPointArrays_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_GetNumberOfCellArrays_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_GetNumberOfColumnArrays_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfColumnArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_GetNumberOfTimeDataArrays_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTimeDataArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLReader_GetTimeDataArray_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeDataArray(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetTimeDataStringArray_125(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeDataStringArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLReader_GetActiveTimeDataArrayName_126(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveTimeDataArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetActiveTimeDataArrayName_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetActiveTimeDataArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLReader_GetPointArrayName_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLReader_GetCellArrayName_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLReader_GetColumnArrayName_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_GetPointArrayStatus_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_GetCellArrayStatus_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetPointArrayStatus_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetCellArrayStatus_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_GetColumnArrayStatus_135(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetColumnArrayStatus_136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColumnArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_CopyOutputInformation_137(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformation * temp0;
  int   temp1;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyOutputInformation(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetTimeStep_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStep(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_GetTimeStep_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStep();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLReader_GetNumberOfTimeSteps_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTimeSteps();
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkXMLReader_GetTimeStepRange_141(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStepRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetTimeStepRange_142(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStepRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetTimeStepRange_143(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStepRange(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetXMLParser_144(JNIEnv* env, jobject obj)
{
  vtkXMLDataParser * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXMLParser();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetReaderErrorObserver_145(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCommand * temp0;
  temp0 = static_cast<vtkCommand*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReaderErrorObserver(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetReaderErrorObserver_146(JNIEnv* env, jobject obj)
{
  vtkCommand * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReaderErrorObserver();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLReader_SetParserErrorObserver_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCommand * temp0;
  temp0 = static_cast<vtkCommand*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParserErrorObserver(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLReader_GetParserErrorObserver_148(JNIEnv* env, jobject obj)
{
  vtkCommand * temp20;

  vtkXMLReader* op = static_cast<vtkXMLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParserErrorObserver();
  return reinterpret_cast<jlong>(temp20);
}
