// java wrapper for vtkImageImport object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageImport.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageImport_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageImport",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageImport_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageImport_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageImport_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageImport_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataScalarType_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataScalarTypeToDouble_15(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToDouble();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataScalarTypeToFloat_16(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToFloat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataScalarTypeToInt_17(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataScalarTypeToShort_18(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataScalarTypeToUnsignedShort_19(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToUnsignedShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataScalarTypeToUnsignedChar_110(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToUnsignedChar();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageImport_GetDataScalarType_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataScalarType();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageImport_GetDataScalarTypeAsString_112(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataScalarTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetNumberOfScalarComponents_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfScalarComponents(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageImport_GetNumberOfScalarComponents_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfScalarComponents();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataExtent_115(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataExtent_116(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageImport_GetDataExtent_117(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataExtentToWholeExtent_118(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataExtentToWholeExtent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataSpacing_119(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataSpacing_120(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageImport_GetDataSpacing_121(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataOrigin_122(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetDataOrigin_123(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageImport_GetDataOrigin_124(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageImport_GetDataDirection_125(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDirection();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetWholeExtent_126(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWholeExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetWholeExtent_127(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWholeExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageImport_GetWholeExtent_128(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWholeExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_SetScalarArrayName_129(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageImport_GetScalarArrayName_130(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageImport_InvokePipelineModifiedCallbacks_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InvokePipelineModifiedCallbacks();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_InvokeUpdateInformationCallbacks_132(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->InvokeUpdateInformationCallbacks();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_InvokeExecuteInformationCallbacks_133(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->InvokeExecuteInformationCallbacks();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_InvokeExecuteDataCallbacks_134(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->InvokeExecuteDataCallbacks();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageImport_LegacyCheckWholeExtent_135(JNIEnv* env, jobject obj)
{

  vtkImageImport* op = static_cast<vtkImageImport*>(vtkJavaGetPointerFromObject(env, obj));
  op->LegacyCheckWholeExtent();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageImport_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageImport::New());
}
