// java wrapper for vtkArrayDataReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkArrayDataReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkArrayDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkArrayDataReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkArrayDataReader",dType)) { return me; }
  if ((res= vtkArrayDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayDataReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayDataReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayDataReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayDataReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayDataReader_GetFileName_14(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataReader_SetFileName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataReader_SetInputString_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputString(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayDataReader_GetInputString_17(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputString();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataReader_SetReadFromInputString_18(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadFromInputString(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayDataReader_GetReadFromInputString_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadFromInputString();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataReader_ReadFromInputStringOn_110(JNIEnv* env, jobject obj)
{

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadFromInputStringOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataReader_ReadFromInputStringOff_111(JNIEnv* env, jobject obj)
{

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadFromInputStringOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayDataReader_Read_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  vtkArrayData * temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkArrayDataReader* op = static_cast<vtkArrayDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Read(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkArrayDataReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkArrayDataReader::New());
}
