// java wrapper for vtkCutMaterial object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCutMaterial.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCutMaterial_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCutMaterial",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutMaterial_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutMaterial_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCutMaterial_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCutMaterial_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutMaterial_SetMaterialArrayName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaterialArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCutMaterial_GetMaterialArrayName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaterialArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutMaterial_SetMaterial_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaterial(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutMaterial_GetMaterial_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaterial();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutMaterial_SetArrayName_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCutMaterial_GetArrayName_19(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutMaterial_SetUpVector_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUpVector(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutMaterial_SetUpVector_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUpVector(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCutMaterial_GetUpVector_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUpVector();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCutMaterial_GetMaximumPoint_113(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCutMaterial_GetCenterPoint_114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenterPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCutMaterial_GetNormal_115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCutMaterial* op = static_cast<vtkCutMaterial*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormal();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCutMaterial_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCutMaterial::New());
}
