// java wrapper for vtkGenericCutter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGenericCutter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGenericCutter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGenericCutter",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCutter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCutter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCutter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCutter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCutter_SetValue_14(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericCutter_GetValue_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCutter_SetNumberOfContours_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfContours(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCutter_GetNumberOfContours_17(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfContours();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCutter_GenerateValues_18(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[2];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateValues(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCutter_GenerateValues_19(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2)
{
  int   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateValues(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCutter_GetMTime_110(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCutter_SetCutFunction_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImplicitFunction * temp0;
  temp0 = static_cast<vtkImplicitFunction*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCutFunction(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCutter_GetCutFunction_112(JNIEnv* env, jobject obj)
{
  vtkImplicitFunction * temp20;

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCutFunction();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCutter_SetGenerateCutScalars_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateCutScalars(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCutter_GetGenerateCutScalars_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateCutScalars();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCutter_GenerateCutScalarsOn_115(JNIEnv* env, jobject obj)
{

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateCutScalarsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCutter_GenerateCutScalarsOff_116(JNIEnv* env, jobject obj)
{

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateCutScalarsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCutter_SetLocator_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIncrementalPointLocator * temp0;
  temp0 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLocator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCutter_GetLocator_118(JNIEnv* env, jobject obj)
{
  vtkIncrementalPointLocator * temp20;

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCutter_CreateDefaultLocator_119(JNIEnv* env, jobject obj)
{

  vtkGenericCutter* op = static_cast<vtkGenericCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateDefaultLocator();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGenericCutter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGenericCutter::New());
}
