// java wrapper for vtkHyperStreamline object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHyperStreamline.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHyperStreamline_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHyperStreamline",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperStreamline_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperStreamline_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetStartLocation_14(JNIEnv* env, jobject obj,jlong id0,jint id1,jdoubleArray id2)
{
  long long   temp0;
  int   temp1;
  double temp2[3];
  temp0 = id0;
  temp1 = id1;
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartLocation(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetStartLocation_15(JNIEnv* env, jobject obj,jlong id0,jint id1,jdouble id2,jdouble id3,jdouble id4)
{
  long long   temp0;
  int   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartLocation(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetStartPosition_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetStartPosition_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkHyperStreamline_GetStartPosition_18(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStartPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetMaximumPropagationDistance_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumPropagationDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetMaximumPropagationDistanceMinValue_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumPropagationDistanceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetMaximumPropagationDistanceMaxValue_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumPropagationDistanceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetMaximumPropagationDistance_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumPropagationDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetIntegrationEigenvector_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationEigenvector(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_GetIntegrationEigenvectorMinValue_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationEigenvectorMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_GetIntegrationEigenvectorMaxValue_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationEigenvectorMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_GetIntegrationEigenvector_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationEigenvector();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetIntegrationEigenvectorToMajor_117(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationEigenvectorToMajor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetIntegrationEigenvectorToMedium_118(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationEigenvectorToMedium();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetIntegrationEigenvectorToMinor_119(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationEigenvectorToMinor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_IntegrateMajorEigenvector_120(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->IntegrateMajorEigenvector();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_IntegrateMediumEigenvector_121(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->IntegrateMediumEigenvector();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_IntegrateMinorEigenvector_122(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->IntegrateMinorEigenvector();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetIntegrationStepLength_123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationStepLength(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetIntegrationStepLengthMinValue_124(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationStepLengthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetIntegrationStepLengthMaxValue_125(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationStepLengthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetIntegrationStepLength_126(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationStepLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetStepLength_127(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStepLength(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetStepLengthMinValue_128(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStepLengthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetStepLengthMaxValue_129(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStepLengthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetStepLength_130(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStepLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetIntegrationDirection_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirection(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_GetIntegrationDirectionMinValue_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationDirectionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_GetIntegrationDirectionMaxValue_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationDirectionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_GetIntegrationDirection_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationDirection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetIntegrationDirectionToForward_135(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirectionToForward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetIntegrationDirectionToBackward_136(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirectionToBackward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetIntegrationDirectionToIntegrateBothDirections_137(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirectionToIntegrateBothDirections();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetTerminalEigenvalue_138(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTerminalEigenvalue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetTerminalEigenvalueMinValue_139(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTerminalEigenvalueMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetTerminalEigenvalueMaxValue_140(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTerminalEigenvalueMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetTerminalEigenvalue_141(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTerminalEigenvalue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetNumberOfSides_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfSides(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_GetNumberOfSidesMinValue_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSidesMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_GetNumberOfSidesMaxValue_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSidesMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_GetNumberOfSides_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSides();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetRadius_146(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetRadiusMinValue_147(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetRadiusMaxValue_148(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHyperStreamline_GetRadius_149(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_SetLogScaling_150(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLogScaling(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperStreamline_GetLogScaling_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLogScaling();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_LogScalingOn_152(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->LogScalingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperStreamline_LogScalingOff_153(JNIEnv* env, jobject obj)
{

  vtkHyperStreamline* op = static_cast<vtkHyperStreamline*>(vtkJavaGetPointerFromObject(env, obj));
  op->LogScalingOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkHyperStreamline_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkHyperStreamline::New());
}
