// java wrapper for vtkSurfaceNets3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSurfaceNets3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSurfaceNets3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSurfaceNets3D",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSurfaceNets3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSurfaceNets3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSurfaceNets3D_GetMTime_14(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetValue_15(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetLabel_16(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabel(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceNets3D_GetValue_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceNets3D_GetLabel_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabel(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetNumberOfLabels_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetNumberOfContours_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfContours(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSurfaceNets3D_GetNumberOfLabels_111(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabels();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSurfaceNets3D_GetNumberOfContours_112(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfContours();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_GenerateLabels_113(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[2];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateLabels(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_GenerateValues_114(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[2];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateValues(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_GenerateLabels_115(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2)
{
  int   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateLabels(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_GenerateValues_116(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2)
{
  int   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateValues(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetBackgroundLabel_117(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundLabel(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceNets3D_GetBackgroundLabel_118(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundLabel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetArrayComponent_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayComponent(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetArrayComponent_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayComponent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetOutputMeshType_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputMeshType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetOutputMeshTypeMinValue_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputMeshTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetOutputMeshTypeMaxValue_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputMeshTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetOutputMeshType_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputMeshType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetOutputMeshTypeToDefault_125(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputMeshTypeToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetOutputMeshTypeToTriangles_126(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputMeshTypeToTriangles();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetOutputMeshTypeToQuads_127(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputMeshTypeToQuads();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetSmoothing_128(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSmoothing(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSurfaceNets3D_GetSmoothing_129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSmoothing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SmoothingOn_130(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SmoothingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SmoothingOff_131(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SmoothingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetNumberOfIterations_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfIterations(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetNumberOfIterations_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfIterations();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetRelaxationFactor_134(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRelaxationFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceNets3D_GetRelaxationFactor_135(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRelaxationFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetConstraintDistance_136(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConstraintDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceNets3D_GetConstraintDistance_137(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConstraintDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetConstraintBox_138(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConstraintBox(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetConstraintBox_139(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConstraintBox(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkSurfaceNets3D_GetConstraintBox_140(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConstraintBox();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_GetConstraintBox_141(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetConstraintBox(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetConstraintStrategyToConstraintDistance_142(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConstraintStrategyToConstraintDistance();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetConstraintStrategyToConstraintBox_143(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConstraintStrategyToConstraintBox();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetConstraintStrategy_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConstraintStrategy();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetAutomaticSmoothingConstraints_145(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutomaticSmoothingConstraints(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSurfaceNets3D_GetAutomaticSmoothingConstraints_146(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutomaticSmoothingConstraints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_AutomaticSmoothingConstraintsOn_147(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutomaticSmoothingConstraintsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_AutomaticSmoothingConstraintsOff_148(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutomaticSmoothingConstraintsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetConstraintScale_149(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConstraintScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceNets3D_GetConstraintScaleMinValue_150(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConstraintScaleMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceNets3D_GetConstraintScaleMaxValue_151(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConstraintScaleMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceNets3D_GetConstraintScale_152(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConstraintScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetOptimizedSmoothingStencils_153(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOptimizedSmoothingStencils(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSurfaceNets3D_GetOptimizedSmoothingStencils_154(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOptimizedSmoothingStencils();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_OptimizedSmoothingStencilsOn_155(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->OptimizedSmoothingStencilsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_OptimizedSmoothingStencilsOff_156(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->OptimizedSmoothingStencilsOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSurfaceNets3D_GetSmoother_157(JNIEnv* env, jobject obj)
{
  vtkConstrainedSmoothingFilter * temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSmoother();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetOutputStyle_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputStyle(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetOutputStyleMinValue_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputStyleMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetOutputStyleMaxValue_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputStyleMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetOutputStyle_161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputStyle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetOutputStyleToDefault_162(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputStyleToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetOutputStyleToBoundary_163(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputStyleToBoundary();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetOutputStyleToSelected_164(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputStyleToSelected();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_InitializeSelectedLabelsList_165(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeSelectedLabelsList();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_AddSelectedLabel_166(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddSelectedLabel(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_DeleteSelectedLabel_167(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeleteSelectedLabel(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSurfaceNets3D_GetNumberOfSelectedLabels_168(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSelectedLabels();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceNets3D_GetSelectedLabel_169(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double   temp20;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedLabel(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetTriangulationStrategy_170(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTriangulationStrategy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetTriangulationStrategyMinValue_171(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTriangulationStrategyMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetTriangulationStrategyMaxValue_172(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTriangulationStrategyMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceNets3D_GetTriangulationStrategy_173(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTriangulationStrategy();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetTriangulationStrategyToGreedy_174(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTriangulationStrategyToGreedy();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetTriangulationStrategyToMinEdge_175(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTriangulationStrategyToMinEdge();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetTriangulationStrategyToMinArea_176(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTriangulationStrategyToMinArea();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_SetDataCaching_177(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataCaching(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSurfaceNets3D_GetDataCaching_178(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataCaching();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_DataCachingOn_179(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DataCachingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceNets3D_DataCachingOff_180(JNIEnv* env, jobject obj)
{

  vtkSurfaceNets3D* op = static_cast<vtkSurfaceNets3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DataCachingOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSurfaceNets3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSurfaceNets3D::New());
}
