// java wrapper for vtkDelaunay3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDelaunay3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkUnstructuredGridAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDelaunay3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDelaunay3D",dType)) { return me; }
  if ((res= vtkUnstructuredGridAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelaunay3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelaunay3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_SetAlpha_14(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlpha(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay3D_GetAlphaMinValue_15(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlphaMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay3D_GetAlphaMaxValue_16(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlphaMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay3D_GetAlpha_17(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlpha();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_SetAlphaTets_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlphaTets(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay3D_GetAlphaTets_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlphaTets();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_AlphaTetsOn_110(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AlphaTetsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_AlphaTetsOff_111(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AlphaTetsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_SetAlphaTris_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlphaTris(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay3D_GetAlphaTris_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlphaTris();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_AlphaTrisOn_114(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AlphaTrisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_AlphaTrisOff_115(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AlphaTrisOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_SetAlphaLines_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlphaLines(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay3D_GetAlphaLines_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlphaLines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_AlphaLinesOn_118(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AlphaLinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_AlphaLinesOff_119(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AlphaLinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_SetAlphaVerts_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlphaVerts(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay3D_GetAlphaVerts_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlphaVerts();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_AlphaVertsOn_122(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AlphaVertsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_AlphaVertsOff_123(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AlphaVertsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_SetTolerance_124(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay3D_GetToleranceMinValue_125(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay3D_GetToleranceMaxValue_126(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay3D_GetTolerance_127(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_SetOffset_128(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffset(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay3D_GetOffsetMinValue_129(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffsetMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay3D_GetOffsetMaxValue_130(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffsetMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay3D_GetOffset_131(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_SetBoundingTriangulation_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBoundingTriangulation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay3D_GetBoundingTriangulation_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundingTriangulation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_BoundingTriangulationOn_134(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BoundingTriangulationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_BoundingTriangulationOff_135(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BoundingTriangulationOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_SetLocator_136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIncrementalPointLocator * temp0;
  temp0 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLocator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelaunay3D_GetLocator_137(JNIEnv* env, jobject obj)
{
  vtkIncrementalPointLocator * temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_CreateDefaultLocator_138(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateDefaultLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_InsertPoint_139(JNIEnv* env, jobject obj,jobject id0,jobject id1,jlong id2,jdoubleArray id3,jobject id4)
{
  vtkUnstructuredGrid * temp0;
  vtkPoints * temp1;
  long long   temp2;
  double temp3[3];
  vtkIdList * temp4;
  temp0 = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  temp4 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id4));

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoint(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_EndPointInsertion_140(JNIEnv* env, jobject obj)
{

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndPointInsertion();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelaunay3D_GetMTime_141(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay3D_SetOutputPointsPrecision_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPointsPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay3D_GetOutputPointsPrecision_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay3D* op = static_cast<vtkDelaunay3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecision();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDelaunay3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDelaunay3D::New());
}
