// java wrapper for vtkAbstractTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAbstractTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAbstractTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAbstractTransform",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_TransformPoint_14(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_TransformPoint_15(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractTransform_TransformPoint_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformPoint(temp0,temp1,temp2);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractTransform_TransformPoint_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformPoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkAbstractTransform_TransformFloatPoint_18(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformFloatPoint(temp0,temp1,temp2);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkAbstractTransform_TransformFloatPoint_19(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  float * temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformFloatPoint(temp0);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractTransform_TransformDoublePoint_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformDoublePoint(temp0,temp1,temp2);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractTransform_TransformDoublePoint_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformDoublePoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_TransformNormalAtPoint_112(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[3];
  float temp1[3];
  float temp2[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformNormalAtPoint(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_TransformNormalAtPoint_113(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformNormalAtPoint(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractTransform_TransformNormalAtPoint_114(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformNormalAtPoint(temp0,temp1);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractTransform_TransformDoubleNormalAtPoint_115(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformDoubleNormalAtPoint(temp0,temp1);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkAbstractTransform_TransformFloatNormalAtPoint_116(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  float * temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformFloatNormalAtPoint(temp0,temp1);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_TransformVectorAtPoint_117(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[3];
  float temp1[3];
  float temp2[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformVectorAtPoint(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_TransformVectorAtPoint_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformVectorAtPoint(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractTransform_TransformVectorAtPoint_119(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformVectorAtPoint(temp0,temp1);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractTransform_TransformDoubleVectorAtPoint_120(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformDoubleVectorAtPoint(temp0,temp1);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkAbstractTransform_TransformFloatVectorAtPoint_121(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  float * temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformFloatVectorAtPoint(temp0,temp1);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_TransformPoints_122(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkPoints * temp0;
  vtkPoints * temp1;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPoints(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractTransform_GetInverse_123(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInverse();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_SetInverse_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInverse(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_Inverse_125(JNIEnv* env, jobject obj)
{

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Inverse();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_DeepCopy_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_Update_127(JNIEnv* env, jobject obj)
{

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_InternalTransformPoint_128(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_InternalTransformPoint_129(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractTransform_MakeTransform_130(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractTransform_CircuitCheck_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  int   temp20;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CircuitCheck(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractTransform_GetMTime_132(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_Modified_133(JNIEnv* env, jobject obj)
{

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Modified();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractTransform_UnRegister_134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObjectBase * temp0;
  temp0 = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractTransform* op = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnRegister(temp0);

}
