// java wrapper for vtkThreadedImageAlgorithm object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkThreadedImageAlgorithm.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkThreadedImageAlgorithm_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkThreadedImageAlgorithm",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkThreadedImageAlgorithm_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkThreadedImageAlgorithm_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_ThreadedExecute_14(JNIEnv* env, jobject obj,jobject id0,jobject id1,jintArray id2,jint id3)
{
  vtkImageData * temp0;
  vtkImageData * temp1;
  int temp2[6];
  int   temp3;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id1));
  env->GetIntArrayRegion(id2, 0, 6, reinterpret_cast<jint*>(&temp2[0]));
  temp3 = id3;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->ThreadedExecute(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id2, 0, 6, reinterpret_cast<jint*>(&temp2[0]));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetEnableSMP_15(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableSMP();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SetEnableSMP_16(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableSMP(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SetGlobalDefaultEnableSMP_17(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGlobalDefaultEnableSMP(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetGlobalDefaultEnableSMP_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalDefaultEnableSMP();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SetMinimumPieceSize_19(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumPieceSize(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SetMinimumPieceSize_110(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumPieceSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetMinimumPieceSize_111(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumPieceSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SetDesiredBytesPerPiece_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDesiredBytesPerPiece(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetDesiredBytesPerPiece_113(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDesiredBytesPerPiece();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SetSplitMode_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSplitMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetSplitModeMinValue_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSplitModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetSplitModeMaxValue_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSplitModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SetSplitModeToSlab_117(JNIEnv* env, jobject obj)
{

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSplitModeToSlab();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SetSplitModeToBeam_118(JNIEnv* env, jobject obj)
{

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSplitModeToBeam();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SetSplitModeToBlock_119(JNIEnv* env, jobject obj)
{

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSplitModeToBlock();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetSplitMode_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSplitMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SetNumberOfThreads_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfThreads(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetNumberOfThreadsMinValue_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThreadsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetNumberOfThreadsMaxValue_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThreadsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkThreadedImageAlgorithm_GetNumberOfThreads_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThreads();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkThreadedImageAlgorithm_SplitExtent_125(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jint id2,jint id3)
{
  int temp0[6];
  int temp1[6];
  int   temp2;
  int   temp3;
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = id2;
  temp3 = id3;

  vtkThreadedImageAlgorithm* op = static_cast<vtkThreadedImageAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SplitExtent(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->SetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));
  return temp20;

}
