// java wrapper for vtkXMLDataElement object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkXMLDataElement.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkXMLDataElement_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkXMLDataElement",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataElement_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataElement_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLDataElement_GetName_14(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLDataElement_GetId_16(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetId();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetId_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetId(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLDataElement_GetAttribute_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  const char * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttribute(temp0);
  delete[] temp0;
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetAttribute_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttribute(temp0,temp1);
  delete[] temp0;
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetCharacterData_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCharacterData(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLDataElement_GetCharacterData_111(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCharacterData();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetIntAttribute_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntAttribute(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetFloatAttribute_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloat id1)
{
  char * temp0;
  float   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFloatAttribute(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetDoubleAttribute_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdouble id1)
{
  char * temp0;
  double   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDoubleAttribute(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetUnsignedLongAttribute_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jlong id1)
{
  char * temp0;
   unsigned long   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnsignedLongAttribute(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataElement_GetNumberOfAttributes_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAttributes();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLDataElement_GetAttributeName_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLDataElement_GetAttributeValue_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeValue(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_RemoveAttribute_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAttribute(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_RemoveAllAttributes_120(JNIEnv* env, jobject obj)
{

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllAttributes();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_GetParent_121(JNIEnv* env, jobject obj)
{
  vtkXMLDataElement * temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParent();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetParent_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkXMLDataElement * temp0;
  temp0 = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParent(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_GetRoot_123(JNIEnv* env, jobject obj)
{
  vtkXMLDataElement * temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRoot();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataElement_GetNumberOfNestedElements_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNestedElements();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_GetNestedElement_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkXMLDataElement * temp20;
  temp0 = id0;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNestedElement(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_AddNestedElement_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkXMLDataElement * temp0;
  temp0 = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddNestedElement(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_RemoveNestedElement_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkXMLDataElement * temp0;
  temp0 = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveNestedElement(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_RemoveAllNestedElements_128(JNIEnv* env, jobject obj)
{

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllNestedElements();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_FindNestedElement_129(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkXMLDataElement * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindNestedElement(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_FindNestedElementWithName_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkXMLDataElement * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindNestedElementWithName(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_FindNestedElementWithNameAndId_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  vtkXMLDataElement * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindNestedElementWithNameAndId(temp0,temp1);
  delete[] temp0;
  delete[] temp1;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_FindNestedElementWithNameAndAttribute_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1, jbyteArray id2, jint len2)
{
  char * temp0;
  char * temp1;
  char * temp2;
  vtkXMLDataElement * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindNestedElementWithNameAndAttribute(temp0,temp1,temp2);
  delete[] temp0;
  delete[] temp1;
  delete[] temp2;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_LookupElementWithName_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkXMLDataElement * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->LookupElementWithName(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_LookupElement_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkXMLDataElement * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->LookupElement(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataElement_GetXMLByteIndex_135(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXMLByteIndex();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetXMLByteIndex_136(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXMLByteIndex(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataElement_IsEqualTo_137(JNIEnv* env, jobject obj,jobject id0)
{
  vtkXMLDataElement * temp0;
  int   temp20;
  temp0 = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsEqualTo(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_DeepCopy_138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkXMLDataElement * temp0;
  temp0 = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetAttributeEncoding_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttributeEncoding(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataElement_GetAttributeEncodingMinValue_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeEncodingMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataElement_GetAttributeEncodingMaxValue_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeEncodingMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataElement_GetAttributeEncoding_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeEncoding();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_PrintXML_143(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrintXML(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataElement_GetCharacterDataWidth_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCharacterDataWidth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataElement_SetCharacterDataWidth_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXMLDataElement* op = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCharacterDataWidth(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkXMLDataElement_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkXMLDataElement::New());
}
