// java wrapper for vtkTetra object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTetra.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkCell3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTetra_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTetra",dType)) { return me; }
  if ((res= vtkCell3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTetra_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTetra_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTetra_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTetra_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTetra_GetCentroid_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCentroid(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTetra_IsInsideOut_15(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInsideOut();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTetra_GetCellType_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTetra_GetNumberOfEdges_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTetra_GetNumberOfFaces_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTetra_GetEdge_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTetra_GetFace_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTetra_Contour_111(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jobject id7,jobject id8,jlong id9,jobject id10)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkCellArray * temp4;
  vtkCellArray * temp5;
  vtkPointData * temp6;
  vtkPointData * temp7;
  vtkCellData * temp8;
  long long   temp9;
  vtkCellData * temp10;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id7));
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;
  temp10 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id10));

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  op->Contour(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTetra_Clip_112(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jlong id7,jobject id8,jint id9)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkPointData * temp4;
  vtkPointData * temp5;
  vtkCellData * temp6;
  long long   temp7;
  vtkCellData * temp8;
  int   temp9;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = id7;
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clip(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTetra_TriangulateLocalIds_113(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTetra_CellBoundary_114(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTetra_GetParametricCenter_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTetra_GetParametricDistance_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricDistance(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTetra_TetraCenter_117(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double temp4[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  op->TetraCenter(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTetra_Circumsphere_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double temp4[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Circumsphere(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTetra_Insphere_119(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double temp4[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Insphere(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTetra_BarycentricCoords_120(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4,jdoubleArray id5)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double temp4[3];
  double temp5[4];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  env->GetDoubleArrayRegion(id5, 0, 4, &temp5[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->BarycentricCoords(temp0,temp1,temp2,temp3,temp4,temp5);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  env->SetDoubleArrayRegion(id5, 0, 4, &temp5[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTetra_ComputeVolume_121(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeVolume(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTetra_InterpolationFunctions_122(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[4];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolationFunctions(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTetra_InterpolationDerivs_123(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[12];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 12, &temp1[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolationDerivs(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 12, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTetra_InterpolateFunctions_124(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[4];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateFunctions(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTetra_InterpolateDerivs_125(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[12];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 12, &temp1[0]);

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateDerivs(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 12, &temp1[0]);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkTetra_GetEdgeArray_126(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 2);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkTetra_GetFaceArray_127(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkTetra_GetEdgeToAdjacentFacesArray_128(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeToAdjacentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 2);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkTetra_GetFaceToAdjacentFacesArray_129(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceToAdjacentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkTetra_GetPointToIncidentEdgesArray_130(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToIncidentEdgesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkTetra_GetPointToIncidentFacesArray_131(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToIncidentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkTetra_GetPointToOneRingPointsArray_132(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkTetra* op = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToOneRingPointsArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTetra_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTetra::New());
}
