// java wrapper for vtkLookupTable object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLookupTable.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkScalarsToColors_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLookupTable_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLookupTable",dType)) { return me; }
  if ((res= vtkScalarsToColors_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLookupTable_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLookupTable_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_IsOpaque_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsOpaque();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_IsOpaque_15(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkAbstractArray * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsOpaque(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_IsOpaque_16(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2,jobject id3,jbyte id4)
{
  vtkAbstractArray * temp0;
  int   temp1;
  int   temp2;
  vtkUnsignedCharArray * temp3;
   unsigned char   temp4;
  int   temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = id4;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsOpaque(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_Allocate_17(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Allocate(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_Build_18(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->Build();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_ForceBuild_19(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceBuild();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_BuildSpecialColors_110(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildSpecialColors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetRamp_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRamp(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetRampToLinear_112(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRampToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetRampToSCurve_113(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRampToSCurve();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetRampToSQRT_114(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRampToSQRT();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_GetRamp_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRamp();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetScale_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetScaleToLinear_117(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetScaleToLog10_118(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleToLog10();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_GetScale_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetTableRange_120(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTableRange(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetTableRange_121(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTableRange(temp0,temp1);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLookupTable_GetTableRange_122(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTableRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetHueRange_123(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHueRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetHueRange_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHueRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLookupTable_GetHueRange_125(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHueRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetSaturationRange_126(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSaturationRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetSaturationRange_127(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSaturationRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLookupTable_GetSaturationRange_128(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSaturationRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetValueRange_129(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValueRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetValueRange_130(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValueRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLookupTable_GetValueRange_131(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetAlphaRange_132(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlphaRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetAlphaRange_133(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlphaRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLookupTable_GetAlphaRange_134(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlphaRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetNanColor_135(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNanColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetNanColor_136(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNanColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLookupTable_GetNanColor_137(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNanColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetBelowRangeColor_138(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBelowRangeColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetBelowRangeColor_139(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBelowRangeColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLookupTable_GetBelowRangeColor_140(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBelowRangeColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetUseBelowRangeColor_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseBelowRangeColor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_GetUseBelowRangeColor_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseBelowRangeColor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_UseBelowRangeColorOn_143(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBelowRangeColorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_UseBelowRangeColorOff_144(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBelowRangeColorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetAboveRangeColor_145(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAboveRangeColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetAboveRangeColor_146(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAboveRangeColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLookupTable_GetAboveRangeColor_147(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAboveRangeColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetUseAboveRangeColor_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseAboveRangeColor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_GetUseAboveRangeColor_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseAboveRangeColor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_UseAboveRangeColorOn_150(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseAboveRangeColorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_UseAboveRangeColorOff_151(JNIEnv* env, jobject obj)
{

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseAboveRangeColorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_GetColor_152(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1)
{
  double   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetColor(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLookupTable_GetOpacity_153(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  double   temp20;
  temp0 = id0;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacity(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLookupTable_GetIndex_154(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  long long   temp20;
  temp0 = id0;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIndex(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetNumberOfTableValues_155(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTableValues(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLookupTable_GetNumberOfTableValues_156(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTableValues();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetTableValue_157(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[4];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTableValue(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetTableValue_158(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTableValue(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLookupTable_GetTableValue_159(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTableValue(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_GetTableValue_160(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[4];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTableValue(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLookupTable_GetRange_161(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetRange_162(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetRange_163(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_GetLogRange_164(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[2];
  double temp1[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetLogRange(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLookupTable_ApplyLogScale_165(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1,jdoubleArray id2)
{
  double   temp0;
  double temp1[2];
  double temp2[2];
  double   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 2, &temp2[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ApplyLogScale(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetNumberOfColors_166(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfColors(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLookupTable_GetNumberOfColorsMinValue_167(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfColorsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLookupTable_GetNumberOfColorsMaxValue_168(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfColorsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLookupTable_GetNumberOfColors_169(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfColors();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_SetTable_170(JNIEnv* env, jobject obj,jobject id0)
{
  vtkUnsignedCharArray * temp0;
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLookupTable_GetTable_171(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_DeepCopy_172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLookupTable_UsingLogScale_173(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UsingLogScale();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLookupTable_GetNumberOfAvailableColors_174(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAvailableColors();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLookupTable_GetIndexedColor_175(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[4];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkLookupTable* op = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetIndexedColor(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLookupTable_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLookupTable::New());
}
