// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkPBRFunctions.h"

const char *vtkPBRFunctions =
"//VTK::Define::Dec\n"
"//VTK::Light::Dec\n"
"const float PI = 3.14159265359;\n"
"const float recPI = 0.31830988618;\n"
"uniform float metallicUniform;\n"
"uniform float roughnessUniform;\n"
"uniform vec3 emissiveFactorUniform;\n"
"uniform float aoStrengthUniform;\n"
"uniform float baseF0Uniform;\n"
"uniform vec3 edgeTintUniform;\n"
"#ifdef ANISOTROPY\n"
"uniform float anisotropyUniform;\n"
"#endif\n"
"#ifdef CLEAR_COAT\n"
"uniform float coatF0Uniform;\n"
"uniform float coatStrengthUniform;\n"
"uniform float coatRoughnessUniform;\n"
"uniform vec3 coatColorUniform;\n"
"#endif\n"
"float D_GGX(float NdH, float roughness)\n"
"{\n"
"  float a = roughness * roughness;\n"
"  float a2 = a * a;\n"
"  float d = (NdH * a2 - NdH) * NdH + 1.0;\n"
"  return a2 / (PI * d * d);\n"
"}\n"
"float V_SmithCorrelated(float NdV, float NdL, float roughness)\n"
"{\n"
"  float a2 = roughness * roughness;\n"
"  float ggxV = NdL * sqrt(a2 + NdV * (NdV - a2 * NdV));\n"
"  float ggxL = NdV * sqrt(a2 + NdL * (NdL - a2 * NdL));\n"
"  return 0.5 / (ggxV + ggxL);\n"
"}\n"
"vec3 F_Schlick(vec3 F0, vec3 F90, float HdL)\n"
"{\n"
"  return F0 + (F90 - F0) * pow(1.0 - HdL, 5.0);\n"
"}\n"
"vec3 DiffuseLambert(vec3 albedo)\n"
"{\n"
"  return albedo * recPI;\n"
"}\n"
"vec3 SpecularIsotropic(float NdH, float NdV, float NdL, float HdL, float roughness,\n"
"  vec3 F0, vec3 F90, out vec3 F)\n"
"{\n"
"  float D = D_GGX(NdH, roughness);\n"
"  float V = V_SmithCorrelated(NdV, NdL, roughness);\n"
"  F = F_Schlick(F0, F90, HdL);\n"
"  return (D * V) * F;\n"
"}\n"
"#ifdef ANISOTROPY\n"
"// Anisotropy functions\n"
"float D_GGX_Anisotropic(float at, float ab, float TdH, float BdH, float NdH)\n"
"{\n"
"  float a2 = at * ab;\n"
"  vec3 d = vec3(ab * TdH, at * BdH, a2 * NdH);\n"
"  float d2 = dot(d, d);\n"
"  float b2 = a2 / d2;\n"
"  return a2 * b2 * b2 * recPI;\n"
"}\n"
"float V_SmithGGXCorrelated_Anisotropic(float at, float ab, float TdV, float BdV,\n"
"  float TdL, float BdL, float NdV, float NdL)\n"
"{\n"
"  float lambdaV = NdL * length(vec3(at * TdV, ab * BdV, NdV));\n"
"  float lambdaL = NdV * length(vec3(at * TdL, ab * BdL, NdL));\n"
"  return 0.5 / (lambdaV + lambdaL);\n"
"}\n"
"vec3 SpecularAnisotropic(float at, float ab, vec3 l, vec3 t, vec3 b, vec3 h, float TdV,\n"
"  float BdV, float NdH, float NdV, float NdL, float HdL, float roughness, float anisotropy,\n"
"  vec3 F0, vec3 F90, out vec3 F)\n"
"{\n"
"  float TdL = dot(t, l);\n"
"  float BdL = dot(b, l);\n"
"  float TdH = dot(t, h);\n"
"  float BdH = dot(b, h);\n"
"  // specular anisotropic BRDF\n"
"  float D = D_GGX_Anisotropic(at, ab, TdH, BdH, NdH);\n"
"  float V = V_SmithGGXCorrelated_Anisotropic(at, ab, TdV, BdV, TdL, BdL, NdV, NdL);\n"
"  F = F_Schlick(F0, F90, HdL);\n"
"  return (D * V) * F;\n"
"}\n"
"#endif\n"
"";
