// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkEDLComposeFS.h"

const char *vtkEDLComposeFS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-FileCopyrightText: Copyright (c) Sandia Corporation, Kitware Inc\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"/*----------------------------------------------------------------------\n"
"Acknowledgement:\n"
"This algorithm is the result of joint work by Electricité de France,\n"
"CNRS, Collège de France and Université J. Fourier as part of the\n"
"Ph.D. thesis of Christian BOUCHENY.\n"
"------------------------------------------------------------------------*/\n"
"//////////////////////////////////////////////////////////////////////////\n"
"//\n"
"//\n"
"//  EyeDome Lighting - Compositing - Simplified version for use in VTK\\n\n"
"//\n"
"//    C.B. - 3 feb. 2009\n"
"//\n"
"//////////////////////////////////////////////////////////////////////////\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"in vec2 tcoordVC;\n"
"\n"
"/**************************************************/\n"
"uniform sampler2D    s2_S1;  // fine scale\n"
"uniform sampler2D    s2_S2;  // larger medium scale\n"
"uniform sampler2D    s2_C;   // scene color image\n"
"/**************************************************/\n"
"\n"
"void main (void)\n"
"{\n"
"  vec4 shade1  =  texture2D(s2_S1,tcoordVC.st);\n"
"  vec4 shade2  =  texture2D(s2_S2,tcoordVC.st);\n"
"  vec4  color   =  texture2D(s2_C,tcoordVC.st);\n"
"\n"
"  // if it is the background (ala depth > 0.99) just copy it\n"
"  //if(shade1.a > 0.99)\n"
"  //  {\n"
"  //  gl_FragData[0] = vec4(shade1.rgb,1.) * color;\n"
"  //  }\n"
"  //else\n"
"  //  {\n"
"    float lum = mix(shade1.r,shade2.r,0.3);\n"
"    gl_FragData[0] = vec4(color.rgb*lum, color.a);\n"
"  //  }\n"
"\n"
"  gl_FragDepth = shade1.a; // write stored depth\n"
"}\n"
"";
