// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkCellGridShaderTessellationDebugGeometry.h"

const char *vtkCellGridShaderTessellationDebugGeometry =
"//VTK::System::Dec\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"\n"
"layout({GSInputPrimitive}) in;\n"
"layout({GSOutputPrimitive}, max_vertices = {GSOutputMaxVertices}) out;\n"
"\n"
"flat in int cellIdTESOutput[{GSOutputMaxVertices}];\n"
"flat in int instanceIdTESOutput[{GSOutputMaxVertices}];\n"
"smooth in vec3 patchDistanceTESOutput[{GSOutputMaxVertices}];\n"
"smooth in vec3 normalVCTESOutput[{GSOutputMaxVertices}];\n"
"smooth in vec4 vertexVCTESOutput[{GSOutputMaxVertices}];\n"
"smooth in vec3 pcoordTESOutput[{GSOutputMaxVertices}];\n"
"\n"
"flat out int cellIdGSOutput;\n"
"flat out int instanceIdGSOutput;\n"
"smooth out vec3 patchDistanceGSOutput;\n"
"smooth out vec3 normalVCGSOutput;\n"
"smooth out vec4 vertexVCGSOutput;\n"
"smooth out vec3 pcoordGSOutput;\n"
"smooth out vec3 primDistanceGSOutput;\n"
"\n"
"void main()\n"
"{{\n"
"#if {GSOutputMaxVertices} == 3\n"
"    cellIdGSOutput = cellIdTESOutput[0];\n"
"    instanceIdGSOutput = instanceIdTESOutput[0];\n"
"    patchDistanceGSOutput = patchDistanceTESOutput[0];\n"
"    normalVCGSOutput = normalVCTESOutput[0];\n"
"    vertexVCGSOutput = vertexVCTESOutput[0];\n"
"    pcoordGSOutput = pcoordTESOutput[0];\n"
"    primDistanceGSOutput = vec3(1, 0, 0);\n"
"    gl_Position = gl_in[0].gl_Position;\n"
"    EmitVertex();\n"
"\n"
"    cellIdGSOutput = cellIdTESOutput[1];\n"
"    instanceIdGSOutput = instanceIdTESOutput[1];\n"
"    patchDistanceGSOutput = patchDistanceTESOutput[1];\n"
"    normalVCGSOutput = normalVCTESOutput[1];\n"
"    vertexVCGSOutput = vertexVCTESOutput[1];\n"
"    pcoordGSOutput = pcoordTESOutput[1];\n"
"    primDistanceGSOutput = vec3(0, 1, 0);\n"
"    gl_Position = gl_in[1].gl_Position;\n"
"    EmitVertex();\n"
"\n"
"    cellIdGSOutput = cellIdTESOutput[2];\n"
"    instanceIdGSOutput = instanceIdTESOutput[2];\n"
"    patchDistanceGSOutput = patchDistanceTESOutput[2];\n"
"    normalVCGSOutput = normalVCTESOutput[2];\n"
"    vertexVCGSOutput = vertexVCTESOutput[2];\n"
"    pcoordGSOutput = pcoordTESOutput[2];\n"
"    primDistanceGSOutput = vec3(0, 0, 1);\n"
"    gl_Position = gl_in[2].gl_Position;\n"
"    EmitVertex();\n"
"\n"
"    EndPrimitive();\n"
"#elif {GSOutputMaxVertices} == 2\n"
"    cellIdGSOutput = cellIdTESOutput[0];\n"
"    instanceIdGSOutput = instanceIdTESOutput[0];\n"
"    patchDistanceGSOutput = patchDistanceTESOutput[0];\n"
"    normalVCGSOutput = normalVCTESOutput[1];\n"
"    vertexVCGSOutput = vertexVCTESOutput[1];\n"
"    pcoordGSOutput = pcoordTESOutput[1];\n"
"    primDistanceGSOutput = vec3(0, 0, 0);\n"
"    gl_Position = gl_in[0].gl_Position;\n"
"    EmitVertex();\n"
"\n"
"    cellIdGSOutput = cellIdTESOutput[1];\n"
"    instanceIdGSOutput = instanceIdTESOutput[1];\n"
"    patchDistanceGSOutput = patchDistanceTESOutput[1];\n"
"    normalVCGSOutput = normalVCTESOutput[1];\n"
"    vertexVCGSOutput = vertexVCTESOutput[1];\n"
"    pcoordGSOutput = pcoordTESOutput[1];\n"
"    primDistanceGSOutput = vec3(1, 0, 0);\n"
"    gl_Position = gl_in[1].gl_Position;\n"
"    EmitVertex();\n"
"\n"
"    EndPrimitive();\n"
"#endif\n"
"}}\n"
"";
