// python wrapper for vtkOSPRayMaterialLibrary
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkOSPRayMaterialLibrary.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkOSPRayMaterialLibrary(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkOSPRayMaterialLibrary_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOSPRayMaterialLibrary_ParameterType_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingRayTracing.vtkOSPRayMaterialLibrary.ParameterType", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkOSPRayMaterialLibrary_ParameterType_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkOSPRayMaterialLibrary_ParameterType_Type, static_cast<int>(val));
}


static PyObject *
PyvtkOSPRayMaterialLibrary_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkOSPRayMaterialLibrary::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkOSPRayMaterialLibrary::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkOSPRayMaterialLibrary *tempr = vtkOSPRayMaterialLibrary::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOSPRayMaterialLibrary *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkOSPRayMaterialLibrary::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkOSPRayMaterialLibrary::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkOSPRayMaterialLibrary::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_Fire(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Fire");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Fire();
    }
    else
    {
      op->vtkOSPRayMaterialLibrary::Fire();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_ReadFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->ReadFile(temp0) :
      op->vtkOSPRayMaterialLibrary::ReadFile(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_WriteBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  bool temp0 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    const char *tempr = (ap.IsBound() ?
      op->WriteBuffer(temp0) :
      op->vtkOSPRayMaterialLibrary::WriteBuffer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_WriteFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->WriteFile(temp0, temp1);
    }
    else
    {
      op->vtkOSPRayMaterialLibrary::WriteFile(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_ReadBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->ReadBuffer(temp0) :
      op->vtkOSPRayMaterialLibrary::ReadBuffer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_LookupImplName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupImplName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->LookupImplName(temp0) :
      op->vtkOSPRayMaterialLibrary::LookupImplName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_GetDoubleShaderVariableList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDoubleShaderVariableList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::vector<std::string> tempr = (ap.IsBound() ?
      op->GetDoubleShaderVariableList(temp0) :
      op->vtkOSPRayMaterialLibrary::GetDoubleShaderVariableList(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_GetDoubleShaderVariable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDoubleShaderVariable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    std::vector<double> tempr = (ap.IsBound() ?
      op->GetDoubleShaderVariable(temp0, temp1) :
      op->vtkOSPRayMaterialLibrary::GetDoubleShaderVariable(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_GetTextureList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTextureList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::vector<std::string> tempr = (ap.IsBound() ?
      op->GetTextureList(temp0) :
      op->vtkOSPRayMaterialLibrary::GetTextureList(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_GetTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkTexture *tempr = (ap.IsBound() ?
      op->GetTexture(temp0, temp1) :
      op->vtkOSPRayMaterialLibrary::GetTexture(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_GetTextureName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTextureName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetTextureName(temp0, temp1) :
      op->vtkOSPRayMaterialLibrary::GetTextureName(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_GetTextureFilename(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTextureFilename");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetTextureFilename(temp0, temp1) :
      op->vtkOSPRayMaterialLibrary::GetTextureFilename(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_AddMaterial(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddMaterial");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddMaterial(temp0, temp1);
    }
    else
    {
      op->vtkOSPRayMaterialLibrary::AddMaterial(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_RemoveMaterial(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveMaterial");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveMaterial(temp0);
    }
    else
    {
      op->vtkOSPRayMaterialLibrary::RemoveMaterial(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_AddTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  std::string temp1;
  vtkTexture *temp2 = nullptr;
  std::string temp3 = "unnamedTexture";
  std::string temp4 = "";
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkTexture") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    if (ap.IsBound())
    {
      op->AddTexture(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkOSPRayMaterialLibrary::AddTexture(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_RemoveTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->RemoveTexture(temp0, temp1);
    }
    else
    {
      op->vtkOSPRayMaterialLibrary::RemoveTexture(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_RemoveAllTextures(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllTextures");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllTextures(temp0);
    }
    else
    {
      op->vtkOSPRayMaterialLibrary::RemoveAllTextures(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_AddShaderVariable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddShaderVariable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  std::string temp1;
  int temp2;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(size3);
  double *temp3 = store3.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetArray(temp3, size3))
  {
    if (ap.IsBound())
    {
      op->AddShaderVariable(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkOSPRayMaterialLibrary::AddShaderVariable(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_RemoveShaderVariable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveShaderVariable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->RemoveShaderVariable(temp0, temp1);
    }
    else
    {
      op->vtkOSPRayMaterialLibrary::RemoveShaderVariable(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayMaterialLibrary_RemoveAllShaderVariables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllShaderVariables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayMaterialLibrary *op = static_cast<vtkOSPRayMaterialLibrary *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllShaderVariables(temp0);
    }
    else
    {
      op->vtkOSPRayMaterialLibrary::RemoveAllShaderVariables(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkOSPRayMaterialLibrary_Methods[] = {
  {"IsTypeOf", PyvtkOSPRayMaterialLibrary_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkOSPRayMaterialLibrary_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkOSPRayMaterialLibrary_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkOSPRayMaterialLibrary\nC++: static vtkOSPRayMaterialLibrary *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkOSPRayMaterialLibrary_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkOSPRayMaterialLibrary\nC++: vtkOSPRayMaterialLibrary *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkOSPRayMaterialLibrary_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkOSPRayMaterialLibrary_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Fire", PyvtkOSPRayMaterialLibrary_Fire, METH_VARARGS,
   "Fire(self) -> None\nC++: void Fire()\n\nCalled to kick off events in all followers.\n"},
  {"ReadFile", PyvtkOSPRayMaterialLibrary_ReadFile, METH_VARARGS,
   "ReadFile(self, FileName:str) -> bool\nC++: bool ReadFile(const char *FileName)\n\nReads the given file of materials and creates the in memory data\nstructures needed to display objects with them. Returns false\nonly if file could not be meaningfully interpreted.\n"},
  {"WriteBuffer", PyvtkOSPRayMaterialLibrary_WriteBuffer, METH_VARARGS,
   "WriteBuffer(self, writeImageInline:bool=True) -> str\nC++: const char *WriteBuffer(bool writeImageInline=true)\n\nSerialize contents to an in memory buffer. If writeImageInline,\nall textures are stored in a XML format. Else, store the texture\nusing its filename stored in its TextureInfo struct. Warning: you\nmust free the return value using delete.\n"},
  {"WriteFile", PyvtkOSPRayMaterialLibrary_WriteFile, METH_VARARGS,
   "WriteFile(self, filename:str, writeImageInline:bool=False) -> None\nC++: void WriteFile(const std::string &filename,\n    bool writeImageInline=false)\n\nSerialize contents to a file specified by filename. If\nwriteImageInline, all textures are stored in a XML format. Else,\nstore the texture using its filename stored in its TextureInfo\nstruct Warning: if filename exists, its content is discarded.\n"},
  {"ReadBuffer", PyvtkOSPRayMaterialLibrary_ReadBuffer, METH_VARARGS,
   "ReadBuffer(self, Buffer:str) -> bool\nC++: bool ReadBuffer(const char *Buffer)\n\nDeSerialize contents from an in memory buffer as ReadFile does\nfrom a file or set of files. Returns false only if buffer could\nnot be meaningfully interpreted.\n"},
  {"LookupImplName", PyvtkOSPRayMaterialLibrary_LookupImplName, METH_VARARGS,
   "LookupImplName(self, nickname:str) -> str\nC++: std::string LookupImplName(const std::string &nickname)\n\nReturn an implementation name for the given material nickname.\n"},
  {"GetDoubleShaderVariableList", PyvtkOSPRayMaterialLibrary_GetDoubleShaderVariableList, METH_VARARGS,
   "GetDoubleShaderVariableList(self, nickname:str) -> (str, ...)\nC++: std::vector<std::string> GetDoubleShaderVariableList(\n    const std::string &nickname)\n\nReturns list of variable names set for a specific material.\n"},
  {"GetDoubleShaderVariable", PyvtkOSPRayMaterialLibrary_GetDoubleShaderVariable, METH_VARARGS,
   "GetDoubleShaderVariable(self, nickname:str, varname:str) -> (\n    float, ...)\nC++: std::vector<double> GetDoubleShaderVariable(\n    const std::string &nickname, const std::string &varname)\n\nReturns a uniform variable.\n"},
  {"GetTextureList", PyvtkOSPRayMaterialLibrary_GetTextureList, METH_VARARGS,
   "GetTextureList(self, nickname:str) -> (str, ...)\nC++: std::vector<std::string> GetTextureList(\n    const std::string &nickname)\n\nReturns list of texture names set for a specific material.\n"},
  {"GetTexture", PyvtkOSPRayMaterialLibrary_GetTexture, METH_VARARGS,
   "GetTexture(self, nickname:str, varname:str) -> vtkTexture\nC++: vtkTexture *GetTexture(const std::string &nickname,\n    const std::string &varname)\n\nReturns a texture.\n"},
  {"GetTextureName", PyvtkOSPRayMaterialLibrary_GetTextureName, METH_VARARGS,
   "GetTextureName(self, nickname:str, varname:str) -> str\nC++: std::string GetTextureName(const std::string &nickname,\n    const std::string &varname)\n\nReturns the name (and not the shader variable name) associated to\na texture.\n"},
  {"GetTextureFilename", PyvtkOSPRayMaterialLibrary_GetTextureFilename, METH_VARARGS,
   "GetTextureFilename(self, nickname:str, varname:str) -> str\nC++: std::string GetTextureFilename(const std::string &nickname,\n    const std::string &varname)\n\nReturns the filename associated ti a texture (if any).\n"},
  {"AddMaterial", PyvtkOSPRayMaterialLibrary_AddMaterial, METH_VARARGS,
   "AddMaterial(self, nickname:str, implname:str) -> None\nC++: void AddMaterial(const std::string &nickname,\n    const std::string &implname)\n\nAdd Material Adds a new material nickname to the set of known\nmaterials. If the name is a repeat, we replace the old one.\n"},
  {"RemoveMaterial", PyvtkOSPRayMaterialLibrary_RemoveMaterial, METH_VARARGS,
   "RemoveMaterial(self, nickname:str) -> None\nC++: void RemoveMaterial(const std::string &nickname)\n\nRemove Material Removes a material nickname from the set of known\nmaterials. Do nothing if material does not exist.\n"},
  {"AddTexture", PyvtkOSPRayMaterialLibrary_AddTexture, METH_VARARGS,
   "AddTexture(self, nickname:str, varname:str, tex:vtkTexture,\n    texturename:str=..., filename:str=...) -> None\nC++: void AddTexture(const std::string &nickname,\n    const std::string &varname, vtkTexture *tex,\n    const std::string &texturename=\"unnamedTexture\",\n    const std::string &filename=\"\")\n\nAdd Texture Given a material nickname and a shader variable\nvarname, set its data to a specific texture tex named\ntexturename. If not specified the texture is called\n\"unnamedTexture\". The last parameter, filename, is defaulted to\nempty. If specified, the absolute path to find the texture will\nbe stored. Useful when writing the library into a file.\n\nReplaces any previous content.\n"},
  {"RemoveTexture", PyvtkOSPRayMaterialLibrary_RemoveTexture, METH_VARARGS,
   "RemoveTexture(self, nickname:str, varname:str) -> None\nC++: void RemoveTexture(const std::string &nickname,\n    const std::string &varname)\n\nRemove Texture Removes a texture for a specific materal nickname\nand shader variable varname. Do nothing if texture does not\nexist.\n"},
  {"RemoveAllTextures", PyvtkOSPRayMaterialLibrary_RemoveAllTextures, METH_VARARGS,
   "RemoveAllTextures(self, nickname:str) -> None\nC++: void RemoveAllTextures(const std::string &nickname)\n\nRemove all textures of a specific material\n"},
  {"AddShaderVariable", PyvtkOSPRayMaterialLibrary_AddShaderVariable, METH_VARARGS,
   "AddShaderVariable(self, nickname:str, variablename:str,\n    numVars:int, x:(float, ...)) -> None\nC++: void AddShaderVariable(const std::string &nickname,\n    const std::string &variablename, int numVars, const double *x)\n\n"},
  {"RemoveShaderVariable", PyvtkOSPRayMaterialLibrary_RemoveShaderVariable, METH_VARARGS,
   "RemoveShaderVariable(self, nickname:str, variablename:str) -> None\nC++: void RemoveShaderVariable(const std::string &nickname,\n    const std::string &variablename)\n\nRemove control variable Removes a new control variable. Do\nnothing if variable does not exist.\n"},
  {"RemoveAllShaderVariables", PyvtkOSPRayMaterialLibrary_RemoveAllShaderVariables, METH_VARARGS,
   "RemoveAllShaderVariables(self, nickname:str) -> None\nC++: void RemoveAllShaderVariables(const std::string &nickname)\n\nRemove all control variables of a specific material\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkOSPRayMaterialLibrary_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkOSPRayMaterialLibrary_Doc =
  "vtkOSPRayMaterialLibrary - a collection of materials for vtk apps to\ndraw from\n\n"
  "Superclass: vtkObject\n\n"
  "A singleton instance of this class manages a collection of materials.\n"
  "The materials can be read in from disk or created programmatically.\n\n"
  "@sa vtkOSPRayMaterialHelpers\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOSPRayMaterialLibrary_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingRayTracing.vtkOSPRayMaterialLibrary", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkOSPRayMaterialLibrary_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkOSPRayMaterialLibrary_StaticNew()
{
  return vtkOSPRayMaterialLibrary::New();
}

PyObject *PyvtkOSPRayMaterialLibrary_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkOSPRayMaterialLibrary_Type, PyvtkOSPRayMaterialLibrary_Methods,
    "vtkOSPRayMaterialLibrary",
 &PyvtkOSPRayMaterialLibrary_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkOSPRayMaterialLibrary_ParameterType_Type);
  // members of vtkOSPRayMaterialLibrary::ParameterType
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyvtkOSPRayMaterialLibrary_ParameterType_Type.tp_dict = enumdict;

    typedef vtkOSPRayMaterialLibrary::ParameterType cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[9] = {
      { "FLOAT", cxx_enum_type::FLOAT },
      { "NORMALIZED_FLOAT", cxx_enum_type::NORMALIZED_FLOAT },
      { "FLOAT_DATA", cxx_enum_type::FLOAT_DATA },
      { "VEC3", cxx_enum_type::VEC3 },
      { "COLOR_RGB", cxx_enum_type::COLOR_RGB },
      { "BOOLEAN", cxx_enum_type::BOOLEAN },
      { "TEXTURE", cxx_enum_type::TEXTURE },
      { "VEC2", cxx_enum_type::VEC2 },
      { "VEC4", cxx_enum_type::VEC4 },
    };

    for (int c = 0; c < 9; c++)
    {
      enumval = PyvtkOSPRayMaterialLibrary_ParameterType_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyvtkOSPRayMaterialLibrary_ParameterType_Type, "vtkOSPRayMaterialLibrary.ParameterType");

  o = (PyObject *)&PyvtkOSPRayMaterialLibrary_ParameterType_Type;
  if (PyDict_SetItemString(d, "ParameterType", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkOSPRayMaterialLibrary_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkOSPRayMaterialLibrary(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkOSPRayMaterialLibrary_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkOSPRayMaterialLibrary", o) != 0)
  {
    Py_DECREF(o);
  }

}

