// python wrapper for vtkSynchronizedRenderers
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSynchronizedRenderers.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSynchronizedRenderers(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSynchronizedRenderers_ClassNew(); }


static PyObject *
PyvtkSynchronizedRenderers_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSynchronizedRenderers::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSynchronizedRenderers::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSynchronizedRenderers *tempr = vtkSynchronizedRenderers::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSynchronizedRenderers *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSynchronizedRenderers::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSynchronizedRenderers::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSynchronizedRenderers::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_SetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->SetRenderer(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::SetRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->GetRenderer() :
      op->vtkSynchronizedRenderers::GetRenderer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_SetParallelController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParallelController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetParallelController(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::SetParallelController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetParallelController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetParallelController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetParallelController() :
      op->vtkSynchronizedRenderers::GetParallelController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_SetParallelRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParallelRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetParallelRendering(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::SetParallelRendering(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetParallelRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetParallelRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetParallelRendering() :
      op->vtkSynchronizedRenderers::GetParallelRendering());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_ParallelRenderingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ParallelRenderingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ParallelRenderingOn();
    }
    else
    {
      op->vtkSynchronizedRenderers::ParallelRenderingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_ParallelRenderingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ParallelRenderingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ParallelRenderingOff();
    }
    else
    {
      op->vtkSynchronizedRenderers::ParallelRenderingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_SetImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImageReductionFactor(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::SetImageReductionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetImageReductionFactorMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageReductionFactorMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetImageReductionFactorMinValue() :
      op->vtkSynchronizedRenderers::GetImageReductionFactorMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetImageReductionFactorMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageReductionFactorMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetImageReductionFactorMaxValue() :
      op->vtkSynchronizedRenderers::GetImageReductionFactorMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetImageReductionFactor() :
      op->vtkSynchronizedRenderers::GetImageReductionFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_SetWriteBackImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteBackImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteBackImages(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::SetWriteBackImages(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetWriteBackImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteBackImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWriteBackImages() :
      op->vtkSynchronizedRenderers::GetWriteBackImages());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_WriteBackImagesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteBackImagesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteBackImagesOn();
    }
    else
    {
      op->vtkSynchronizedRenderers::WriteBackImagesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_WriteBackImagesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteBackImagesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteBackImagesOff();
    }
    else
    {
      op->vtkSynchronizedRenderers::WriteBackImagesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_SetRootProcessId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRootProcessId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRootProcessId(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::SetRootProcessId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetRootProcessId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRootProcessId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRootProcessId() :
      op->vtkSynchronizedRenderers::GetRootProcessId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_CollectiveExpandForVisiblePropBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CollectiveExpandForVisiblePropBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  double save0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->CollectiveExpandForVisiblePropBounds(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::CollectiveExpandForVisiblePropBounds(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_SetCaptureDelegate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCaptureDelegate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  vtkSynchronizedRenderers *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSynchronizedRenderers"))
  {
    if (ap.IsBound())
    {
      op->SetCaptureDelegate(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::SetCaptureDelegate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetCaptureDelegate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCaptureDelegate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSynchronizedRenderers *tempr = (ap.IsBound() ?
      op->GetCaptureDelegate() :
      op->vtkSynchronizedRenderers::GetCaptureDelegate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_EnableSynchronizableActors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableSynchronizableActors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->EnableSynchronizableActors(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::EnableSynchronizableActors(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_SetAutomaticEventHandling(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutomaticEventHandling");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutomaticEventHandling(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::SetAutomaticEventHandling(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetAutomaticEventHandling(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutomaticEventHandling");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAutomaticEventHandling() :
      op->vtkSynchronizedRenderers::GetAutomaticEventHandling());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_AutomaticEventHandlingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutomaticEventHandlingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutomaticEventHandlingOn();
    }
    else
    {
      op->vtkSynchronizedRenderers::AutomaticEventHandlingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_AutomaticEventHandlingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutomaticEventHandlingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutomaticEventHandlingOff();
    }
    else
    {
      op->vtkSynchronizedRenderers::AutomaticEventHandlingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_SetFixBackground(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFixBackground");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFixBackground(temp0);
    }
    else
    {
      op->vtkSynchronizedRenderers::SetFixBackground(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_GetFixBackground(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFixBackground");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFixBackground() :
      op->vtkSynchronizedRenderers::GetFixBackground());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_FixBackgroundOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FixBackgroundOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->FixBackgroundOn();
    }
    else
    {
      op->vtkSynchronizedRenderers::FixBackgroundOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizedRenderers_FixBackgroundOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FixBackgroundOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizedRenderers *op = static_cast<vtkSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->FixBackgroundOff();
    }
    else
    {
      op->vtkSynchronizedRenderers::FixBackgroundOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSynchronizedRenderers_Methods[] = {
  {"IsTypeOf", PyvtkSynchronizedRenderers_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSynchronizedRenderers_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSynchronizedRenderers_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSynchronizedRenderers\nC++: static vtkSynchronizedRenderers *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSynchronizedRenderers_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSynchronizedRenderers\nC++: vtkSynchronizedRenderers *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSynchronizedRenderers_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSynchronizedRenderers_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetRenderer", PyvtkSynchronizedRenderers_SetRenderer, METH_VARARGS,
   "SetRenderer(self, __a:vtkRenderer) -> None\nC++: virtual void SetRenderer(vtkRenderer *)\n\nSet the renderer to be synchronized by this instance. A\nvtkSynchronizedRenderers instance can be used to synchronize\nexactly 1 renderer on each processes. You can create multiple\ninstances on vtkSynchronizedRenderers to synchronize multiple\nrenderers.\n"},
  {"GetRenderer", PyvtkSynchronizedRenderers_GetRenderer, METH_VARARGS,
   "GetRenderer(self) -> vtkRenderer\nC++: virtual vtkRenderer *GetRenderer()\n\n"},
  {"SetParallelController", PyvtkSynchronizedRenderers_SetParallelController, METH_VARARGS,
   "SetParallelController(self, __a:vtkMultiProcessController) -> None\nC++: virtual void SetParallelController(\n    vtkMultiProcessController *)\n\nSet the parallel message communicator. This is used to\ncommunicate among processes.\n"},
  {"GetParallelController", PyvtkSynchronizedRenderers_GetParallelController, METH_VARARGS,
   "GetParallelController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetParallelController()\n\n"},
  {"SetParallelRendering", PyvtkSynchronizedRenderers_SetParallelRendering, METH_VARARGS,
   "SetParallelRendering(self, _arg:bool) -> None\nC++: virtual void SetParallelRendering(bool _arg)\n\nEnable/Disable parallel rendering. Unless Parallel rendering is\non, the cameras won't be synchronized across processes.\n"},
  {"GetParallelRendering", PyvtkSynchronizedRenderers_GetParallelRendering, METH_VARARGS,
   "GetParallelRendering(self) -> bool\nC++: virtual bool GetParallelRendering()\n\n"},
  {"ParallelRenderingOn", PyvtkSynchronizedRenderers_ParallelRenderingOn, METH_VARARGS,
   "ParallelRenderingOn(self) -> None\nC++: virtual void ParallelRenderingOn()\n\n"},
  {"ParallelRenderingOff", PyvtkSynchronizedRenderers_ParallelRenderingOff, METH_VARARGS,
   "ParallelRenderingOff(self) -> None\nC++: virtual void ParallelRenderingOff()\n\n"},
  {"SetImageReductionFactor", PyvtkSynchronizedRenderers_SetImageReductionFactor, METH_VARARGS,
   "SetImageReductionFactor(self, _arg:int) -> None\nC++: virtual void SetImageReductionFactor(int _arg)\n\nGet/Set the image reduction factor.\n"},
  {"GetImageReductionFactorMinValue", PyvtkSynchronizedRenderers_GetImageReductionFactorMinValue, METH_VARARGS,
   "GetImageReductionFactorMinValue(self) -> int\nC++: virtual int GetImageReductionFactorMinValue()\n\n"},
  {"GetImageReductionFactorMaxValue", PyvtkSynchronizedRenderers_GetImageReductionFactorMaxValue, METH_VARARGS,
   "GetImageReductionFactorMaxValue(self) -> int\nC++: virtual int GetImageReductionFactorMaxValue()\n\n"},
  {"GetImageReductionFactor", PyvtkSynchronizedRenderers_GetImageReductionFactor, METH_VARARGS,
   "GetImageReductionFactor(self) -> int\nC++: virtual int GetImageReductionFactor()\n\n"},
  {"SetWriteBackImages", PyvtkSynchronizedRenderers_SetWriteBackImages, METH_VARARGS,
   "SetWriteBackImages(self, _arg:bool) -> None\nC++: virtual void SetWriteBackImages(bool _arg)\n\nIf on (default), the rendered images are pasted back on to the\nscreen. You should turn this flag off on processes that are not\nmeant to be visible to the user.\n"},
  {"GetWriteBackImages", PyvtkSynchronizedRenderers_GetWriteBackImages, METH_VARARGS,
   "GetWriteBackImages(self) -> bool\nC++: virtual bool GetWriteBackImages()\n\n"},
  {"WriteBackImagesOn", PyvtkSynchronizedRenderers_WriteBackImagesOn, METH_VARARGS,
   "WriteBackImagesOn(self) -> None\nC++: virtual void WriteBackImagesOn()\n\n"},
  {"WriteBackImagesOff", PyvtkSynchronizedRenderers_WriteBackImagesOff, METH_VARARGS,
   "WriteBackImagesOff(self) -> None\nC++: virtual void WriteBackImagesOff()\n\n"},
  {"SetRootProcessId", PyvtkSynchronizedRenderers_SetRootProcessId, METH_VARARGS,
   "SetRootProcessId(self, _arg:int) -> None\nC++: virtual void SetRootProcessId(int _arg)\n\nGet/Set the root-process id. This is required when the\nParallelController is a vtkSocketController. Set to 0 by default\n(which will not work when using a vtkSocketController but will\nwork for vtkMPIController).\n"},
  {"GetRootProcessId", PyvtkSynchronizedRenderers_GetRootProcessId, METH_VARARGS,
   "GetRootProcessId(self) -> int\nC++: virtual int GetRootProcessId()\n\n"},
  {"CollectiveExpandForVisiblePropBounds", PyvtkSynchronizedRenderers_CollectiveExpandForVisiblePropBounds, METH_VARARGS,
   "CollectiveExpandForVisiblePropBounds(self, bounds:[float, float,\n    float, float, float, float]) -> None\nC++: void CollectiveExpandForVisiblePropBounds(double bounds[6])\n\nComputes visible prob bounds. This must be called on all\nprocesses at the same time. The collective result is made\navailable on all processes once this method returns. Note that\nthis method requires that bounds is initialized to some value.\nThis expands the bounds to include the prop bounds.\n"},
  {"SetCaptureDelegate", PyvtkSynchronizedRenderers_SetCaptureDelegate, METH_VARARGS,
   "SetCaptureDelegate(self, __a:vtkSynchronizedRenderers) -> None\nC++: virtual void SetCaptureDelegate(vtkSynchronizedRenderers *)\n\nWhen set, this->CaptureRenderedImage() does not capture image\nfrom the screen instead passes the call to the delegate.\n"},
  {"GetCaptureDelegate", PyvtkSynchronizedRenderers_GetCaptureDelegate, METH_VARARGS,
   "GetCaptureDelegate(self) -> vtkSynchronizedRenderers\nC++: virtual vtkSynchronizedRenderers *GetCaptureDelegate()\n\n"},
  {"EnableSynchronizableActors", PyvtkSynchronizedRenderers_EnableSynchronizableActors, METH_VARARGS,
   "EnableSynchronizableActors(self, __a:bool) -> None\nC++: void EnableSynchronizableActors(bool)\n\nAllows synchronizing collections of actors from local to remote\nrenderer.\n"},
  {"SetAutomaticEventHandling", PyvtkSynchronizedRenderers_SetAutomaticEventHandling, METH_VARARGS,
   "SetAutomaticEventHandling(self, _arg:bool) -> None\nC++: virtual void SetAutomaticEventHandling(bool _arg)\n\nWhen multiple groups of processes are synchronized together using\ndifferent controllers, one needs to specify the order in which\nthe various synchronizers execute. In such cases one starts with\nthe outer most vtkSynchronizedRenderers, sets the dependent one\nas a CaptureDelegate on it and the turn off\nAutomaticEventHandling on the delegate.\n"},
  {"GetAutomaticEventHandling", PyvtkSynchronizedRenderers_GetAutomaticEventHandling, METH_VARARGS,
   "GetAutomaticEventHandling(self) -> bool\nC++: virtual bool GetAutomaticEventHandling()\n\n"},
  {"AutomaticEventHandlingOn", PyvtkSynchronizedRenderers_AutomaticEventHandlingOn, METH_VARARGS,
   "AutomaticEventHandlingOn(self) -> None\nC++: virtual void AutomaticEventHandlingOn()\n\n"},
  {"AutomaticEventHandlingOff", PyvtkSynchronizedRenderers_AutomaticEventHandlingOff, METH_VARARGS,
   "AutomaticEventHandlingOff(self) -> None\nC++: virtual void AutomaticEventHandlingOff()\n\n"},
  {"SetFixBackground", PyvtkSynchronizedRenderers_SetFixBackground, METH_VARARGS,
   "SetFixBackground(self, _arg:bool) -> None\nC++: virtual void SetFixBackground(bool _arg)\n\nWhen doing rendering between multiple processes, it is often\neasier to have all ranks do the rendering on a black background.\nThis helps avoid issues where the background gets over blended as\nthe images are composted together. If  set to true (default is\nfalse), before the rendering begins, vtkSynchronizedRenderers\nwill change the renderer's background color and other flags to\nmake it render on a black background and then restore then on end\nrender. If WriteBackImages is true, then the background will\nindeed be restored before the write-back happens, thus ensuring\nthe result displayed to the user is on correct background.\n"},
  {"GetFixBackground", PyvtkSynchronizedRenderers_GetFixBackground, METH_VARARGS,
   "GetFixBackground(self) -> bool\nC++: virtual bool GetFixBackground()\n\n"},
  {"FixBackgroundOn", PyvtkSynchronizedRenderers_FixBackgroundOn, METH_VARARGS,
   "FixBackgroundOn(self) -> None\nC++: virtual void FixBackgroundOn()\n\n"},
  {"FixBackgroundOff", PyvtkSynchronizedRenderers_FixBackgroundOff, METH_VARARGS,
   "FixBackgroundOff(self) -> None\nC++: virtual void FixBackgroundOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSynchronizedRenderers_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("renderer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSynchronizedRenderers_GetRenderer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSynchronizedRenderers_SetRenderer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSynchronizedRenderers_SetRenderer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderer/SetRenderer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("parallel_controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSynchronizedRenderers_GetParallelController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSynchronizedRenderers_SetParallelController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSynchronizedRenderers_SetParallelController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetParallelController/SetParallelController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("parallel_rendering"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSynchronizedRenderers_GetParallelRendering(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSynchronizedRenderers_SetParallelRendering(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSynchronizedRenderers_SetParallelRendering(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetParallelRendering/SetParallelRendering\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_reduction_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSynchronizedRenderers_GetImageReductionFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSynchronizedRenderers_SetImageReductionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSynchronizedRenderers_SetImageReductionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImageReductionFactor/SetImageReductionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_back_images"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSynchronizedRenderers_GetWriteBackImages(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSynchronizedRenderers_SetWriteBackImages(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSynchronizedRenderers_SetWriteBackImages(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteBackImages/SetWriteBackImages\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("root_process_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSynchronizedRenderers_GetRootProcessId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSynchronizedRenderers_SetRootProcessId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSynchronizedRenderers_SetRootProcessId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRootProcessId/SetRootProcessId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("capture_delegate"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSynchronizedRenderers_GetCaptureDelegate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSynchronizedRenderers_SetCaptureDelegate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSynchronizedRenderers_SetCaptureDelegate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCaptureDelegate/SetCaptureDelegate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("automatic_event_handling"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSynchronizedRenderers_GetAutomaticEventHandling(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSynchronizedRenderers_SetAutomaticEventHandling(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSynchronizedRenderers_SetAutomaticEventHandling(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutomaticEventHandling/SetAutomaticEventHandling\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fix_background"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSynchronizedRenderers_GetFixBackground(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSynchronizedRenderers_SetFixBackground(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSynchronizedRenderers_SetFixBackground(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFixBackground/SetFixBackground\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSynchronizedRenderers_Doc =
  "vtkSynchronizedRenderers - synchronizes renderers across processes.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkSynchronizedRenderers is used to synchronize renderers\n"
  "(vtkRenderer and subclasses) across processes for parallel rendering.\n"
  "It's designed to be used in conjunction with\n"
  "vtkSynchronizedRenderWindows to synchronize the render windows among\n"
  "those processes. This class handles synchronization of certain render\n"
  "parameters among the renderers such as viewport, camera parameters.\n"
  "It doesn't support compositing of rendered images across processes on\n"
  "its own. You typically either subclass to implement a compositing\n"
  "algorithm or use a renderer capable of compositing eg. IceT based\n"
  "renderer.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSynchronizedRenderers_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingParallel.vtkSynchronizedRenderers", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSynchronizedRenderers_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSynchronizedRenderers_StaticNew()
{
  return vtkSynchronizedRenderers::New();
}

PyObject *PyvtkSynchronizedRenderers_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSynchronizedRenderers_Type, PyvtkSynchronizedRenderers_Methods,
    "vtkSynchronizedRenderers",
 &PyvtkSynchronizedRenderers_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 3; c++)
  {
    static const struct { const char *name; int value; }
      constants[3] = {
        { "SYNC_RENDERER_TAG", vtkSynchronizedRenderers::SYNC_RENDERER_TAG },
        { "RESET_CAMERA_TAG", vtkSynchronizedRenderers::RESET_CAMERA_TAG },
        { "COMPUTE_BOUNDS_TAG", vtkSynchronizedRenderers::COMPUTE_BOUNDS_TAG },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSynchronizedRenderers_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSynchronizedRenderers(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSynchronizedRenderers_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSynchronizedRenderers", o) != 0)
  {
    Py_DECREF(o);
  }

}

