// python wrapper for vtkSynchronizableAvatars
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSynchronizableAvatars.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSynchronizableAvatars(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSynchronizableAvatars_ClassNew(); }

#ifndef DECLARED_PyvtkSynchronizableActors_ClassNew
extern "C" { PyObject *PyvtkSynchronizableActors_ClassNew(); }
#define DECLARED_PyvtkSynchronizableActors_ClassNew
#endif

static PyObject *
PyvtkSynchronizableAvatars_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSynchronizableAvatars::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizableAvatars_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizableAvatars *op = static_cast<vtkSynchronizableAvatars *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSynchronizableAvatars::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizableAvatars_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSynchronizableAvatars *tempr = vtkSynchronizableAvatars::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizableAvatars_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizableAvatars *op = static_cast<vtkSynchronizableAvatars *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSynchronizableAvatars *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSynchronizableAvatars::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizableAvatars_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSynchronizableAvatars::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizableAvatars_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizableAvatars *op = static_cast<vtkSynchronizableAvatars *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSynchronizableAvatars::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizableAvatars_InitializeRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InitializeRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizableAvatars *op = static_cast<vtkSynchronizableAvatars *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->InitializeRenderer(temp0);
    }
    else
    {
      op->vtkSynchronizableAvatars::InitializeRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizableAvatars_CleanUpRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CleanUpRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizableAvatars *op = static_cast<vtkSynchronizableAvatars *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->CleanUpRenderer(temp0);
    }
    else
    {
      op->vtkSynchronizableAvatars::CleanUpRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizableAvatars_SaveToStream(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SaveToStream");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizableAvatars *op = static_cast<vtkSynchronizableAvatars *>(vp);

  vtkMultiProcessStream *temp0 = nullptr;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, "vtkMultiProcessStream") &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->SaveToStream(*temp0, temp1);
    }
    else
    {
      op->vtkSynchronizableAvatars::SaveToStream(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSynchronizableAvatars_RestoreFromStream(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RestoreFromStream");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSynchronizableAvatars *op = static_cast<vtkSynchronizableAvatars *>(vp);

  vtkMultiProcessStream *temp0 = nullptr;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, "vtkMultiProcessStream") &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->RestoreFromStream(*temp0, temp1);
    }
    else
    {
      op->vtkSynchronizableAvatars::RestoreFromStream(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSynchronizableAvatars_Methods[] = {
  {"IsTypeOf", PyvtkSynchronizableAvatars_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSynchronizableAvatars_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSynchronizableAvatars_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSynchronizableAvatars\nC++: static vtkSynchronizableAvatars *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSynchronizableAvatars_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSynchronizableAvatars\nC++: vtkSynchronizableAvatars *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSynchronizableAvatars_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSynchronizableAvatars_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"InitializeRenderer", PyvtkSynchronizableAvatars_InitializeRenderer, METH_VARARGS,
   "InitializeRenderer(self, ren:vtkRenderer) -> None\nC++: void InitializeRenderer(vtkRenderer *ren) override;\n\nIn immersive environments like CAVE, all actors must be visible,\nso this method removes cullers from the renderer.\n"},
  {"CleanUpRenderer", PyvtkSynchronizableAvatars_CleanUpRenderer, METH_VARARGS,
   "CleanUpRenderer(self, ren:vtkRenderer) -> None\nC++: void CleanUpRenderer(vtkRenderer *ren) override;\n\nRemoves any OpenGLAvatar instances from the renderer.\n"},
  {"SaveToStream", PyvtkSynchronizableAvatars_SaveToStream, METH_VARARGS,
   "SaveToStream(self, stream:vtkMultiProcessStream, ren:vtkRenderer)\n    -> None\nC++: void SaveToStream(vtkMultiProcessStream &stream,\n    vtkRenderer *ren) override;\n\nSave to the stream any vtkOpenGLAvatar instances added to the\nrenderer.\n"},
  {"RestoreFromStream", PyvtkSynchronizableAvatars_RestoreFromStream, METH_VARARGS,
   "RestoreFromStream(self, stream:vtkMultiProcessStream,\n    ren:vtkRenderer) -> None\nC++: void RestoreFromStream(vtkMultiProcessStream &stream,\n    vtkRenderer *ren) override;\n\nRestore from the stream a collection of vtkOpenGLAvatars and\nupdate the renderer.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSynchronizableAvatars_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSynchronizableAvatars_Doc =
  "vtkSynchronizableAvatars - Serialize/deserialize collection of\nvtkOpenGLAvatars among renderers\n\n"
  "Superclass: vtkSynchronizableActors\n\n"
  "vtkSynchronizableAvatars is a specialization of vtkSerializableActors\n"
  "for synchronizing a collection of vtkOpenGLAvatars among a group of\n"
  "cooperative renderers.\n\n"
  "@sa\n"
  "vtkSynchronizedRenderers\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSynchronizableAvatars_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingParallel.vtkSynchronizableAvatars", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSynchronizableAvatars_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSynchronizableAvatars_StaticNew()
{
  return vtkSynchronizableAvatars::New();
}

PyObject *PyvtkSynchronizableAvatars_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSynchronizableAvatars_Type, PyvtkSynchronizableAvatars_Methods,
    "vtkSynchronizableAvatars",
 &PyvtkSynchronizableAvatars_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSynchronizableActors_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSynchronizableAvatars_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSynchronizableAvatars(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSynchronizableAvatars_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSynchronizableAvatars", o) != 0)
  {
    Py_DECREF(o);
  }

}

