// python wrapper for vtkAnariVolumeMapperNode
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkAnariVolumeMapperNode.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAnariVolumeMapperNode(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAnariVolumeMapperNode_ClassNew(); }


static PyObject *
PyvtkAnariVolumeMapperNode_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAnariVolumeMapperNode::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariVolumeMapperNode *op = static_cast<vtkAnariVolumeMapperNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAnariVolumeMapperNode::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAnariVolumeMapperNode *tempr = vtkAnariVolumeMapperNode::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariVolumeMapperNode *op = static_cast<vtkAnariVolumeMapperNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAnariVolumeMapperNode *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAnariVolumeMapperNode::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAnariVolumeMapperNode::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariVolumeMapperNode *op = static_cast<vtkAnariVolumeMapperNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAnariVolumeMapperNode::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_SetColorSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColorSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariVolumeMapperNode *op = static_cast<vtkAnariVolumeMapperNode *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetColorSize(temp0);
    }
    else
    {
      op->vtkAnariVolumeMapperNode::SetColorSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_GetColorSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColorSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariVolumeMapperNode *op = static_cast<vtkAnariVolumeMapperNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetColorSize() :
      op->vtkAnariVolumeMapperNode::GetColorSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_SetOpacitySize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOpacitySize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariVolumeMapperNode *op = static_cast<vtkAnariVolumeMapperNode *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOpacitySize(temp0);
    }
    else
    {
      op->vtkAnariVolumeMapperNode::SetOpacitySize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_GetOpacitySize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOpacitySize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariVolumeMapperNode *op = static_cast<vtkAnariVolumeMapperNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetOpacitySize() :
      op->vtkAnariVolumeMapperNode::GetOpacitySize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_Synchronize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Synchronize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariVolumeMapperNode *op = static_cast<vtkAnariVolumeMapperNode *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Synchronize(temp0);
    }
    else
    {
      op->vtkAnariVolumeMapperNode::Synchronize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariVolumeMapperNode_Render(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Render");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariVolumeMapperNode *op = static_cast<vtkAnariVolumeMapperNode *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Render(temp0);
    }
    else
    {
      op->vtkAnariVolumeMapperNode::Render(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkAnariVolumeMapperNode_Methods[] = {
  {"IsTypeOf", PyvtkAnariVolumeMapperNode_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAnariVolumeMapperNode_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAnariVolumeMapperNode_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAnariVolumeMapperNode\nC++: static vtkAnariVolumeMapperNode *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAnariVolumeMapperNode_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAnariVolumeMapperNode\nC++: vtkAnariVolumeMapperNode *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAnariVolumeMapperNode_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAnariVolumeMapperNode_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetColorSize", PyvtkAnariVolumeMapperNode_SetColorSize, METH_VARARGS,
   "SetColorSize(self, _arg:int) -> None\nC++: virtual void SetColorSize(int _arg)\n\nConvenience method to set/get color array size.\n"},
  {"GetColorSize", PyvtkAnariVolumeMapperNode_GetColorSize, METH_VARARGS,
   "GetColorSize(self) -> int\nC++: virtual int GetColorSize()\n\nConvenience method to set/get color array size.\n"},
  {"SetOpacitySize", PyvtkAnariVolumeMapperNode_SetOpacitySize, METH_VARARGS,
   "SetOpacitySize(self, _arg:int) -> None\nC++: virtual void SetOpacitySize(int _arg)\n\nConvenience method to set/get opacity array size.\n"},
  {"GetOpacitySize", PyvtkAnariVolumeMapperNode_GetOpacitySize, METH_VARARGS,
   "GetOpacitySize(self) -> int\nC++: virtual int GetOpacitySize()\n\nConvenience method to set/get opacity array size.\n"},
  {"Synchronize", PyvtkAnariVolumeMapperNode_Synchronize, METH_VARARGS,
   "Synchronize(self, prepass:bool) -> None\nC++: void Synchronize(bool prepass) override;\n\nSynchronize VTK and ANARI Objects\n"},
  {"Render", PyvtkAnariVolumeMapperNode_Render, METH_VARARGS,
   "Render(self, prepass:bool) -> None\nC++: void Render(bool prepass) override;\n\nAdd volume to ANARI world.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAnariVolumeMapperNode_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("color_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAnariVolumeMapperNode_GetColorSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAnariVolumeMapperNode_SetColorSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAnariVolumeMapperNode_SetColorSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetColorSize/SetColorSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("opacity_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAnariVolumeMapperNode_GetOpacitySize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAnariVolumeMapperNode_SetOpacitySize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAnariVolumeMapperNode_SetOpacitySize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOpacitySize/SetOpacitySize\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAnariVolumeMapperNode_Doc =
  "vtkAnariVolumeMapperNode - links vtkVolumeMapper  to ANARI\n\n"
  "Superclass: vtkVolumeMapperNode\n\n"
  "Translates vtkVolumeMapper state into ANARI rendering calls\n\n"
  "@par Thanks: Kevin Griffin kgriffin\n\n"
  "vidia.com for creating and contributing the class and NVIDIA for\n"
  "supporting this work.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAnariVolumeMapperNode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingAnari.vtkAnariVolumeMapperNode", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAnariVolumeMapperNode_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAnariVolumeMapperNode_StaticNew()
{
  return vtkAnariVolumeMapperNode::New();
}

PyObject *PyvtkAnariVolumeMapperNode_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAnariVolumeMapperNode_Type, PyvtkAnariVolumeMapperNode_Methods,
    "vtkAnariVolumeMapperNode",
 &PyvtkAnariVolumeMapperNode_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkVolumeMapperNode");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAnariVolumeMapperNode_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAnariVolumeMapperNode(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAnariVolumeMapperNode_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAnariVolumeMapperNode", o) != 0)
  {
    Py_DECREF(o);
  }

}

