// python wrapper for vtkNativePartitioningStrategy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkNativePartitioningStrategy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkNativePartitioningStrategy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkNativePartitioningStrategy_ClassNew(); }

#ifndef DECLARED_PyvtkPartitioningStrategy_ClassNew
extern "C" { PyObject *PyvtkPartitioningStrategy_ClassNew(); }
#define DECLARED_PyvtkPartitioningStrategy_ClassNew
#endif

static PyObject *
PyvtkNativePartitioningStrategy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkNativePartitioningStrategy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkNativePartitioningStrategy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkNativePartitioningStrategy *tempr = vtkNativePartitioningStrategy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkNativePartitioningStrategy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkNativePartitioningStrategy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkNativePartitioningStrategy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkNativePartitioningStrategy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_SetUseExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseExplicitCuts(temp0);
    }
    else
    {
      op->vtkNativePartitioningStrategy::SetUseExplicitCuts(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_GetUseExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseExplicitCuts() :
      op->vtkNativePartitioningStrategy::GetUseExplicitCuts());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_UseExplicitCutsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseExplicitCutsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseExplicitCutsOn();
    }
    else
    {
      op->vtkNativePartitioningStrategy::UseExplicitCutsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_UseExplicitCutsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseExplicitCutsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseExplicitCutsOff();
    }
    else
    {
      op->vtkNativePartitioningStrategy::UseExplicitCutsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_RemoveAllExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllExplicitCuts();
    }
    else
    {
      op->vtkNativePartitioningStrategy::RemoveAllExplicitCuts();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_AddExplicitCut_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddExplicitCut");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  vtkBoundingBox *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkBoundingBox"))
  {
    if (ap.IsBound())
    {
      op->AddExplicitCut(*temp0);
    }
    else
    {
      op->vtkNativePartitioningStrategy::AddExplicitCut(*temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkNativePartitioningStrategy_AddExplicitCut_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddExplicitCut");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->AddExplicitCut(temp0);
    }
    else
    {
      op->vtkNativePartitioningStrategy::AddExplicitCut(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkNativePartitioningStrategy_AddExplicitCut_Methods[] = {
  {"AddExplicitCut", PyvtkNativePartitioningStrategy_AddExplicitCut_s1, METH_VARARGS,
   "@W vtkBoundingBox"},
  {"AddExplicitCut", PyvtkNativePartitioningStrategy_AddExplicitCut_s2, METH_VARARGS,
   "@P *d"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkNativePartitioningStrategy_AddExplicitCut(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkNativePartitioningStrategy_AddExplicitCut_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "AddExplicitCut");
  return nullptr;
}


static PyObject *
PyvtkNativePartitioningStrategy_GetNumberOfExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfExplicitCuts() :
      op->vtkNativePartitioningStrategy::GetNumberOfExplicitCuts());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_GetExplicitCut(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExplicitCut");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const vtkBoundingBox *tempr = (ap.IsBound() ?
      &op->GetExplicitCut(temp0) :
      &op->vtkNativePartitioningStrategy::GetExplicitCut(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(tempr, "vtkBoundingBox");
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_SetExpandExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExpandExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExpandExplicitCuts(temp0);
    }
    else
    {
      op->vtkNativePartitioningStrategy::SetExpandExplicitCuts(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_GetExpandExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExpandExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExpandExplicitCuts() :
      op->vtkNativePartitioningStrategy::GetExpandExplicitCuts());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_ExpandExplicitCutsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExpandExplicitCutsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExpandExplicitCutsOn();
    }
    else
    {
      op->vtkNativePartitioningStrategy::ExpandExplicitCutsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_ExpandExplicitCutsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExpandExplicitCutsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExpandExplicitCutsOff();
    }
    else
    {
      op->vtkNativePartitioningStrategy::ExpandExplicitCutsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_SetLoadBalanceAcrossAllBlocks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLoadBalanceAcrossAllBlocks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLoadBalanceAcrossAllBlocks(temp0);
    }
    else
    {
      op->vtkNativePartitioningStrategy::SetLoadBalanceAcrossAllBlocks(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_GetLoadBalanceAcrossAllBlocks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLoadBalanceAcrossAllBlocks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLoadBalanceAcrossAllBlocks() :
      op->vtkNativePartitioningStrategy::GetLoadBalanceAcrossAllBlocks());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_LoadBalanceAcrossAllBlocksOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadBalanceAcrossAllBlocksOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadBalanceAcrossAllBlocksOn();
    }
    else
    {
      op->vtkNativePartitioningStrategy::LoadBalanceAcrossAllBlocksOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkNativePartitioningStrategy_LoadBalanceAcrossAllBlocksOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadBalanceAcrossAllBlocksOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkNativePartitioningStrategy *op = static_cast<vtkNativePartitioningStrategy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadBalanceAcrossAllBlocksOff();
    }
    else
    {
      op->vtkNativePartitioningStrategy::LoadBalanceAcrossAllBlocksOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkNativePartitioningStrategy_Methods[] = {
  {"IsTypeOf", PyvtkNativePartitioningStrategy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkNativePartitioningStrategy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkNativePartitioningStrategy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkNativePartitioningStrategy\nC++: static vtkNativePartitioningStrategy *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkNativePartitioningStrategy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkNativePartitioningStrategy\nC++: vtkNativePartitioningStrategy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkNativePartitioningStrategy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkNativePartitioningStrategy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetUseExplicitCuts", PyvtkNativePartitioningStrategy_SetUseExplicitCuts, METH_VARARGS,
   "SetUseExplicitCuts(self, _arg:bool) -> None\nC++: virtual void SetUseExplicitCuts(bool _arg)\n\nSpecify whether to compute the load balancing automatically or\nuse explicitly provided cuts. Set to false (default) to\nautomatically compute the cuts to use for redistributing the\ndataset.\n"},
  {"GetUseExplicitCuts", PyvtkNativePartitioningStrategy_GetUseExplicitCuts, METH_VARARGS,
   "GetUseExplicitCuts(self) -> bool\nC++: virtual bool GetUseExplicitCuts()\n\n"},
  {"UseExplicitCutsOn", PyvtkNativePartitioningStrategy_UseExplicitCutsOn, METH_VARARGS,
   "UseExplicitCutsOn(self) -> None\nC++: virtual void UseExplicitCutsOn()\n\n"},
  {"UseExplicitCutsOff", PyvtkNativePartitioningStrategy_UseExplicitCutsOff, METH_VARARGS,
   "UseExplicitCutsOff(self) -> None\nC++: virtual void UseExplicitCutsOff()\n\n"},
  {"RemoveAllExplicitCuts", PyvtkNativePartitioningStrategy_RemoveAllExplicitCuts, METH_VARARGS,
   "RemoveAllExplicitCuts(self) -> None\nC++: void RemoveAllExplicitCuts()\n\n"},
  {"AddExplicitCut", PyvtkNativePartitioningStrategy_AddExplicitCut, METH_VARARGS,
   "AddExplicitCut(self, bbox:vtkBoundingBox) -> None\nC++: void AddExplicitCut(const vtkBoundingBox &bbox)\nAddExplicitCut(self, bbox:(float, float, float, float, float,\n    float)) -> None\nC++: void AddExplicitCut(const double bbox[6])\n\n"},
  {"GetNumberOfExplicitCuts", PyvtkNativePartitioningStrategy_GetNumberOfExplicitCuts, METH_VARARGS,
   "GetNumberOfExplicitCuts(self) -> int\nC++: int GetNumberOfExplicitCuts()\n\n"},
  {"GetExplicitCut", PyvtkNativePartitioningStrategy_GetExplicitCut, METH_VARARGS,
   "GetExplicitCut(self, index:int) -> vtkBoundingBox\nC++: const vtkBoundingBox &GetExplicitCut(int index)\n\n"},
  {"SetExpandExplicitCuts", PyvtkNativePartitioningStrategy_SetExpandExplicitCuts, METH_VARARGS,
   "SetExpandExplicitCuts(self, _arg:bool) -> None\nC++: virtual void SetExpandExplicitCuts(bool _arg)\n\nWhen using explicit cuts, it possible that the bounding box\ndefined by all the cuts is smaller than the input's bounds. In\nthat case, the filter can automatically expand the edge boxes to\ninclude the input bounds to avoid clipping of the input dataset\non the external faces of the combined bounding box.\n\nDefault is true, that is explicit cuts will automatically be\nexpanded.\n"},
  {"GetExpandExplicitCuts", PyvtkNativePartitioningStrategy_GetExpandExplicitCuts, METH_VARARGS,
   "GetExpandExplicitCuts(self) -> bool\nC++: virtual bool GetExpandExplicitCuts()\n\n"},
  {"ExpandExplicitCutsOn", PyvtkNativePartitioningStrategy_ExpandExplicitCutsOn, METH_VARARGS,
   "ExpandExplicitCutsOn(self) -> None\nC++: virtual void ExpandExplicitCutsOn()\n\n"},
  {"ExpandExplicitCutsOff", PyvtkNativePartitioningStrategy_ExpandExplicitCutsOff, METH_VARARGS,
   "ExpandExplicitCutsOff(self) -> None\nC++: virtual void ExpandExplicitCutsOff()\n\n"},
  {"SetLoadBalanceAcrossAllBlocks", PyvtkNativePartitioningStrategy_SetLoadBalanceAcrossAllBlocks, METH_VARARGS,
   "SetLoadBalanceAcrossAllBlocks(self, _arg:bool) -> None\nC++: virtual void SetLoadBalanceAcrossAllBlocks(bool _arg)\n\nWhen UseExplicitCuts is false, and input is a\n`vtkPartitionedDataSetCollection`, set this to true to generate\ncuts for load balancing using all the datasets in the\nvtkPartitionedDataSetCollection.\n\nDefault is true.\n"},
  {"GetLoadBalanceAcrossAllBlocks", PyvtkNativePartitioningStrategy_GetLoadBalanceAcrossAllBlocks, METH_VARARGS,
   "GetLoadBalanceAcrossAllBlocks(self) -> bool\nC++: virtual bool GetLoadBalanceAcrossAllBlocks()\n\n"},
  {"LoadBalanceAcrossAllBlocksOn", PyvtkNativePartitioningStrategy_LoadBalanceAcrossAllBlocksOn, METH_VARARGS,
   "LoadBalanceAcrossAllBlocksOn(self) -> None\nC++: virtual void LoadBalanceAcrossAllBlocksOn()\n\n"},
  {"LoadBalanceAcrossAllBlocksOff", PyvtkNativePartitioningStrategy_LoadBalanceAcrossAllBlocksOff, METH_VARARGS,
   "LoadBalanceAcrossAllBlocksOff(self) -> None\nC++: virtual void LoadBalanceAcrossAllBlocksOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkNativePartitioningStrategy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("use_explicit_cuts"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkNativePartitioningStrategy_GetUseExplicitCuts(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkNativePartitioningStrategy_SetUseExplicitCuts(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkNativePartitioningStrategy_SetUseExplicitCuts(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseExplicitCuts/SetUseExplicitCuts\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("expand_explicit_cuts"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkNativePartitioningStrategy_GetExpandExplicitCuts(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkNativePartitioningStrategy_SetExpandExplicitCuts(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkNativePartitioningStrategy_SetExpandExplicitCuts(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExpandExplicitCuts/SetExpandExplicitCuts\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("load_balance_across_all_blocks"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkNativePartitioningStrategy_GetLoadBalanceAcrossAllBlocks(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkNativePartitioningStrategy_SetLoadBalanceAcrossAllBlocks(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkNativePartitioningStrategy_SetLoadBalanceAcrossAllBlocks(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLoadBalanceAcrossAllBlocks/SetLoadBalanceAcrossAllBlocks\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkNativePartitioningStrategy_Doc =
  "vtkNativePartitioningStrategy - A partitioning strategy based on load\nbalancing geometric bounding boxes as cuts of a data set\n\n"
  "Superclass: vtkPartitioningStrategy\n\n"
  "This strategy is the traditional strategy used in the\n"
  "vtkRedistributeDataSetFilter which has been refactored into this\n"
  "class. It is based on cuting up the data set into equally balanced\n"
  "(in terms of cell number) bounding boxes that then get distributed to\n"
  "all ranks.\n\n"
  "The load balancing attempts to balance the number of cells per target\n"
  "partition approximately. It uses a DIY-based kdtree implementation\n"
  "that balances the cell centers among requested number of partitions.\n"
  "Current implementation only supports power-of-2 target partition. If\n"
  "a non-power of two value is specified for `NumberOfPartitions`, then\n"
  "the load balancing simply uses the power-of-two greater than the\n"
  "requested value. The bounding boxes for the kdtree leaf nodes are\n"
  "then used to redistribute the data.\n\n"
  "Alternatively a collection of bounding boxes may be provided that can\n"
  "be used to distribute the data instead of computing them (see\n"
  "`UseExplicitCuts` and `SetExplicitCuts`). When explicit cuts are\n"
  "specified, it is possible use those cuts strictly or to expand boxes\n"
  "on the edge to fit the domain of the input dataset. This can be\n"
  "controlled by `ExpandExplicitCutsForInputDomain`.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkNativePartitioningStrategy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkFiltersParallelDIY2.vtkNativePartitioningStrategy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkNativePartitioningStrategy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkNativePartitioningStrategy_StaticNew()
{
  return vtkNativePartitioningStrategy::New();
}

PyObject *PyvtkNativePartitioningStrategy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkNativePartitioningStrategy_Type, PyvtkNativePartitioningStrategy_Methods,
    "vtkNativePartitioningStrategy",
 &PyvtkNativePartitioningStrategy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPartitioningStrategy_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkNativePartitioningStrategy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkNativePartitioningStrategy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkNativePartitioningStrategy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkNativePartitioningStrategy", o) != 0)
  {
    Py_DECREF(o);
  }

}

