// python wrapper for vtkmPointElevation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkmPointElevation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkmPointElevation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkmPointElevation_ClassNew(); }


static PyObject *
PyvtkmPointElevation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkmPointElevation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkmPointElevation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkmPointElevation *op = static_cast<vtkmPointElevation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkmPointElevation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkmPointElevation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkmPointElevation *tempr = vtkmPointElevation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkmPointElevation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkmPointElevation *op = static_cast<vtkmPointElevation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkmPointElevation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkmPointElevation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkmPointElevation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkmPointElevation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkmPointElevation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkmPointElevation *op = static_cast<vtkmPointElevation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkmPointElevation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkmPointElevation_GetForceVTKm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceVTKm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkmPointElevation *op = static_cast<vtkmPointElevation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetForceVTKm() :
      op->vtkmPointElevation::GetForceVTKm());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkmPointElevation_SetForceVTKm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceVTKm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkmPointElevation *op = static_cast<vtkmPointElevation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceVTKm(temp0);
    }
    else
    {
      op->vtkmPointElevation::SetForceVTKm(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkmPointElevation_ForceVTKmOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ForceVTKmOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkmPointElevation *op = static_cast<vtkmPointElevation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ForceVTKmOn();
    }
    else
    {
      op->vtkmPointElevation::ForceVTKmOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkmPointElevation_ForceVTKmOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ForceVTKmOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkmPointElevation *op = static_cast<vtkmPointElevation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ForceVTKmOff();
    }
    else
    {
      op->vtkmPointElevation::ForceVTKmOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkmPointElevation_Methods[] = {
  {"IsTypeOf", PyvtkmPointElevation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkmPointElevation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkmPointElevation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkmPointElevation\nC++: static vtkmPointElevation *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkmPointElevation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkmPointElevation\nC++: vtkmPointElevation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkmPointElevation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkmPointElevation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetForceVTKm", PyvtkmPointElevation_GetForceVTKm, METH_VARARGS,
   "GetForceVTKm(self) -> int\nC++: virtual vtkTypeBool GetForceVTKm()\n\nWhen this flag is off (the default), then the computation will\nfall back to the serial VTK version if Viskores fails to run.\nWhen the flag is on, the filter will generate an error if\nViskores fails to run. This is mostly useful in testing to make\nsure the expected algorithm is run.\n"},
  {"SetForceVTKm", PyvtkmPointElevation_SetForceVTKm, METH_VARARGS,
   "SetForceVTKm(self, _arg:int) -> None\nC++: virtual void SetForceVTKm(vtkTypeBool _arg)\n\n"},
  {"ForceVTKmOn", PyvtkmPointElevation_ForceVTKmOn, METH_VARARGS,
   "ForceVTKmOn(self) -> None\nC++: virtual void ForceVTKmOn()\n\n"},
  {"ForceVTKmOff", PyvtkmPointElevation_ForceVTKmOff, METH_VARARGS,
   "ForceVTKmOff(self) -> None\nC++: virtual void ForceVTKmOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkmPointElevation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_vt_km"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkmPointElevation_GetForceVTKm(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkmPointElevation_SetForceVTKm(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkmPointElevation_SetForceVTKm(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceVTKm/SetForceVTKm\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkmPointElevation_Doc =
  "vtkmPointElevation - generate a scalar field along a specified\ndirection\n\n"
  "Superclass: vtkElevationFilter\n\n"
  "vtkmPointElevation is a filter that generates a scalar field along a\n"
  "specified direction. The scalar field values lie within a user\n"
  "specified range, and are generated by computing a projection of each\n"
  "dataset point onto a line. The line can be oriented arbitrarily. A\n"
  "typical example is to generate scalars based on elevation or height\n"
  "above a plane.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkmPointElevation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkAcceleratorsVTKmFilters.vtkmPointElevation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkmPointElevation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkmPointElevation_StaticNew()
{
  return vtkmPointElevation::New();
}

PyObject *PyvtkmPointElevation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkmPointElevation_Type, PyvtkmPointElevation_Methods,
    "vtkmPointElevation",
 &PyvtkmPointElevation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkElevationFilter");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkmPointElevation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkmPointElevation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkmPointElevation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkmPointElevation", o) != 0)
  {
    Py_DECREF(o);
  }

}

