//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// wrapRange.template.cpp file to make changes.

#include "pxr/pxr.h"
#include "pxr/base/gf/range1d.h"
#include "pxr/base/gf/range1f.h"

#include "pxr/base/tf/hash.h"
#include "pxr/base/tf/pyUtils.h"
#include "pxr/base/tf/wrapTypeHelpers.h"
#include "pxr/base/tf/pyContainerConversions.h"

#include "pxr/external/boost/python/class.hpp"
#include "pxr/external/boost/python/copy_const_reference.hpp"
#include "pxr/external/boost/python/operators.hpp"
#include "pxr/external/boost/python/return_arg.hpp"

#include <string>

using std::string;

PXR_NAMESPACE_USING_DIRECTIVE

using namespace pxr_boost::python;

namespace {

static const int _dimension = 1;

static string _Repr(GfRange1d const &self) {
    return TF_PY_REPR_PREFIX + "Range1d(" +
        TfPyRepr(self.GetMin()) + ", " + TfPyRepr(self.GetMax()) + ")";
}

static GfRange1d __truediv__(const GfRange1d &self, double value)
{
    return self / value;
}

static GfRange1d& __itruediv__(GfRange1d &self, double value)
{
    return self /= value;
}

static size_t __hash__(GfRange1d const &r) { return TfHash{}(r); }

} // anonymous namespace 

void wrapRange1d()
{    
    object getMin = make_function(&GfRange1d::GetMin,
                                  return_value_policy<return_by_value>());

    object getMax = make_function(&GfRange1d::GetMax,
                                  return_value_policy<return_by_value>());

    class_<GfRange1d> cls("Range1d", init<>());
    cls
        .def(init<GfRange1d>())
        .def(init<double , double >())

        .def(init<GfRange1f>())
        
        .def(TfTypePythonClass())

        .def_readonly("dimension", _dimension)
        
        .add_property("min", getMin, &GfRange1d::SetMin)
        .add_property("max", getMax, &GfRange1d::SetMax)

        .def("GetMin", getMin)
        .def("GetMax", getMax)

        .def("GetSize", &GfRange1d::GetSize)
        .def("GetMidpoint", &GfRange1d::GetMidpoint)
    
        .def("SetMin", &GfRange1d::SetMin)
        .def("SetMax", &GfRange1d::SetMax)
    
        .def("IsEmpty", &GfRange1d::IsEmpty)
    
        .def("SetEmpty", &GfRange1d::SetEmpty)

        .def("Contains", (bool (GfRange1d::*)(double ) const)
             &GfRange1d::Contains)
        .def("Contains", (bool (GfRange1d::*)(const GfRange1d &) const)
             &GfRange1d::Contains)
    
        .def("GetUnion", &GfRange1d::GetUnion)
        .staticmethod("GetUnion")
    
        .def("UnionWith", (const GfRange1d & (GfRange1d::*)(double ))
             &GfRange1d::UnionWith, return_self<>())
        .def("UnionWith", (const GfRange1d & (GfRange1d::*)(const GfRange1d &))
             &GfRange1d::UnionWith, return_self<>())
    
        .def("GetIntersection", &GfRange1d::GetIntersection)
        .staticmethod("GetIntersection")
    
        .def("IntersectWith", (const GfRange1d & (GfRange1d::*)(const GfRange1d &))
             &GfRange1d::IntersectWith, return_self<>())
    
        .def("GetDistanceSquared", &GfRange1d::GetDistanceSquared)
    
        .def(str(self))
        .def(self += self)
        .def(self -= self)
        .def(self *= double())
        .def(self /= double())
        .def(self + self)
        .def(self - self)
        .def(double() * self)
        .def(self * double())
        .def(self / double())
        .def(self == GfRange1f())
        .def(self != GfRange1f())
        .def(self == self)
        .def(self != self)
        .def("__repr__", _Repr)
        .def("__hash__", __hash__)

        
        ;
    to_python_converter<std::vector<GfRange1d>,
        TfPySequenceToPython<std::vector<GfRange1d> > >();

    if (!PyObject_HasAttrString(cls.ptr(), "__truediv__")) {
        // __truediv__ not added by .def( self / double() ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division"
        cls.def("__truediv__", __truediv__);
    }
    if (!PyObject_HasAttrString(cls.ptr(), "__itruediv__")) {
        // __itruediv__ not added by .def( self /= double() ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division". This is also a workaround for a 
        // bug in the current version of pxr_boost::python that incorrectly wraps
        // in-place division with __idiv__ when building with python 3.
        cls.def("__itruediv__", __itruediv__, return_self<>());
    }

}
