/* AppExcludeEntry.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppExcludeEntry.vala, do not modify */

/*
 * AppExcludeEntry.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;
typedef struct _AppExcludeEntryPrivate AppExcludeEntryPrivate;
enum  {
	APP_EXCLUDE_ENTRY_0_PROPERTY,
	APP_EXCLUDE_ENTRY_NUM_PROPERTIES
};
static GParamSpec* app_exclude_entry_properties[APP_EXCLUDE_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _AppExcludeEntry {
	GObject parent_instance;
	AppExcludeEntryPrivate * priv;
	gchar* name;
	gboolean is_include;
	gboolean is_file;
	gboolean enabled;
	GeeArrayList* items;
	GeeArrayList* patterns;
};

struct _AppExcludeEntryClass {
	GObjectClass parent_class;
};

static gpointer app_exclude_entry_parent_class = NULL;
VALA_EXTERN GeeHashMap* app_exclude_entry_app_map;
GeeHashMap* app_exclude_entry_app_map = NULL;

VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN AppExcludeEntry* app_exclude_entry_new (const gchar* _name,
                                        gboolean _is_include);
VALA_EXTERN AppExcludeEntry* app_exclude_entry_construct (GType object_type,
                                              const gchar* _name,
                                              gboolean _is_include);
VALA_EXTERN gchar* app_exclude_entry_tooltip_text (AppExcludeEntry* self);
VALA_EXTERN void app_exclude_entry_clear (void);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN void app_exclude_entry_add_app_exclude_entries_from_home (const gchar* home);
VALA_EXTERN void app_exclude_entry_add_app_exclude_entries_from_path (const gchar* user_home);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void app_exclude_entry_add_item (const gchar* item_path,
                                 gboolean is_file,
                                 gboolean is_include);
VALA_EXTERN gboolean tee_jee_file_system_dir_exists (const gchar* dir_path);
VALA_EXTERN gchar* tee_jee_file_system_file_basename (const gchar* file_path);
VALA_EXTERN GeeArrayList* app_exclude_entry_get_apps_list (GeeArrayList* selected_app_names);
static gint __lambda7_ (AppExcludeEntry* a,
                 AppExcludeEntry* b);
static gint ___lambda7__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void app_exclude_entry_finalize (GObject * obj);
static GType app_exclude_entry_get_type_once (void);

AppExcludeEntry*
app_exclude_entry_construct (GType object_type,
                             const gchar* _name,
                             gboolean _is_include)
{
	AppExcludeEntry * self = NULL;
	gchar* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_val_if_fail (_name != NULL, NULL);
	self = (AppExcludeEntry*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (_name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	self->is_include = _is_include;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->items);
	self->items = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->patterns);
	self->patterns = _tmp2_;
	return self;
}

AppExcludeEntry*
app_exclude_entry_new (const gchar* _name,
                       gboolean _is_include)
{
	return app_exclude_entry_construct (TYPE_APP_EXCLUDE_ENTRY, _name, _is_include);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
app_exclude_entry_tooltip_text (AppExcludeEntry* self)
{
	gchar* txt = NULL;
	gchar* _tmp0_;
	const gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	txt = _tmp0_;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp1_;
		gint _item_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _item_index = 0;
		_tmp1_ = self->items;
		_item_list = _tmp1_;
		_tmp2_ = _item_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_item_size = _tmp4_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* item = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_item_index = _item_index + 1;
			_tmp5_ = _item_index;
			_tmp6_ = _item_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _item_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _item_index);
			item = (gchar*) _tmp8_;
			_tmp9_ = txt;
			_tmp10_ = item;
			_tmp11_ = g_strdup_printf ("%s\n", _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
			_g_free0 (txt);
			txt = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (item);
		}
	}
	_tmp14_ = txt;
	if (g_str_has_suffix (_tmp14_, "\n")) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
		_tmp15_ = txt;
		_tmp16_ = txt;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_slice (_tmp15_, (glong) 0, (glong) (_tmp18_ - 1));
		_g_free0 (txt);
		txt = _tmp19_;
	}
	result = txt;
	return result;
}

void
app_exclude_entry_clear (void)
{
	GeeHashMap* _tmp0_;
	tee_jee_logging_log_debug ("AppExcludeEntry: clear()");
	_tmp0_ = app_exclude_entry_app_map;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_APP_EXCLUDE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (app_exclude_entry_app_map);
		app_exclude_entry_app_map = _tmp1_;
	} else {
		GeeHashMap* _tmp2_;
		_tmp2_ = app_exclude_entry_app_map;
		gee_abstract_map_clear ((GeeAbstractMap*) _tmp2_);
	}
}

void
app_exclude_entry_add_app_exclude_entries_from_home (const gchar* home)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (home != NULL);
	tee_jee_logging_log_debug ("AppExcludeEntry: add_app_exclude_entries_from_home()");
	_tmp0_ = g_strdup_printf ("path=%s", home);
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_debug (_tmp1_);
	_g_free0 (_tmp1_);
	{
		GFile* f_home = NULL;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp4_;
		GFileEnumerator* _tmp5_;
		GFileInfo* file = NULL;
		_tmp2_ = g_file_new_for_path (home);
		f_home = _tmp2_;
		_tmp3_ = f_home;
		if (!g_file_query_exists (_tmp3_, NULL)) {
			_g_object_unref0 (f_home);
			return;
		}
		_tmp4_ = f_home;
		_tmp5_ = g_file_enumerate_children (_tmp4_, "standard::*", 0, NULL, &_inner_error0_);
		enumerator = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (f_home);
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp6_ = NULL;
			GFileEnumerator* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			gchar* name = NULL;
			GFileInfo* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* item = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp7_ = enumerator;
			_tmp8_ = g_file_enumerator_next_file (_tmp7_, NULL, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (f_home);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_object_unref0 (file);
			file = _tmp9_;
			_tmp10_ = file;
			if (!(_tmp10_ != NULL)) {
				_g_object_unref0 (_tmp6_);
				break;
			}
			_tmp11_ = file;
			_tmp12_ = g_file_info_get_name (_tmp11_);
			_tmp13_ = g_strdup (_tmp12_);
			name = _tmp13_;
			_tmp14_ = g_strconcat (home, "/", NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = name;
			_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			_g_free0 (_tmp15_);
			item = _tmp18_;
			_tmp19_ = name;
			if (g_str_has_suffix (_tmp19_, ".lock")) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp20_ = name;
			if (g_str_has_suffix (_tmp20_, ".log")) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp21_ = name;
			if (g_str_has_suffix (_tmp21_, ".old")) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp22_ = name;
			if (g_str_has_suffix (_tmp22_, "~")) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp23_ = item;
			app_exclude_entry_add_app_exclude_entries_from_path (_tmp23_);
			_g_free0 (item);
			_g_free0 (name);
			_g_object_unref0 (_tmp6_);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (f_home);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		tee_jee_logging_log_error (_tmp25_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
app_exclude_entry_add_app_exclude_entries_from_path (const gchar* user_home)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (user_home != NULL);
	tee_jee_logging_log_debug ("AppExcludeEntry: add_app_exclude_entries_from_path()");
	_tmp0_ = g_strdup_printf ("path=%s", user_home);
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_debug (_tmp1_);
	_g_free0 (_tmp1_);
	{
		GFile* f_home = NULL;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp4_;
		GFileEnumerator* _tmp5_;
		GFileInfo* file = NULL;
		GFile* f_home_config = NULL;
		gchar* _tmp36_;
		gchar* _tmp37_;
		GFile* _tmp38_;
		GFile* _tmp39_;
		GFile* _tmp40_;
		GFile* f_home_local = NULL;
		gchar* _tmp66_;
		gchar* _tmp67_;
		GFile* _tmp68_;
		GFile* _tmp69_;
		GFile* _tmp70_;
		_tmp2_ = g_file_new_for_path (user_home);
		f_home = _tmp2_;
		_tmp3_ = f_home;
		if (!g_file_query_exists (_tmp3_, NULL)) {
			_g_object_unref0 (f_home);
			return;
		}
		_tmp4_ = f_home;
		_tmp5_ = g_file_enumerate_children (_tmp4_, "standard::*", 0, NULL, &_inner_error0_);
		enumerator = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (f_home);
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp6_ = NULL;
			GFileEnumerator* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			gchar* name = NULL;
			GFileInfo* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* item = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* relpath = NULL;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			_tmp7_ = enumerator;
			_tmp8_ = g_file_enumerator_next_file (_tmp7_, NULL, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (f_home);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_object_unref0 (file);
			file = _tmp9_;
			_tmp10_ = file;
			if (!(_tmp10_ != NULL)) {
				_g_object_unref0 (_tmp6_);
				break;
			}
			_tmp11_ = file;
			_tmp12_ = g_file_info_get_name (_tmp11_);
			_tmp13_ = g_strdup (_tmp12_);
			name = _tmp13_;
			_tmp14_ = g_strconcat (user_home, "/", NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = name;
			_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			_g_free0 (_tmp15_);
			item = _tmp18_;
			_tmp19_ = name;
			if (!g_str_has_prefix (_tmp19_, ".")) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp20_ = name;
			if (g_str_has_suffix (_tmp20_, "~")) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp21_ = name;
			if (g_strcmp0 (_tmp21_, ".config") == 0) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp22_ = name;
			if (g_strcmp0 (_tmp22_, ".local") == 0) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp23_ = name;
			if (g_strcmp0 (_tmp23_, ".gvfs") == 0) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp24_ = name;
			if (g_strcmp0 (_tmp24_, ".thumbnails") == 0) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp25_ = name;
			if (g_strcmp0 (_tmp25_, ".cache") == 0) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp26_ = name;
			if (g_strcmp0 (_tmp26_, ".temp") == 0) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp27_ = name;
			if (g_strcmp0 (_tmp27_, ".sudo_as_admin_successful") == 0) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp28_ = name;
			if (g_str_has_suffix (_tmp28_, ".lock")) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp29_ = name;
			if (g_str_has_suffix (_tmp29_, ".log")) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp30_ = name;
			if (g_str_has_suffix (_tmp30_, ".old")) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp31_ = name;
			if (g_str_has_suffix (_tmp31_, "~")) {
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp32_ = name;
			_tmp33_ = g_strdup_printf ("~/%s", _tmp32_);
			relpath = _tmp33_;
			_tmp34_ = relpath;
			_tmp35_ = item;
			app_exclude_entry_add_item (_tmp34_, !tee_jee_file_system_dir_exists (_tmp35_), FALSE);
			_g_free0 (relpath);
			_g_free0 (item);
			_g_free0 (name);
			_g_object_unref0 (_tmp6_);
		}
		_tmp36_ = g_strconcat (user_home, "/.config", NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_file_new_for_path (_tmp37_);
		_tmp39_ = _tmp38_;
		_g_free0 (_tmp37_);
		f_home_config = _tmp39_;
		_tmp40_ = f_home_config;
		if (g_file_query_exists (_tmp40_, NULL)) {
			GFileEnumerator* _tmp41_ = NULL;
			GFile* _tmp42_;
			GFileEnumerator* _tmp43_;
			GFileEnumerator* _tmp44_;
			_tmp42_ = f_home_config;
			_tmp43_ = g_file_enumerate_children (_tmp42_, "standard::*", 0, NULL, &_inner_error0_);
			_tmp41_ = _tmp43_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (f_home_config);
				_g_object_unref0 (file);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (f_home);
				goto __catch0_g_error;
			}
			_tmp44_ = _tmp41_;
			_tmp41_ = NULL;
			_g_object_unref0 (enumerator);
			enumerator = _tmp44_;
			while (TRUE) {
				GFileInfo* _tmp45_ = NULL;
				GFileEnumerator* _tmp46_;
				GFileInfo* _tmp47_;
				GFileInfo* _tmp48_;
				GFileInfo* _tmp49_;
				gchar* name = NULL;
				GFileInfo* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* item = NULL;
				gchar* _tmp53_;
				gchar* _tmp54_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				gchar* relpath = NULL;
				const gchar* _tmp62_;
				gchar* _tmp63_;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				_tmp46_ = enumerator;
				_tmp47_ = g_file_enumerator_next_file (_tmp46_, NULL, &_inner_error0_);
				_tmp45_ = _tmp47_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp41_);
					_g_object_unref0 (f_home_config);
					_g_object_unref0 (file);
					_g_object_unref0 (enumerator);
					_g_object_unref0 (f_home);
					goto __catch0_g_error;
				}
				_tmp48_ = _tmp45_;
				_tmp45_ = NULL;
				_g_object_unref0 (file);
				file = _tmp48_;
				_tmp49_ = file;
				if (!(_tmp49_ != NULL)) {
					_g_object_unref0 (_tmp45_);
					break;
				}
				_tmp50_ = file;
				_tmp51_ = g_file_info_get_name (_tmp50_);
				_tmp52_ = g_strdup (_tmp51_);
				name = _tmp52_;
				_tmp53_ = g_strconcat (user_home, "/.config/", NULL);
				_tmp54_ = _tmp53_;
				_tmp55_ = name;
				_tmp56_ = g_strconcat (_tmp54_, _tmp55_, NULL);
				_tmp57_ = _tmp56_;
				_g_free0 (_tmp54_);
				item = _tmp57_;
				_tmp58_ = name;
				if (g_str_has_suffix (_tmp58_, ".lock")) {
					_g_free0 (item);
					_g_free0 (name);
					_g_object_unref0 (_tmp45_);
					continue;
				}
				_tmp59_ = name;
				if (g_str_has_suffix (_tmp59_, ".log")) {
					_g_free0 (item);
					_g_free0 (name);
					_g_object_unref0 (_tmp45_);
					continue;
				}
				_tmp60_ = name;
				if (g_str_has_suffix (_tmp60_, ".old")) {
					_g_free0 (item);
					_g_free0 (name);
					_g_object_unref0 (_tmp45_);
					continue;
				}
				_tmp61_ = name;
				if (g_str_has_suffix (_tmp61_, "~")) {
					_g_free0 (item);
					_g_free0 (name);
					_g_object_unref0 (_tmp45_);
					continue;
				}
				_tmp62_ = name;
				_tmp63_ = g_strdup_printf ("~/.config/%s", _tmp62_);
				relpath = _tmp63_;
				_tmp64_ = relpath;
				_tmp65_ = item;
				app_exclude_entry_add_item (_tmp64_, !tee_jee_file_system_dir_exists (_tmp65_), FALSE);
				_g_free0 (relpath);
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp45_);
			}
			_g_object_unref0 (_tmp41_);
		}
		_tmp66_ = g_strconcat (user_home, "/.local/share", NULL);
		_tmp67_ = _tmp66_;
		_tmp68_ = g_file_new_for_path (_tmp67_);
		_tmp69_ = _tmp68_;
		_g_free0 (_tmp67_);
		f_home_local = _tmp69_;
		_tmp70_ = f_home_local;
		if (g_file_query_exists (_tmp70_, NULL)) {
			GFileEnumerator* _tmp71_ = NULL;
			GFile* _tmp72_;
			GFileEnumerator* _tmp73_;
			GFileEnumerator* _tmp74_;
			_tmp72_ = f_home_local;
			_tmp73_ = g_file_enumerate_children (_tmp72_, "standard::*", 0, NULL, &_inner_error0_);
			_tmp71_ = _tmp73_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (f_home_local);
				_g_object_unref0 (f_home_config);
				_g_object_unref0 (file);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (f_home);
				goto __catch0_g_error;
			}
			_tmp74_ = _tmp71_;
			_tmp71_ = NULL;
			_g_object_unref0 (enumerator);
			enumerator = _tmp74_;
			while (TRUE) {
				GFileInfo* _tmp75_ = NULL;
				GFileEnumerator* _tmp76_;
				GFileInfo* _tmp77_;
				GFileInfo* _tmp78_;
				GFileInfo* _tmp79_;
				gchar* name = NULL;
				GFileInfo* _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* item = NULL;
				gchar* _tmp83_;
				gchar* _tmp84_;
				const gchar* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_;
				const gchar* _tmp90_;
				const gchar* _tmp91_;
				const gchar* _tmp92_;
				const gchar* _tmp93_;
				gchar* relpath = NULL;
				const gchar* _tmp94_;
				gchar* _tmp95_;
				const gchar* _tmp96_;
				const gchar* _tmp97_;
				_tmp76_ = enumerator;
				_tmp77_ = g_file_enumerator_next_file (_tmp76_, NULL, &_inner_error0_);
				_tmp75_ = _tmp77_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp71_);
					_g_object_unref0 (f_home_local);
					_g_object_unref0 (f_home_config);
					_g_object_unref0 (file);
					_g_object_unref0 (enumerator);
					_g_object_unref0 (f_home);
					goto __catch0_g_error;
				}
				_tmp78_ = _tmp75_;
				_tmp75_ = NULL;
				_g_object_unref0 (file);
				file = _tmp78_;
				_tmp79_ = file;
				if (!(_tmp79_ != NULL)) {
					_g_object_unref0 (_tmp75_);
					break;
				}
				_tmp80_ = file;
				_tmp81_ = g_file_info_get_name (_tmp80_);
				_tmp82_ = g_strdup (_tmp81_);
				name = _tmp82_;
				_tmp83_ = g_strconcat (user_home, "/.local/share/", NULL);
				_tmp84_ = _tmp83_;
				_tmp85_ = name;
				_tmp86_ = g_strconcat (_tmp84_, _tmp85_, NULL);
				_tmp87_ = _tmp86_;
				_g_free0 (_tmp84_);
				item = _tmp87_;
				_tmp88_ = name;
				if (g_str_has_suffix (_tmp88_, ".lock")) {
					_g_free0 (item);
					_g_free0 (name);
					_g_object_unref0 (_tmp75_);
					continue;
				}
				_tmp89_ = name;
				if (g_str_has_suffix (_tmp89_, ".log")) {
					_g_free0 (item);
					_g_free0 (name);
					_g_object_unref0 (_tmp75_);
					continue;
				}
				_tmp90_ = name;
				if (g_str_has_suffix (_tmp90_, ".old")) {
					_g_free0 (item);
					_g_free0 (name);
					_g_object_unref0 (_tmp75_);
					continue;
				}
				_tmp91_ = name;
				if (g_str_has_suffix (_tmp91_, "~")) {
					_g_free0 (item);
					_g_free0 (name);
					_g_object_unref0 (_tmp75_);
					continue;
				}
				_tmp92_ = name;
				if (g_strcmp0 (_tmp92_, "applications") == 0) {
					_g_free0 (item);
					_g_free0 (name);
					_g_object_unref0 (_tmp75_);
					continue;
				}
				_tmp93_ = name;
				if (g_strcmp0 (_tmp93_, "Trash") == 0) {
					_g_free0 (item);
					_g_free0 (name);
					_g_object_unref0 (_tmp75_);
					continue;
				}
				_tmp94_ = name;
				_tmp95_ = g_strdup_printf ("~/.local/share/%s", _tmp94_);
				relpath = _tmp95_;
				_tmp96_ = relpath;
				_tmp97_ = item;
				app_exclude_entry_add_item (_tmp96_, !tee_jee_file_system_dir_exists (_tmp97_), FALSE);
				_g_free0 (relpath);
				_g_free0 (item);
				_g_free0 (name);
				_g_object_unref0 (_tmp75_);
			}
			_g_object_unref0 (_tmp71_);
		}
		_g_object_unref0 (f_home_local);
		_g_object_unref0 (f_home_config);
		_g_object_unref0 (file);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (f_home);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp98_;
		const gchar* _tmp99_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp98_ = e;
		_tmp99_ = _tmp98_->message;
		tee_jee_logging_log_error (_tmp99_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
app_exclude_entry_add_item (const gchar* item_path,
                            gboolean is_file,
                            gboolean is_include)
{
	GeeHashMap* _tmp0_;
	gchar* name = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp123_;
	const gchar* _tmp129_;
	gchar* _tmp130_;
	const gchar* _tmp131_;
	gint _tmp132_;
	gint _tmp133_;
	AppExcludeEntry* entry = NULL;
	GeeHashMap* _tmp134_;
	const gchar* _tmp135_;
	AppExcludeEntry* _tmp154_;
	GeeArrayList* _tmp155_;
	gboolean* _tmp158_;
	g_return_if_fail (item_path != NULL);
	_tmp0_ = app_exclude_entry_app_map;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_APP_EXCLUDE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (app_exclude_entry_app_map);
		app_exclude_entry_app_map = _tmp1_;
	}
	_tmp2_ = tee_jee_file_system_file_basename (item_path);
	name = _tmp2_;
	_tmp3_ = name;
	if (g_str_has_suffix (_tmp3_, ".ini")) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = name;
		_tmp5_ = name;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = strlen (".ini");
		_tmp9_ = _tmp8_;
		_tmp10_ = string_slice (_tmp4_, (glong) 0, (glong) (_tmp7_ - _tmp9_));
		_g_free0 (name);
		name = _tmp10_;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = name;
		if (g_str_has_suffix (_tmp11_, ".sh")) {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gchar* _tmp18_;
			_tmp12_ = name;
			_tmp13_ = name;
			_tmp14_ = strlen (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = strlen (".sh");
			_tmp17_ = _tmp16_;
			_tmp18_ = string_slice (_tmp12_, (glong) 0, (glong) (_tmp15_ - _tmp17_));
			_g_free0 (name);
			name = _tmp18_;
		} else {
			const gchar* _tmp19_;
			_tmp19_ = name;
			if (g_str_has_suffix (_tmp19_, ".json")) {
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gchar* _tmp26_;
				_tmp20_ = name;
				_tmp21_ = name;
				_tmp22_ = strlen (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = strlen (".json");
				_tmp25_ = _tmp24_;
				_tmp26_ = string_slice (_tmp20_, (glong) 0, (glong) (_tmp23_ - _tmp25_));
				_g_free0 (name);
				name = _tmp26_;
			} else {
				const gchar* _tmp27_;
				_tmp27_ = name;
				if (g_str_has_suffix (_tmp27_, ".conf")) {
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					gchar* _tmp34_;
					_tmp28_ = name;
					_tmp29_ = name;
					_tmp30_ = strlen (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = strlen (".conf");
					_tmp33_ = _tmp32_;
					_tmp34_ = string_slice (_tmp28_, (glong) 0, (glong) (_tmp31_ - _tmp33_));
					_g_free0 (name);
					name = _tmp34_;
				} else {
					const gchar* _tmp35_;
					_tmp35_ = name;
					if (g_str_has_suffix (_tmp35_, ".list")) {
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						gint _tmp40_;
						gint _tmp41_;
						gchar* _tmp42_;
						_tmp36_ = name;
						_tmp37_ = name;
						_tmp38_ = strlen (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = strlen (".list");
						_tmp41_ = _tmp40_;
						_tmp42_ = string_slice (_tmp36_, (glong) 0, (glong) (_tmp39_ - _tmp41_));
						_g_free0 (name);
						name = _tmp42_;
					} else {
						const gchar* _tmp43_;
						_tmp43_ = name;
						if (g_str_has_suffix (_tmp43_, ".xbel")) {
							const gchar* _tmp44_;
							const gchar* _tmp45_;
							gint _tmp46_;
							gint _tmp47_;
							gint _tmp48_;
							gint _tmp49_;
							gchar* _tmp50_;
							_tmp44_ = name;
							_tmp45_ = name;
							_tmp46_ = strlen (_tmp45_);
							_tmp47_ = _tmp46_;
							_tmp48_ = strlen (".xbel");
							_tmp49_ = _tmp48_;
							_tmp50_ = string_slice (_tmp44_, (glong) 0, (glong) (_tmp47_ - _tmp49_));
							_g_free0 (name);
							name = _tmp50_;
						} else {
							const gchar* _tmp51_;
							_tmp51_ = name;
							if (g_str_has_suffix (_tmp51_, ".xbel.tbcache")) {
								const gchar* _tmp52_;
								const gchar* _tmp53_;
								gint _tmp54_;
								gint _tmp55_;
								gint _tmp56_;
								gint _tmp57_;
								gchar* _tmp58_;
								_tmp52_ = name;
								_tmp53_ = name;
								_tmp54_ = strlen (_tmp53_);
								_tmp55_ = _tmp54_;
								_tmp56_ = strlen (".xbel.tbcache");
								_tmp57_ = _tmp56_;
								_tmp58_ = string_slice (_tmp52_, (glong) 0, (glong) (_tmp55_ - _tmp57_));
								_g_free0 (name);
								name = _tmp58_;
							} else {
								const gchar* _tmp59_;
								_tmp59_ = name;
								if (g_str_has_suffix (_tmp59_, ".bz2")) {
									const gchar* _tmp60_;
									const gchar* _tmp61_;
									gint _tmp62_;
									gint _tmp63_;
									gint _tmp64_;
									gint _tmp65_;
									gchar* _tmp66_;
									_tmp60_ = name;
									_tmp61_ = name;
									_tmp62_ = strlen (_tmp61_);
									_tmp63_ = _tmp62_;
									_tmp64_ = strlen (".bz2");
									_tmp65_ = _tmp64_;
									_tmp66_ = string_slice (_tmp60_, (glong) 0, (glong) (_tmp63_ - _tmp65_));
									_g_free0 (name);
									name = _tmp66_;
								} else {
									const gchar* _tmp67_;
									_tmp67_ = name;
									if (g_str_has_suffix (_tmp67_, ".old")) {
										const gchar* _tmp68_;
										const gchar* _tmp69_;
										gint _tmp70_;
										gint _tmp71_;
										gint _tmp72_;
										gint _tmp73_;
										gchar* _tmp74_;
										_tmp68_ = name;
										_tmp69_ = name;
										_tmp70_ = strlen (_tmp69_);
										_tmp71_ = _tmp70_;
										_tmp72_ = strlen (".old");
										_tmp73_ = _tmp72_;
										_tmp74_ = string_slice (_tmp68_, (glong) 0, (glong) (_tmp71_ - _tmp73_));
										_g_free0 (name);
										name = _tmp74_;
									} else {
										const gchar* _tmp75_;
										_tmp75_ = name;
										if (g_str_has_suffix (_tmp75_, ".dirs")) {
											const gchar* _tmp76_;
											const gchar* _tmp77_;
											gint _tmp78_;
											gint _tmp79_;
											gint _tmp80_;
											gint _tmp81_;
											gchar* _tmp82_;
											_tmp76_ = name;
											_tmp77_ = name;
											_tmp78_ = strlen (_tmp77_);
											_tmp79_ = _tmp78_;
											_tmp80_ = strlen (".dirs");
											_tmp81_ = _tmp80_;
											_tmp82_ = string_slice (_tmp76_, (glong) 0, (glong) (_tmp79_ - _tmp81_));
											_g_free0 (name);
											name = _tmp82_;
										} else {
											const gchar* _tmp83_;
											_tmp83_ = name;
											if (g_str_has_suffix (_tmp83_, ".locale")) {
												const gchar* _tmp84_;
												const gchar* _tmp85_;
												gint _tmp86_;
												gint _tmp87_;
												gint _tmp88_;
												gint _tmp89_;
												gchar* _tmp90_;
												_tmp84_ = name;
												_tmp85_ = name;
												_tmp86_ = strlen (_tmp85_);
												_tmp87_ = _tmp86_;
												_tmp88_ = strlen (".locale");
												_tmp89_ = _tmp88_;
												_tmp90_ = string_slice (_tmp84_, (glong) 0, (glong) (_tmp87_ - _tmp89_));
												_g_free0 (name);
												name = _tmp90_;
											} else {
												const gchar* _tmp91_;
												_tmp91_ = name;
												if (g_str_has_suffix (_tmp91_, ".dockitem")) {
													const gchar* _tmp92_;
													const gchar* _tmp93_;
													gint _tmp94_;
													gint _tmp95_;
													gint _tmp96_;
													gint _tmp97_;
													gchar* _tmp98_;
													_tmp92_ = name;
													_tmp93_ = name;
													_tmp94_ = strlen (_tmp93_);
													_tmp95_ = _tmp94_;
													_tmp96_ = strlen (".dockitem");
													_tmp97_ = _tmp96_;
													_tmp98_ = string_slice (_tmp92_, (glong) 0, (glong) (_tmp95_ - _tmp97_));
													_g_free0 (name);
													name = _tmp98_;
												} else {
													const gchar* _tmp99_;
													_tmp99_ = name;
													if (g_str_has_suffix (_tmp99_, ".xml")) {
														const gchar* _tmp100_;
														const gchar* _tmp101_;
														gint _tmp102_;
														gint _tmp103_;
														gint _tmp104_;
														gint _tmp105_;
														gchar* _tmp106_;
														_tmp100_ = name;
														_tmp101_ = name;
														_tmp102_ = strlen (_tmp101_);
														_tmp103_ = _tmp102_;
														_tmp104_ = strlen (".xml");
														_tmp105_ = _tmp104_;
														_tmp106_ = string_slice (_tmp100_, (glong) 0, (glong) (_tmp103_ - _tmp105_));
														_g_free0 (name);
														name = _tmp106_;
													} else {
														const gchar* _tmp107_;
														_tmp107_ = name;
														if (g_str_has_suffix (_tmp107_, ".log")) {
															const gchar* _tmp108_;
															const gchar* _tmp109_;
															gint _tmp110_;
															gint _tmp111_;
															gint _tmp112_;
															gint _tmp113_;
															gchar* _tmp114_;
															_tmp108_ = name;
															_tmp109_ = name;
															_tmp110_ = strlen (_tmp109_);
															_tmp111_ = _tmp110_;
															_tmp112_ = strlen (".log");
															_tmp113_ = _tmp112_;
															_tmp114_ = string_slice (_tmp108_, (glong) 0, (glong) (_tmp111_ - _tmp113_));
															_g_free0 (name);
															name = _tmp114_;
														} else {
															const gchar* _tmp115_;
															_tmp115_ = name;
															if (g_str_has_suffix (_tmp115_, ".txt")) {
																const gchar* _tmp116_;
																const gchar* _tmp117_;
																gint _tmp118_;
																gint _tmp119_;
																gint _tmp120_;
																gint _tmp121_;
																gchar* _tmp122_;
																_tmp116_ = name;
																_tmp117_ = name;
																_tmp118_ = strlen (_tmp117_);
																_tmp119_ = _tmp118_;
																_tmp120_ = strlen (".txt");
																_tmp121_ = _tmp120_;
																_tmp122_ = string_slice (_tmp116_, (glong) 0, (glong) (_tmp119_ - _tmp121_));
																_g_free0 (name);
																name = _tmp122_;
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp123_ = name;
	if (g_str_has_prefix (_tmp123_, ".")) {
		const gchar* _tmp124_;
		const gchar* _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		gchar* _tmp128_;
		_tmp124_ = name;
		_tmp125_ = name;
		_tmp126_ = strlen (_tmp125_);
		_tmp127_ = _tmp126_;
		_tmp128_ = string_slice (_tmp124_, (glong) 1, (glong) _tmp127_);
		_g_free0 (name);
		name = _tmp128_;
	}
	_tmp129_ = name;
	_tmp130_ = string_strip (_tmp129_);
	_g_free0 (name);
	name = _tmp130_;
	_tmp131_ = name;
	_tmp132_ = strlen (_tmp131_);
	_tmp133_ = _tmp132_;
	if (_tmp133_ == 0) {
		_g_free0 (name);
		return;
	}
	entry = NULL;
	_tmp134_ = app_exclude_entry_app_map;
	_tmp135_ = name;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp134_, _tmp135_)) {
		GeeHashMap* _tmp136_;
		const gchar* _tmp137_;
		gpointer _tmp138_;
		_tmp136_ = app_exclude_entry_app_map;
		_tmp137_ = name;
		_tmp138_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp136_, _tmp137_);
		_g_object_unref0 (entry);
		entry = (AppExcludeEntry*) _tmp138_;
	} else {
		GeeHashMap* _tmp139_;
		const gchar* _tmp140_;
		gchar* _tmp141_;
		gchar* _tmp142_;
		gboolean _tmp143_;
		_tmp139_ = app_exclude_entry_app_map;
		_tmp140_ = name;
		_tmp141_ = g_utf8_strdown (_tmp140_, (gssize) -1);
		_tmp142_ = _tmp141_;
		_tmp143_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp139_, _tmp142_);
		_g_free0 (_tmp142_);
		if (_tmp143_) {
			GeeHashMap* _tmp144_;
			const gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			gpointer _tmp148_;
			_tmp144_ = app_exclude_entry_app_map;
			_tmp145_ = name;
			_tmp146_ = g_utf8_strdown (_tmp145_, (gssize) -1);
			_tmp147_ = _tmp146_;
			_tmp148_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp144_, _tmp147_);
			_g_object_unref0 (entry);
			entry = (AppExcludeEntry*) _tmp148_;
			_g_free0 (_tmp147_);
		} else {
			const gchar* _tmp149_;
			AppExcludeEntry* _tmp150_;
			GeeHashMap* _tmp151_;
			const gchar* _tmp152_;
			AppExcludeEntry* _tmp153_;
			_tmp149_ = name;
			_tmp150_ = app_exclude_entry_new (_tmp149_, is_include);
			_g_object_unref0 (entry);
			entry = _tmp150_;
			_tmp151_ = app_exclude_entry_app_map;
			_tmp152_ = name;
			_tmp153_ = entry;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp151_, _tmp152_, _tmp153_);
		}
	}
	_tmp154_ = entry;
	_tmp155_ = _tmp154_->items;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp155_, item_path)) {
		AppExcludeEntry* _tmp156_;
		GeeArrayList* _tmp157_;
		_tmp156_ = entry;
		_tmp157_ = _tmp156_->items;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp157_, item_path);
	}
	_tmp158_ = g_new0 (gboolean, 2);
	_tmp158_[0] = TRUE;
	_tmp158_[1] = FALSE;
	{
		gboolean* root_user_collection = NULL;
		gint root_user_collection_length1 = 0;
		gint _root_user_collection_size_ = 0;
		gint root_user_it = 0;
		root_user_collection = _tmp158_;
		root_user_collection_length1 = 2;
		for (root_user_it = 0; root_user_it < root_user_collection_length1; root_user_it = root_user_it + 1) {
			gboolean root_user = FALSE;
			root_user = root_user_collection[root_user_it];
			{
				const gchar* _tmp159_ = NULL;
				gchar* str = NULL;
				gchar* _tmp160_;
				const gchar* _tmp161_ = NULL;
				const gchar* _tmp162_;
				gchar* _tmp163_;
				const gchar* _tmp164_;
				gint _tmp165_;
				gint _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				AppExcludeEntry* _tmp170_;
				GeeArrayList* _tmp171_;
				const gchar* _tmp172_;
				if (is_include) {
					_tmp159_ = "+ ";
				} else {
					_tmp159_ = "";
				}
				_tmp160_ = g_strdup (_tmp159_);
				str = _tmp160_;
				if (root_user) {
					_tmp161_ = "/root";
				} else {
					_tmp161_ = "/home/*";
				}
				_tmp162_ = str;
				_tmp163_ = g_strconcat (_tmp162_, _tmp161_, NULL);
				_g_free0 (str);
				str = _tmp163_;
				_tmp164_ = str;
				_tmp165_ = strlen (item_path);
				_tmp166_ = _tmp165_;
				_tmp167_ = string_slice (item_path, (glong) 1, (glong) _tmp166_);
				_tmp168_ = _tmp167_;
				_tmp169_ = g_strconcat (_tmp164_, _tmp168_, NULL);
				_g_free0 (str);
				str = _tmp169_;
				_g_free0 (_tmp168_);
				_tmp170_ = entry;
				_tmp171_ = _tmp170_->patterns;
				_tmp172_ = str;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp171_, _tmp172_);
				_g_free0 (str);
			}
		}
		root_user_collection = (g_free (root_user_collection), NULL);
	}
	_g_object_unref0 (entry);
	_g_free0 (name);
}

static gint
__lambda7_ (AppExcludeEntry* a,
            AppExcludeEntry* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = a->name;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = b->name;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	result = _tmp7_;
	return result;
}

static gint
___lambda7__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda7_ ((AppExcludeEntry*) a, (AppExcludeEntry*) b);
	return result;
}

GeeArrayList*
app_exclude_entry_get_apps_list (GeeArrayList* selected_app_names)
{
	GeeHashMap* _tmp0_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp19_;
	GCompareDataFunc entry_compare = NULL;
	gpointer entry_compare_target;
	GDestroyNotify entry_compare_target_destroy_notify;
	GeeArrayList* _tmp34_;
	GCompareDataFunc _tmp35_;
	gpointer _tmp35__target;
	GDestroyNotify _tmp35__target_destroy_notify;
	GeeArrayList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GeeArrayList* result;
	g_return_val_if_fail (selected_app_names != NULL, NULL);
	_tmp0_ = app_exclude_entry_app_map;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_APP_EXCLUDE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (app_exclude_entry_app_map);
		app_exclude_entry_app_map = _tmp1_;
	}
	{
		GeeArrayList* _selected_name_list = NULL;
		gint _selected_name_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _selected_name_index = 0;
		_selected_name_list = selected_app_names;
		_tmp2_ = _selected_name_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_selected_name_size = _tmp4_;
		_selected_name_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* selected_name = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			GeeHashMap* _tmp9_;
			const gchar* _tmp10_;
			_selected_name_index = _selected_name_index + 1;
			_tmp5_ = _selected_name_index;
			_tmp6_ = _selected_name_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _selected_name_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _selected_name_index);
			selected_name = (gchar*) _tmp8_;
			_tmp9_ = app_exclude_entry_app_map;
			_tmp10_ = selected_name;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, _tmp10_)) {
				GeeHashMap* _tmp11_;
				const gchar* _tmp12_;
				gpointer _tmp13_;
				AppExcludeEntry* _tmp14_;
				_tmp11_ = app_exclude_entry_app_map;
				_tmp12_ = selected_name;
				_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
				_tmp14_ = (AppExcludeEntry*) _tmp13_;
				_tmp14_->enabled = TRUE;
				_g_object_unref0 (_tmp14_);
			} else {
				GeeHashMap* _tmp15_;
				const gchar* _tmp16_;
				gpointer _tmp17_;
				AppExcludeEntry* _tmp18_;
				_tmp15_ = app_exclude_entry_app_map;
				_tmp16_ = selected_name;
				_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
				_tmp18_ = (AppExcludeEntry*) _tmp17_;
				_tmp18_->enabled = FALSE;
				_g_object_unref0 (_tmp18_);
			}
			_g_free0 (selected_name);
		}
	}
	_tmp19_ = gee_array_list_new (TYPE_APP_EXCLUDE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp19_;
	{
		GeeIterator* _key_it = NULL;
		GeeHashMap* _tmp20_;
		GeeSet* _tmp21_;
		GeeSet* _tmp22_;
		GeeSet* _tmp23_;
		GeeIterator* _tmp24_;
		GeeIterator* _tmp25_;
		_tmp20_ = app_exclude_entry_app_map;
		_tmp21_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_key_it = _tmp25_;
		while (TRUE) {
			GeeIterator* _tmp26_;
			gchar* key = NULL;
			GeeIterator* _tmp27_;
			gpointer _tmp28_;
			GeeArrayList* _tmp29_;
			GeeHashMap* _tmp30_;
			const gchar* _tmp31_;
			gpointer _tmp32_;
			AppExcludeEntry* _tmp33_;
			_tmp26_ = _key_it;
			if (!gee_iterator_next (_tmp26_)) {
				break;
			}
			_tmp27_ = _key_it;
			_tmp28_ = gee_iterator_get (_tmp27_);
			key = (gchar*) _tmp28_;
			_tmp29_ = list;
			_tmp30_ = app_exclude_entry_app_map;
			_tmp31_ = key;
			_tmp32_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, _tmp31_);
			_tmp33_ = (AppExcludeEntry*) _tmp32_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp33_);
			_g_object_unref0 (_tmp33_);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	entry_compare = ___lambda7__gcompare_data_func;
	entry_compare_target = NULL;
	entry_compare_target_destroy_notify = NULL;
	_tmp34_ = list;
	_tmp35_ = entry_compare;
	_tmp35__target = entry_compare_target;
	_tmp35__target_destroy_notify = entry_compare_target_destroy_notify;
	entry_compare = NULL;
	entry_compare_target = NULL;
	entry_compare_target_destroy_notify = NULL;
	gee_list_sort ((GeeList*) _tmp34_, _tmp35_, _tmp35__target, _tmp35__target_destroy_notify);
	_tmp36_ = list;
	_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strdup_printf ("apps: %d", _tmp38_);
	_tmp40_ = _tmp39_;
	tee_jee_logging_log_debug (_tmp40_);
	_g_free0 (_tmp40_);
	result = list;
	(entry_compare_target_destroy_notify == NULL) ? NULL : (entry_compare_target_destroy_notify (entry_compare_target), NULL);
	entry_compare = NULL;
	entry_compare_target = NULL;
	entry_compare_target_destroy_notify = NULL;
	return result;
}

static void
app_exclude_entry_class_init (AppExcludeEntryClass * klass,
                              gpointer klass_data)
{
	app_exclude_entry_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = app_exclude_entry_finalize;
}

static void
app_exclude_entry_instance_init (AppExcludeEntry * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	self->name = _tmp0_;
	self->is_include = FALSE;
	self->is_file = FALSE;
	self->enabled = FALSE;
}

static void
app_exclude_entry_finalize (GObject * obj)
{
	AppExcludeEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry);
	_g_free0 (self->name);
	_g_object_unref0 (self->items);
	_g_object_unref0 (self->patterns);
	G_OBJECT_CLASS (app_exclude_entry_parent_class)->finalize (obj);
}

static GType
app_exclude_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AppExcludeEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_exclude_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppExcludeEntry), 0, (GInstanceInitFunc) app_exclude_entry_instance_init, NULL };
	GType app_exclude_entry_type_id;
	app_exclude_entry_type_id = g_type_register_static (G_TYPE_OBJECT, "AppExcludeEntry", &g_define_type_info, 0);
	return app_exclude_entry_type_id;
}

GType
app_exclude_entry_get_type (void)
{
	static volatile gsize app_exclude_entry_type_id__once = 0;
	if (g_once_init_enter (&app_exclude_entry_type_id__once)) {
		GType app_exclude_entry_type_id;
		app_exclude_entry_type_id = app_exclude_entry_get_type_once ();
		g_once_init_leave (&app_exclude_entry_type_id__once, app_exclude_entry_type_id);
	}
	return app_exclude_entry_type_id__once;
}

