/* TeeJee.System.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TeeJee.System.vala, do not modify */

/*
 * TeeJee.System.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <float.h>
#include <math.h>
#include <locale.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN gint tee_jee_system_euid;
gint tee_jee_system_euid = -1;

VALA_EXTERN gboolean tee_jee_system_user_is_admin (void);
VALA_EXTERN gint tee_jee_system_get_user_id_effective (void);
VALA_EXTERN gint tee_jee_system_get_user_id (void);
VALA_EXTERN gchar* tee_jee_system_get_username_from_uid (gint user_id);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN gdouble tee_jee_system_get_system_uptime_seconds (void);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_system_xdg_open (const gchar* file);
VALA_EXTERN gboolean tee_jee_process_helper_cmd_exists (const gchar* cmd_tool);
VALA_EXTERN gchar* tee_jee_file_system_escape_single_quote (const gchar* file_path);
VALA_EXTERN gint tee_jee_process_helper_exec_user_async (const gchar* command);
VALA_EXTERN gboolean tee_jee_system_exo_open_folder (const gchar* dir_path,
                                         gboolean xdg_open_try_first);
VALA_EXTERN gint tee_jee_process_helper_exec_script_async (const gchar* script);
VALA_EXTERN gboolean tee_jee_system_using_efi_boot (void);
VALA_EXTERN gboolean tee_jee_file_system_dir_exists (const gchar* dir_path);
VALA_EXTERN GTimer* tee_jee_system_timer_start (void);
VALA_EXTERN gulong tee_jee_system_timer_elapsed (GTimer* timer,
                                     gboolean stop);
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN gchar* tee_jee_system_timer_elapsed_string (GTimer* timer,
                                            gboolean stop);
VALA_EXTERN void tee_jee_system_set_numeric_locale (const gchar* type);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gboolean
tee_jee_system_user_is_admin (void)
{
	gboolean result;
	result = tee_jee_system_get_user_id_effective () == 0;
	return result;
}

gint
tee_jee_system_get_user_id (void)
{
	gchar* pkexec_uid = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* sudo_user = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gint result;
	_tmp0_ = g_getenv ("PKEXEC_UID");
	_tmp1_ = g_strdup (_tmp0_);
	pkexec_uid = _tmp1_;
	_tmp2_ = pkexec_uid;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = pkexec_uid;
		result = atoi (_tmp3_);
		_g_free0 (pkexec_uid);
		return result;
	}
	_tmp4_ = g_getenv ("SUDO_UID");
	_tmp5_ = g_strdup (_tmp4_);
	sudo_user = _tmp5_;
	_tmp6_ = sudo_user;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = sudo_user;
		result = atoi (_tmp7_);
		_g_free0 (sudo_user);
		_g_free0 (pkexec_uid);
		return result;
	}
	result = tee_jee_system_get_user_id_effective ();
	_g_free0 (sudo_user);
	_g_free0 (pkexec_uid);
	return result;
}

gint
tee_jee_system_get_user_id_effective (void)
{
	gint result;
	if (tee_jee_system_euid < 0) {
		tee_jee_system_euid = (gint) geteuid ();
	}
	result = tee_jee_system_euid;
	return result;
}

gchar*
tee_jee_system_get_username_from_uid (gint user_id)
{
	struct passwd* pw = NULL;
	struct passwd* _tmp0_;
	struct passwd* _tmp1_ = NULL;
	struct passwd* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* outvalue = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* result;
	_tmp0_ = getpwuid ((uid_t) user_id);
	pw = _tmp0_;
	_tmp2_ = pw;
	_tmp1_ = _tmp2_;
	_tmp3_ = NULL;
	if (_tmp1_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = _tmp1_->pw_name;
		_tmp3_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp3_);
	outvalue = _tmp5_;
	_tmp6_ = outvalue;
	if (NULL == _tmp6_) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = g_strdup_printf ("Could not get username for uid %d", user_id);
		_tmp8_ = _tmp7_;
		tee_jee_logging_log_error (_tmp8_, FALSE, FALSE);
		_g_free0 (_tmp8_);
	}
	result = outvalue;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

gdouble
tee_jee_system_get_system_uptime_seconds (void)
{
	gchar* uptime = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gdouble secs = 0.0;
	gdouble result;
	_tmp0_ = tee_jee_file_system_file_read ("/proc/uptime");
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_tmp5_ = _tmp4_[0];
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp1_);
	uptime = _tmp7_;
	secs = double_parse (uptime);
	result = secs;
	_g_free0 (uptime);
	return result;
}

gboolean
tee_jee_system_xdg_open (const gchar* file)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	if (!tee_jee_process_helper_cmd_exists ("xdg-open")) {
		result = FALSE;
		return result;
	}
	_tmp0_ = tee_jee_file_system_escape_single_quote (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("xdg-open '%s'", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	cmd = _tmp3_;
	_tmp4_ = cmd;
	result = tee_jee_process_helper_exec_user_async (_tmp4_) == 0;
	_g_free0 (cmd);
	return result;
}

gboolean
tee_jee_system_exo_open_folder (const gchar* dir_path,
                                gboolean xdg_open_try_first)
{
	gboolean xdgAvailable = FALSE;
	gchar* escaped_dir_path = NULL;
	gchar* _tmp0_;
	gint status = 0;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gboolean _tmp19_ = FALSE;
	gboolean result;
	g_return_val_if_fail (dir_path != NULL, FALSE);
	xdgAvailable = tee_jee_process_helper_cmd_exists ("xdg-open");
	_tmp0_ = tee_jee_file_system_escape_single_quote (dir_path);
	escaped_dir_path = _tmp0_;
	status = -1;
	if (xdg_open_try_first) {
		_tmp1_ = xdgAvailable;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* cmd = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = escaped_dir_path;
		_tmp3_ = g_strdup_printf ("xdg-open '%s'", _tmp2_);
		cmd = _tmp3_;
		_tmp4_ = cmd;
		status = tee_jee_process_helper_exec_script_async (_tmp4_);
		result = status == 0;
		_g_free0 (cmd);
		_g_free0 (escaped_dir_path);
		return result;
	}
	_tmp5_ = g_strdup ("nemo");
	_tmp6_ = g_strdup ("nautilus");
	_tmp7_ = g_strdup ("thunar");
	_tmp8_ = g_strdup ("io.elementary.files");
	_tmp9_ = g_strdup ("pantheon-files");
	_tmp10_ = g_strdup ("marlin");
	_tmp11_ = g_strdup ("dolphin");
	_tmp12_ = g_new0 (gchar*, 7 + 1);
	_tmp12_[0] = _tmp5_;
	_tmp12_[1] = _tmp6_;
	_tmp12_[2] = _tmp7_;
	_tmp12_[3] = _tmp8_;
	_tmp12_[4] = _tmp9_;
	_tmp12_[5] = _tmp10_;
	_tmp12_[6] = _tmp11_;
	{
		gchar** app_name_collection = NULL;
		gint app_name_collection_length1 = 0;
		gint _app_name_collection_size_ = 0;
		gint app_name_it = 0;
		app_name_collection = _tmp12_;
		app_name_collection_length1 = 7;
		for (app_name_it = 0; app_name_it < app_name_collection_length1; app_name_it = app_name_it + 1) {
			gchar* _tmp13_;
			gchar* app_name = NULL;
			_tmp13_ = g_strdup (app_name_collection[app_name_it]);
			app_name = _tmp13_;
			{
				const gchar* _tmp14_;
				gchar* cmd = NULL;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp14_ = app_name;
				if (!tee_jee_process_helper_cmd_exists (_tmp14_)) {
					_g_free0 (app_name);
					continue;
				}
				_tmp15_ = app_name;
				_tmp16_ = escaped_dir_path;
				_tmp17_ = g_strdup_printf ("%s '%s'", _tmp15_, _tmp16_);
				cmd = _tmp17_;
				_tmp18_ = cmd;
				status = tee_jee_process_helper_exec_script_async (_tmp18_);
				if (status == 0) {
					result = TRUE;
					_g_free0 (cmd);
					_g_free0 (app_name);
					app_name_collection = (_vala_array_free (app_name_collection, app_name_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (escaped_dir_path);
					return result;
				}
				_g_free0 (cmd);
				_g_free0 (app_name);
			}
		}
		app_name_collection = (_vala_array_free (app_name_collection, app_name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (!xdg_open_try_first) {
		_tmp19_ = xdgAvailable;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gchar* cmd = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp20_ = escaped_dir_path;
		_tmp21_ = g_strdup_printf ("xdg-open '%s'", _tmp20_);
		cmd = _tmp21_;
		_tmp22_ = cmd;
		status = tee_jee_process_helper_exec_script_async (_tmp22_);
		result = status == 0;
		_g_free0 (cmd);
		_g_free0 (escaped_dir_path);
		return result;
	}
	result = FALSE;
	_g_free0 (escaped_dir_path);
	return result;
}

gboolean
tee_jee_system_using_efi_boot (void)
{
	gboolean result;
	result = tee_jee_file_system_dir_exists ("/sys/firmware/efi");
	return result;
}

GTimer*
tee_jee_system_timer_start (void)
{
	GTimer* timer = NULL;
	GTimer* _tmp0_;
	GTimer* result;
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	g_timer_start (timer);
	result = timer;
	return result;
}

gulong
tee_jee_system_timer_elapsed (GTimer* timer,
                              gboolean stop)
{
	gulong microseconds = 0UL;
	gdouble seconds = 0.0;
	gulong _tmp0_ = 0UL;
	gdouble _tmp1_;
	gulong result;
	g_return_val_if_fail (timer != NULL, 0UL);
	_tmp1_ = g_timer_elapsed (timer, &_tmp0_);
	microseconds = _tmp0_;
	seconds = _tmp1_;
	if (stop) {
		g_timer_stop (timer);
	}
	result = (gulong) ((seconds * 1000) + (microseconds / 1000));
	return result;
}

void
tee_jee_system_sleep (gint milliseconds)
{
	g_usleep (((gulong) milliseconds) * 1000);
}

gchar*
tee_jee_system_timer_elapsed_string (GTimer* timer,
                                     gboolean stop)
{
	gulong microseconds = 0UL;
	gdouble seconds = 0.0;
	gulong _tmp0_ = 0UL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (timer != NULL, NULL);
	_tmp1_ = g_timer_elapsed (timer, &_tmp0_);
	microseconds = _tmp0_;
	seconds = _tmp1_;
	if (stop) {
		g_timer_stop (timer);
	}
	_tmp2_ = g_strdup_printf ("%.0f ms", (seconds * 1000) + (microseconds / 1000));
	result = _tmp2_;
	return result;
}

void
tee_jee_system_set_numeric_locale (const gchar* type)
{
	g_return_if_fail (type != NULL);
	setlocale (LC_NUMERIC, type);
	setlocale (LC_COLLATE, type);
	setlocale (LC_TIME, type);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

