/* server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_unixinfo.h"
#include <util/debug.h>

NTSTATUS dcerpc_server_unixinfo_init(TALLOC_CTX *);

/* unixinfo - dcerpc server boilerplate generated by pidl */


static NTSTATUS unixinfo__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_UNIXINFO_BIND
	return DCESRV_INTERFACE_UNIXINFO_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void unixinfo__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_UNIXINFO_UNBIND
	DCESRV_INTERFACE_UNIXINFO_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS unixinfo__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_unixinfo.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_unixinfo.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_unixinfo.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_unixinfo.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS unixinfo__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct unixinfo_SidToUid *r2 = (struct unixinfo_SidToUid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(unixinfo_SidToUid, NDR_IN, r2);
		}
		r2->out.result = dcesrv_unixinfo_SidToUid(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function unixinfo_SidToUid will reply async\n"));
		}
		break;
	}
	case 1: {
		struct unixinfo_UidToSid *r2 = (struct unixinfo_UidToSid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(unixinfo_UidToSid, NDR_IN, r2);
		}
		r2->out.result = dcesrv_unixinfo_UidToSid(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function unixinfo_UidToSid will reply async\n"));
		}
		break;
	}
	case 2: {
		struct unixinfo_SidToGid *r2 = (struct unixinfo_SidToGid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(unixinfo_SidToGid, NDR_IN, r2);
		}
		r2->out.result = dcesrv_unixinfo_SidToGid(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function unixinfo_SidToGid will reply async\n"));
		}
		break;
	}
	case 3: {
		struct unixinfo_GidToSid *r2 = (struct unixinfo_GidToSid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(unixinfo_GidToSid, NDR_IN, r2);
		}
		r2->out.result = dcesrv_unixinfo_GidToSid(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function unixinfo_GidToSid will reply async\n"));
		}
		break;
	}
	case 4: {
		struct unixinfo_GetPWUid *r2 = (struct unixinfo_GetPWUid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(unixinfo_GetPWUid, NDR_IN, r2);
		}
		r2->out.result = dcesrv_unixinfo_GetPWUid(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function unixinfo_GetPWUid will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS unixinfo__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct unixinfo_SidToUid *r2 = (struct unixinfo_SidToUid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function unixinfo_SidToUid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(unixinfo_SidToUid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in unixinfo_SidToUid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct unixinfo_UidToSid *r2 = (struct unixinfo_UidToSid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function unixinfo_UidToSid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(unixinfo_UidToSid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in unixinfo_UidToSid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct unixinfo_SidToGid *r2 = (struct unixinfo_SidToGid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function unixinfo_SidToGid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(unixinfo_SidToGid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in unixinfo_SidToGid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct unixinfo_GidToSid *r2 = (struct unixinfo_GidToSid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function unixinfo_GidToSid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(unixinfo_GidToSid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in unixinfo_GidToSid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct unixinfo_GetPWUid *r2 = (struct unixinfo_GetPWUid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function unixinfo_GetPWUid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(unixinfo_GetPWUid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in unixinfo_GetPWUid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS unixinfo__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_unixinfo.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface dcesrv_unixinfo_interface = {
	.name		    = "unixinfo",
	.syntax_id          = {{0x9c54e310,0xa955,0x4885,{0xbd,0x31},{0x78,0x78,0x71,0x47,0xdf,0xa6}},0.0},
	.bind		    = unixinfo__op_bind,
	.unbind		    = unixinfo__op_unbind,
	.ndr_pull	    = unixinfo__op_ndr_pull,
	.dispatch	    = unixinfo__op_dispatch,
	.reply		    = unixinfo__op_reply,
	.ndr_push	    = unixinfo__op_ndr_push,
	.local		    = NULL,
#ifdef DCESRV_INTERFACE_UNIXINFO_FLAGS
	.flags              = DCESRV_INTERFACE_UNIXINFO_FLAGS
#else
	.flags              = 0
#endif
};


static NTSTATUS unixinfo__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;
#ifdef DCESRV_INTERFACE_UNIXINFO_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint =
		DCESRV_INTERFACE_UNIXINFO_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_unixinfo.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_unixinfo.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx,
						name,
						ncacn_np_secondary_endpoint,
						&dcesrv_unixinfo_interface,
						NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("unixinfo_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS unixinfo__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool unixinfo__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_unixinfo_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_unixinfo_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_unixinfo_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool unixinfo__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_unixinfo_interface.name, name)==0) {
		memcpy(iface, &dcesrv_unixinfo_interface, sizeof(*iface));
		return true;
	}

	return false;
}

NTSTATUS dcerpc_server_unixinfo_init(TALLOC_CTX *ctx)
{
	NTSTATUS ret;
	static const struct dcesrv_endpoint_server ep_server = {
	    /* fill in our name */
	    .name = "unixinfo",

	    /* Initialization flag */
	    .initialized = false,

	    /* fill in all the operations */
#ifdef DCESRV_INTERFACE_UNIXINFO_INIT_SERVER
	    .init_server = DCESRV_INTERFACE_UNIXINFO_INIT_SERVER,
#else
	    .init_server = unixinfo__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_UNIXINFO_SHUTDOWN_SERVER
	    .shutdown_server = DCESRV_INTERFACE_UNIXINFO_SHUTDOWN_SERVER,
#else
	    .shutdown_server = unixinfo__op_shutdown_server,
#endif
	    .interface_by_uuid = unixinfo__op_interface_by_uuid,
	    .interface_by_name = unixinfo__op_interface_by_name
	};
	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'unixinfo' endpoint server!\n"));
		return ret;
	}

	return ret;
}

