
#line 110 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
// Copyright (C) 2016 The Qt Company Ltd.
// Contact: https://www.qt.io/licensing/
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#include <private/qqmljsengine_p.h>
#include <private/qqmljslexer_p.h>
#include <private/qqmljsast_p.h>
#include <private/qqmljsmemorypool_p.h>

#include <QtCore/qdebug.h>
#include <QtCore/qcoreapplication.h>

#include <string.h>


#line 418 "../../../qtdeclarative/src/qml/parser/qqmljs.g"


#include "qqmljsparser_p.h"

#include <QtCore/qvarlengtharray.h>

//
//  W A R N I N G
//  -------------
//
// This file is automatically generated from qqmljs.g.
// Changes should be made to that file, not here. Any change to this file will
// be lost!
//
// To regenerate this file, run:
//    qlalr --no-debug --no-lines --qt qqmljs.g
//

#define UNIMPLEMENTED syntaxError(loc(1), "Unimplemented"); return false

using namespace QQmlJS;
using namespace Qt::StringLiterals;

QT_BEGIN_NAMESPACE

void Parser::reallocateStack()
{
    if (! stack_size)
        stack_size = 128;
    else
        stack_size <<= 1;

    sym_stack = reinterpret_cast<Value*> (realloc(sym_stack, stack_size * sizeof(Value)));
    state_stack = reinterpret_cast<int*> (realloc(state_stack, stack_size * sizeof(int)));
    location_stack = reinterpret_cast<SourceLocation*> (realloc(location_stack, stack_size * sizeof(SourceLocation)));
    string_stack.resize(stack_size);
    rawString_stack.resize(stack_size);
}

Parser::Parser(Engine *engine):
    driver(engine),
    pool(engine->pool())
{
}

Parser::~Parser()
{
    if (stack_size) {
        free(sym_stack);
        free(state_stack);
        free(location_stack);
    }
}

static inline SourceLocation location(Lexer *lexer)
{
    SourceLocation loc;
    loc.offset = lexer->tokenOffset();
    loc.length = lexer->tokenLength();
    loc.startLine = lexer->tokenStartLine();
    loc.startColumn = lexer->tokenStartColumn();
    return loc;
}

AST::UiQualifiedId *Parser::reparseAsQualifiedId(AST::ExpressionNode *expr)
{
    QVarLengthArray<QStringView, 4> nameIds;
    QVarLengthArray<SourceLocation, 4> locations;
    QVarLengthArray<SourceLocation, 4> dotLocations;

    AST::ExpressionNode *it = expr;
    while (AST::FieldMemberExpression *m = AST::cast<AST::FieldMemberExpression *>(it)) {
        nameIds.append(m->name);
        locations.append(m->identifierToken);
        dotLocations.append(m->dotToken);
        it = m->base;
    }

    if (AST::IdentifierExpression *idExpr = AST::cast<AST::IdentifierExpression *>(it)) {
        AST::UiQualifiedId *q = new (pool) AST::UiQualifiedId(idExpr->name);
        q->identifierToken = idExpr->identifierToken;

        AST::UiQualifiedId *currentId = q;
        for (int i = nameIds.size() - 1; i != -1; --i) {
            currentId = new (pool) AST::UiQualifiedId(currentId, nameIds[i]);
            currentId->identifierToken = locations[i];
            currentId->dotToken = dotLocations[i];
        }

        return currentId->finish();
    }

    return 0;
}

void Parser::pushToken(int token)
{
    Q_ASSERT(last_token);
    Q_ASSERT(last_token < &token_buffer[TOKEN_BUFFER_SIZE]);
    last_token->token = yytoken;
    last_token->dval = yylval;
    last_token->spell = yytokenspell;
    last_token->raw = yytokenraw;
    last_token->loc = yylloc;
    ++last_token;
    yytoken = token;
}

void Parser::pushTokenWithEmptyLocation(int token)
{
    pushToken(token);
    yylloc = yyprevlloc;
    yylloc.offset += yylloc.length;
    yylloc.startColumn += yylloc.length;
    yylloc.length = 0;
}

int Parser::lookaheadToken(Lexer *lexer)
{
    if (yytoken < 0) {
        yyprevtoken = yytoken;
        yytoken = lexer->lex();
        yylval = lexer->tokenValue();
        yytokenspell = lexer->tokenSpell();
        yytokenraw = lexer->rawString();
        yylloc = location(lexer);
    }
    return yytoken;
}

bool Parser::ensureNoFunctionTypeAnnotations(AST::TypeAnnotation *returnValueAnnotation, AST::FormalParameterList *formals)
{
    // Type annotations are allowed everywhere in QML code.
    if (driver->lexer()->qmlMode())
        return true;

    for (auto formal = formals; formal; formal = formal->next) {
        if (formal->element && formal->element->typeAnnotation) {
            syntaxError(formal->element->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in function parameters in JavaScript functions");
            return false;
        }
    }
    if (returnValueAnnotation) {
        syntaxError(returnValueAnnotation->firstSourceLocation(), "Type annotations are not permitted for the return value of JavaScript functions");
        return false;
    }
    return true;
}

//#define PARSER_DEBUG

bool Parser::parse(int startToken)
{
    Lexer *lexer = driver->lexer();

    if (auto diagnosticMessage = lexer->illegalFileLengthError()) {
        diagnostic_messages.append(*diagnosticMessage);
        return false;
    }

    bool hadErrors = false;
    yytoken = -1;
    int action = 0;

    token_buffer[0].token = startToken;
    first_token = &token_buffer[0];
    if (startToken == T_FEED_JS_SCRIPT && !lexer->qmlMode()) {
        Directives ignoreDirectives;
        Directives *directives = driver->directives();
        if (!directives)
            directives = &ignoreDirectives;
        DiagnosticMessage error;
        if (!lexer->scanDirectives(directives, &error)) {
            diagnostic_messages.append(error);
            return false;
        }
        token_buffer[1].token = lexer->tokenKind();
        token_buffer[1].dval = lexer->tokenValue();
        token_buffer[1].loc = location(lexer);
        token_buffer[1].spell = lexer->tokenSpell();
        last_token = &token_buffer[2];
    } else {
        last_token = &token_buffer[1];
    }

    tos = -1;
    program = 0;

    do {
        if (++tos == stack_size)
            reallocateStack();

        state_stack[tos] = action;

    _Lcheck_token:
        if (yytoken == -1 && -TERMINAL_COUNT != action_index[action]) {
            yyprevlloc = yylloc;

            if (first_token == last_token) {
                yytoken = lexer->lex();
                yylval = lexer->tokenValue();
                yytokenspell = lexer->tokenSpell();
                yytokenraw = lexer->rawString();
                yylloc = location(lexer);
            } else {
                yytoken = first_token->token;
                yylval = first_token->dval;
                yytokenspell = first_token->spell;
                yytokenraw = first_token->raw;
                yylloc = first_token->loc;
                ++first_token;
                if (first_token == last_token)
                    first_token = last_token = &token_buffer[0];
            }
        }

#ifdef PARSER_DEBUG
       qDebug() << "   in state" << action;
#endif

        action = t_action(action, yytoken);
#ifdef PARSER_DEBUG
       qDebug() << "   current token" << yytoken << (yytoken >= 0 ? spell[yytoken] : "(null)") << "new state" << action;
#endif
        if (action > 0) {
            if (action != ACCEPT_STATE) {
                yyprevtoken = yytoken;
                yytoken = -1;
                sym(1).dval = yylval;
                stringRef(1) = yytokenspell;
                rawStringRef(1) = yytokenraw;
                loc(1) = yylloc;
            } else {
              --tos;
              return ! hadErrors;
            }
        } else if (action < 0) {
          const int r = -action - 1;
          tos -= rhs[r];

#ifdef PARSER_DEBUG
          qDebug() << "        reducing through rule " << -action;
#endif

          switch (r) {

#line 670 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 0: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 678 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 1: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 686 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 2: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 694 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 3: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 702 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 4: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 710 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 5: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 719 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 6: {
        sym(1).UiProgram = new (pool) AST::UiProgram(sym(1).UiHeaderItemList, sym(2).UiObjectMemberList->finish());
    } break;

#line 727 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 8: {
        sym(1).Node = sym(1).UiHeaderItemList->finish();
    } break;

#line 734 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 9: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiPragma);
    } break;

#line 741 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 10: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiImport);
    } break;

#line 748 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 11: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiPragma);
    } break;

#line 755 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 12: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiImport);
    } break;

#line 769 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 18: {
        AST::UiPragmaValueList *list
            = new (pool) AST::UiPragmaValueList(stringRef(1));
        list->location = loc(1);
        sym(1).Node = list;
    } break;

#line 779 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 19: {
        AST::UiPragmaValueList *list
            = new (pool) AST::UiPragmaValueList(sym(1).UiPragmaValueList, stringRef(3));
        list->location = loc(3);
        sym(1).Node = list;
    } break;

#line 789 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 20: {
        AST::UiPragma *pragma = new (pool) AST::UiPragma(stringRef(2));
        pragma->pragmaToken = loc(1);
        pragma->pragmaIdToken = loc(2);
        pragma->semicolonToken = loc(3);
        sym(1).Node = pragma;
    } break;

#line 800 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 21: {
        AST::UiPragma *pragma = new (pool) AST::UiPragma(
                stringRef(2), sym(4).UiPragmaValueList->finish());
        pragma->pragmaToken = loc(1);
        pragma->pragmaIdToken = loc(2);
        pragma->colonToken = loc(3);
        pragma->semicolonToken = loc(5);
        sym(1).Node = pragma;
    } break;

#line 815 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 23: {
        sym(1).UiImport->semicolonToken = loc(2);
    } break;

#line 822 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 24: {
        const int major = sym(1).dval;
        const int minor = sym(3).dval;
        if (!QTypeRevision::isValidSegment(major) || !QTypeRevision::isValidSegment(minor)) {
            diagnostic_messages.append(
                    compileError(loc(1),
                    QLatin1String("Invalid version. Version numbers must be >= 0 and < 255.")));
            return false;
        }
        auto version = new (pool) AST::UiVersionSpecifier(major, minor);
        version->majorToken = loc(1);
        version->minorToken = loc(3);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 841 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 25: {
        const int major = sym(1).dval;
        if (!QTypeRevision::isValidSegment(major)) {
            diagnostic_messages.append(
                    compileError(loc(1),
                    QLatin1String("Invalid major version. Version numbers must be >= 0 and < 255.")));
            return false;
        }
        auto version = new (pool) AST::UiVersionSpecifier(sym(1).dval);
        version->majorToken = loc(1);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 857 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 26: {
        sym(1).UiImport->version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->semicolonToken = loc(3);
    } break;

#line 865 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 27: {
        sym(1).UiImport->version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->asToken = loc(3);
        sym(1).UiImport->importIdToken = loc(4);
        sym(1).UiImport->importId = stringRef(4);
        sym(1).UiImport->semicolonToken = loc(5);
    } break;

#line 876 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 28: {
        sym(1).UiImport->asToken = loc(2);
        sym(1).UiImport->importIdToken = loc(3);
        sym(1).UiImport->importId = stringRef(3);
        sym(1).UiImport->semicolonToken = loc(4);
    } break;

#line 886 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 29: {
        AST::UiImport *node = 0;

        if (AST::StringLiteral *importIdLiteral = AST::cast<AST::StringLiteral *>(sym(2).Expression)) {
            node = new (pool) AST::UiImport(importIdLiteral->value);
            node->fileNameToken = loc(2);
        } else if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(2).Expression)) {
            node = new (pool) AST::UiImport(qualifiedId);
            node->fileNameToken = loc(2);
        }

        sym(1).Node = node;

        if (node) {
            node->importToken = loc(1);
        } else {
            diagnostic_messages.append(compileError(loc(1),
             QLatin1String("Expected a qualified name id or a string literal")));

            return false; // ### remove me
        }
    } break;

#line 912 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 30: {
        sym(1).Node = nullptr;
    } break;

#line 919 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 31: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 926 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 32: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 935 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 33: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 945 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 34: {
        if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
            sym(1).UiQualifiedId = qualifiedId;
        } else {
            sym(1).UiQualifiedId = 0;

            diagnostic_messages.append(compileError(loc(1),
            QLatin1String("Expected a qualified name id")));

            return false;
        }
        AST::UiAnnotation *node = new (pool) AST::UiAnnotation(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 963 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

case 35: {
    sym(1).Node = sym(2).Node;
} break;

#line 971 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 36: {
        sym(1).Node = new (pool) AST::UiAnnotationList(sym(1).UiAnnotation);
    } break;

#line 978 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 37: {
        AST::UiAnnotationList *node = new (pool) AST::UiAnnotationList(sym(1).UiAnnotationList, sym(2).UiAnnotation);
        sym(1).Node = node;
    } break;

#line 986 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

   case 38: {
       AST::UiObjectDefinition *node = sym(2).UiObjectDefinition;
       node->annotations = sym(1).UiAnnotationList->finish();
       sym(1).Node = node;
   } break;

#line 997 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 40: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 1004 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 41: {
        AST::UiObjectMemberList *node = new (pool) AST:: UiObjectMemberList(sym(1).UiObjectMemberList, sym(2).UiObjectMember);
        sym(1).Node = node;
    } break;

#line 1012 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 42: {
        sym(1).Node = new (pool) AST::UiArrayMemberList(sym(1).UiObjectMember);
    } break;

#line 1019 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 43: {
        AST::UiArrayMemberList *node = new (pool) AST::UiArrayMemberList(sym(1).UiArrayMemberList, sym(3).UiObjectMember);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1028 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 44: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer((AST::UiObjectMemberList*)0);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1038 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 45: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer(sym(2).UiObjectMemberList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1048 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 46: {
        AST::UiObjectDefinition *node = new (pool) AST::UiObjectDefinition(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 1056 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

   case 47: {
       AST::UiObjectMember *node = sym(2).UiObjectMember;
       node->annotations = sym(1).UiAnnotationList->finish();
       sym(1).Node = sym(2).Node;
   } break;

#line 1072 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 52: {
        AST::UiArrayBinding *node = new (pool) AST::UiArrayBinding(sym(1).UiQualifiedId, sym(5).UiArrayMemberList->finish());
        node->colonToken = loc(2);
        node->lbracketToken = loc(4);
        node->rbracketToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1083 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 53: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
            sym(1).UiQualifiedId, sym(4).UiQualifiedId, sym(5).UiObjectInitializer);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1093 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 54: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
          sym(3).UiQualifiedId, sym(1).UiQualifiedId, sym(4).UiObjectInitializer);
        node->colonToken = loc(2);
        node->hasOnToken = true;
        sym(1).Node = node;
    } break;

#line 1105 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 55: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(4);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        node->semicolonToken = loc(5);
        sym(1).Node = node;
    } break;

#line 1118 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 56: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(5);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1131 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 57: Q_FALLTHROUGH(); 
#line 1133 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 58: Q_FALLTHROUGH(); 
#line 1135 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 59: {
        sym(1).Node = sym(3).Node;
    } break;

#line 1143 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 60: Q_FALLTHROUGH(); 
#line 1145 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 61: Q_FALLTHROUGH(); 
#line 1147 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 62: Q_FALLTHROUGH(); 
#line 1149 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 63: Q_FALLTHROUGH(); 
#line 1151 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 64: Q_FALLTHROUGH(); 
#line 1153 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 65: {
        sym(1).Node = sym(2).Node;
    } break;

#line 1160 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

case 66:
{
    AST::UiScriptBinding *node = new (pool) AST::UiScriptBinding(sym(1).UiQualifiedId, sym(3).Statement);
    node->colonToken = loc(2);
    sym(1).Node = node;
    } break;

#line 1170 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 67: {
    if (!m_incompleteBindingsEnabled) {
        diagnostic_messages.append(compileError(loc(1), QLatin1String("Incomplete binding, expected token `:` or `{`")));
        return false;
    }
    AST::EmptyStatement *statement = new (pool) AST::EmptyStatement;
    statement->semicolonToken = loc(2);
    AST::UiScriptBinding *node = new (pool) AST::UiScriptBinding(sym(1).UiQualifiedId, statement);
    sym(1).Node = node;
    } break;

#line 1184 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 68: Q_FALLTHROUGH(); 
#line 1186 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 69: Q_FALLTHROUGH(); 
#line 1188 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 70: Q_FALLTHROUGH(); 
#line 1190 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 71: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1199 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 72: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(sym(1).UiQualifiedId, stringRef(3));
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1208 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 73: {
        sym(1).Node = nullptr;
    } break;

#line 1215 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 74: {
        sym(1).Node = sym(1).UiParameterList->finish();
    } break;

#line 1222 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 75: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(3).Type, stringRef(1));
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        node->propertyTypeToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1233 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 76: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).Type, stringRef(2));
        node->propertyTypeToken = loc(1);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1243 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 77: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(5).Type, stringRef(3));
        node->propertyTypeToken = loc(5);
        node->commaToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1255 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 78: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(3).Type, stringRef(4));
        node->propertyTypeToken = loc(3);
        node->commaToken = loc(2);
        node->identifierToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1266 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 79: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->setPropertyToken(loc(1));
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->parameters = sym(4).UiParameterList;
        node->rparenToken = loc(5);
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1282 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 80: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->setPropertyToken(loc(1));
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1309 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 85: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isRequired())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'required' attribute is not allowed."), QtCriticalMsg));
        node->m_requiredToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1320 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 86: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isDefaultMember())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'default' attribute is not allowed."), QtCriticalMsg));
        node->m_defaultToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1331 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 87: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isReadonly())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'readonly' attribute is not allowed."), QtCriticalMsg));
        node->m_readonlyToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1342 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 88: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isFinal())
            diagnostic_messages.append(compileError(node->finalToken(), QLatin1String("Duplicated 'final' attribute is not allowed."), QtCriticalMsg));
        node->m_finalToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1353 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 89: {
        AST::UiPropertyAttributes *node = new (pool) AST::UiPropertyAttributes();
        node->m_propertyToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1362 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 90: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        auto attributes = sym(1).UiPropertyAttributes;
        node->setAttributes(attributes);
        if (attributes->isReadonly())
            diagnostic_messages.append(compileError(attributes->readonlyToken(), QLatin1String("Read-only properties require an initializer."), QtWarningMsg));
        node->typeModifier = stringRef(2);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1381 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 92: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isReadonly())
            diagnostic_messages.append(compileError(attributes->readonlyToken(), QLatin1String("Read-only properties require an initializer."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1399 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

/* we need OptionalSemicolon because UiScriptStatement might already parse the last semicolon
  and then we would miss a semicolon (see tests/auto/quick/qquickvisualdatamodel/data/objectlist.qml)*/
 
#line 1405 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 96: {
        AST::UiRequired *node = new (pool) AST::UiRequired(stringRef(2));
        node->requiredToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1417 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 98: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3), sym(5).Statement);
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1432 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 99: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6), sym(8).Statement);
        node->typeModifier = stringRef(2);
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->colonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1451 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 101: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeModifier = stringRef(2);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7); // insert a fake ';' before ':'
        node->colonToken = loc(7);

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(6));
        propertyName->identifierToken = loc(6);
        propertyName->next = nullptr;

        AST::UiArrayBinding *binding = new (pool) AST::UiArrayBinding(propertyName, sym(10).UiArrayMemberList->finish());
        binding->colonToken = loc(7);
        binding->lbracketToken = loc(9);
        binding->rbracketToken = loc(12);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1483 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 103: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtWarningMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4); // insert a fake ';' before ':'
        node->colonToken = loc(4);

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(3));
        propertyName->identifierToken = loc(3);
        propertyName->next = nullptr;

        AST::UiObjectBinding *binding = new (pool) AST::UiObjectBinding(
          propertyName, sym(6).UiQualifiedId, sym(7).UiObjectInitializer);
        binding->colonToken = loc(4);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1512 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 105: {
        auto node = new (pool) AST::UiSourceElement(sym(1).Node);
        sym(1).Node = node;
    } break;

#line 1520 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 106: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1527 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 107: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1534 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 108: {
      if (AST::ArrayMemberExpression *mem = AST::cast<AST::ArrayMemberExpression *>(sym(1).Expression)) {
        diagnostic_messages.append(compileError(mem->lbracketToken,
          QLatin1String("Ignored annotation"), QtWarningMsg));

        sym(1).Expression = mem->base;
      }

      if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
        sym(1).UiQualifiedId = qualifiedId;
      } else {
        sym(1).UiQualifiedId = 0;

        diagnostic_messages.append(compileError(loc(1),
          QLatin1String("Expected a qualified name id")));

        return false; // ### recover
      }
    } break;

#line 1557 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 109: {
        AST::UiEnumDeclaration *enumDeclaration = new (pool) AST::UiEnumDeclaration(stringRef(2), sym(4).UiEnumMemberList->finish());
        enumDeclaration->enumToken = loc(1);
        enumDeclaration->identifierToken = loc(2);
        enumDeclaration->lbraceToken = loc(3);
        enumDeclaration->rbraceToken = loc(5);
        sym(1).Node = enumDeclaration;
        break;
    }

#line 1570 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 110: {
        if (!stringRef(2).front().isUpper()) {
            diagnostic_messages.append(compileError(loc(2),
                QLatin1String("Type name must be upper case"), QtWarningMsg));
        }
        auto inlineComponent = new (pool) AST::UiInlineComponent(stringRef(2), sym(4).UiObjectDefinition);
        inlineComponent->componentToken = loc(1);
        inlineComponent->identifierToken = loc(2);
        sym(1).Node = inlineComponent;
    } break;

#line 1584 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 111: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1));
        node->memberToken = loc(1);
        sym(1).Node = node;
        break;
    }

#line 1594 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 112: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1), sym(3).dval);
        node->memberToken = loc(1);
        node->valueToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1606 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 113: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1), -sym(4).dval);
        node->memberToken = loc(1);
        node->valueToken = combine(loc(3), loc(4));
        sym(1).Node = node;
        break;
    }

#line 1617 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 114: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3));
        node->commaToken = loc(2);
        node->memberToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1628 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 115: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3), sym(5).dval);
        node->commaToken = loc(2);
        node->memberToken = loc(3);
        node->equalToken = loc(4);
        node->valueToken = loc(5);
        sym(1).Node = node;
        break;
    }

#line 1642 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 116: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3), -sym(6).dval);
        node->commaToken = loc(2);
        node->memberToken = loc(3);
        node->equalToken = loc(4);
        node->valueToken = combine(loc(5), loc(6));
        sym(1).Node = node;
        break;
    }

#line 1688 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 143: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId, sym(3).Type);
        sym(1).Type->lAngleBracketToken = loc(2);
        sym(1).Type->rAngleBracketToken = loc(4);
    } break;

#line 1699 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 145: Q_FALLTHROUGH(); 
#line 1701 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 146: Q_FALLTHROUGH(); 
#line 1703 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 147: Q_FALLTHROUGH(); 
#line 1705 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 148: {
        AST::UiQualifiedId *id = new (pool) AST::UiQualifiedId(stringRef(1));
        id->identifierToken = loc(1);
        sym(1).Type = new (pool) AST::Type(id->finish());
    } break;

#line 1714 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 149: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId);
    } break;

#line 1721 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 150: {
        sym(1).TypeAnnotation = new (pool) AST::TypeAnnotation(sym(2).Type);
        sym(1).TypeAnnotation->colonToken = loc(1);
    } break;

#line 1730 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 152: {
        sym(1).TypeAnnotation = nullptr;
    } break;

#line 1741 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 153: {
        AST::ThisExpression *node = new (pool) AST::ThisExpression();
        node->thisToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1750 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 154: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1768 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 163: {
        if (coverExpressionType != CE_ParenthesizedExpression) {
            syntaxError(coverExpressionErrorLocation, "Expected token ')'.");
            return false;
        }
    } break;

#line 1779 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 164: {
        AST::NestedExpression *node = new (pool) AST::NestedExpression(sym(2).Expression);
        node->lparenToken = loc(1);
        node->rparenToken = loc(3);
        sym(1).Node = node;
        coverExpressionType = CE_ParenthesizedExpression;
    } break;

#line 1790 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 165: {
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), nullptr, nullptr);
        f->functionToken = loc(1).startZeroLengthLocation();
        f->lparenToken = loc(1);
        f->rparenToken = loc(2);
        sym(1).Node = f;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1803 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 166: {
        AST::FormalParameterList *list = (new (pool) AST::FormalParameterList(nullptr, sym(2).PatternElement))->finish(pool);
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), list, nullptr);
        f->functionToken = loc(1).startZeroLengthLocation();
        f->lparenToken = loc(1);
        f->rparenToken = loc(3);
        sym(1).FunctionExpression = f;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1817 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 167: {
        AST::FormalParameterList *list = sym(2).Expression->reparseAsFormalParameterList(pool);
        if (!list) {
            syntaxError(loc(1), "Invalid Arrow parameter list.");
            return false;
        }
        list->commaToken = loc(3);
        if (sym(4).Node) {
            list = new (pool) AST::FormalParameterList(list, sym(4).PatternElement);
        }

        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), list->finish(pool), nullptr);
        f->functionToken = loc(1).startZeroLengthLocation();
        f->lparenToken = loc(1);
        f->rparenToken = loc(5);
        coverExpressionErrorLocation = loc(4);
        coverExpressionType = CE_FormalParameterList;
        sym(1).FunctionExpression = f;
    } break;

#line 1840 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 168: {
        AST::NullExpression *node = new (pool) AST::NullExpression();
        node->nullToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1849 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 169: {
        AST::TrueLiteral *node = new (pool) AST::TrueLiteral();
        node->trueToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1858 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 170: {
        AST::FalseLiteral *node = new (pool) AST::FalseLiteral();
        node->falseToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1867 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 171: {
        AST::NumericLiteral *node = new (pool) AST::NumericLiteral(sym(1).dval);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1876 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 172: Q_FALLTHROUGH(); 
#line 1879 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 173: {
        AST::StringLiteral *node = new (pool) AST::StringLiteral(stringRef(1));
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1891 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

{
    Lexer::RegExpBodyPrefix prefix;
    case 174:
        prefix = Lexer::NoPrefix;
        goto scan_regexp;

#line 1903 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 175:
        prefix = Lexer::EqualPrefix;
        goto scan_regexp;

    scan_regexp: {
        bool rx = lexer->scanRegExp(prefix);
        if (!rx) {
            diagnostic_messages.append(compileError(location(lexer), lexer->errorMessage()));
            return false;
        }

        loc(1).length = lexer->tokenLength();
        yylloc = loc(1); // adjust the location of the current token

        AST::RegExpLiteral *node = new (pool) AST::RegExpLiteral(driver->newStringRef(lexer->regExpPattern()), lexer->regExpFlags());
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;
}

#line 1927 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 176: {
        AST::PatternElementList *list = nullptr;
        if (sym(2).Elision)
            list = (new (pool) AST::PatternElementList(sym(2).Elision, nullptr))->finish();
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1940 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 177: {
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList->finish());
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1950 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 178: {
        auto *list = sym(2).PatternElementList;
        if (sym(4).Elision) {
            AST::PatternElementList *l = new (pool) AST::PatternElementList(sym(4).Elision, nullptr);
            list = list->append(l);
        }
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list->finish());
        node->lbracketToken = loc(1);
        node->commaToken = loc(3);
        node->rbracketToken = loc(5);
        sym(1).Node = node;
        Q_ASSERT(node->isValidArrayLiteral());
    } break;

#line 1967 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 179: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(1).Expression);
        sym(1).Node = new (pool) AST::PatternElementList(nullptr, e);
    } break;

#line 1975 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 180: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(2).Expression);
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision->finish(), e);
    } break;

#line 1983 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 181: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
        sym(1).Node = node;
    } break;

#line 1991 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 182: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(4).Expression);
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, e);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 2000 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 183: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 2008 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 184: {
        AST::Elision *node = new (pool) AST::Elision();
        node->commaToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2017 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 185: {
        AST::Elision *node = new (pool) AST::Elision(sym(1).Elision);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2026 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 186: {
        sym(1).Node = nullptr;
    } break;

#line 2033 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 187: {
        sym(1).Node = sym(1).Elision->finish();
    } break;

#line 2040 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 188: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Expression, AST::PatternElement::SpreadElement);
        sym(1).Node = node;
    } break;

#line 2048 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 189: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern();
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2058 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 190: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2068 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 191: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2079 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 192: Q_FALLTHROUGH(); 
#line 2081 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 193: {
      sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 2088 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 194: Q_FALLTHROUGH(); 
#line 2090 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 195: {
        AST::PatternPropertyList *node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
        sym(1).Node = node;
    } break;

#line 2098 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 196: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *expr = new (pool) AST::IdentifierExpression(stringRef(1));
        expr->identifierToken = loc(1);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, expr);
        sym(1).Node = node;
    } break;

#line 2113 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 198: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *left = new (pool) AST::IdentifierExpression(stringRef(1));
        left->identifierToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        AST::BinaryExpression *assignment = new (pool) AST::BinaryExpression(left, QSOperator::Assign, sym(2).Expression);
        assignment->operatorToken = loc(2);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, assignment);
        sym(1).Node = node;

    } break;

#line 2133 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 199: Q_FALLTHROUGH(); 
#line 2135 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 200: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Expression);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (!AST::cast<AST::ComputedPropertyName *>(sym(1).PropertyName))
                c->name = driver->newStringRef(sym(1).PropertyName->asString());
        }
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2153 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 204: {
        AST::IdentifierPropertyName *node = new (pool) AST::IdentifierPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2162 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 205: Q_FALLTHROUGH(); 
#line 2164 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 206: {
        AST::StringLiteralPropertyName *node = new (pool) AST::StringLiteralPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2173 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 207: Q_FALLTHROUGH(); 
#line 2175 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 208: {
        AST::NumericLiteralPropertyName *node = new (pool) AST::NumericLiteralPropertyName(sym(1).dval);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2227 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 250: {
        AST::ComputedPropertyName *node = new (pool) AST::ComputedPropertyName(sym(2).Expression);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2236 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 251: Q_FALLTHROUGH(); 
#line 2238 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

case 252: {
    auto node = new (pool) AST::InitializerExpression(sym(2).Expression);
    node->equalToken = loc(1);
    sym(1).Expression = node;
} break;

#line 2248 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 253: Q_FALLTHROUGH(); 
#line 2250 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 254: {
        sym(1).Node = nullptr;
    } break;

#line 2260 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 257: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        node->hasNoSubstitution = true;
        sym(1).Node = node;
    } break;

#line 2270 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 258: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2279 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 259: Q_FALLTHROUGH(); 
#line 2282 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 260: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), sym(2).Expression);
        node->next = sym(3).Template;
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2295 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 262: {
        AST::SuperLiteral *node = new (pool) AST::SuperLiteral();
        node->superToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2305 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 263: Q_FALLTHROUGH(); 
#line 2307 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 264: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2316 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 265: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(4).Expression);
        node->optionalToken = loc(2);
        node->lbracketToken = loc(3);
        node->rbracketToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2329 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 266:
    {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken= loc(1);
        sym(1).Node = node;
    } Q_FALLTHROUGH();

#line 2337 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 267: Q_FALLTHROUGH(); 
#line 2339 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 268: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2349 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 269: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2362 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 271: {
        AST::NewMemberExpression *node = new (pool) AST::NewMemberExpression(sym(2).Expression, sym(4).ArgumentList);
        node->newToken = loc(1);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        sym(1).Node = node;
    } break;

#line 2378 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 274: {
        AST::NewExpression *node = new (pool) AST::NewExpression(sym(2).Expression);
        node->newToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2388 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 275: Q_FALLTHROUGH(); 
#line 2390 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 276: {
        AST::TaggedTemplate *node = new (pool) AST::TaggedTemplate(sym(1).Expression, sym(2).Template);
        sym(1).Node = node;
    } break;

#line 2398 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 277: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2408 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 278: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(4).ArgumentList);
        node->optionalToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2420 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 279: Q_FALLTHROUGH(); 
#line 2422 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 280: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2432 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 281: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(4).ArgumentList);
        node->optionalToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2445 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 282: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2455 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 283: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(4).Expression);
        node->optionalToken = loc(2);
        node->lbracketToken = loc(3);
        node->rbracketToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2467 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 284: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2477 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 285: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2488 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 286: {
        sym(1).Node = nullptr;
    } break;

#line 2495 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 287: Q_FALLTHROUGH(); 
#line 2497 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 288: {
        sym(1).Node = sym(1).ArgumentList->finish();
    } break;

#line 2504 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 289: {
        sym(1).Node = new (pool) AST::ArgumentList(sym(1).Expression);
    } break;

#line 2511 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 290: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(2).Expression);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2520 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 291: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(3).Expression);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2529 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 292: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(4).Expression);
        node->commaToken = loc(2);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2544 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 296: {
        AST::PostIncrementExpression *node = new (pool) AST::PostIncrementExpression(sym(1).Expression);
        node->incrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2553 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 297: {
        AST::PostDecrementExpression *node = new (pool) AST::PostDecrementExpression(sym(1).Expression);
        node->decrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2562 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 298: {
        AST::PreIncrementExpression *node = new (pool) AST::PreIncrementExpression(sym(2).Expression);
        node->incrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2571 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 299: {
        AST::PreDecrementExpression *node = new (pool) AST::PreDecrementExpression(sym(2).Expression);
        node->decrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2582 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 301: {
        AST::DeleteExpression *node = new (pool) AST::DeleteExpression(sym(2).Expression);
        node->deleteToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2591 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 302: {
        AST::VoidExpression *node = new (pool) AST::VoidExpression(sym(2).Expression);
        node->voidToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2600 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 303: {
        AST::TypeOfExpression *node = new (pool) AST::TypeOfExpression(sym(2).Expression);
        node->typeofToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2609 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 304: {
        AST::UnaryPlusExpression *node = new (pool) AST::UnaryPlusExpression(sym(2).Expression);
        node->plusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2618 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 305: {
        AST::UnaryMinusExpression *node = new (pool) AST::UnaryMinusExpression(sym(2).Expression);
        node->minusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2627 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 306: {
        AST::TildeExpression *node = new (pool) AST::TildeExpression(sym(2).Expression);
        node->tildeToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2636 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 307: {
        AST::NotExpression *node = new (pool) AST::NotExpression(sym(2).Expression);
        node->notToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2647 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 309: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Exp, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2658 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 311: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2667 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 312: {
        sym(1).ival = QSOperator::Mul;
    } break;

#line 2674 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 313: {
        sym(1).ival = QSOperator::Div;
    } break;

#line 2681 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 314: {
        sym(1).ival = QSOperator::Mod;
    } break;

#line 2690 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 316: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Add, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2699 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 317: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Sub, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2710 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 319: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::LShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2719 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 320: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::RShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2728 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 321: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::URShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2740 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 324: Q_FALLTHROUGH(); 
#line 2742 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 325: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2751 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 326: {
        sym(1).ival = QSOperator::Lt;
    } break;

#line 2757 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 327: {
        sym(1).ival = QSOperator::Gt;
    } break;

#line 2763 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 328: {
        sym(1).ival = QSOperator::Le;
    } break;

#line 2769 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 329: {
        sym(1).ival = QSOperator::Ge;
    } break;

#line 2775 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 330: {
        sym(1).ival = QSOperator::InstanceOf;
    } break;

#line 2781 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 331: {
        sym(1).ival = QSOperator::As;
    } break;

#line 2788 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 332: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::In, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2800 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 335: Q_FALLTHROUGH(); 
#line 2802 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 336: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2811 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 337: {
        sym(1).ival = QSOperator::Equal;
    } break;

#line 2817 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 338: {
        sym(1).ival = QSOperator::NotEqual;
    } break;

#line 2823 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 339: {
        sym(1).ival = QSOperator::StrictEqual;
    } break;

#line 2829 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 340: {
        sym(1).ival = QSOperator::StrictNotEqual;
    } break;

#line 2840 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 343: Q_FALLTHROUGH(); 
#line 2842 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 344: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitAnd, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2855 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 347: Q_FALLTHROUGH(); 
#line 2857 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 348: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitXor, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2869 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 351: Q_FALLTHROUGH(); 
#line 2871 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 352: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitOr, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2883 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 355: Q_FALLTHROUGH(); 
#line 2885 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 356: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::And, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2897 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 359: Q_FALLTHROUGH(); 
#line 2899 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 360: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Or, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2911 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 363: Q_FALLTHROUGH(); 
#line 2913 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 364: {

        auto *lhs = sym(1).Expression;
        auto *rhs = sym(3).Expression;

        // Check if lhs or rhs contain || or &&

        if (lhs->binaryExpressionCast() != nullptr) {
            auto *binaryExpr = lhs->binaryExpressionCast();
            if (binaryExpr->op == QSOperator::And || binaryExpr->op == QSOperator::Or) {
                syntaxError(binaryExpr->operatorToken, "Left-hand side may not contain || or &&");
                return false;
            }
        }

        if (rhs->binaryExpressionCast() != nullptr) {
            auto *binaryExpr = rhs->binaryExpressionCast();
            if (binaryExpr->op == QSOperator::And || binaryExpr->op == QSOperator::Or) {
                syntaxError(binaryExpr->operatorToken, "Right-hand side may not contain || or &&");
                return false;
            }
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(lhs, QSOperator::Coalesce, rhs);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2947 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 367: Q_FALLTHROUGH(); 
#line 2949 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 368: {
        AST::ConditionalExpression *node = new (pool) AST::ConditionalExpression(sym(1).Expression, sym(3).Expression, sym(5).Expression);
        node->questionToken = loc(2);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2968 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 375: Q_FALLTHROUGH(); 
#line 2970 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 376: {
        if (sym(1).Expression->containsOptionalChain()) {
            syntaxError(loc(1), QStringLiteral("Optional chains are not permitted on the left-hand-side in assignments"));
        }
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(1).Expression->patternCast()) {
            SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                f->name = id->name;
        }
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                c->name = id->name;
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Assign, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3001 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 377: Q_FALLTHROUGH(); 
#line 3003 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 378: {
        if (sym(1).Expression->containsOptionalChain()) {
            syntaxError(loc(1), QStringLiteral("Optional chains are not permitted on the left-hand-side in assignments"));
        }
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3015 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 379: {
        sym(1).ival = QSOperator::InplaceMul;
    } break;

#line 3022 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 380: {
        sym(1).ival = QSOperator::InplaceExp;
    } break;

#line 3029 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 381: {
        sym(1).ival = QSOperator::InplaceDiv;
    } break;

#line 3036 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 382: {
        sym(1).ival = QSOperator::InplaceMod;
    } break;

#line 3043 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 383: {
        sym(1).ival = QSOperator::InplaceAdd;
    } break;

#line 3050 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 384: {
        sym(1).ival = QSOperator::InplaceSub;
    } break;

#line 3057 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 385: {
        sym(1).ival = QSOperator::InplaceLeftShift;
    } break;

#line 3064 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 386: {
        sym(1).ival = QSOperator::InplaceRightShift;
    } break;

#line 3071 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 387: {
        sym(1).ival = QSOperator::InplaceURightShift;
    } break;

#line 3078 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 388: {
        sym(1).ival = QSOperator::InplaceAnd;
    } break;

#line 3085 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 389: {
        sym(1).ival = QSOperator::InplaceXor;
    } break;

#line 3092 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 390: {
        sym(1).ival = QSOperator::InplaceOr;
    } break;

#line 3102 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 393: Q_FALLTHROUGH(); 
#line 3104 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 394: {
          AST::CommaExpression *node
                = new (pool) AST::CommaExpression(sym(1).Expression, sym(3).Expression);
          node->commaToken = loc(2);
          sym(1).Node = node;
    } break;

#line 3114 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 395: Q_FALLTHROUGH(); 
#line 3116 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 396: {
      sym(1).Node = nullptr;
    } break;

#line 3128 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 399: {
        sym(1).Node = sym(3).Node;
    } break;

#line 3135 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 400: Q_FALLTHROUGH(); 
#line 3137 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 401: Q_FALLTHROUGH(); 
#line 3139 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 402: Q_FALLTHROUGH(); 
#line 3141 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 403: Q_FALLTHROUGH(); 
#line 3143 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 404: Q_FALLTHROUGH(); 
#line 3145 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 405: Q_FALLTHROUGH(); 
#line 3147 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 406: Q_FALLTHROUGH(); 
#line 3149 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 407: Q_FALLTHROUGH(); 
#line 3151 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 408: Q_FALLTHROUGH(); 
#line 3153 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 409: Q_FALLTHROUGH(); 
#line 3155 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 410: Q_FALLTHROUGH(); 
#line 3157 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 411: Q_FALLTHROUGH(); 
#line 3159 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 412: {
        sym(1).Node = sym(2).Node;
    } break;

#line 3181 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 423: {
        AST::Block *node = new (pool) AST::Block(sym(2).StatementList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3193 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 425: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 3200 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 426: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Statement);
    } break;

#line 3207 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 427: {
        sym(1).Node = new (pool) AST::StatementList(sym(3).FunctionDeclaration);
    } break;

#line 3214 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 428: {
        sym(1).Node = nullptr;
    } break;

#line 3221 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 429: {
        sym(1).Node = sym(1).StatementList->finish();
    } break;

#line 3228 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 430: {
        sym(1).scope = AST::VariableScope::Let;
    } break;

#line 3234 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 431: {
        sym(1).scope = AST::VariableScope::Const;
    } break;

#line 3241 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 432: {
        sym(1).scope = AST::VariableScope::Var;
    } break;

#line 3248 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 433: Q_FALLTHROUGH(); 
#line 3250 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 434: Q_FALLTHROUGH(); 
#line 3252 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 435: Q_FALLTHROUGH(); 
#line 3254 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 436: {
        AST::VariableDeclarationList *declarations = sym(2).VariableDeclarationList->finish(sym(1).scope);
        for (auto it = declarations; it; it = it->next) {
            if (it->declaration && it->declaration->typeAnnotation) {
                syntaxError(it->declaration->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
                return false;
            }
        }
        AST::VariableStatement *node = new (pool) AST::VariableStatement(declarations);
        node->declarationKindToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3272 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 438: Q_FALLTHROUGH(); 
#line 3274 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 439: Q_FALLTHROUGH(); 
#line 3276 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 440: Q_FALLTHROUGH(); 
#line 3278 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 441: {
  sym(1).Node = new (pool) AST::VariableDeclarationList(sym(1).PatternElement);
    } break;

#line 3285 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 442: Q_FALLTHROUGH(); 
#line 3287 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 443: Q_FALLTHROUGH(); 
#line 3289 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 444: Q_FALLTHROUGH(); 
#line 3291 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 445: {
        AST::VariableDeclarationList *node = new (pool) AST::VariableDeclarationList(sym(1).VariableDeclarationList, sym(3).PatternElement);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3300 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 446: Q_FALLTHROUGH(); 
#line 3302 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 447: Q_FALLTHROUGH(); 
#line 3304 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 448: Q_FALLTHROUGH(); 
#line 3306 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 449: {
        auto *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
            c->name = stringRef(1);
    } break;

#line 3320 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 450: Q_FALLTHROUGH(); 
#line 3322 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 451: Q_FALLTHROUGH(); 
#line 3324 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 452: Q_FALLTHROUGH(); 
#line 3326 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 453: {
        auto *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3335 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 454: {
        auto *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3346 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 455: {
        auto *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3357 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 456: {
        sym(1).Node = nullptr;
    } break;

#line 3364 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
 case 457: 
#line 3366 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 458: {
        sym(1).Node = sym(1).PatternPropertyList->finish();
    } break;

#line 3373 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 459: {
        if (sym(1).Elision || sym(2).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
            sym(1).Node = l->finish();
        } else {
            sym(1).Node = nullptr;
        }
    } break;

#line 3385 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 460: {
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3392 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 461: {
        if (sym(3).Elision || sym(4).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
            l = sym(1).PatternElementList->append(l);
            sym(1).Node = l;
        }
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3404 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 462: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 3411 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 463: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
    } break;

#line 3420 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 465: {
        sym(1).PatternElementList = sym(1).PatternElementList->append(sym(3).PatternElementList);
    } break;

#line 3427 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 466: {
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
    } break;

#line 3435 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 467: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, stringRef(1), sym(2).Expression);
        sym(1).Node = node;
    } break;

#line 3450 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 468: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, stringRef(3), sym(4).Expression);
        node->colonToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3460 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 469: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Pattern, sym(4).Expression);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3469 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 470: {
      AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
      node->identifierToken = loc(1);
      // if initializer is an anonymous function expression, we need to assign identifierref as it's name
      if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
          f->name = stringRef(1);
      if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
          c->name = stringRef(1);
      sym(1).Node = node;
    } break;

#line 3483 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 471: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        sym(1).Node = node;
    } break;

#line 3491 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 472: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(2), /*type annotation*/nullptr, nullptr, AST::PatternElement::RestElement);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3500 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 473: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr, AST::PatternElement::RestElement);
        sym(1).Node = node;
    } break;

#line 3508 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 474: {
        sym(1).Node = nullptr;
    } break;

#line 3518 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 476: {
        AST::EmptyStatement *node = new (pool) AST::EmptyStatement();
        node->semicolonToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3533 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 477: {
        int token = lookaheadToken(lexer);
        if (token == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
        else if (token == T_FUNCTION || token == T_CLASS || token == T_LET || token == T_CONST)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 3544 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 478: {
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(sym(1).Expression);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3553 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 479: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement, sym(7).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->elseToken = loc(6);
        sym(1).Node = node;
    } break;

#line 3565 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 480: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3578 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 482: {
        AST::DoWhileStatement *node = new (pool) AST::DoWhileStatement(sym(2).Statement, sym(5).Expression);
        node->doToken = loc(1);
        node->whileToken = loc(3);
        node->lparenToken = loc(4);
        node->rparenToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 3591 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 483: {
        AST::WhileStatement *node = new (pool) AST::WhileStatement(sym(3).Expression, sym(5).Statement);
        node->whileToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3602 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 484: {
        AST::ForStatement *node = new (pool) AST::ForStatement(sym(3).Expression, sym(5).Expression, sym(7).Expression, sym(9).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3615 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 485: Q_FALLTHROUGH(); 
#line 3617 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 486: {
        // ### get rid of the static_cast!
        AST::ForStatement *node = new (pool) AST::ForStatement(
          static_cast<AST::VariableStatement *>(sym(3).Node)->declarations, sym(5).Expression,
          sym(7).Expression, sym(9).Statement);
        if (node->declarations) {
            AST::PatternElement *pe = node->declarations->declaration;
            pe->isForDeclaration = true;
            pe->declarationKindToken = loc(3);
        }
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3638 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 487: {
        sym(1).forEachType = AST::ForEachType::In;
    } break;

#line 3645 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 488: {
        sym(1).forEachType = AST::ForEachType::Of;
    } break;

#line 3652 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 489: {
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(3).Expression->patternCast()) {
            SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).Expression, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3674 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 490: {
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).PatternElement, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3687 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 491: Q_FALLTHROUGH(); 
#line 3689 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 492: {
        if (auto typeAnnotation = sym(3).TypeAnnotation) {
            syntaxError(typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
            return false;
        }
        auto *node = new (pool) AST::PatternElement(stringRef(2), sym(3).TypeAnnotation, nullptr);
        node->identifierToken = loc(2);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        node->declarationKindToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3705 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 493: Q_FALLTHROUGH(); 
#line 3707 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 494: {
        auto *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        node->declarationKindToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3718 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 495: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement();
        node->continueToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3728 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 496: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement(stringRef(2));
        node->continueToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3739 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 497: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(QStringView());
        node->breakToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3749 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 498: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(stringRef(2));
        node->breakToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3760 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 499: {
        if (!functionNestingLevel) {
            syntaxError(loc(1), "Return statement not allowed outside of Function declaration.");
            return false;
        }
        AST::ReturnStatement *node = new (pool) AST::ReturnStatement(sym(2).Expression);
        node->returnToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3774 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 500: {
        AST::WithStatement *node = new (pool) AST::WithStatement(sym(3).Expression, sym(5).Statement);
        node->withToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3785 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 501: {
        AST::SwitchStatement *node = new (pool) AST::SwitchStatement(sym(3).Expression, sym(5).CaseBlock);
        node->switchToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3796 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 502: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3806 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 503: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses, sym(3).DefaultClause, sym(4).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 3816 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 504: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClause);
    } break;

#line 3823 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 505: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClauses, sym(2).CaseClause);
    } break;

#line 3830 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 506: {
        sym(1).Node = nullptr;
    } break;

#line 3837 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 507: {
        sym(1).Node = sym(1).CaseClauses->finish();
    } break;

#line 3844 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 508: {
        AST::CaseClause *node = new (pool) AST::CaseClause(sym(2).Expression, sym(4).StatementList);
        node->caseToken = loc(1);
        node->colonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3854 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 509: {
        AST::DefaultClause *node = new (pool) AST::DefaultClause(sym(3).StatementList);
        node->defaultToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3864 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 510: {
        AST::LabelledStatement *node = new (pool) AST::LabelledStatement(stringRef(1), sym(3).Statement);
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3876 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 512: {
        syntaxError(loc(3), "FunctionDeclarations are not allowed after a label.");
        return false;
    } break;

#line 3884 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 513: {
        AST::ThrowStatement *node = new (pool) AST::ThrowStatement(sym(2).Expression);
        node->throwToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3894 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 514: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3903 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 515: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3912 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 516: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch, sym(4).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3921 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 517: {
        AST::Catch *node = new (pool) AST::Catch(sym(3).PatternElement, sym(5).Block);
        node->catchToken = loc(1);
        node->lparenToken = loc(2);
        node->identifierToken = loc(3);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3933 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 518: {
        AST::Finally *node = new (pool) AST::Finally(sym(2).Block);
        node->finallyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3942 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 519: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1));
        node->identifierToken = loc(1);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 3952 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 520: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 3961 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 521: {
        AST::DebuggerStatement *node = new (pool) AST::DebuggerStatement();
        node->debuggerToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3978 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 523: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList, sym(6).TypeAnnotation);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3994 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 524: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                             sym(6).TypeAnnotation);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 4010 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 526: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringView(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                             sym(5).TypeAnnotation);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 4026 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 527: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                           sym(6).TypeAnnotation);
        node->functionToken = loc(1);
        if (! stringRef(2).isNull())
          node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 4044 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 528: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringView(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                           sym(5).TypeAnnotation);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 4062 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 530: {
        sym(1).Node = nullptr;
    } break;

#line 4069 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 531: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4077 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
 case 532: 
#line 4079 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 533: {
        sym(1).Node = sym(1).FormalParameterList->finish(pool);
    } break;

#line 4086 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 534: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4094 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 535: {
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement);
        sym(1).Node = node;
    } break;

#line 4103 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 536: {
        sym(1).FormalParameterList->commaToken = loc(2);
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement);
        sym(1).Node = node;
    } break;

#line 4114 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 538: {
        ++functionNestingLevel;
    } break;

#line 4121 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 539: {
        --functionNestingLevel;
    } break;

#line 4131 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 541: Q_FALLTHROUGH(); 
#line 4133 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 542: {
        AST::ReturnStatement *ret = new (pool) AST::ReturnStatement(sym(4).Expression);
        ret->returnToken = sym(4).Node->firstSourceLocation().startZeroLengthLocation();
        ret->semicolonToken = sym(4).Node->lastSourceLocation().endZeroLengthLocation(driver->code());
        AST::StatementList *statements = (new (pool) AST::StatementList(ret))->finish();
        AST::FunctionExpression *f = sym(1).FunctionExpression;
        f->body = statements;
        f->isArrowFunction = true;
        f->lbraceToken = sym(4).Node->firstSourceLocation().startZeroLengthLocation();
        f->rbraceToken = sym(4).Node->lastSourceLocation().endZeroLengthLocation(driver->code());
        sym(1).Node = f;
    } break;

#line 4149 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 543: Q_FALLTHROUGH(); 
#line 4151 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 544: {
        AST::FunctionExpression *f = sym(1).FunctionExpression;
        f->body = sym(6).StatementList;
        f->isArrowFunction = true;
        f->lbraceToken = loc(5);
        f->rbraceToken = loc(7);
        sym(1).Node = f;
    } break;

#line 4163 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 545: {
        AST::PatternElement *e = new (pool) AST::PatternElement(stringRef(1), /*type annotation*/nullptr, nullptr, AST::PatternElement::Binding);
        e->identifierToken = loc(1);
        AST::FormalParameterList *list = (new (pool) AST::FormalParameterList(nullptr, e))->finish(pool);
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), list, nullptr);
        f->functionToken = loc(1).startZeroLengthLocation();
        sym(1).FunctionExpression = f;
    } break;

#line 4177 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 546: {
        if (coverExpressionType != CE_FormalParameterList) {
            AST::NestedExpression *ne = static_cast<AST::NestedExpression *>(sym(1).Node);
            AST::FormalParameterList *list = ne->expression->reparseAsFormalParameterList(pool);
            if (!list) {
                syntaxError(loc(1), "Invalid Arrow parameter list.");
                return false;
            }
            AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), list->finish(pool), nullptr);
            f->functionToken = loc(1).startZeroLengthLocation();
            f->lparenToken = ne->lparenToken;
            f->rparenToken = ne->rparenToken;
            sym(1).FunctionExpression = f;
        }
    } break;

#line 4199 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 547: {
        if (lookaheadToken(lexer) == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
    } break;

#line 4207 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 548: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(1), sym(3).FormalParameterList, sym(7).StatementList);
        f->functionToken = sym(1).PropertyName->firstSourceLocation();
        f->lparenToken = loc(2);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, f, AST::PatternProperty::Method);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4224 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 549: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->starToken = loc(1);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        f->isGenerator = true;
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Method);
        sym(1).Node = node;
    } break;

#line 4243 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 550: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, /*formals*/nullptr))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), nullptr, sym(7).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Getter);
        sym(1).Node = node;
    } break;

#line 4259 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 551: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Setter);
        sym(1).Node = node;
    } break;

#line 4276 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 552: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4284 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 553: {
        lexer->enterGeneratorBody();
    } break;

#line 4291 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 554: {
        --functionNestingLevel;
        lexer->leaveGeneratorBody();
    } break;

#line 4299 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 555: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringView(), nullptr, nullptr);
        node->functionToken = loc(1);
        node->starToken = loc(2);
        sym(1).FunctionDeclaration = node;
    } break;

#line 4309 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 556: {
        AST::FunctionDeclaration *node = sym(1).FunctionDeclaration;
        node->identifierToken = loc(2);
        node->name = stringRef(2);
        node->lparenToken = loc(3);
        node->formals = sym(4).FormalParameterList;
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->body = sym(7).StatementList;
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4327 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 558: {
        AST::FunctionDeclaration *node = sym(1).FunctionDeclaration;
        node->lparenToken = loc(2);
        node->formals = sym(3).FormalParameterList;
        node->rparenToken = loc(4);
        node->lbraceToken = loc(5);
        node->body = sym(6).StatementList;
        node->rbraceToken = loc(7);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4342 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 559: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(3), sym(5).FormalParameterList, sym(8).StatementList);
        node->functionToken = loc(1);
        node->starToken = loc(2);
        if (!stringRef(3).isNull())
          node->identifierToken = loc(3);
        node->lparenToken = loc(4);
        node->rparenToken = loc(6);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4359 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 560: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringView(), sym(4).FormalParameterList, sym(7).StatementList);
        node->functionToken = loc(1);
        node->starToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4376 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 562: Q_FALLTHROUGH(); 
#line 4378 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 563: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression();
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4387 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 564: Q_FALLTHROUGH(); 
#line 4389 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 565: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(3).Expression);
        node->yieldToken = loc(1);
        node->isYieldStar = true;
        sym(1).Node = node;
    } break;

#line 4399 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 566: Q_FALLTHROUGH(); 
#line 4401 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 567: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(2).Expression);
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4411 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 568: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4423 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 569: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4435 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 570: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(QStringView(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4446 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 571: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(QStringView(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4459 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 573: {
        if (++classNestingLevel == 1)
            lexer->setStaticIsKeyword(true);
    } break;

#line 4467 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 574: {
        if (--classNestingLevel == 0)
            lexer->setStaticIsKeyword(false);
    } break;

#line 4475 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 575: {
        sym(1).Node = nullptr;
    } break;

#line 4482 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 576: {
        sym(1).Node = sym(2).Node;
    } break;

#line 4489 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 577: {
        sym(1).Node = nullptr;
    } break;

#line 4496 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 578: {
        if (sym(1).Node)
            sym(1).Node = sym(1).ClassElementList->finish();
    } break;

#line 4506 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 580: {
        if (sym(1).Node) {
            if (sym(2).Node)
                sym(1).ClassElementList = sym(1).ClassElementList->append(sym(2).ClassElementList);
        } else if (sym(2).Node) {
            sym(1).Node = sym(2).Node;
        }
    } break;

#line 4518 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 581: {
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(1).PatternProperty, false);
        sym(1).Node = node;
    } break;

#line 4526 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 582: {
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(2).PatternProperty, true);
        sym(1).Node = node;
    } break;

#line 4534 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 583: {
        sym(1).Node = nullptr;
    } break;

#line 4543 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 584: {
        sym(1).Node = nullptr;
    } break;

#line 4552 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 586: {
        sym(1).Node = new (pool) AST::Program(sym(1).StatementList->finish());
    } break;

#line 4559 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 587: {
        sym(1).Node = new (pool) AST::ESModule(sym(1).StatementList);
    } break;

#line 4565 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 588: {
        sym(1).StatementList = sym(1).StatementList->finish();
    } break;

#line 4572 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 589: {
        sym(1).StatementList = nullptr;
    } break;

#line 4582 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 592: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 4590 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
 case 593:  Q_FALLTHROUGH(); 
#line 4592 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 594: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Node);
    } break;

#line 4601 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 596: {
        auto decl = new (pool) AST::ImportDeclaration(sym(2).ImportClause, sym(3).FromClause);
        decl->importToken = loc(1);
        sym(1).Node = decl;
    } break;

#line 4609 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 597: {
        auto decl = new (pool) AST::ImportDeclaration(stringRef(2));
        decl->importToken = loc(1);
        decl->moduleSpecifierToken = loc(2);
        sym(1).Node = decl;
    } break;

#line 4619 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 598: {
        auto clause = new (pool) AST::ImportClause(stringRef(1));
        clause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = clause;
    } break;

#line 4627 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 599: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NameSpaceImport);
    } break;

#line 4633 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 600: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NamedImports);
    } break;

#line 4639 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 601: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NameSpaceImport);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4647 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 602: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NamedImports);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4658 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 604: {
        auto import = new (pool) AST::NameSpaceImport(stringRef(3));
        import->starToken = loc(1);
        import->importedBindingToken = loc(3);
        sym(1).NameSpaceImport = import;
    } break;

#line 4668 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 605: {
        auto namedImports = new (pool) AST::NamedImports();
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(2);
        sym(1).NamedImports = namedImports;
    } break;

#line 4677 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 606: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(3);
        sym(1).NamedImports = namedImports;
    } break;

#line 4686 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 607: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(4);
        sym(1).NamedImports = namedImports;
    } break;

#line 4696 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 608: {
        auto clause = new (pool) AST::FromClause(stringRef(2));
        clause->fromToken = loc(1);
        clause->moduleSpecifierToken = loc(2);
        sym(1).FromClause = clause;
    } break;

#line 4706 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 609: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportSpecifier);
        importsList->importSpecifierToken = loc(1);
        sym(1).ImportsList = importsList;
    } break;

#line 4714 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 610: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportsList, sym(3).ImportSpecifier);
        importsList->importSpecifierToken = loc(3);
        sym(1).ImportsList = importsList;
    } break;

#line 4726 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 611: {
        auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1));
        importSpecifier->importedBindingToken = loc(1);
        sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4734 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 612: {
    auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1), stringRef(3));
    importSpecifier->identifierToken = loc(1);
    importSpecifier->importedBindingToken = loc(3);
    sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4751 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 615: {
        int token = lookaheadToken(lexer);
        if (token == T_FUNCTION || token == T_CLASS)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 4760 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 616: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4768 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 617: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause, sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4776 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 618: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4784 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
 case 619:  Q_FALLTHROUGH(); 
#line 4786 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 620: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/false, sym(2).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4794 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 621: {
        if (auto *f = AST::cast<AST::FunctionDeclaration*>(sym(5).Node)) {
            if (f->name.isEmpty()) {
                f->name = stringRef(2);
                f->identifierToken = loc(2);
            }
        }
    } Q_FALLTHROUGH();

#line 4805 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 622: {
        // Emulate 15.2.3.11
        if (auto *cls = AST::cast<AST::ClassDeclaration*>(sym(5).Node)) {
            if (cls->name.isEmpty()) {
                cls->name = stringRef(2);
                cls->identifierToken = loc(2);
            }
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(5).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4821 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 623: {
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(4).Node)) {
            f->name = stringRef(2);
        }
        if (auto *c = asAnonymousClassDefinition(sym(4).Expression)) {
            c->name = stringRef(2);
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(4).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4838 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 624: {
        auto exportClause = new (pool) AST::ExportClause();
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(2);
        sym(1).ExportClause = exportClause;
    } break;

#line 4847 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 625: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(3);
        sym(1).ExportClause = exportClause;
    } break;

#line 4856 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 626: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(4);
        sym(1).ExportClause = exportClause;
    } break;

#line 4866 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 627: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportSpecifier);
    } break;

#line 4872 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 628: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportsList, sym(3).ExportSpecifier);
    } break;

#line 4879 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 629: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1));
        exportSpecifier->identifierToken = loc(1);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4887 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 630: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1), stringRef(3));
        exportSpecifier->identifierToken = loc(1);
        exportSpecifier->exportedIdentifierToken = loc(3);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4898 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    // ------------ end of switch statement
            } // switch
            action = nt_action(state_stack[tos], lhs[r] - TERMINAL_COUNT);
        } // if
    } while (action != 0);

#ifdef PARSER_DEBUG
    qDebug() << "Done or error.";
#endif

    if (first_token == last_token) {
        const int errorState = state_stack[tos];

        // automatic insertion of missing identifiers after dots
        if (yytoken != -1 && m_identifierInsertionEnabled && t_action(errorState, T_IDENTIFIER) && yyprevtoken == T_DOT) {
#ifdef PARSER_DEBUG
            qDebug() << "Inserting missing identifier between" << spell[yyprevtoken] << "and"
                     << spell[yytoken];
#endif
            pushTokenWithEmptyLocation(T_IDENTIFIER);
            action = errorState;
            goto _Lcheck_token;
        }


        // automatic insertion of `;'
        if (yytoken != -1 && ((t_action(errorState, T_AUTOMATIC_SEMICOLON) && lexer->canInsertAutomaticSemicolon(yytoken))
                              || t_action(errorState, T_COMPATIBILITY_SEMICOLON))) {
#ifdef PARSER_DEBUG
            qDebug() << "Inserting automatic semicolon.";
#endif
            pushTokenWithEmptyLocation(T_SEMICOLON);
            action = errorState;
            goto _Lcheck_token;
        }

        hadErrors = true;

        token_buffer[0].token = yytoken;
        token_buffer[0].dval = yylval;
        token_buffer[0].spell = yytokenspell;
        token_buffer[0].raw = yytokenraw;
        token_buffer[0].loc = yylloc;

        token_buffer[1].token = yytoken       = lexer->lex();
        token_buffer[1].dval  = yylval        = lexer->tokenValue();
        token_buffer[1].spell = yytokenspell  = lexer->tokenSpell();
        token_buffer[1].raw   = yytokenraw    = lexer->rawString();
        token_buffer[1].loc   = yylloc        = location(lexer);

        if (t_action(errorState, yytoken)) {
#ifdef PARSER_DEBUG
            qDebug() << "Parse error, trying to recover.";
#endif
            QString msg;
            int token = token_buffer[0].token;
            if (token < 0 || token >= TERMINAL_COUNT)
                msg = QCoreApplication::translate("QQmlParser", "Syntax error");
            else
                msg = QCoreApplication::translate("QQmlParser", "Unexpected token `%1'").arg(QLatin1String(spell[token]));
            diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

            action = errorState;
            goto _Lcheck_token;
        }

        static int tokens[] = {
            T_PLUS,
            T_EQ,

            T_COMMA,
            T_COLON,
            T_SEMICOLON,

            T_RPAREN, T_RBRACKET, T_RBRACE,

            T_NUMERIC_LITERAL,
            T_IDENTIFIER,

            T_LPAREN, T_LBRACKET, T_LBRACE,

            EOF_SYMBOL
        };

        for (int *tk = tokens; *tk != EOF_SYMBOL; ++tk) {
            int a = t_action(errorState, *tk);
            if (a > 0 && t_action(a, yytoken)) {
#ifdef PARSER_DEBUG
                qDebug() << "Parse error, trying to recover (2).";
#endif
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[*tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(*tk);
                goto _Lcheck_token;
            }
        }

        for (int tk = 1; tk < TERMINAL_COUNT; ++tk) {
            if (tk == T_AUTOMATIC_SEMICOLON || tk == T_FEED_UI_PROGRAM    ||
                tk == T_FEED_JS_STATEMENT   || tk == T_FEED_JS_EXPRESSION)
               continue;

            int a = t_action(errorState, tk);
            if (a > 0 && t_action(a, yytoken)) {
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(tk);
                goto _Lcheck_token;
            }
        }

        const QString msg = QCoreApplication::translate("QQmlParser", "Syntax error");
        diagnostic_messages.append(compileError(token_buffer[0].loc, msg));
    }

    return false;
}

QT_END_NAMESPACE


