// python wrapper for vtkPVSystemConfigInformation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVSystemConfigInformation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVSystemConfigInformation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVSystemConfigInformation_ClassNew(); }

#ifndef DECLARED_PyvtkPVInformation_ClassNew
extern "C" { PyObject *PyvtkPVInformation_ClassNew(); }
#define DECLARED_PyvtkPVInformation_ClassNew
#endif

static PyObject *
PyvtkPVSystemConfigInformation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVSystemConfigInformation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVSystemConfigInformation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVSystemConfigInformation *tempr = vtkPVSystemConfigInformation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVSystemConfigInformation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVSystemConfigInformation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVSystemConfigInformation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVSystemConfigInformation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_CopyFromObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  vtkObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObject"))
  {
    if (ap.IsBound())
    {
      op->CopyFromObject(temp0);
    }
    else
    {
      op->vtkPVSystemConfigInformation::CopyFromObject(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_AddInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  vtkPVInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVInformation"))
  {
    if (ap.IsBound())
    {
      op->AddInformation(temp0);
    }
    else
    {
      op->vtkPVSystemConfigInformation::AddInformation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    size_t tempr = (ap.IsBound() ?
      op->GetSize() :
      op->vtkPVSystemConfigInformation::GetSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetOSDescriptor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOSDescriptor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetOSDescriptor(temp0) :
      op->vtkPVSystemConfigInformation::GetOSDescriptor(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetCPUDescriptor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCPUDescriptor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetCPUDescriptor(temp0) :
      op->vtkPVSystemConfigInformation::GetCPUDescriptor(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetMemoryDescriptor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMemoryDescriptor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetMemoryDescriptor(temp0) :
      op->vtkPVSystemConfigInformation::GetMemoryDescriptor(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetHostName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHostName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetHostName(temp0) :
      op->vtkPVSystemConfigInformation::GetHostName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetProcessType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcessType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetProcessType(temp0) :
      op->vtkPVSystemConfigInformation::GetProcessType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetSystemType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSystemType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSystemType(temp0) :
      op->vtkPVSystemConfigInformation::GetSystemType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRank");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRank(temp0) :
      op->vtkPVSystemConfigInformation::GetRank(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetPid(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPid");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetPid(temp0) :
      op->vtkPVSystemConfigInformation::GetPid(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetHostMemoryTotal(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHostMemoryTotal");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetHostMemoryTotal(temp0) :
      op->vtkPVSystemConfigInformation::GetHostMemoryTotal(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetHostMemoryAvailable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHostMemoryAvailable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetHostMemoryAvailable(temp0) :
      op->vtkPVSystemConfigInformation::GetHostMemoryAvailable(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_GetProcMemoryAvailable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcMemoryAvailable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetProcMemoryAvailable(temp0) :
      op->vtkPVSystemConfigInformation::GetProcMemoryAvailable(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSystemConfigInformation_Sort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Sort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSystemConfigInformation *op = static_cast<vtkPVSystemConfigInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Sort();
    }
    else
    {
      op->vtkPVSystemConfigInformation::Sort();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVSystemConfigInformation_Methods[] = {
  {"IsTypeOf", PyvtkPVSystemConfigInformation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVSystemConfigInformation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVSystemConfigInformation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVSystemConfigInformation\nC++: static vtkPVSystemConfigInformation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVSystemConfigInformation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVSystemConfigInformation\nC++: vtkPVSystemConfigInformation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVSystemConfigInformation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVSystemConfigInformation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"CopyFromObject", PyvtkPVSystemConfigInformation_CopyFromObject, METH_VARARGS,
   "CopyFromObject(self, obj:vtkObject) -> None\nC++: void CopyFromObject(vtkObject *obj) override;\n\nTransfer information about a single object into this object.\n"},
  {"AddInformation", PyvtkPVSystemConfigInformation_AddInformation, METH_VARARGS,
   "AddInformation(self, info:vtkPVInformation) -> None\nC++: void AddInformation(vtkPVInformation *info) override;\n\nMerge another information object.\n"},
  {"GetSize", PyvtkPVSystemConfigInformation_GetSize, METH_VARARGS,
   "GetSize(self) -> int\nC++: size_t GetSize()\n\nAccess managed information\n"},
  {"GetOSDescriptor", PyvtkPVSystemConfigInformation_GetOSDescriptor, METH_VARARGS,
   "GetOSDescriptor(self, i:int) -> str\nC++: const char *GetOSDescriptor(size_t i)\n\n"},
  {"GetCPUDescriptor", PyvtkPVSystemConfigInformation_GetCPUDescriptor, METH_VARARGS,
   "GetCPUDescriptor(self, i:int) -> str\nC++: const char *GetCPUDescriptor(size_t i)\n\n"},
  {"GetMemoryDescriptor", PyvtkPVSystemConfigInformation_GetMemoryDescriptor, METH_VARARGS,
   "GetMemoryDescriptor(self, i:int) -> str\nC++: const char *GetMemoryDescriptor(size_t i)\n\n"},
  {"GetHostName", PyvtkPVSystemConfigInformation_GetHostName, METH_VARARGS,
   "GetHostName(self, i:int) -> str\nC++: const char *GetHostName(size_t i)\n\n"},
  {"GetProcessType", PyvtkPVSystemConfigInformation_GetProcessType, METH_VARARGS,
   "GetProcessType(self, i:int) -> int\nC++: int GetProcessType(size_t i)\n\n"},
  {"GetSystemType", PyvtkPVSystemConfigInformation_GetSystemType, METH_VARARGS,
   "GetSystemType(self, i:int) -> int\nC++: int GetSystemType(size_t i)\n\n"},
  {"GetRank", PyvtkPVSystemConfigInformation_GetRank, METH_VARARGS,
   "GetRank(self, i:int) -> int\nC++: int GetRank(size_t i)\n\n"},
  {"GetPid", PyvtkPVSystemConfigInformation_GetPid, METH_VARARGS,
   "GetPid(self, i:int) -> int\nC++: long long GetPid(size_t i)\n\n"},
  {"GetHostMemoryTotal", PyvtkPVSystemConfigInformation_GetHostMemoryTotal, METH_VARARGS,
   "GetHostMemoryTotal(self, i:int) -> int\nC++: long long GetHostMemoryTotal(size_t i)\n\n"},
  {"GetHostMemoryAvailable", PyvtkPVSystemConfigInformation_GetHostMemoryAvailable, METH_VARARGS,
   "GetHostMemoryAvailable(self, i:int) -> int\nC++: long long GetHostMemoryAvailable(size_t i)\n\n"},
  {"GetProcMemoryAvailable", PyvtkPVSystemConfigInformation_GetProcMemoryAvailable, METH_VARARGS,
   "GetProcMemoryAvailable(self, i:int) -> int\nC++: long long GetProcMemoryAvailable(size_t i)\n\n"},
  {"Sort", PyvtkPVSystemConfigInformation_Sort, METH_VARARGS,
   "Sort(self) -> None\nC++: void Sort()\n\nSort elements by mpi rank.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVSystemConfigInformation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSystemConfigInformation_GetSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSize\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVSystemConfigInformation_Doc =
  "vtkPVSystemConfigInformation - A vtkClientServerStream serializable\ncontainer of information describing memory configuration of the host\nof a single process.\n\n"
  "Superclass: vtkPVInformation\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVSystemConfigInformation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVSystemConfigInformation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVSystemConfigInformation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVSystemConfigInformation_StaticNew()
{
  return vtkPVSystemConfigInformation::New();
}

PyObject *PyvtkPVSystemConfigInformation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVSystemConfigInformation_Type, PyvtkPVSystemConfigInformation_Methods,
    "vtkPVSystemConfigInformation",
 &PyvtkPVSystemConfigInformation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVInformation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVSystemConfigInformation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVSystemConfigInformation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVSystemConfigInformation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVSystemConfigInformation", o) != 0)
  {
    Py_DECREF(o);
  }

}

