// ClientServer wrapper for vtkExtractTensorComponents object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkExtractTensorComponents.h"
#include "vtkSystemIncludes.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkExtractTensorComponentsClientServerNewCommand(void* /*ctx*/)
{
  return vtkExtractTensorComponents::New();
}


static int vtkExtractTensorComponentsCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkExtractTensorComponents *op = vtkExtractTensorComponents::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkExtractTensorComponents.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkExtractTensorComponents::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkExtractTensorComponents  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkExtractTensorComponents::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkExtractTensorComponents  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkExtractTensorComponents::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkExtractTensorComponents  *temp20;
      {
      temp20 = vtkExtractTensorComponents::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetPassTensorsToOutput",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetPassTensorsToOutput(temp0);
      return 1;
      }
    }
  if (!strcmp("GetPassTensorsToOutput",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetPassTensorsToOutput();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("PassTensorsToOutputOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PassTensorsToOutputOn();
      return 1;
      }
    }
  if (!strcmp("PassTensorsToOutputOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PassTensorsToOutputOff();
      return 1;
      }
    }
  if (!strcmp("SetExtractScalars",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetExtractScalars(temp0);
      return 1;
      }
    }
  if (!strcmp("GetExtractScalars",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetExtractScalars();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ExtractScalarsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ExtractScalarsOn();
      return 1;
      }
    }
  if (!strcmp("ExtractScalarsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ExtractScalarsOff();
      return 1;
      }
    }
  if (!strcmp("SetScalarComponents",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    int      temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetScalarComponents(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("SetScalarComponents",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int    temp0[2];
    if(msg.GetArgument(0, 2, temp0, 2))
      {
      op->SetScalarComponents(temp0);
      return 1;
      }
    }
  if (!strcmp("GetScalarComponents",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int     *temp20;
      {
      temp20 = (op)->GetScalarComponents();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << vtkClientServerStream::InsertArray(temp20,2) << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetScalarMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetScalarMode(temp0);
      return 1;
      }
    }
  if (!strcmp("GetScalarMode",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetScalarMode();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetScalarModeToComponent",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetScalarModeToComponent();
      return 1;
      }
    }
  if (!strcmp("SetScalarModeToEffectiveStress",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetScalarModeToEffectiveStress();
      return 1;
      }
    }
  if (!strcmp("SetScalarModeToDeterminant",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetScalarModeToDeterminant();
      return 1;
      }
    }
  if (!strcmp("SetScalarModeToNonNegativeDeterminant",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetScalarModeToNonNegativeDeterminant();
      return 1;
      }
    }
  if (!strcmp("SetScalarModeToTrace",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetScalarModeToTrace();
      return 1;
      }
    }
  if (!strcmp("ScalarIsComponent",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ScalarIsComponent();
      return 1;
      }
    }
  if (!strcmp("ScalarIsEffectiveStress",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ScalarIsEffectiveStress();
      return 1;
      }
    }
  if (!strcmp("ScalarIsDeterminant",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ScalarIsDeterminant();
      return 1;
      }
    }
  if (!strcmp("ScalarIsNonNegativeDeterminant",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ScalarIsNonNegativeDeterminant();
      return 1;
      }
    }
  if (!strcmp("ScalarIsTrace",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ScalarIsTrace();
      return 1;
      }
    }
  if (!strcmp("SetExtractVectors",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetExtractVectors(temp0);
      return 1;
      }
    }
  if (!strcmp("GetExtractVectors",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetExtractVectors();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ExtractVectorsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ExtractVectorsOn();
      return 1;
      }
    }
  if (!strcmp("ExtractVectorsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ExtractVectorsOff();
      return 1;
      }
    }
  if (!strcmp("SetVectorComponents",method) && msg.GetNumberOfArguments(0) == 8)
    {
    int      temp0;
    int      temp1;
    int      temp2;
    int      temp3;
    int      temp4;
    int      temp5;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3) &&
      msg.GetArgument(0, 6, &temp4) &&
      msg.GetArgument(0, 7, &temp5))
      {
      op->SetVectorComponents(temp0,temp1,temp2,temp3,temp4,temp5);
      return 1;
      }
    }
  if (!strcmp("SetVectorComponents",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int    temp0[6];
    if(msg.GetArgument(0, 2, temp0, 6))
      {
      op->SetVectorComponents(temp0);
      return 1;
      }
    }
  if (!strcmp("GetVectorComponents",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int     *temp20;
      {
      temp20 = (op)->GetVectorComponents();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << vtkClientServerStream::InsertArray(temp20,6) << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetExtractNormals",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetExtractNormals(temp0);
      return 1;
      }
    }
  if (!strcmp("GetExtractNormals",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetExtractNormals();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ExtractNormalsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ExtractNormalsOn();
      return 1;
      }
    }
  if (!strcmp("ExtractNormalsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ExtractNormalsOff();
      return 1;
      }
    }
  if (!strcmp("SetNormalizeNormals",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetNormalizeNormals(temp0);
      return 1;
      }
    }
  if (!strcmp("GetNormalizeNormals",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetNormalizeNormals();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NormalizeNormalsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->NormalizeNormalsOn();
      return 1;
      }
    }
  if (!strcmp("NormalizeNormalsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->NormalizeNormalsOff();
      return 1;
      }
    }
  if (!strcmp("SetNormalComponents",method) && msg.GetNumberOfArguments(0) == 8)
    {
    int      temp0;
    int      temp1;
    int      temp2;
    int      temp3;
    int      temp4;
    int      temp5;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3) &&
      msg.GetArgument(0, 6, &temp4) &&
      msg.GetArgument(0, 7, &temp5))
      {
      op->SetNormalComponents(temp0,temp1,temp2,temp3,temp4,temp5);
      return 1;
      }
    }
  if (!strcmp("SetNormalComponents",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int    temp0[6];
    if(msg.GetArgument(0, 2, temp0, 6))
      {
      op->SetNormalComponents(temp0);
      return 1;
      }
    }
  if (!strcmp("GetNormalComponents",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int     *temp20;
      {
      temp20 = (op)->GetNormalComponents();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << vtkClientServerStream::InsertArray(temp20,6) << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetExtractTCoords",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetExtractTCoords(temp0);
      return 1;
      }
    }
  if (!strcmp("GetExtractTCoords",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetExtractTCoords();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ExtractTCoordsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ExtractTCoordsOn();
      return 1;
      }
    }
  if (!strcmp("ExtractTCoordsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ExtractTCoordsOff();
      return 1;
      }
    }
  if (!strcmp("SetNumberOfTCoords",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetNumberOfTCoords(temp0);
      return 1;
      }
    }
  if (!strcmp("GetNumberOfTCoordsMinValue",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetNumberOfTCoordsMinValue();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfTCoordsMaxValue",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetNumberOfTCoordsMaxValue();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfTCoords",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetNumberOfTCoords();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetTCoordComponents",method) && msg.GetNumberOfArguments(0) == 8)
    {
    int      temp0;
    int      temp1;
    int      temp2;
    int      temp3;
    int      temp4;
    int      temp5;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3) &&
      msg.GetArgument(0, 6, &temp4) &&
      msg.GetArgument(0, 7, &temp5))
      {
      op->SetTCoordComponents(temp0,temp1,temp2,temp3,temp4,temp5);
      return 1;
      }
    }
  if (!strcmp("SetTCoordComponents",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int    temp0[6];
    if(msg.GetArgument(0, 2, temp0, 6))
      {
      op->SetTCoordComponents(temp0);
      return 1;
      }
    }
  if (!strcmp("GetTCoordComponents",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int     *temp20;
      {
      temp20 = (op)->GetTCoordComponents();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << vtkClientServerStream::InsertArray(temp20,6) << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetOutputPrecision",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetOutputPrecision(temp0);
      return 1;
      }
    }
  if (!strcmp("GetOutputPrecision",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetOutputPrecision();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }

  {
    const char* commandName = "vtkDataSetAlgorithm";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkExtractTensorComponents, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkExtractTensorComponents_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkExtractTensorComponents", vtkExtractTensorComponentsClientServerNewCommand);
    csi->AddCommandFunction("vtkExtractTensorComponents", vtkExtractTensorComponentsCommand);
    }
}
}
