// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtFVCOMFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_FVCOM_MTMD_FILE_FORMAT_H
#define AVT_FVCOM_MTMD_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>
#include <avtMTMDFileFormatInterface.h>

#include <vector>

class NETCDFFileObject;
class avtFVCOMReader;
    
// ****************************************************************************
//  Class: avtFVCOM_MTMDFileFormat
//
//  Purpose:
//      Reads in FVCOM Master file as a plugin to VisIt.
//
//  Programmer: dstuebe -- generated by xml2avt
//  Creation:   Wed Aug 16 16:40:22 PST 2006
//
// ****************************************************************************

class avtFVCOM_MTMDFileFormat : public avtMTMDFileFormat
{
  public:
   static bool        Identify(NETCDFFileObject *);   

   static avtFileFormatInterface *CreateInterface(NETCDFFileObject *f,
                         const char *const *list, int nList, int nBlock);

                       avtFVCOM_MTMDFileFormat(const char *, NETCDFFileObject *);
                       avtFVCOM_MTMDFileFormat(const char *);
    virtual           ~avtFVCOM_MTMDFileFormat();

    virtual void       Init(void);

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    
    virtual void        GetCycles(std::vector<int> &);
    virtual void        GetTimes(std::vector<double> &);

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "FVCOM"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);

    virtual void          *GetAuxiliaryData(const char *var, int timestate,
                                            int domain,
                                            const char *type, void *args,
                                            DestructorFunction &);

   protected:
    // DATA MEMBERS
   NETCDFFileObject      *fileObject;

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);

    bool  init;
    bool IsGeoRef;
    
    //    int status;

    size_t ndoms;
    size_t nfnames;
    size_t ntime;
    size_t ntwo;
    
    std::vector<avtFVCOMReader *> domainFiles;

    private:
   
    const char *keysuffix;
};


#endif
