#pragma once

// --- AUTO GENERATED ---
// gen_docs.py is run by cmake build

namespace manifold_docstrings {
const char* cross_section__area = R"___(Return the total area covered by complex polygons making up the
CrossSection.)___";
const char* cross_section__batch_boolean__cross_sections__op = R"___(Perform the given boolean operation on a list of CrossSections. In case of
Subtract, all CrossSections in the tail are differenced from the head.)___";
const char* cross_section__boolean__second__op = R"___(Perform the given boolean operation between this and another CrossSection.)___";
const char* cross_section__bounds = R"___(Returns the axis-aligned bounding rectangle of all the CrossSections'
vertices.)___";
const char* cross_section__circle__radius__circular_segments = R"___(Constructs a circle of a given radius.
:param radius: Radius of the circle. Must be positive.
:param circular_segments: Number of segments along its diameter. Default is
calculated by the static Quality defaults according to the radius.)___";
const char* cross_section__compose__cross_sections = R"___(Construct a CrossSection from a vector of other CrossSections (batch
boolean union).)___";
const char* cross_section__cross_section = R"___(The default constructor is an empty cross-section (containing no contours).)___";
const char* cross_section__cross_section__contour__fillrule = R"___(Create a 2d cross-section from a single contour. A boolean union operation
(with Positive filling rule by default) is performed to ensure the
resulting CrossSection is free of self-intersections.
:param contour: A closed path outlining the desired cross-section.
:param fillrule: The filling rule used to interpret polygon sub-regions
created by self-intersections in contour.)___";
const char* cross_section__cross_section__contours__fillrule = R"___(Create a 2d cross-section from a set of contours (complex polygons). A
boolean union operation (with Positive filling rule by default) is
performed to combine overlapping polygons and ensure the resulting
CrossSection is free of intersections.
:param contours: A set of closed paths describing zero or more complex
polygons.
:param fillrule: The filling rule used to interpret polygon sub-regions in
contours.)___";
const char* cross_section__cross_section__other = R"___(The copy constructor avoids copying the underlying paths vector (sharing
with its parent via shared_ptr), however subsequent transformations, and
their application will not be shared. It is generally recommended to avoid
this, opting instead to simply create CrossSections with the available
const methods.)___";
const char* cross_section__cross_section__rect = R"___(Create a 2d cross-section from an axis-aligned rectangle (bounding box).
:param rect: An axis-aligned rectangular bounding box.)___";
const char* cross_section__decompose = R"___(This operation returns a vector of CrossSections that are topologically
disconnected, each containing one outline contour with zero or more
holes.)___";
const char* cross_section__hull = R"___(Compute the convex hull of this cross-section.)___";
const char* cross_section__hull__cross_sections = R"___(Compute the convex hull enveloping a set of cross-sections.
:param cross_sections: A vector of cross-sections over which to compute a
convex hull.)___";
const char* cross_section__hull__polys = R"___(Compute the convex hull of a set of points/polygons. If the given points are
fewer than 3, an empty CrossSection will be returned.
:param polys: A vector of vectors of 2-dimensional points over which to
compute a convex hull.)___";
const char* cross_section__hull__pts = R"___(Compute the convex hull of a set of points. If the given points are fewer
than 3, an empty CrossSection will be returned.
:param pts: A vector of 2-dimensional points over which to compute a convex
hull.)___";
const char* cross_section__is_empty = R"___(Does the CrossSection contain any contours?)___";
const char* cross_section__mirror__ax = R"___(Mirror this CrossSection over the arbitrary axis whose normal is described by
the unit form of the given vector. If the length of the vector is zero, an
empty CrossSection is returned. This operation can be chained. Transforms are
combined and applied lazily.
:param ax: the axis to be mirrored over)___";
const char* cross_section__num_contour = R"___(Return the number of contours (both outer and inner paths) in the
CrossSection.)___";
const char* cross_section__num_vert = R"___(Return the number of vertices in the CrossSection.)___";
const char* cross_section__offset__delta__jointype__miter_limit__circular_segments = R"___(Inflate the contours in CrossSection by the specified delta, handling
corners according to the given JoinType.
:param delta: Positive deltas will cause the expansion of outlining contours
to expand, and retraction of inner (hole) contours. Negative deltas will
have the opposite effect.
:param jointype: The join type specifying the treatment of contour joins
(corners). Defaults to Round.
:param miter_limit: The maximum distance in multiples of delta that vertices
can be offset from their original positions with before squaring is
applied, <B>when the join type is Miter</B> (default is 2, which is the
minimum allowed). See the [Clipper2
MiterLimit](http://www.angusj.com/clipper2/Docs/Units/Clipper.Offset/Classes/ClipperOffset/Properties/MiterLimit.htm)
page for a visual example.
:param circular_segments: Number of segments per 360 degrees of
<B>JoinType::Round</B> corners (roughly, the number of vertices that
will be added to each contour). Default is calculated by the static Quality
defaults according to the radius.)___";
const char* cross_section__operator_minus__q = R"___(Compute the boolean difference of a (clip) cross-section from another
(subject).)___";
const char* cross_section__operator_minus_eq__q = R"___(Compute the boolean difference of a (clip) cross-section from a another
(subject), assigning the result to the subject.)___";
const char* cross_section__operator_plus__q = R"___(Compute the boolean union between two cross-sections.)___";
const char* cross_section__operator_plus_eq__q = R"___(Compute the boolean union between two cross-sections, assigning the result
to the first.)___";
const char* cross_section__operator_xor__q = R"___(Compute the boolean intersection between two cross-sections.)___";
const char* cross_section__operator_xor_eq__q = R"___(Compute the boolean intersection between two cross-sections, assigning the
result to the first.)___";
const char* cross_section__rotate__degrees = R"___(Applies a (Z-axis) rotation to the CrossSection, in degrees. This operation
can be chained. Transforms are combined and applied lazily.
:param degrees: degrees about the Z-axis to rotate.)___";
const char* cross_section__scale__scale = R"___(Scale this CrossSection in space. This operation can be chained. Transforms
are combined and applied lazily.
:param scale: The vector to multiply every vertex by per component.)___";
const char* cross_section__simplify__epsilon = R"___(Remove vertices from the contours in this CrossSection that are less than
the specified distance epsilon from an imaginary line that passes through
its two adjacent vertices. Near duplicate vertices and collinear points
will be removed at lower epsilons, with elimination of line segments
becoming increasingly aggressive with larger epsilons.
It is recommended to apply this function following Offset, in order to
clean up any spurious tiny line segments introduced that do not improve
quality in any meaningful way. This is particularly important if further
offseting operations are to be performed, which would compound the issue.)___";
const char* cross_section__square__size__center = R"___(Constructs a square with the given XY dimensions. By default it is
positioned in the first quadrant, touching the origin. If any dimensions in
size are negative, or if all are zero, an empty Manifold will be returned.
:param size: The X, and Y dimensions of the square.
:param center: Set to true to shift the center to the origin.)___";
const char* cross_section__to_polygons = R"___(Return the contours of this CrossSection as a Polygons.)___";
const char* cross_section__transform__m = R"___(Transform this CrossSection in space. The first two columns form a 2x2
matrix transform and the last is a translation vector. This operation can
be chained. Transforms are combined and applied lazily.
:param m: The affine transform matrix to apply to all the vertices.)___";
const char* cross_section__translate__v = R"___(Move this CrossSection in space. This operation can be chained. Transforms
are combined and applied lazily.
:param v: The vector to add to every vertex.)___";
const char* cross_section__warp__warp_func = R"___(Move the vertices of this CrossSection (creating a new one) according to
any arbitrary input function, followed by a union operation (with a
Positive fill rule) that ensures any introduced intersections are not
included in the result.
:param warp_func: A function that takes the original vertex position and
return the new position.)___";
const char* cross_section__warp_batch__warp_func = R"___(Same as CrossSection::warp but calls warpFunc with
an ndarray[n, 2] instead of processing only one vertex at a time.
:param warp_func: A function that takes multiple vertex positions as an
ndarray[n, 2] and returns the new vertex positions.)___";
const char* la__any = R"___(Each GridVert is connected to 14 others, and in charge of 7 of these edges
(see Neighbor() above). Each edge that changes sign contributes one vert,
unless the GridVert is close enough to the surface, in which case it
contributes only a single movedVert and all crossing edgeVerts refer to that.)___";
const char* manifold__as_original = R"___(This removes all relations (originalID, faceID, transform) to ancestor meshes
and this new Manifold is marked an original. It also recreates faces
- these don't get joined at boundaries where originalID changes, so the
reset may allow triangles of flat faces to be further collapsed with
Simplify().)___";
const char* manifold__batch_boolean__manifolds__op = R"___(Perform the given boolean operation on a list of Manifolds. In case of
Subtract, all Manifolds in the tail are differenced from the head.)___";
const char* manifold__boolean__second__op = R"___(The central operation of this library: the Boolean combines two manifolds
into another by calculating their intersections and removing the unused
portions.
[&epsilon;-valid](https://github.com/elalish/manifold/wiki/Manifold-Library#definition-of-%CE%B5-valid)
inputs will produce &epsilon;-valid output. &epsilon;-invalid input may fail
triangulation.
These operations are optimized to produce nearly-instant results if either
input is empty or their bounding boxes do not overlap.
:param second: The other Manifold.
:param op: The type of operation to perform.)___";
const char* manifold__bounding_box = R"___(Returns the axis-aligned bounding box of all the Manifold's vertices.)___";
const char* manifold__calculate_curvature__gaussian_idx__mean_idx = R"___(Curvature is the inverse of the radius of curvature, and signed such that
positive is convex and negative is concave. There are two orthogonal
principal curvatures at any point on a manifold, with one maximum and the
other minimum. Gaussian curvature is their product, while mean
curvature is their sum. This approximates them for every vertex and assigns
them as vertex properties on the given channels.
:param gaussian_idx: The property channel index in which to store the Gaussian
curvature. An index < 0 will be ignored (stores nothing). The property set
will be automatically expanded to include the channel index specified.
:param mean_idx: The property channel index in which to store the mean
curvature. An index < 0 will be ignored (stores nothing). The property set
will be automatically expanded to include the channel index specified.)___";
const char* manifold__calculate_normals__normal_idx__min_sharp_angle = R"___(Fills in vertex properties for normal vectors, calculated from the mesh
geometry. Flat faces composed of three or more triangles will remain flat.
:param normal_idx: The property channel in which to store the X
values of the normals. The X, Y, and Z channels will be sequential. The
property set will be automatically expanded such that NumProp will be at
least normalIdx + 3.
:param min_sharp_angle: Any edges with angles greater than this value will
remain sharp, getting different normal vector properties on each side of the
edge. By default, no edges are sharp and all normals are shared. With a value
of zero, the model is faceted and all normals match their triangle normals,
but in this case it would be better not to calculate normals at all.)___";
const char* manifold__compose__manifolds = R"___(Constructs a new manifold from a vector of other manifolds. This is a purely
topological operation, so care should be taken to avoid creating
overlapping results. It is the inverse operation of Decompose().
:param manifolds: A vector of Manifolds to lazy-union together.)___";
const char* manifold__cube__size__center = R"___(Constructs a unit cube (edge lengths all one), by default in the first
octant, touching the origin. If any dimensions in size are negative, or if
all are zero, an empty Manifold will be returned.
:param size: The X, Y, and Z dimensions of the box.
:param center: Set to true to shift the center to the origin.)___";
const char* manifold__cylinder__height__radius_low__radius_high__circular_segments__center = R"___(A convenience constructor for the common case of extruding a circle. Can also
form cones if both radii are specified.
:param height: Z-extent
:param radius_low: Radius of bottom circle. Must be positive.
:param radius_high: Radius of top circle. Can equal zero. Default is equal to
radiusLow.
:param circular_segments: How many line segments to use around the circle.
Default is calculated by the static Defaults.
:param center: Set to true to shift the center to the origin. Default is
origin at the bottom.)___";
const char* manifold__decompose = R"___(This operation returns a vector of Manifolds that are topologically
disconnected. If everything is connected, the vector is length one,
containing a copy of the original. It is the inverse operation of Compose().)___";
const char* manifold__extrude__cross_section__height__n_divisions__twist_degrees__scale_top = R"___(Constructs a manifold from a set of polygons by extruding them along the
Z-axis.
Note that high twistDegrees with small nDivisions may cause
self-intersection. This is not checked here and it is up to the user to
choose the correct parameters.
:param cross_section: A set of non-overlapping polygons to extrude.
:param height: Z-extent of extrusion.
:param n_divisions: Number of extra copies of the crossSection to insert into
the shape vertically; especially useful in combination with twistDegrees to
avoid interpolation artifacts. Default is none.
:param twist_degrees: Amount to twist the top crossSection relative to the
bottom, interpolated linearly for the divisions in between.
:param scale_top: Amount to scale the top (independently in X and Y). If the
scale is {0, 0}, a pure cone is formed with only a single vertex at the top.
Note that scale is applied after twist.
Default {1, 1}.)___";
const char* manifold__genus = R"___(The genus is a topological property of the manifold, representing the number
of "handles". A sphere is 0, torus 1, etc. It is only meaningful for a single
mesh, so it is best to call Decompose() first.)___";
const char* manifold__get_epsilon = R"___(Returns the epsilon value of this Manifold's vertices, which tracks the
approximate rounding error over all the transforms and operations that have
led to this state. This is the value of &epsilon; defining
[&epsilon;-valid](https://github.com/elalish/manifold/wiki/Manifold-Library#definition-of-%CE%B5-valid).)___";
const char* manifold__get_mesh_gl64__normal_idx = R"___(The most complete output of this library, returning a Mesh that is designed
to easily push into a renderer, including all interleaved vertex properties
that may have been input. It also includes relations to all the input meshes
that form a part of this result and the transforms applied to each.
:param normal_idx: If the original Mesh inputs that formed this manifold had
properties corresponding to normal vectors, you can specify the first of the
three consecutive property channels forming the (x, y, z) normals, which will
cause this output Mesh to automatically update these normals according to
the applied transforms and front/back side. normalIdx + 3 must be <=
numProp, and all original Meshs must use the same channels for their
normals.)___";
const char* manifold__get_mesh_gl__normal_idx = R"___(The most complete output of this library, returning a Mesh that is designed
to easily push into a renderer, including all interleaved vertex properties
that may have been input. It also includes relations to all the input meshes
that form a part of this result and the transforms applied to each.
:param normal_idx: If the original Mesh inputs that formed this manifold had
properties corresponding to normal vectors, you can specify the first of the
three consecutive property channels forming the (x, y, z) normals, which will
cause this output Mesh to automatically update these normals according to
the applied transforms and front/back side. normalIdx + 3 must be <=
numProp, and all original Meshs must use the same channels for their
normals.)___";
const char* manifold__get_tolerance = R"___(Returns the tolerance value of this Manifold. Triangles that are coplanar
within tolerance tend to be merged and edges shorter than tolerance tend to
be collapsed.)___";
const char* manifold__hull = R"___(Compute the convex hull of this manifold.)___";
const char* manifold__hull__manifolds = R"___(Compute the convex hull enveloping a set of manifolds.
:param manifolds: A vector of manifolds over which to compute a convex hull.)___";
const char* manifold__hull__pts = R"___(Compute the convex hull of a set of points. If the given points are fewer
than 4, or they are all coplanar, an empty Manifold will be returned.
:param pts: A vector of 3-dimensional points over which to compute a convex
hull.)___";
const char* manifold__impl__compact_props = R"___(Removes unreferenced property verts and reindexes propVerts.)___";
const char* manifold__impl__finish = R"___(Once halfedge_ has been filled in, this function can be called to create the
rest of the internal data structures. This function also removes the verts
and halfedges flagged for removal (NaN verts and -1 halfedges).)___";
const char* manifold__impl__gather_faces__face_new2_old = R"___(Creates the halfedge_ vector for this manifold by copying a set of faces from
another manifold, given by oldHalfedge. Input faceNew2Old defines the old
faces to gather into this.)___";
const char* manifold__impl__get_face_box_morton__face_box__face_morton = R"___(Fills the faceBox and faceMorton input with the bounding boxes and Morton
codes of the faces, respectively. The Morton code is based on the center of
the bounding box.)___";
const char* manifold__impl__reindex_verts__vert_new2_old__old_num_vert = R"___(Updates the halfedges to point to new vert indices based on a mapping,
vertNew2Old. This may be a subset, so the total number of original verts is
also given.)___";
const char* manifold__impl__sort_faces__face_box__face_morton = R"___(Sorts the faces of this manifold according to their input Morton code. The
bounding box and Morton code arrays are also sorted accordingly.)___";
const char* manifold__impl__sort_verts = R"___(Sorts the vertices according to their Morton code.)___";
const char* manifold__is_empty = R"___(Does the Manifold have any triangles?)___";
const char* manifold__level_set__sdf__bounds__edge_length__level__tolerance__can_parallel = R"___(Constructs a level-set manifold from the input Signed-Distance Function
(SDF). This uses a form of Marching Tetrahedra (akin to Marching
Cubes, but better for manifoldness). Instead of using a cubic grid, it uses a
body-centered cubic grid (two shifted cubic grids). These grid points are
snapped to the surface where possible to keep short edges from forming.
:param sdf: The signed-distance functor, containing this function signature:
`double operator()(vec3 point)`, which returns the
signed distance of a given point in R^3. Positive values are inside,
negative outside. There is no requirement that the function be a true
distance, or even continuous.
:param bounds: An axis-aligned box that defines the extent of the grid.
:param edge_length: Approximate maximum edge length of the triangles in the
final result. This affects grid spacing, and hence has a strong effect on
performance.
:param level: Extract the surface at this value of your sdf; defaults to
zero. You can inset your mesh by using a positive value, or outset it with a
negative value.
:param tolerance: Ensure each vertex is within this distance of the true
surface. Defaults to -1, which will return the interpolated
crossing-point based on the two nearest grid points. Small positive values
will require more sdf evaluations per output vertex.
:param can_parallel: Parallel policies violate will crash language runtimes
with runtime locks that expect to not be called back by unregistered threads.
This allows bindings use LevelSet despite being compiled with MANIFOLD_PAR
active.)___";
const char* manifold__manifold = R"___(Construct an empty Manifold.)___";
const char* manifold__manifold__mesh_gl = R"___(Convert a Mesh into a Manifold, retaining its properties and merging only
the positions according to the merge vectors. Will return an empty Manifold
and set an Error Status if the result is not an oriented 2-manifold. Will
collapse degenerate triangles and unnecessary vertices.
All fields are read, making this structure suitable for a lossless round-trip
of data from GetMesh. For multi-material input, use ReserveIDs to set a
unique originalID for each material, and sort the materials into triangle
runs.
:param mesh: The input Mesh.)___";
const char* manifold__manifold__mesh_gl64 = R"___(Convert a Mesh into a Manifold, retaining its properties and merging only
the positions according to the merge vectors. Will return an empty Manifold
and set an Error Status if the result is not an oriented 2-manifold. Will
collapse degenerate triangles and unnecessary vertices.
All fields are read, making this structure suitable for a lossless round-trip
of data from GetMesh. For multi-material input, use ReserveIDs to set a
unique originalID for each material, and sort the materials into triangle
runs.
:param mesh64: The input Mesh64.)___";
const char* manifold__matches_tri_normals = R"___(The triangle normal vectors are saved over the course of operations rather
than recalculated to avoid rounding error. This checks that triangles still
match their normal vectors within Precision().)___";
const char* manifold__min_gap__other__search_length = R"___(Returns the minimum gap between two manifolds. Returns a double between
0 and searchLength.
:param other: The other manifold to compute the minimum gap to.
:param search_length: The maximum distance to search for a minimum gap.)___";
const char* manifold__mirror__normal = R"___(Mirror this Manifold over the plane described by the unit form of the given
normal vector. If the length of the normal is zero, an empty Manifold is
returned. This operation can be chained. Transforms are combined and applied
lazily.
:param normal: The normal vector of the plane to be mirrored over)___";
const char* manifold__num_degenerate_tris = R"___(The number of triangles that are colinear within Precision(). This library
attempts to remove all of these, but it cannot always remove all of them
without changing the mesh by too much.)___";
const char* manifold__num_edge = R"___(The number of edges in the Manifold.)___";
const char* manifold__num_prop = R"___(The number of properties per vertex in the Manifold.)___";
const char* manifold__num_prop_vert = R"___(The number of property vertices in the Manifold. This will always be >=
NumVert, as some physical vertices may be duplicated to account for different
properties on different neighboring triangles.)___";
const char* manifold__num_tri = R"___(The number of triangles in the Manifold.)___";
const char* manifold__num_vert = R"___(The number of vertices in the Manifold.)___";
const char* manifold__operator_minus__q = R"___(Shorthand for Boolean Difference.)___";
const char* manifold__operator_minus_eq__q = R"___(Shorthand for Boolean Difference assignment.)___";
const char* manifold__operator_plus__q = R"___(Shorthand for Boolean Union.)___";
const char* manifold__operator_plus_eq__q = R"___(Shorthand for Boolean Union assignment.)___";
const char* manifold__operator_xor__q = R"___(Shorthand for Boolean Intersection.)___";
const char* manifold__operator_xor_eq__q = R"___(Shorthand for Boolean Intersection assignment.)___";
const char* manifold__original_id = R"___(If this mesh is an original, this returns its meshID that can be referenced
by product manifolds' MeshRelation. If this manifold is a product, this
returns -1.)___";
const char* manifold__project = R"___(Returns polygons representing the projected outline of this object
onto the X-Y plane. These polygons will often self-intersect, so it is
recommended to run them through the positive fill rule of CrossSection to get
a sensible result before using them.)___";
const char* manifold__refine__n = R"___(Increase the density of the mesh by splitting every edge into n pieces. For
instance, with n = 2, each triangle will be split into 4 triangles. Quads
will ignore their interior triangle bisector. These will all be coplanar (and
will not be immediately collapsed) unless the Mesh/Manifold has
halfedgeTangents specified (e.g. from the Smooth() constructor), in which
case the new vertices will be moved to the interpolated surface according to
their barycentric coordinates.
:param n: The number of pieces to split every edge into. Must be > 1.)___";
const char* manifold__refine_to_length__length = R"___(Increase the density of the mesh by splitting each edge into pieces of
roughly the input length. Interior verts are added to keep the rest of the
triangulation edges also of roughly the same length. If halfedgeTangents are
present (e.g. from the Smooth() constructor), the new vertices will be moved
to the interpolated surface according to their barycentric coordinates. Quads
will ignore their interior triangle bisector.
:param length: The length that edges will be broken down to.)___";
const char* manifold__refine_to_tolerance__tolerance = R"___(Increase the density of the mesh by splitting each edge into pieces such that
any point on the resulting triangles is roughly within tolerance of the
smoothly curved surface defined by the tangent vectors. This means tightly
curving regions will be divided more finely than smoother regions. If
halfedgeTangents are not present, the result will simply be a copy of the
original. Quads will ignore their interior triangle bisector.
:param tolerance: The desired maximum distance between the faceted mesh
produced and the exact smoothly curving surface. All vertices are exactly on
the surface, within rounding error.)___";
const char* manifold__reserve_ids__n = R"___(Returns the first of n sequential new unique mesh IDs for marking sets of
triangles that can be looked up after further operations. Assign to
Mesh.runOriginalID vector.)___";
const char* manifold__revolve__cross_section__circular_segments__revolve_degrees = R"___(Constructs a manifold from a set of polygons by revolving this cross-section
around its Y-axis and then setting this as the Z-axis of the resulting
manifold. If the polygons cross the Y-axis, only the part on the positive X
side is used. Geometrically valid input will result in geometrically valid
output.
:param cross_section: A set of non-overlapping polygons to revolve.
:param circular_segments: Number of segments along its diameter. Default is
calculated by the static Defaults.
:param revolve_degrees: Number of degrees to revolve. Default is 360 degrees.)___";
const char* manifold__rotate__x_degrees__y_degrees__z_degrees = R"___(Applies an Euler angle rotation to the manifold, first about the X axis, then
Y, then Z, in degrees. We use degrees so that we can minimize rounding error,
and eliminate it completely for any multiples of 90 degrees. Additionally,
more efficient code paths are used to update the manifold when the transforms
only rotate by multiples of 90 degrees. This operation can be chained.
Transforms are combined and applied lazily.
:param x_degrees: First rotation, degrees about the X-axis.
:param y_degrees: Second rotation, degrees about the Y-axis.
:param z_degrees: Third rotation, degrees about the Z-axis.)___";
const char* manifold__scale__v = R"___(Scale this Manifold in space. This operation can be chained. Transforms are
combined and applied lazily.
:param v: The vector to multiply every vertex by per component.)___";
const char* manifold__set_properties__num_prop__prop_func = R"___(Create a new copy of this manifold with updated vertex properties by
supplying a function that takes the existing position and properties as
input. You may specify any number of output properties, allowing creation and
removal of channels. Note: undefined behavior will result if you read past
the number of input properties or write past the number of output properties.
If propFunc is a nullptr, this function will just set the channel to zeroes.
:param num_prop: The new number of properties per vertex.
:param prop_func: A function that modifies the properties of a given vertex.)___";
const char* manifold__set_tolerance__tolerance = R"___(Return a copy of the manifold with the set tolerance value.
This performs mesh simplification when the tolerance value is increased.)___";
const char* manifold__simplify__tolerance = R"___(Return a copy of the manifold simplified to the given tolerance, but with its
actual tolerance value unchanged. If the tolerance is not given or is less
than the current tolerance, the current tolerance is used for simplification.
The result will contain a subset of the original verts and all surfaces will
have moved by less than tolerance.)___";
const char* manifold__slice__height = R"___(Returns the cross section of this object parallel to the X-Y plane at the
specified Z height, defaulting to zero. Using a height equal to the bottom of
the bounding box will return the bottom faces, while using a height equal to
the top of the bounding box will return empty.)___";
const char* manifold__smooth__mesh_gl64__sharpened_edges = R"___(Constructs a smooth version of the input mesh by creating tangents; this
method will throw if you have supplied tangents with your mesh already. The
actual triangle resolution is unchanged; use the Refine() method to
interpolate to a higher-resolution curve.
By default, every edge is calculated for maximum smoothness (very much
approximately), attempting to minimize the maximum mean Curvature magnitude.
No higher-order derivatives are considered, as the interpolation is
independent per triangle, only sharing constraints on their boundaries.
:param mesh64: input Mesh64.
:param sharpened_edges: If desired, you can supply a vector of sharpened
halfedges, which should in general be a small subset of all halfedges. Order
of entries doesn't matter, as each one specifies the desired smoothness
(between zero and one, with one the default for all unspecified halfedges)
and the halfedge index (3 * triangle index + [0,1,2] where 0 is the edge
between triVert 0 and 1, etc).
At a smoothness value of zero, a sharp crease is made. The smoothness is
interpolated along each edge, so the specified value should be thought of as
an average. Where exactly two sharpened edges meet at a vertex, their
tangents are rotated to be colinear so that the sharpened edge can be
continuous. Vertices with only one sharpened edge are completely smooth,
allowing sharpened edges to smoothly vanish at termination. A single vertex
can be sharpened by sharping all edges that are incident on it, allowing
cones to be formed.)___";
const char* manifold__smooth__mesh_gl__sharpened_edges = R"___(Constructs a smooth version of the input mesh by creating tangents; this
method will throw if you have supplied tangents with your mesh already. The
actual triangle resolution is unchanged; use the Refine() method to
interpolate to a higher-resolution curve.
By default, every edge is calculated for maximum smoothness (very much
approximately), attempting to minimize the maximum mean Curvature magnitude.
No higher-order derivatives are considered, as the interpolation is
independent per triangle, only sharing constraints on their boundaries.
:param mesh: input Mesh.
:param sharpened_edges: If desired, you can supply a vector of sharpened
halfedges, which should in general be a small subset of all halfedges. Order
of entries doesn't matter, as each one specifies the desired smoothness
(between zero and one, with one the default for all unspecified halfedges)
and the halfedge index (3 * triangle index + [0,1,2] where 0 is the edge
between triVert 0 and 1, etc).
:param edge_smoothness: Smoothness values associated to each halfedge defined
in sharpened_edges. At a smoothness value of zero, a sharp crease is made. The
smoothness is interpolated along each edge, so the specified value should be
thought of as an average. Where exactly two sharpened edges meet at a vertex,
their tangents are rotated to be colinear so that the sharpened edge can be
continuous. Vertices with only one sharpened edge are completely smooth,
allowing sharpened edges to smoothly vanish at termination. A single vertex
can be sharpened by sharping all edges that are incident on it, allowing cones
to be formed.)___";
const char* manifold__smooth_by_normals__normal_idx = R"___(Smooths out the Manifold by filling in the halfedgeTangent vectors. The
geometry will remain unchanged until Refine or RefineToLength is called to
interpolate the surface. This version uses the supplied vertex normal
properties to define the tangent vectors. Faces of two coplanar triangles
will be marked as quads, while faces with three or more will be flat.
:param normal_idx: The first property channel of the normals. NumProp must be
at least normalIdx + 3. Any vertex where multiple normals exist and don't
agree will result in a sharp edge.)___";
const char* manifold__smooth_out__min_sharp_angle__min_smoothness = R"___(Smooths out the Manifold by filling in the halfedgeTangent vectors. The
geometry will remain unchanged until Refine or RefineToLength is called to
interpolate the surface. This version uses the geometry of the triangles and
pseudo-normals to define the tangent vectors. Faces of two coplanar triangles
will be marked as quads.
:param min_sharp_angle: degrees, default 60. Any edges with angles greater than
this value will remain sharp. The rest will be smoothed to G1 continuity,
with the caveat that flat faces of three or more triangles will always remain
flat. With a value of zero, the model is faceted, but in this case there is
no point in smoothing.
:param min_smoothness: range: 0 - 1, default 0. The smoothness applied to sharp
angles. The default gives a hard edge, while values > 0 will give a small
fillet on these sharp edges. A value of 1 is equivalent to a minSharpAngle of
180 - all edges will be smooth.)___";
const char* manifold__sphere__radius__circular_segments = R"___(Constructs a geodesic sphere of a given radius.
:param radius: Radius of the sphere. Must be positive.
:param circular_segments: Number of segments along its
diameter. This number will always be rounded up to the nearest factor of
four, as this sphere is constructed by refining an octahedron. This means
there are a circle of vertices on all three of the axis planes. Default is
calculated by the static Defaults.)___";
const char* manifold__split__cutter = R"___(Split cuts this manifold in two using the cutter manifold. The first result
is the intersection, second is the difference. This is more efficient than
doing them separately.
:param cutter:)___";
const char* manifold__split_by_plane__normal__origin_offset = R"___(Convenient version of Split() for a half-space.
:param normal: This vector is normal to the cutting plane and its length does
not matter. The first result is in the direction of this vector, the second
result is on the opposite side.
:param origin_offset: The distance of the plane from the origin in the
direction of the normal vector.)___";
const char* manifold__status = R"___(Returns the reason for an input Mesh producing an empty Manifold. This Status
will carry on through operations like NaN propogation, ensuring an errored
mesh doesn't get mysteriously lost. Empty meshes may still show
NoError, for instance the intersection of non-overlapping meshes.)___";
const char* manifold__surface_area = R"___(Returns the surface area of the manifold.)___";
const char* manifold__tetrahedron = R"___(Constructs a tetrahedron centered at the origin with one vertex at (1,1,1)
and the rest at similarly symmetric points.)___";
const char* manifold__transform__m = R"___(Transform this Manifold in space. The first three columns form a 3x3 matrix
transform and the last is a translation vector. This operation can be
chained. Transforms are combined and applied lazily.
:param m: The affine transform matrix to apply to all the vertices.)___";
const char* manifold__translate__v = R"___(Move this Manifold in space. This operation can be chained. Transforms are
combined and applied lazily.
:param v: The vector to add to every vertex.)___";
const char* manifold__trim_by_plane__normal__origin_offset = R"___(Identical to SplitByPlane(), but calculating and returning only the first
result.
:param normal: This vector is normal to the cutting plane and its length does
not matter. The result is in the direction of this vector from the plane.
:param origin_offset: The distance of the plane from the origin in the
direction of the normal vector.)___";
const char* manifold__volume = R"___(Returns the volume of the manifold.)___";
const char* manifold__warp__warp_func = R"___(This function does not change the topology, but allows the vertices to be
moved according to any arbitrary input function. It is easy to create a
function that warps a geometrically valid object into one which overlaps, but
that is not checked here, so it is up to the user to choose their function
with discretion.
:param warp_func: A function that takes the original vertex position and
return the new position.)___";
const char* manifold__warp_batch__warp_func = R"___(Same as Manifold::warp but calls warpFunc with with
an ndarray[n, 3] instead of processing only one vertex at a time.
:param warp_func: A function that takes multiple vertex positions as an
ndarray[n, 3] and returns the new vertex positions. The result should have the
same shape as the input.)___";
const char* mesh_gl__merge = R"___(Updates the mergeFromVert and mergeToVert vectors in order to create a
manifold solid. If the Mesh is already manifold, no change will occur and
the function will return false. Otherwise, this will merge verts along open
edges within tolerance (the maximum of the Mesh tolerance and the
baseline bounding-box tolerance), keeping any from the existing merge
vectors, and return true.
There is no guarantee the result will be manifold - this is a best-effort
helper function designed primarily to aid in the case where a manifold
multi-material Mesh was produced, but its merge vectors were lost due to
a round-trip through a file format. Constructing a Manifold from the result
will report an error status if it is not manifold.)___";
const char* quality__get_circular_segments__radius = R"___(Determine the result of the SetMinCircularAngle(),
SetMinCircularEdgeLength(), and SetCircularSegments() defaults.
:param radius: For a given radius of circle, determine how many default
segments there will be.)___";
const char* quality__reset_to_defaults = R"___(Resets the circular construction parameters to their defaults if
SetMinCircularAngle, SetMinCircularEdgeLength, or SetCircularSegments have
been called.)___";
const char* quality__set_circular_segments__number = R"___(Sets the default number of circular segments for the
CrossSection::Circle(), Manifold::Cylinder(), Manifold::Sphere(), and
Manifold::Revolve() constructors. Overrides the edge length and angle
constraints and sets the number of segments to exactly this value.
:param number: Number of circular segments. Default is 0, meaning no
constraint is applied.)___";
const char* quality__set_min_circular_angle__angle = R"___(Sets an angle constraint the default number of circular segments for the
CrossSection::Circle(), Manifold::Cylinder(), Manifold::Sphere(), and
Manifold::Revolve() constructors. The number of segments will be rounded up
to the nearest factor of four.
:param angle: The minimum angle in degrees between consecutive segments. The
angle will increase if the the segments hit the minimum edge length.
Default is 10 degrees.)___";
const char* quality__set_min_circular_edge_length__length = R"___(Sets a length constraint the default number of circular segments for the
CrossSection::Circle(), Manifold::Cylinder(), Manifold::Sphere(), and
Manifold::Revolve() constructors. The number of segments will be rounded up
to the nearest factor of four.
:param length: The minimum length of segments. The length will
increase if the the segments hit the minimum angle. Default is 1.0.)___";
const char* set_min_circular_angle__angle = R"___(@brief These static properties control how circular shapes are quantized by
default on construction.
If circularSegments is specified, it takes
precedence. If it is zero, then instead the minimum is used of the segments
calculated based on edge length and angle, rounded up to the nearest
multiple of four. To get numbers not divisible by four, circularSegments
must be specified.)___";
const char* triangulate = R"___(Ear-clipping triangulator based on David Eberly's approach from Geometric
Tools, but adjusted to handle epsilon-valid polygons, and including a
fallback that ensures a manifold triangulation even for overlapping polygons.
This is reduced from an O(n^2) algorithm by means of our BVH Collider.
The main adjustments for robustness involve clipping the sharpest ears first
(a known technique to get higher triangle quality), and doing an exhaustive
search to determine ear convexity exactly if the first geometric result is
within epsilon.)___";
const char* triangulate__polygons__epsilon__allow_convex = R"___(@brief Triangulates a set of &epsilon;-valid polygons. If the input is not
&epsilon;-valid, the triangulation may overlap, but will always return a
manifold result that matches the input edge directions.
:param polygons: The set of polygons, wound CCW and representing multiple
polygons and/or holes.
:param epsilon: The value of &epsilon;, bounding the uncertainty of the
input.
:param allow_convex: If true (default), the triangulator will use a fast
triangulation if the input is convex, falling back to ear-clipping if not.
The triangle quality may be lower, so set to false to disable this
optimization.
@return std::vector<ivec3> The triangles, referencing the original
polygon points in order.)___";
const char* triangulate_convex__polys = R"___(Triangulates a set of convex polygons by alternating instead of a fan, to
avoid creating high-degree vertices.)___";
const char* triangulate_idx__polys__epsilon__allow_convex = R"___(@brief Triangulates a set of &epsilon;-valid polygons. If the input is not
&epsilon;-valid, the triangulation may overlap, but will always return a
manifold result that matches the input edge directions.
:param polys: The set of polygons, wound CCW and representing multiple
polygons and/or holes. These have 2D-projected positions as well as
references back to the original vertices.
:param epsilon: The value of &epsilon;, bounding the uncertainty of the
input.
:param allow_convex: If true (default), the triangulator will use a fast
triangulation if the input is convex, falling back to ear-clipping if not.
The triangle quality may be lower, so set to false to disable this
optimization.
@return std::vector<ivec3> The triangles, referencing the original
vertex indicies.)___";
} // namespace manifold_docs