#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0061\x0072";
static constexpr OUStringLiteral langDefaultName = u"\x0041\x0072\x0061\x0062\x0069\x0063";
static constexpr OUStringLiteral countryID = u"\x0049\x0051";
static constexpr OUStringLiteral countryDefaultName = u"\x0049\x0072\x0061\x0071";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_ar_IQ(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_ar_IQ(sal_Int16& count)
{
	return getLocaleItem_ar_SA(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x62f, 0x2e, 0x639, 0x2e, 0x200f, 0x2d, 0x38, 0x30, 0x31, 0x5d, 0x0};
extern OUString const * getAllFormats0_ar_SA(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_ar_IQ(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_ar_SA(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_ar_IQ(sal_Int16& count)
{
	return getDateAcceptancePatterns_ar_SA(count);
}
extern const OUString *  getCollatorImplementation_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_ar_IQ(sal_Int16& count)
{
	return getCollatorImplementation_ar_SA(count);
}
extern const OUString *  getCollationOptions_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_ar_IQ(sal_Int16& count)
{
	return getCollationOptions_ar_SA(count);
}
extern const OUString *  getSearchOptions_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_ar_IQ(sal_Int16& count)
{
	return getSearchOptions_ar_SA(count);
}
extern const OUString *  getIndexAlgorithm_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_ar_IQ(sal_Int16& count)
{
	return getIndexAlgorithm_ar_SA(count);
}
extern const OUString *  getUnicodeScripts_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_ar_IQ(sal_Int16& count)
{
	return getUnicodeScripts_ar_SA(count);
}
extern const OUString *  getFollowPageWords_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_ar_IQ(sal_Int16& count)
{
	return getFollowPageWords_ar_SA(count);
}
extern const OUString *  getAllCalendars_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_ar_IQ(sal_Int16& count)
{
	return getAllCalendars_ar_SA(count);
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0049\x0051\x0044";
static constexpr OUStringLiteral currencySymbol0 = u"\x062f\x002e\x0639\x002e\x200f";
static constexpr OUStringLiteral bankSymbol0 = u"\x0049\x0051\x0044";
static constexpr OUStringLiteral currencyName0 = u"\x0049\x0051\x0044";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_ar_IQ(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_ar_IQ(sal_Int16& count)
{
	return getTransliterations_ar_SA(count);
}
extern const OUString *  getForbiddenCharacters_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_ar_IQ(sal_Int16& count)
{
	return getForbiddenCharacters_ar_SA(count);
}
extern const OUString *  getBreakIteratorRules_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_ar_IQ(sal_Int16& count)
{
	return getBreakIteratorRules_ar_SA(count);
}
extern const OUString *  getReservedWords_ar_SA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_ar_IQ(sal_Int16& count)
{
	return getReservedWords_ar_SA(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_ar_SA(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_ar_IQ(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_ar_SA(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_ar_SA(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_ar_IQ(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_ar_SA(nStyles, nLevels, nAttributes);
}
} // extern "C"

