
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kpagewidgetitem_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <qaction.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPageWidgetItem_Type = nullptr;
static PyTypeObject *Sbk_KPageWidgetItem_TypeF(void)
{
    return _Sbk_KPageWidgetItem_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KPageWidgetItemWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KPageWidgetItemWrapper::KPageWidgetItemWrapper(::QWidget * widget) : KPageWidgetItem(widget)
{
}

KPageWidgetItemWrapper::KPageWidgetItemWrapper(::QWidget * widget, const ::QString & name) : KPageWidgetItem(widget, name)
{
}

void KPageWidgetItemWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetItem_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KPageWidgetItem", funcName, gil, pyOverride, event);
}

void KPageWidgetItemWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetItem_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPageWidgetItem", funcName, gil, pyOverride, signal);
}

void KPageWidgetItemWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetItem_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KPageWidgetItem", funcName, gil, pyOverride, event);
}

void KPageWidgetItemWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetItem_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPageWidgetItem", funcName, gil, pyOverride, signal);
}

bool KPageWidgetItemWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetItem_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KPageWidgetItem", funcName, gil, pyOverride, event);
}

bool KPageWidgetItemWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetItem_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KPageWidgetItem", funcName, gil, pyOverride, watched, event);
}

void KPageWidgetItemWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetItem_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KPageWidgetItem", funcName, gil, pyOverride, event);
}

const QMetaObject *KPageWidgetItemWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KPageWidgetItem::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KPageWidgetItemWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KPageWidgetItem::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KPageWidgetItemWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KPageWidgetItemWrapper *>(this));
    }
    return KPageWidgetItem::qt_metacast(_clname);
}

KPageWidgetItemWrapper::~KPageWidgetItemWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KPageWidgetItem_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPageWidgetItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPageWidgetItem >()))
        return -1;

    KPageWidgetItemWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KPageWidgetItem", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPageWidgetItem::KPageWidgetItem(QWidget*)
    // 1: KPageWidgetItem::KPageWidgetItem(QWidget*,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KPageWidgetItem(QWidget*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 1; // KPageWidgetItem(QWidget*,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KPageWidgetItem(QWidget *widget)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPageWidgetItem(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KPageWidgetItemWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KPageWidgetItemWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KPageWidgetItem(QWidget *widget, const QString &name)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPageWidgetItem(QWidget*,QString)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KPageWidgetItemWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KPageWidgetItemWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KPageWidgetItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KPageWidgetItemFunc_actions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // actions()const
        QList<QAction*> cppResult = const_cast<const ::KPageWidgetItem *>(cppSelf)->actions();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QActionPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetItemFunc_header(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // header()const
        QString cppResult = const_cast<const ::KPageWidgetItem *>(cppSelf)->header();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetItemFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QIcon cppResult = const_cast<const ::KPageWidgetItem *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetItemFunc_isCheckable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isCheckable()const
        bool cppResult = const_cast<const ::KPageWidgetItem *>(cppSelf)->isCheckable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetItemFunc_isChecked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isChecked()const
        bool cppResult = const_cast<const ::KPageWidgetItem *>(cppSelf)->isChecked();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetItemFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isEnabled()const
        bool cppResult = const_cast<const ::KPageWidgetItem *>(cppSelf)->isEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetItemFunc_isHeaderVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isHeaderVisible()const
        bool cppResult = const_cast<const ::KPageWidgetItem *>(cppSelf)->isHeaderVisible();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetItemFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        QString cppResult = const_cast<const ::KPageWidgetItem *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetItemFunc_setActions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageWidgetItem::setActions(QList<QAction*>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QActionPTR_IDX], (pyArg)))) {
        overloadId = 0; // setActions(QList<QAction*>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setActions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);

    // Call function/method
    {
        ::QList<QAction*> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setActions(QList<QAction*>)
            cppSelf->setActions(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageWidgetItemFunc_setCheckable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageWidgetItem::setCheckable(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setCheckable(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCheckable", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCheckable(bool)
            cppSelf->setCheckable(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageWidgetItemFunc_setChecked(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageWidgetItem::setChecked(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setChecked(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setChecked", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setChecked(bool)
            cppSelf->setChecked(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageWidgetItemFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageWidgetItem::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageWidgetItemFunc_setHeader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageWidgetItem::setHeader(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setHeader(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setHeader", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setHeader(QString)
            cppSelf->setHeader(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageWidgetItemFunc_setHeaderVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageWidgetItem::setHeaderVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setHeaderVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setHeaderVisible", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setHeaderVisible(bool)
            cppSelf->setHeaderVisible(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageWidgetItemFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageWidgetItem::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageWidgetItemFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageWidgetItem::setName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setName", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setName(QString)
            cppSelf->setName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageWidgetItemFunc_widget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // widget()const
        QWidget * cppResult = const_cast<const ::KPageWidgetItem *>(cppSelf)->widget();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KPageWidgetItem_PropertyStrings[] = {
    "actions::",
    "checkable:isCheckable:",
    "checked:isChecked:",
    "enabled:isEnabled:",
    "header::",
    "headerVisible:isHeaderVisible:",
    "icon::",
    "name::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPageWidgetItem_methods[] = {
    {"actions", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_actions), METH_NOARGS, nullptr},
    {"header", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_header), METH_NOARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_icon), METH_NOARGS, nullptr},
    {"isCheckable", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_isCheckable), METH_NOARGS, nullptr},
    {"isChecked", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_isChecked), METH_NOARGS, nullptr},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_isEnabled), METH_NOARGS, nullptr},
    {"isHeaderVisible", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_isHeaderVisible), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_name), METH_NOARGS, nullptr},
    {"setActions", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_setActions), METH_O, nullptr},
    {"setCheckable", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_setCheckable), METH_O, nullptr},
    {"setChecked", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_setChecked), METH_O, nullptr},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_setEnabled), METH_O, nullptr},
    {"setHeader", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_setHeader), METH_O, nullptr},
    {"setHeaderVisible", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_setHeaderVisible), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_setIcon), METH_O, nullptr},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_setName), METH_O, nullptr},
    {"widget", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetItemFunc_widget), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KPageWidgetItem_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KPageWidgetItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KPageWidgetItemWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KPageWidgetItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPageWidgetItem_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPageWidgetItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KPageWidgetItem_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPageWidgetItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPageWidgetItem_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPageWidgetItem_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPageWidgetItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPageWidgetItem_spec = {
    "1:KWidgetsAddons.KPageWidgetItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPageWidgetItem_slots
};

} //extern "C"

static void *Sbk_KPageWidgetItem_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KPageWidgetItem *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPageWidgetItem_PythonToCpp_KPageWidgetItem_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPageWidgetItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPageWidgetItem_PythonToCpp_KPageWidgetItem_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPageWidgetItem_TypeF()))
        return KPageWidgetItem_PythonToCpp_KPageWidgetItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPageWidgetItem_PTR_CppToPython_KPageWidgetItem(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KPageWidgetItem *>(const_cast<void *>(cppIn)), Sbk_KPageWidgetItem_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPageWidgetItem_SignatureStrings[] = {
    "1:KWidgetsAddons.KPageWidgetItem(self,widget:PySide6.QtWidgets.QWidget,*:KeywordOnly=None,name:QString=None,header:QString=None,icon:QIcon=None,checkable:bool=None,checked:bool=None,enabled:bool=None,headerVisible:bool=None,actions:QList[PySide6.QtGui.QAction]=None)",
    "0:KWidgetsAddons.KPageWidgetItem(self,widget:PySide6.QtWidgets.QWidget,name:QString,*:KeywordOnly=None,name:QString=None,header:QString=None,icon:QIcon=None,checkable:bool=None,checked:bool=None,enabled:bool=None,headerVisible:bool=None,actions:QList[PySide6.QtGui.QAction]=None)",
    "KWidgetsAddons.KPageWidgetItem.actions(self)->QList[PySide6.QtGui.QAction]",
    "KWidgetsAddons.KPageWidgetItem.header(self)->QString",
    "KWidgetsAddons.KPageWidgetItem.icon(self)->PySide6.QtGui.QIcon",
    "KWidgetsAddons.KPageWidgetItem.isCheckable(self)->bool",
    "KWidgetsAddons.KPageWidgetItem.isChecked(self)->bool",
    "KWidgetsAddons.KPageWidgetItem.isEnabled(self)->bool",
    "KWidgetsAddons.KPageWidgetItem.isHeaderVisible(self)->bool",
    "KWidgetsAddons.KPageWidgetItem.name(self)->QString",
    "KWidgetsAddons.KPageWidgetItem.setActions(self,actions:QList[PySide6.QtGui.QAction])",
    "KWidgetsAddons.KPageWidgetItem.setCheckable(self,checkable:bool)",
    "KWidgetsAddons.KPageWidgetItem.setChecked(self,checked:bool)",
    "KWidgetsAddons.KPageWidgetItem.setEnabled(self,arg__1:bool)",
    "KWidgetsAddons.KPageWidgetItem.setHeader(self,header:QString)",
    "KWidgetsAddons.KPageWidgetItem.setHeaderVisible(self,visible:bool)",
    "KWidgetsAddons.KPageWidgetItem.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KWidgetsAddons.KPageWidgetItem.setName(self,name:QString)",
    "KWidgetsAddons.KPageWidgetItem.widget(self)->PySide6.QtWidgets.QWidget",
    nullptr}; // Sentinel
#else
static constexpr size_t KPageWidgetItem_SignatureByteSize = 344;
static constexpr uint8_t KPageWidgetItem_SignatureBytes[344] = {
    0x78, 0xda, 0xdd, 0x54, 0x41, 0x4f, 0x83, 0x30, 0x18, 0xbd, 0xef, 0x57, 0x78, 0x14, 0x53, 0x89,
    0xbb, 0x78, 0x68, 0xa2, 0x09, 0x31, 0xc6, 0x11, 0xcc, 0xa4, 0x59, 0xd4, 0xc3, 0x62, 0x96, 0x8e,
    0x7e, 0xb2, 0x46, 0x68, 0x17, 0x5a, 0x9d, 0xfc, 0x7b, 0x81, 0x0e, 0x57, 0xd0, 0x8c, 0x92, 0x78,
    0xf2, 0x42, 0xe8, 0xa3, 0xef, 0x95, 0xef, 0x7d, 0xaf, 0xdf, 0x14, 0x47, 0xcf, 0x9c, 0xa5, 0xa0,
    0x55, 0xc0, 0x98, 0x14, 0xca, 0x8f, 0x62, 0x9a, 0x82, 0x81, 0x42, 0x0d, 0xf9, 0xa9, 0x82, 0xec,
    0x15, 0xed, 0x9a, 0x35, 0x8e, 0xcb, 0x05, 0x67, 0x70, 0xe9, 0x13, 0xbd, 0xe7, 0xf8, 0xc4, 0xbc,
    0xa0, 0x33, 0x1c, 0x41, 0xb9, 0x93, 0x05, 0x7b, 0x10, 0x59, 0x79, 0x35, 0x97, 0x02, 0x90, 0xa0,
    0x39, 0x60, 0xb2, 0xd0, 0x05, 0x17, 0xa9, 0x41, 0x36, 0x40, 0x19, 0x14, 0x5d, 0x8c, 0x27, 0x52,
    0x60, 0x12, 0x56, 0x4f, 0xb3, 0x4e, 0x36, 0x90, 0xbc, 0xd1, 0x75, 0x06, 0x78, 0x2d, 0x65, 0x66,
    0x61, 0xc0, 0x2c, 0x04, 0x44, 0xbd, 0xc5, 0x46, 0x8c, 0xf6, 0x13, 0x57, 0xbc, 0xcb, 0xa5, 0x89,
    0xe6, 0x55, 0x59, 0x98, 0xdc, 0x73, 0xa5, 0x97, 0x87, 0x02, 0xee, 0xde, 0xb9, 0x4f, 0x82, 0xe6,
    0xe3, 0x4b, 0xb3, 0xd3, 0x9b, 0x5c, 0xfc, 0x8d, 0x15, 0x76, 0xdd, 0xff, 0xc2, 0x97, 0xe3, 0xae,
    0xf8, 0x7b, 0xa5, 0xc6, 0x1d, 0xef, 0xfc, 0xfa, 0x98, 0xe0, 0x90, 0x94, 0xf9, 0xd9, 0x6f, 0x25,
    0xe3, 0xc7, 0x10, 0xa9, 0x76, 0xaa, 0xa5, 0xf4, 0x8e, 0xad, 0xed, 0x1b, 0xa4, 0xab, 0x9b, 0xd6,
    0xda, 0x56, 0xa5, 0x76, 0xc9, 0x91, 0x06, 0x6c, 0x1c, 0xe9, 0xd6, 0x34, 0x68, 0x1c, 0x69, 0x66,
    0xf7, 0x70, 0x0c, 0xb5, 0x8e, 0xda, 0x48, 0x37, 0x15, 0xe8, 0xc0, 0x6a, 0xa8, 0x53, 0x4e, 0x3c,
    0x07, 0xd1, 0xae, 0xc9, 0xbd, 0x38, 0x3b, 0x0b, 0xec, 0x9d, 0xeb, 0x24, 0xdf, 0x85, 0x6c, 0xdb,
    0x8e, 0x68, 0x91, 0xae, 0x56, 0x53, 0x67, 0xee, 0xec, 0x10, 0xca, 0xde, 0x4d, 0x75, 0x67, 0xdb,
    0xbd, 0x43, 0x1f, 0xd6, 0x65, 0x74, 0x91, 0x08, 0xdb, 0x80, 0x9b, 0xa1, 0xa0, 0xcb, 0x6d, 0x75,
    0xb6, 0xff, 0x28, 0x2a, 0xeb, 0x97, 0xbf, 0x04, 0x1e, 0x9d, 0xf4, 0xc0, 0x98, 0x7f, 0xe6, 0x74,
    0xeb, 0xd4, 0xa5, 0x79, 0x1b, 0x98, 0xce, 0x94, 0x1a, 0x64, 0x9a, 0x99, 0xf8, 0xf3, 0x12, 0xf6,
    0x46, 0xe3, 0xe4, 0x0b, 0xe4, 0x6d, 0x57, 0xa6
};
#endif

PyTypeObject *init_KPageWidgetItem(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX].type;

    Shiboken::AutoDecRef Sbk_KPageWidgetItem_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KPageWidgetItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPageWidgetItem",
        "KPageWidgetItem*",
        &Sbk_KPageWidgetItem_spec,
        &Shiboken::callCppDestructor< KPageWidgetItem >,
        Sbk_KPageWidgetItem_Type_bases.object(),
        0);
    auto *pyType = Sbk_KPageWidgetItem_TypeF(); // references _Sbk_KPageWidgetItem_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPageWidgetItem_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPageWidgetItem_SignatureBytes, KPageWidgetItem_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPageWidgetItem_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPageWidgetItem_PythonToCpp_KPageWidgetItem_PTR,
        is_KPageWidgetItem_PythonToCpp_KPageWidgetItem_PTR_Convertible,
        KPageWidgetItem_PTR_CppToPython_KPageWidgetItem);

    Shiboken::Conversions::registerConverterName(converter, "KPageWidgetItem");
    Shiboken::Conversions::registerConverterName(converter, "KPageWidgetItem*");
    Shiboken::Conversions::registerConverterName(converter, "KPageWidgetItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPageWidgetItem).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KPageWidgetItemWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KPageWidgetItem_TypeF(), &Sbk_KPageWidgetItem_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KPageWidgetItem::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KPageWidgetItem::staticMetaObject, sizeof(KPageWidgetItemWrapper));

    return pyType;
}
